/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiPointImpl;
import com.esri.core.geometry.MultiVertexGeometryImpl;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.RasterizedGeometry2D;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentIteratorImpl;
import com.esri.core.geometry.SimpleRasterizer;
import com.esri.core.geometry.SizeOf;
import com.esri.core.geometry.Transformation2D;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

final class RasterizedGeometry2DImpl
extends RasterizedGeometry2D {
    int[] m_bitmap;
    int m_scanLineSize;
    int m_width;
    double m_dx;
    double m_dy;
    double m_x0;
    double m_y0;
    double m_toleranceXY;
    double m_stroke_half_widthX_pix;
    double m_stroke_half_widthY_pix;
    double m_stroke_half_width;
    Envelope2D m_geomEnv;
    Transformation2D m_transform;
    int m_dbgTestCount;
    SimpleRasterizer m_rasterizer;
    ScanCallbackImpl m_callback;

    /*
     * Exception decompiling
     */
    void fillMultiPath(SimpleRasterizer rasterizer, Transformation2D trans, MultiPathImpl polygon, boolean isWinding) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void fillPoints(SimpleRasterizer rasterizer, MultiPointImpl geom, double stroke_half_width) {
        throw GeometryException.GeometryInternalError();
    }

    void fillConvexPolygon(SimpleRasterizer rasterizer, Point2D[] fan, int len) {
        int i = 1;
        int n = len;
        while (i < n) {
            rasterizer.addEdge(fan[i - 1].x, fan[i - 1].y, fan[i].x, fan[i].y);
            ++i;
        }
        rasterizer.addEdge(fan[len - 1].x, fan[len - 1].y, fan[0].x, fan[0].y);
        this.m_rasterizer.renderEdges(0);
    }

    void fillEnvelope(SimpleRasterizer rasterizer, Envelope2D envIn) {
        rasterizer.fillEnvelope(envIn);
    }

    void strokeDrawPolyPath(SimpleRasterizer rasterizer, MultiPathImpl polyPath, double tol) {
        Point2D[] fan = new Point2D[4];
        int i = 0;
        while (i < fan.length) {
            fan[i] = new Point2D();
            ++i;
        }
        SegmentIteratorImpl segIter = polyPath.querySegmentIterator();
        double strokeHalfWidth = this.m_transform.transform(tol) + 1.5;
        Point2D ptStart = new Point2D();
        Point2D ptEnd = new Point2D();
        Point2D prev_start = new Point2D();
        Point2D prev_end = new Point2D();
        double[] helper_xy_10_elm = new double[10];
        Envelope2D segEnv = new Envelope2D();
        Point2D ptOld = new Point2D();
        double extraWidth = 0.0;
        while (segIter.nextPath()) {
            boolean hasFan = false;
            boolean first = true;
            ptOld.setCoords(0.0, 0.0);
            while (segIter.hasNextSegment()) {
                Segment seg = segIter.nextSegment();
                ptStart.x = seg.getStartX();
                ptStart.y = seg.getStartY();
                ptEnd.x = seg.getEndX();
                ptEnd.y = seg.getEndY();
                segEnv.setEmpty();
                segEnv.merge(ptStart.x, ptStart.y);
                segEnv.mergeNE(ptEnd.x, ptEnd.y);
                if (!this.m_geomEnv.isIntersectingNE(segEnv)) {
                    if (hasFan) {
                        rasterizer.startAddingEdges();
                        rasterizer.addSegmentStroke(prev_start.x, prev_start.y, prev_end.x, prev_end.y, strokeHalfWidth + extraWidth, false, helper_xy_10_elm);
                        rasterizer.renderEdges(0);
                        hasFan = false;
                        extraWidth = 0.0;
                    }
                    first = true;
                    continue;
                }
                this.m_transform.transform(ptEnd, ptEnd);
                if (first) {
                    this.m_transform.transform(ptStart, ptStart);
                    ptOld.setCoords(ptStart);
                    first = false;
                } else {
                    ptStart.setCoords(ptOld);
                }
                prev_start.setCoords(ptStart);
                prev_end.setCoords(ptEnd);
                rasterizer.startAddingEdges();
                hasFan = !rasterizer.addSegmentStroke(prev_start.x, prev_start.y, prev_end.x, prev_end.y, strokeHalfWidth + extraWidth, true, helper_xy_10_elm);
                rasterizer.renderEdges(0);
                if (!hasFan) {
                    ptOld.setCoords(prev_end);
                    extraWidth = 0.0;
                    continue;
                }
                extraWidth = Math.max(extraWidth, Point2D.distance(prev_start, prev_end));
            }
            if (!hasFan) continue;
            rasterizer.startAddingEdges();
            hasFan = !rasterizer.addSegmentStroke(prev_start.x, prev_start.y, prev_end.x, prev_end.y, strokeHalfWidth + extraWidth, false, helper_xy_10_elm);
            rasterizer.renderEdges(0);
            extraWidth = 0.0;
        }
    }

    int worldToPixX(double x) {
        return (int)(x * this.m_dx + this.m_x0);
    }

    int worldToPixY(double y) {
        return (int)(y * this.m_dy + this.m_y0);
    }

    RasterizedGeometry2DImpl(Geometry geom, double toleranceXY, int rasterSizeBytes) {
        this.init((MultiVertexGeometryImpl)geom._getImpl(), toleranceXY, rasterSizeBytes);
    }

    static RasterizedGeometry2DImpl createImpl(Geometry geom, double toleranceXY, int rasterSizeBytes) {
        RasterizedGeometry2DImpl rgImpl = new RasterizedGeometry2DImpl(geom, toleranceXY, rasterSizeBytes);
        return rgImpl;
    }

    private RasterizedGeometry2DImpl(MultiVertexGeometryImpl geom, double toleranceXY, int rasterSizeBytes) {
        this.init(geom, toleranceXY, rasterSizeBytes);
    }

    static RasterizedGeometry2DImpl createImpl(MultiVertexGeometryImpl geom, double toleranceXY, int rasterSizeBytes) {
        RasterizedGeometry2DImpl rgImpl = new RasterizedGeometry2DImpl(geom, toleranceXY, rasterSizeBytes);
        return rgImpl;
    }

    void init(MultiVertexGeometryImpl geom, double toleranceXY, int rasterSizeBytes) {
        ScanCallbackImpl callback;
        this.m_width = Math.max((int)(Math.sqrt(rasterSizeBytes) * 2.0 + 0.5), 64);
        this.m_scanLineSize = (this.m_width * 2 + 31) / 32;
        this.m_geomEnv = new Envelope2D();
        this.m_toleranceXY = toleranceXY;
        int size = 0;
        int width = this.m_width;
        int scanLineSize = this.m_scanLineSize;
        while (width >= 8) {
            size += width * scanLineSize;
            scanLineSize = ((width /= 2) * 2 + 31) / 32;
        }
        this.m_bitmap = new int[size];
        int i = 0;
        while (i < size) {
            this.m_bitmap[i] = 0;
            ++i;
        }
        this.m_rasterizer = new SimpleRasterizer();
        this.m_callback = callback = new ScanCallbackImpl(this.m_bitmap, this.m_scanLineSize);
        this.m_rasterizer.setup(this.m_width, this.m_width, callback);
        geom.queryEnvelope2D(this.m_geomEnv);
        if (!(this.m_geomEnv.getWidth() > (double)this.m_width * this.m_geomEnv.getHeight())) {
            this.m_geomEnv.getHeight();
            this.m_geomEnv.getWidth();
        }
        this.m_geomEnv.inflate(toleranceXY, toleranceXY);
        Envelope2D worldEnv = new Envelope2D();
        Envelope2D pixEnv = Envelope2D.construct(1.0, 1.0, this.m_width - 2, this.m_width - 2);
        double minWidth = toleranceXY * pixEnv.getWidth();
        double minHeight = toleranceXY * pixEnv.getHeight();
        worldEnv.setCoords(this.m_geomEnv.getCenter(), Math.max(minWidth, this.m_geomEnv.getWidth()), Math.max(minHeight, this.m_geomEnv.getHeight()));
        this.m_stroke_half_widthX_pix = worldEnv.getWidth() / pixEnv.getWidth();
        this.m_stroke_half_widthY_pix = worldEnv.getHeight() / pixEnv.getHeight();
        this.m_stroke_half_width = this.m_toleranceXY;
        this.m_transform = new Transformation2D();
        this.m_transform.initializeFromRect(worldEnv, pixEnv);
        switch (geom.getType().value()) {
            case 550: {
                callback.setColor(this.m_rasterizer, 2);
                this.fillPoints(this.m_rasterizer, (MultiPointImpl)geom, this.m_stroke_half_width);
                break;
            }
            case 1607: {
                callback.setColor(this.m_rasterizer, 2);
                this.strokeDrawPolyPath(this.m_rasterizer, (MultiPathImpl)geom._getImpl(), this.m_stroke_half_width);
                break;
            }
            case 1736: {
                boolean isWinding = false;
                callback.setColor(this.m_rasterizer, 1);
                this.fillMultiPath(this.m_rasterizer, this.m_transform, (MultiPathImpl)geom, isWinding);
                callback.setColor(this.m_rasterizer, 2);
                this.strokeDrawPolyPath(this.m_rasterizer, (MultiPathImpl)geom._getImpl(), this.m_stroke_half_width);
            }
        }
        this.m_dx = this.m_transform.xx;
        this.m_dy = this.m_transform.yy;
        this.m_x0 = this.m_transform.xd;
        this.m_y0 = this.m_transform.yd;
        this.buildLevels();
    }

    boolean tryRenderAsSmallEnvelope_(Envelope2D env) {
        if (!env.isIntersecting(this.m_geomEnv)) {
            return true;
        }
        Envelope2D envPix = new Envelope2D();
        envPix.setCoords(env);
        this.m_transform.transform(env);
        double strokeHalfWidthPixX = this.m_stroke_half_widthX_pix;
        double strokeHalfWidthPixY = this.m_stroke_half_widthY_pix;
        if (envPix.getWidth() > 2.0 * strokeHalfWidthPixX + 1.0 || envPix.getHeight() > 2.0 * strokeHalfWidthPixY + 1.0) {
            return false;
        }
        envPix.inflate(strokeHalfWidthPixX, strokeHalfWidthPixY);
        envPix.xmax += 1.0;
        envPix.ymax += 1.0;
        this.m_callback.setColor(this.m_rasterizer, 2);
        this.fillEnvelope(this.m_rasterizer, envPix);
        return true;
    }

    void buildLevels() {
        this.m_rasterizer.flush();
        int iStart = 0;
        int iStartNext = this.m_width * this.m_scanLineSize;
        int width = this.m_width;
        int widthNext = this.m_width / 2;
        int scanLineSize = this.m_scanLineSize;
        int scanLineSizeNext = (widthNext * 2 + 31) / 32;
        while (width > 8) {
            int iy = 0;
            while (iy < widthNext) {
                int iysrc1 = iy * 2;
                int iysrc2 = iy * 2 + 1;
                int ix = 0;
                while (ix < widthNext) {
                    int ixsrc1 = ix * 2;
                    int ixsrc2 = ix * 2 + 1;
                    int divix1 = ixsrc1 >> 4;
                    int modix1 = (ixsrc1 & 0xF) * 2;
                    int divix2 = ixsrc2 >> 4;
                    int modix2 = (ixsrc2 & 0xF) * 2;
                    int res = this.m_bitmap[iStart + scanLineSize * iysrc1 + divix1] >> modix1 & 3;
                    res |= this.m_bitmap[iStart + scanLineSize * iysrc1 + divix2] >> modix2 & 3;
                    res |= this.m_bitmap[iStart + scanLineSize * iysrc2 + divix1] >> modix1 & 3;
                    int divixDst = ix >> 4;
                    int modixDst = (ix & 0xF) * 2;
                    int n = iStartNext + scanLineSizeNext * iy + divixDst;
                    this.m_bitmap[n] = this.m_bitmap[n] | (res |= this.m_bitmap[iStart + scanLineSize * iysrc2 + divix2] >> modix2 & 3) << modixDst;
                    ++ix;
                }
                ++iy;
            }
            width = widthNext;
            scanLineSize = scanLineSizeNext;
            iStart = iStartNext;
            widthNext = width / 2;
            scanLineSizeNext = (widthNext * 2 + 31) / 32;
            iStartNext = iStart + scanLineSize * width;
        }
    }

    @Override
    public RasterizedGeometry2D.HitType queryPointInGeometry(double x, double y) {
        if (!this.m_geomEnv.contains(x, y)) {
            return RasterizedGeometry2D.HitType.Outside;
        }
        int ix = this.worldToPixX(x);
        int iy = this.worldToPixY(y);
        if (ix < 0 || ix >= this.m_width || iy < 0 || iy >= this.m_width) {
            return RasterizedGeometry2D.HitType.Outside;
        }
        int divix = ix >> 4;
        int modix = (ix & 0xF) * 2;
        int res = this.m_bitmap[this.m_scanLineSize * iy + divix] >> modix & 3;
        if (res == 0) {
            return RasterizedGeometry2D.HitType.Outside;
        }
        if (res == 1) {
            return RasterizedGeometry2D.HitType.Inside;
        }
        return RasterizedGeometry2D.HitType.Border;
    }

    @Override
    public RasterizedGeometry2D.HitType queryEnvelopeInGeometry(Envelope2D env) {
        if (!env.intersect(this.m_geomEnv)) {
            return RasterizedGeometry2D.HitType.Outside;
        }
        int ixmin = this.worldToPixX(env.xmin);
        int ixmax = this.worldToPixX(env.xmax);
        int iymin = this.worldToPixY(env.ymin);
        int iymax = this.worldToPixY(env.ymax);
        if (ixmin < 0) {
            ixmin = 0;
        }
        if (iymin < 0) {
            iymin = 0;
        }
        if (ixmax >= this.m_width) {
            ixmax = this.m_width - 1;
        }
        if (iymax >= this.m_width) {
            iymax = this.m_width - 1;
        }
        if (ixmin > ixmax || iymin > iymax) {
            return RasterizedGeometry2D.HitType.Outside;
        }
        int area = Math.max(ixmax - ixmin, 1) * Math.max(iymax - iymin, 1);
        int iStart = 0;
        int scanLineSize = this.m_scanLineSize;
        int width = this.m_width;
        int res = 0;
        while (true) {
            if (area < 32 || width < 16) {
                int iy = iymin;
                while (iy <= iymax) {
                    int ix = ixmin;
                    while (ix <= ixmax) {
                        int divix = ix >> 4;
                        int modix = (ix & 0xF) * 2;
                        res = this.m_bitmap[iStart + scanLineSize * iy + divix] >> modix & 3;
                        if (res > 1) {
                            return RasterizedGeometry2D.HitType.Border;
                        }
                        ++ix;
                    }
                    ++iy;
                }
                if (res == 0) {
                    return RasterizedGeometry2D.HitType.Outside;
                }
                if (res == 1) {
                    return RasterizedGeometry2D.HitType.Inside;
                }
            }
            iStart += scanLineSize * width;
            scanLineSize = ((width /= 2) * 2 + 31) / 32;
            area = Math.max((ixmax /= 2) - (ixmin /= 2), 1) * Math.max((iymax /= 2) - (iymin /= 2), 1);
        }
    }

    @Override
    public double getToleranceXY() {
        return this.m_toleranceXY;
    }

    @Override
    public int getRasterSize() {
        return this.m_width * this.m_scanLineSize;
    }

    @Override
    public boolean dbgSaveToBitmap(String fileName) {
        try {
            FileOutputStream outfile = new FileOutputStream(fileName);
            int height = this.m_width;
            int width = this.m_width;
            int sz = 54 + 4 * this.m_width * height;
            ByteBuffer byteBuffer = ByteBuffer.allocate(sz);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.put((byte)66);
            byteBuffer.put((byte)77);
            byteBuffer.putInt(sz);
            short zero16 = 0;
            byteBuffer.putShort(zero16);
            byteBuffer.putShort(zero16);
            int offset = 54;
            byteBuffer.putInt(offset);
            int biSize = 40;
            int biWidth = width;
            int biHeight = -height;
            short biPlanes = 1;
            short biBitCount = 32;
            int biCompression = 0;
            int biSizeImage = 4 * width * height;
            int biXPelsPerMeter = 0;
            int biYPelsPerMeter = 0;
            int biClrUsed = 0;
            int biClrImportant = 0;
            byteBuffer.putInt(biSize);
            byteBuffer.putInt(biWidth);
            byteBuffer.putInt(biHeight);
            byteBuffer.putShort(biPlanes);
            byteBuffer.putShort(biBitCount);
            byteBuffer.putInt(biCompression);
            byteBuffer.putInt(biSizeImage);
            byteBuffer.putInt(biXPelsPerMeter);
            byteBuffer.putInt(biYPelsPerMeter);
            byteBuffer.putInt(biClrUsed);
            byteBuffer.putInt(biClrImportant);
            int[] colors = new int[]{-1, -16777216, -65536, -16711936};
            int y = 0;
            while (y < height) {
                int scanlineIn = y * ((width * 2 + 31) / 32);
                int x = 0;
                while (x < width) {
                    int res = this.m_bitmap[scanlineIn + (x >> 4)] >> (x & 0xF) * 2 & 3;
                    byteBuffer.putInt(colors[res]);
                    ++x;
                }
                ++y;
            }
            byte[] b = byteBuffer.array();
            outfile.write(b);
            outfile.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public long estimateMemorySize() {
        return (long)(112 + (this.m_geomEnv != null ? this.m_geomEnv.estimateMemorySize() : 0)) + (this.m_transform != null ? this.m_transform.estimateMemorySize() : 0L) + (this.m_rasterizer != null ? this.m_rasterizer.estimateMemorySize() : 0L) + (this.m_callback != null ? this.m_callback.estimateMemorySize() : 0L);
    }

    class ScanCallbackImpl
    implements SimpleRasterizer.ScanCallback {
        int[] m_bitmap;
        int m_scanlineWidth;
        int m_color;

        public ScanCallbackImpl(int[] bitmap, int scanlineWidth) {
            this.m_scanlineWidth = scanlineWidth;
            this.m_bitmap = bitmap;
        }

        public void setColor(SimpleRasterizer rasterizer, int color) {
            if (this.m_color != color) {
                rasterizer.flush();
            }
            this.m_color = color;
        }

        @Override
        public void drawScan(int[] scans, int scanCount3) {
            int i = 0;
            while (i < scanCount3) {
                int x0 = scans[i++];
                int x1 = scans[i++];
                int y = scans[i++];
                int scanlineStart = y * this.m_scanlineWidth;
                int xx = x0;
                while (xx < x1) {
                    int n = scanlineStart + (xx >> 4);
                    this.m_bitmap[n] = this.m_bitmap[n] | this.m_color << (xx & 0xF) * 2;
                    ++xx;
                }
            }
        }

        public long estimateMemorySize() {
            return 32L + (this.m_bitmap != null ? SizeOf.sizeOfIntArray(this.m_bitmap.length) : 0L);
        }
    }
}

