/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfInt8;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiVertexGeometryImpl;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;

@Deprecated
final class GeometrySerializer
implements Serializable {
    private static final long serialVersionUID = 1L;
    BaseGeometryData geometryData;

    GeometrySerializer() {
    }

    Object readResolve() throws ObjectStreamException {
        Geometry geometry = null;
        try {
            geometry = GeometryEngine.geometryFromEsriShape(this.geometryData.esriShape, this.geometryData.geometryType);
            if (Geometry.isMultiVertex(geometry.getType().value())) {
                MultiVertexData mvd = (MultiVertexData)this.geometryData;
                MultiVertexGeometryImpl mvImpl = (MultiVertexGeometryImpl)geometry._getImpl();
                if (!geometry.isEmpty() && Geometry.isMultiPath(geometry.getType().value())) {
                    MultiPathData mpd = (MultiPathData)this.geometryData;
                    MultiPathImpl mpImpl = (MultiPathImpl)geometry._getImpl();
                    AttributeStreamOfInt8 pathFlags = mpImpl.getPathFlagsStreamRef();
                    int i = 0;
                    int n = mpImpl.getPathCount();
                    while (i < n) {
                        if (mpd.ogcFlags[i]) {
                            pathFlags.setBits(i, (byte)4);
                        }
                        ++i;
                    }
                }
                mvImpl.setIsSimple(mvd.simpleFlag, mvd.tolerance, false);
            }
        }
        catch (Exception ex) {
            throw new InvalidObjectException("Cannot read geometry from stream");
        }
        return geometry;
    }

    public void setGeometryByValue(Geometry geometry) throws ObjectStreamException {
        try {
            this.geometryData = Geometry.isMultiPath(geometry.getType().value()) ? new MultiPathData() : (Geometry.isMultiVertex(geometry.getType().value()) ? new MultiVertexData() : new BaseGeometryData());
            this.geometryData.esriShape = GeometryEngine.geometryToEsriShape(geometry);
            this.geometryData.geometryType = geometry.getType();
            if (Geometry.isMultiVertex(this.geometryData.geometryType.value())) {
                MultiVertexData mvd = (MultiVertexData)this.geometryData;
                MultiVertexGeometryImpl mvImpl = (MultiVertexGeometryImpl)geometry._getImpl();
                mvd.tolerance = mvImpl.m_simpleTolerance;
                mvd.simpleFlag = mvImpl.getIsSimple(0.0);
                if (!geometry.isEmpty() && Geometry.isMultiPath(this.geometryData.geometryType.value())) {
                    MultiPathData mpd = (MultiPathData)this.geometryData;
                    MultiPathImpl mpImpl = (MultiPathImpl)geometry._getImpl();
                    mpd.ogcFlags = new boolean[mpImpl.getPathCount()];
                    AttributeStreamOfInt8 pathFlags = mpImpl.getPathFlagsStreamRef();
                    int i = 0;
                    int n = mpImpl.getPathCount();
                    while (i < n) {
                        mpd.ogcFlags[i] = (pathFlags.read(i) & 4) != 0;
                        ++i;
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new InvalidObjectException("Cannot serialize this geometry");
        }
    }

    static class BaseGeometryData
    implements Serializable {
        Geometry.Type geometryType;
        byte[] esriShape = null;

        BaseGeometryData() {
        }
    }

    static class MultiPathData
    extends MultiVertexData {
        boolean[] ogcFlags = null;

        MultiPathData() {
        }
    }

    static class MultiVertexData
    extends BaseGeometryData {
        int simpleFlag = 0;
        double tolerance = 0.0;

        MultiVertexData() {
        }
    }
}

