/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.expressions.index;

import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI$;
import com.databricks.labs.mosaic.core.index.IndexSystem;
import com.databricks.labs.mosaic.core.index.IndexSystemID$;
import com.databricks.labs.mosaic.expressions.index.IndexGeometry$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(indexID, indexSystem) - Returns the geometry representing the index.", examples="\n    Examples:\n      > SELECT _FUNC_(a, 'H3');\n      0001100100100.....001010 // WKB\n  ", since="1.0")
@ScalaSignature(bytes="\u0006\u0001\t\u001da\u0001\u0002\u0011\"\u0001:B\u0001b\u0019\u0001\u0003\u0016\u0004%\t\u0001\u001a\u0005\tQ\u0002\u0011\t\u0012)A\u0005K\"A\u0011\u000e\u0001BK\u0002\u0013\u0005!\u000e\u0003\u0005t\u0001\tE\t\u0015!\u0003l\u0011!!\bA!f\u0001\n\u0003Q\u0007\u0002C;\u0001\u0005#\u0005\u000b\u0011B6\t\u000bY\u0004A\u0011A<\t\u000bu\u0004A\u0011\t@\t\u000f\u0005-\u0001\u0001\"\u0011\u0002\u000e!1\u0011q\u0002\u0001\u0005B)Dq!!\u0005\u0001\t\u0003\n\u0019\u0002C\u0004\u0002 \u0001!\t%!\t\t\r\u0005M\u0002\u0001\"\u0011e\u0011\u001d\t)\u0004\u0001C)\u0003oA\u0011\"!\u0010\u0001\u0003\u0003%\t!a\u0010\t\u0013\u0005\u001d\u0003!%A\u0005\u0002\u0005%\u0003\"CA0\u0001E\u0005I\u0011AA1\u0011%\t)\u0007AI\u0001\n\u0003\t\t\u0007C\u0005\u0002h\u0001\t\t\u0011\"\u0011\u0002j!I\u0011\u0011\u0010\u0001\u0002\u0002\u0013\u0005\u00111\u0010\u0005\n\u0003\u0007\u0003\u0011\u0011!C\u0001\u0003\u000bC\u0011\"a#\u0001\u0003\u0003%\t%!$\t\u0013\u0005m\u0005!!A\u0005\u0002\u0005u\u0005\"CAT\u0001\u0005\u0005I\u0011IAU\u000f\u001d\t9-\tE\u0001\u0003\u00134a\u0001I\u0011\t\u0002\u0005-\u0007B\u0002<\u001b\t\u0003\ti\rC\u0004\u0002Pj!\t!!5\t\u0013\u0005\r($!A\u0005\u0002\u0006\u0015\b\"CAw5\u0005\u0005I\u0011QAx\u0011%\tiPGA\u0001\n\u0013\tyPA\u0007J]\u0012,\u0007pR3p[\u0016$(/\u001f\u0006\u0003E\r\nQ!\u001b8eKbT!\u0001J\u0013\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003M\u001d\na!\\8tC&\u001c'B\u0001\u0015*\u0003\u0011a\u0017MY:\u000b\u0005)Z\u0013A\u00033bi\u0006\u0014'/[2lg*\tA&A\u0002d_6\u001c\u0001a\u0005\u0004\u0001_y\"&\f\u0019\t\u0003aqj\u0011!\r\u0006\u0003IIR!a\r\u001b\u0002\u0011\r\fG/\u00197zgRT!!\u000e\u001c\u0002\u0007M\fHN\u0003\u00028q\u0005)1\u000f]1sW*\u0011\u0011HO\u0001\u0007CB\f7\r[3\u000b\u0003m\n1a\u001c:h\u0013\ti\u0014GA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\ty\u0014K\u0004\u0002A\u001f:\u0011\u0011I\u0014\b\u0003\u00056s!a\u0011'\u000f\u0005\u0011[eBA#K\u001d\t1\u0015*D\u0001H\u0015\tAU&\u0001\u0004=e>|GOP\u0005\u0002w%\u0011\u0011HO\u0005\u0003oaJ!!\u000e\u001c\n\u0005M\"\u0014B\u0001\u00133\u0013\t\u0001\u0016'A\u0004qC\u000e\\\u0017mZ3\n\u0005I\u001b&A\u0004(vY2Le\u000e^8mKJ\fg\u000e\u001e\u0006\u0003!F\u0002\"!\u0016-\u000e\u0003YS!aV\u0019\u0002\u000f\r|G-Z4f]&\u0011\u0011L\u0016\u0002\u0010\u0007>$WmZ3o\r\u0006dGNY1dWB\u00111LX\u0007\u00029*\tQ,A\u0003tG\u0006d\u0017-\u0003\u0002`9\n9\u0001K]8ek\u000e$\bCA.b\u0013\t\u0011GL\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0004j]\u0012,\u00070\u0013#\u0016\u0003\u0015\u0004\"\u0001\r4\n\u0005\u001d\f$AC#yaJ,7o]5p]\u0006A\u0011N\u001c3fq&#\u0005%A\bj]\u0012,\u0007pU=ti\u0016lg*Y7f+\u0005Y\u0007C\u00017q\u001d\tig\u000e\u0005\u0002G9&\u0011q\u000eX\u0001\u0007!J,G-\u001a4\n\u0005E\u0014(AB*ue&twM\u0003\u0002p9\u0006\u0001\u0012N\u001c3fqNK8\u000f^3n\u001d\u0006lW\rI\u0001\u0010O\u0016|W.\u001a;ss\u0006\u0003\u0016JT1nK\u0006\u0001r-Z8nKR\u0014\u00180\u0011)J\u001d\u0006lW\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\taT8\u0010 \t\u0003s\u0002i\u0011!\t\u0005\u0006G\u001e\u0001\r!\u001a\u0005\u0006S\u001e\u0001\ra\u001b\u0005\u0006i\u001e\u0001\ra[\u0001\tI\u0006$\u0018\rV=qKV\tq\u0010\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)\u0001N\u0001\u0006if\u0004Xm]\u0005\u0005\u0003\u0013\t\u0019A\u0001\u0005ECR\fG+\u001f9f\u0003!!xn\u0015;sS:<G#A6\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0003\u0002\u0016\u0005m\u0001cA.\u0002\u0018%\u0019\u0011\u0011\u0004/\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002\u001e-\u0001\r!!\u0006\u0002\r%t\u0007/\u001e;2\u0003!i\u0017m[3D_BLHcA3\u0002$!9\u0011Q\u0005\u0007A\u0002\u0005\u001d\u0012a\u00028fo\u0006\u0013xm\u001d\t\u00067\u0006%\u0012QF\u0005\u0004\u0003Wa&!B!se\u0006L\bcA.\u00020%\u0019\u0011\u0011\u0007/\u0003\r\u0005s\u0017PU3g\u0003\u0015\u0019\u0007.\u001b7e\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR\u0019Q-!\u000f\t\r\u0005mb\u00021\u0001f\u0003!qWm^\"iS2$\u0017\u0001B2paf$r\u0001_A!\u0003\u0007\n)\u0005C\u0004d\u001fA\u0005\t\u0019A3\t\u000f%|\u0001\u0013!a\u0001W\"9Ao\u0004I\u0001\u0002\u0004Y\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0017R3!ZA'W\t\ty\u0005\u0005\u0003\u0002R\u0005mSBAA*\u0015\u0011\t)&a\u0016\u0002\u0013Ut7\r[3dW\u0016$'bAA-9\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00131\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003GR3a[A'\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA6!\u0011\ti'a\u001e\u000e\u0005\u0005=$\u0002BA9\u0003g\nA\u0001\\1oO*\u0011\u0011QO\u0001\u0005U\u00064\u0018-C\u0002r\u0003_\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!! \u0011\u0007m\u000by(C\u0002\u0002\u0002r\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0006\u0002\b\"I\u0011\u0011R\u000b\u0002\u0002\u0003\u0007\u0011QP\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005=\u0005CBAI\u0003/\u000b)\"\u0004\u0002\u0002\u0014*\u0019\u0011Q\u0013/\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u001a\u0006M%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a(\u0002&B\u00191,!)\n\u0007\u0005\rFLA\u0004C_>dW-\u00198\t\u0013\u0005%u#!AA\u0002\u0005U\u0011AB3rk\u0006d7\u000f\u0006\u0003\u0002 \u0006-\u0006\"CAE1\u0005\u0005\t\u0019AA\u000bQ=\u0001\u0011qVA[\u0003o\u000bY,!0\u0002B\u0006\r\u0007c\u0001\u0019\u00022&\u0019\u00111W\u0019\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011X\u0001L?\u001a+fjQ0)S:$W\r_%EY\u0001Jg\u000eZ3y'f\u001cH/Z7*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fA\u001d,w.\\3uef\u0004#/\u001a9sKN,g\u000e^5oO\u0002\"\b.\u001a\u0011j]\u0012,\u0007PL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011qX\u0001X\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\nG\u0006I\u0014Ig\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\r\u00191cE\u0002\u0004'\r\u00191cA\u0002dF\f\u0018/]A\u0002\u0014\u0007M\u00191A=z\u0003eV&C\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAc\u0003\r\td\u0006M\u0001\u000e\u0013:$W\r_$f_6,GO]=\u0011\u0005eT2\u0003\u0002\u000e\u0002.\u0001$\"!!3\u0002-I,w-[:uef,\u0005\u0010\u001d:fgNLwN\\%oM>$B!a5\u0002ZB\u0019\u0001'!6\n\u0007\u0005]\u0017G\u0001\bFqB\u0014Xm]:j_:LeNZ8\t\u000f\u0005mG\u00041\u0001\u0002^\u0006\u0011AM\u0019\t\u00057\u0006}7.C\u0002\u0002br\u0013aa\u00149uS>t\u0017!B1qa2LHc\u0002=\u0002h\u0006%\u00181\u001e\u0005\u0006Gv\u0001\r!\u001a\u0005\u0006Sv\u0001\ra\u001b\u0005\u0006iv\u0001\ra[\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\t0!?\u0011\u000bm\u000by.a=\u0011\rm\u000b)0Z6l\u0013\r\t9\u0010\u0018\u0002\u0007)V\u0004H.Z\u001a\t\u0011\u0005mh$!AA\u0002a\f1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\u0005\u0001\u0003BA7\u0005\u0007IAA!\u0002\u0002p\t1qJ\u00196fGR\u0004")
public class IndexGeometry
extends UnaryExpression
implements package.NullIntolerant,
CodegenFallback,
Serializable {
    private final Expression indexID;
    private final String indexSystemName;
    private final String geometryAPIName;

    public static Option<Tuple3<Expression, String, String>> unapply(IndexGeometry indexGeometry) {
        return IndexGeometry$.MODULE$.unapply(indexGeometry);
    }

    public static ExpressionInfo registryExpressionInfo(Option<String> option) {
        return IndexGeometry$.MODULE$.registryExpressionInfo(option);
    }

    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$((CodegenFallback)this, (CodegenContext)ctx, (ExprCode)ev);
    }

    public Expression indexID() {
        return this.indexID;
    }

    public String indexSystemName() {
        return this.indexSystemName;
    }

    public String geometryAPIName() {
        return this.geometryAPIName;
    }

    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    public String toString() {
        return new StringBuilder(16).append("index_geometry(").append(this.indexID()).append(")").toString();
    }

    public String prettyName() {
        return "index_geometry";
    }

    public Object nullSafeEval(Object input1) {
        IndexSystem indexSystem = IndexSystemID$.MODULE$.getIndexSystem(IndexSystemID$.MODULE$.apply(this.indexSystemName()));
        GeometryAPI geometryAPI = GeometryAPI$.MODULE$.apply(this.geometryAPIName());
        MosaicGeometry indexGeometry = indexSystem.indexToGeometry(BoxesRunTime.unboxToLong(input1), geometryAPI);
        return indexGeometry.toWKB();
    }

    /*
     * WARNING - void declaration
     */
    public Expression makeCopy(Object[] newArgs) {
        void var3_3;
        Expression arg1 = (Expression)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps(newArgs)).head();
        IndexGeometry res = new IndexGeometry(arg1, this.indexSystemName(), this.geometryAPIName());
        res.copyTagsFrom((TreeNode)this);
        return var3_3;
    }

    public Expression child() {
        return this.indexID();
    }

    public Expression withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2(), this.copy$default$3());
    }

    public IndexGeometry copy(Expression indexID, String indexSystemName, String geometryAPIName) {
        return new IndexGeometry(indexID, indexSystemName, geometryAPIName);
    }

    public Expression copy$default$1() {
        return this.indexID();
    }

    public String copy$default$2() {
        return this.indexSystemName();
    }

    public String copy$default$3() {
        return this.geometryAPIName();
    }

    public String productPrefix() {
        return "IndexGeometry";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.indexID();
                break;
            }
            case 1: {
                object = this.indexSystemName();
                break;
            }
            case 2: {
                object = this.geometryAPIName();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)((Object)this));
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof IndexGeometry;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof IndexGeometry)) return false;
        boolean bl = true;
        if (!bl) return false;
        IndexGeometry indexGeometry = (IndexGeometry)x$1;
        Expression expression = this.indexID();
        Expression expression2 = indexGeometry.indexID();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        String string = this.indexSystemName();
        String string2 = indexGeometry.indexSystemName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.geometryAPIName();
        String string4 = indexGeometry.geometryAPIName();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        if (!indexGeometry.canEqual(this)) return false;
        return true;
    }

    public IndexGeometry(Expression indexID, String indexSystemName, String geometryAPIName) {
        this.indexID = indexID;
        this.indexSystemName = indexSystemName;
        this.geometryAPIName = geometryAPIName;
        CodegenFallback.$init$((CodegenFallback)this);
    }
}

