/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.core.geometry.polygon;

import com.databricks.labs.mosaic.core.geometry.GeometryReader;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometryJTS$;
import com.databricks.labs.mosaic.core.geometry.linestring.MosaicLineString;
import com.databricks.labs.mosaic.core.geometry.linestring.MosaicLineStringJTS;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPoint;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPointJTS;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPointJTS$;
import com.databricks.labs.mosaic.core.geometry.polygon.MosaicPolygonJTS;
import com.databricks.labs.mosaic.core.types.model.GeometryTypeEnum$;
import com.databricks.labs.mosaic.core.types.model.InternalCoord;
import com.databricks.labs.mosaic.core.types.model.InternalGeometry;
import com.databricks.labs.mosaic.core.types.model.InternalGeometry$;
import com.esotericsoftware.kryo.io.Input;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$DummyImplicit$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public final class MosaicPolygonJTS$
implements GeometryReader,
scala.Serializable {
    public static MosaicPolygonJTS$ MODULE$;
    private final int defaultSpatialReferenceId;

    static {
        new MosaicPolygonJTS$();
    }

    @Override
    public int defaultSpatialReferenceId() {
        return this.defaultSpatialReferenceId;
    }

    @Override
    public void com$databricks$labs$mosaic$core$geometry$GeometryReader$_setter_$defaultSpatialReferenceId_$eq(int x$1) {
        this.defaultSpatialReferenceId = x$1;
    }

    public MosaicPolygonJTS apply(Geometry geometry) {
        return new MosaicPolygonJTS((Polygon)geometry);
    }

    public Seq<MosaicPoint> getPoints(LinearRing linearRing) {
        return new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])linearRing.getCoordinates())).map((Function1<Coordinate, MosaicPointJTS> & Serializable & scala.Serializable)x$4 -> MosaicPointJTS$.MODULE$.apply((Coordinate)x$4, linearRing.getSRID()), Array$.MODULE$.fallbackCanBuildFrom(Predef$DummyImplicit$.MODULE$.dummyImplicit()));
    }

    @Override
    public MosaicGeometry fromInternal(InternalRow row) {
        GeometryFactory gf = new GeometryFactory();
        InternalGeometry internalGeom = InternalGeometry$.MODULE$.apply(row);
        LinearRing shell = gf.createLinearRing((Coordinate[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])internalGeom.boundaries())).head())).map((Function1<InternalCoord, Coordinate> & Serializable & scala.Serializable)x$5 -> x$5.toCoordinate(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Coordinate.class))));
        LinearRing[] holes = (LinearRing[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])internalGeom.holes())).head())).map((Function1<InternalCoord[], Coordinate[]> & Serializable & scala.Serializable)ring -> (Coordinate[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])ring)).map((Function1<InternalCoord, Coordinate> & Serializable & scala.Serializable)x$6 -> x$6.toCoordinate(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Coordinate.class))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Coordinate.class)))))).map((Function1<Coordinate[], LinearRing> & Serializable & scala.Serializable)x$1 -> gf.createLinearRing((Coordinate[])x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LinearRing.class)));
        Polygon geometry = gf.createPolygon(shell, holes);
        geometry.setSRID(internalGeom.srid());
        return MosaicGeometryJTS$.MODULE$.apply(geometry);
    }

    @Override
    public <T extends MosaicGeometry> MosaicPolygonJTS fromSeq(Seq<T> geomSeq, Enumeration.Value geomType) {
        Polygon polygon;
        GeometryFactory gf = new GeometryFactory();
        int spatialReference = ((MosaicGeometry)geomSeq.head()).getSpatialReference();
        Enumeration.Value value = GeometryTypeEnum$.MODULE$.fromString(((MosaicGeometry)geomSeq.head()).getGeometryType());
        Enumeration.Value value2 = GeometryTypeEnum$.MODULE$.POINT();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !((Object)value2).equals(value3) : value3 != null)) {
            Seq extractedPoints = geomSeq.map((Function1<MosaicGeometry, MosaicPointJTS> & Serializable & scala.Serializable)x$7 -> (MosaicPointJTS)x$7, Seq$.MODULE$.canBuildFrom());
            Coordinate[] exteriorRing = (Coordinate[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)extractedPoints.map((Function1<MosaicPointJTS, Coordinate> & Serializable & scala.Serializable)x$8 -> x$8.coord(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Coordinate.class)))).$plus$plus(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new Coordinate[]{((MosaicPointJTS)extractedPoints.head()).coord()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Coordinate.class)));
            polygon = gf.createPolygon(exteriorRing);
        } else {
            Enumeration.Value value4 = GeometryTypeEnum$.MODULE$.LINESTRING();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !((Object)value4).equals(value5) : value5 != null)) {
                Seq extractedLines = geomSeq.map((Function1<MosaicGeometry, MosaicLineStringJTS> & Serializable & scala.Serializable)x$9 -> (MosaicLineStringJTS)x$9, Seq$.MODULE$.canBuildFrom());
                LinearRing exteriorRing = gf.createLinearRing((Coordinate[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)((MosaicLineString)extractedLines.head()).asSeq().map((Function1<MosaicPoint, Coordinate> & Serializable & scala.Serializable)x$10 -> x$10.coord(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Coordinate.class)))).$plus$plus(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new Coordinate[]{((MosaicPoint)((MosaicLineString)extractedLines.head()).asSeq().head()).coord()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Coordinate.class))));
                LinearRing[] holes = (LinearRing[])((TraversableOnce)((TraversableLike)((TraversableLike)extractedLines.tail()).map((Function1<MosaicLineStringJTS, Coordinate[]> & Serializable & scala.Serializable)h -> (Coordinate[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)h.asSeq().map((Function1<MosaicPoint, Coordinate> & Serializable & scala.Serializable)x$11 -> x$11.coord(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Coordinate.class)))).$plus$plus(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new Coordinate[]{((MosaicPoint)h.asSeq().head()).coord()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Coordinate.class))), Seq$.MODULE$.canBuildFrom())).map((Function1<Coordinate[], LinearRing> & Serializable & scala.Serializable)x$1 -> gf.createLinearRing((Coordinate[])x$1), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(LinearRing.class));
                polygon = gf.createPolygon(exteriorRing, holes);
            } else {
                if (value != null) {
                    Enumeration.Value value6 = value;
                    throw new UnsupportedOperationException(new StringBuilder(57).append("MosaicGeometry.fromSeq() cannot create ").append(geomType.toString()).append(" from ").append(value6.toString()).append(" geometries.").toString());
                }
                throw new MatchError(value);
            }
        }
        Polygon newGeom = polygon;
        newGeom.setSRID(spatialReference);
        return this.apply(newGeom);
    }

    public <T extends MosaicGeometry> Enumeration.Value fromSeq$default$2() {
        return GeometryTypeEnum$.MODULE$.POLYGON();
    }

    @Override
    public MosaicGeometry fromWKB(byte[] wkb) {
        return MosaicGeometryJTS$.MODULE$.fromWKB(wkb);
    }

    @Override
    public MosaicGeometry fromWKT(String wkt) {
        return MosaicGeometryJTS$.MODULE$.fromWKT(wkt);
    }

    @Override
    public MosaicGeometry fromJSON(String geoJson) {
        return MosaicGeometryJTS$.MODULE$.fromJSON(geoJson);
    }

    @Override
    public MosaicGeometry fromHEX(String hex) {
        return MosaicGeometryJTS$.MODULE$.fromHEX(hex);
    }

    @Override
    public MosaicGeometry fromKryo(InternalRow row) {
        byte[] kryoBytes = row.getBinary(1);
        Input input = new Input(kryoBytes);
        return (MosaicGeometry)MosaicGeometryJTS$.MODULE$.kryo().readObject(input, MosaicPolygonJTS.class);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MosaicPolygonJTS$() {
        MODULE$ = this;
        GeometryReader.$init$(this);
    }
}

