/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.codegen.geometry;

import com.databricks.labs.mosaic.codegen.format.ConvertToCodeGen$;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometryJTS;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.types.DataType;
import org.locationtech.jts.geom.Geometry;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;

public final class GeometryTransformationsCodeGenJTS$ {
    public static GeometryTransformationsCodeGenJTS$ MODULE$;

    static {
        new GeometryTransformationsCodeGenJTS$();
    }

    public Tuple2<String, String> rotate(CodegenContext ctx, String geomEval, String angleEval, DataType dataType, GeometryAPI geometryAPI) {
        Tuple2<String, String> tuple2 = ConvertToCodeGen$.MODULE$.readGeometryCode(ctx, geomEval, dataType, geometryAPI);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String inCode = tuple2._1();
        String geomInRef = tuple2._2();
        Tuple2<String, String> tuple22 = new Tuple2<String, String>(inCode, geomInRef);
        Tuple2<String, String> tuple23 = tuple22;
        String inCode2 = tuple23._1();
        String geomInRef2 = tuple23._2();
        String tmpGeom = ctx.freshName("tmpGeom");
        Tuple2<String, String> tuple24 = ConvertToCodeGen$.MODULE$.writeGeometryCode(ctx, tmpGeom, dataType, geometryAPI);
        if (tuple24 == null) {
            throw new MatchError(tuple24);
        }
        String outCode = tuple24._1();
        String geomOutRef = tuple24._2();
        Tuple2<String, String> tuple25 = new Tuple2<String, String>(outCode, geomOutRef);
        Tuple2<String, String> tuple26 = tuple25;
        String outCode2 = tuple26._1();
        String geomOutRef2 = tuple26._2();
        String jtsGeometryClass = Geometry.class.getName();
        String mosaicGeometryJTSClass = MosaicGeometryJTS.class.getName();
        return new Tuple2<String, String>(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(96).append("\n             |").append(inCode2).append("\n             |").append(jtsGeometryClass).append(" ").append(tmpGeom).append(" = ((").append(mosaicGeometryJTSClass).append(")").append(mosaicGeometryJTSClass).append(".apply(").append(geomInRef2).append(").rotate(").append(angleEval).append(")).getGeom();\n             |").append(outCode2).append("\n             |").toString())).stripMargin(), geomOutRef2);
    }

    public Tuple2<String, String> scale(CodegenContext ctx, String geomEval, String xDist, String yDist, DataType dataType, GeometryAPI geometryAPI) {
        Tuple2<String, String> tuple2 = ConvertToCodeGen$.MODULE$.readGeometryCode(ctx, geomEval, dataType, geometryAPI);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String inCode = tuple2._1();
        String geomInRef = tuple2._2();
        Tuple2<String, String> tuple22 = new Tuple2<String, String>(inCode, geomInRef);
        Tuple2<String, String> tuple23 = tuple22;
        String inCode2 = tuple23._1();
        String geomInRef2 = tuple23._2();
        String tmpGeom = ctx.freshName("tmpGeom");
        Tuple2<String, String> tuple24 = ConvertToCodeGen$.MODULE$.writeGeometryCode(ctx, tmpGeom, dataType, geometryAPI);
        if (tuple24 == null) {
            throw new MatchError(tuple24);
        }
        String outCode = tuple24._1();
        String geomOutRef = tuple24._2();
        Tuple2<String, String> tuple25 = new Tuple2<String, String>(outCode, geomOutRef);
        Tuple2<String, String> tuple26 = tuple25;
        String outCode2 = tuple26._1();
        String geomOutRef2 = tuple26._2();
        String jtsGeometryClass = Geometry.class.getName();
        String mosaicGeometryJTSClass = MosaicGeometryJTS.class.getName();
        return new Tuple2<String, String>(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(97).append("\n             |").append(inCode2).append("\n             |").append(jtsGeometryClass).append(" ").append(tmpGeom).append(" = ((").append(mosaicGeometryJTSClass).append(")").append(mosaicGeometryJTSClass).append(".apply(").append(geomInRef2).append(").scale(").append(xDist).append(", ").append(yDist).append(")).getGeom();\n             |").append(outCode2).append("\n             |").toString())).stripMargin(), geomOutRef2);
    }

    public Tuple2<String, String> translate(CodegenContext ctx, String geomEval, String xDist, String yDist, DataType dataType, GeometryAPI geometryAPI) {
        Tuple2<String, String> tuple2 = ConvertToCodeGen$.MODULE$.readGeometryCode(ctx, geomEval, dataType, geometryAPI);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String inCode = tuple2._1();
        String geomInRef = tuple2._2();
        Tuple2<String, String> tuple22 = new Tuple2<String, String>(inCode, geomInRef);
        Tuple2<String, String> tuple23 = tuple22;
        String inCode2 = tuple23._1();
        String geomInRef2 = tuple23._2();
        String tmpGeom = ctx.freshName("tmpGeom");
        Tuple2<String, String> tuple24 = ConvertToCodeGen$.MODULE$.writeGeometryCode(ctx, tmpGeom, dataType, geometryAPI);
        if (tuple24 == null) {
            throw new MatchError(tuple24);
        }
        String outCode = tuple24._1();
        String geomOutRef = tuple24._2();
        Tuple2<String, String> tuple25 = new Tuple2<String, String>(outCode, geomOutRef);
        Tuple2<String, String> tuple26 = tuple25;
        String outCode2 = tuple26._1();
        String geomOutRef2 = tuple26._2();
        String jtsGeometryClass = Geometry.class.getName();
        String mosaicGeometryJTSClass = MosaicGeometryJTS.class.getName();
        return new Tuple2<String, String>(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(101).append("\n             |").append(inCode2).append("\n             |").append(jtsGeometryClass).append(" ").append(tmpGeom).append(" = ((").append(mosaicGeometryJTSClass).append(")").append(mosaicGeometryJTSClass).append(".apply(").append(geomInRef2).append(").translate(").append(xDist).append(", ").append(yDist).append(")).getGeom();\n             |").append(outCode2).append("\n             |").toString())).stripMargin(), geomOutRef2);
    }

    private GeometryTransformationsCodeGenJTS$() {
        MODULE$ = this;
    }
}

