Planetary maps
==============

> __Warning__: For ESA/JUICE instruments,
> the longitudes are defined eastward from (0° to 360° to the East).
> This definition is not consistent with the IAU report (2018)
> and the NAIF-SPICE planetographic coordinate system (defined
> westward for prograde bodies).

> __Note__: All the maps are center at 180° and the mean radius is calculated
> based on `pck00010.tpc` kernel.

Mercury
-------
* __Mean radius__: 2,439.7 km

![USGS 4.6 km mosaic](Mercury.jpg)

* __Source__: [USGS](https://planetarymaps.usgs.gov/mosaic/Mercury_MESSENGER_MDIS_Basemap_LOI_Mosaic_Global_166m.tif)
* __Original image size__: 92,160 × 46,080 pixels
* __Instrument__: Messenger WAC/NAC at 750 nm
* __Equatorial resolution__: 166 m / pixel


Venus
-----
* __Mean radius__: 6,051.8 km

![USGS 4.6 km mosaic](Venus.jpg)

* __Source__: [USGS](https://planetarymaps.usgs.gov/mosaic/Venus_Magellan_C3-MDIR_Colorized_Global_Mosaic_4641m.tif)
* __Original image size__: 8,192 ×  4,096 pixels
* __Instrument__: C3-MDIR Synthetic Color Mosaic
* __Equatorial resolution__: 4.6 km / pixel


Earth
-----
* __Mean radius__: 6,371.0 km

![July, Blue Marble Next Generation w/ Topography and Bathymetry](Earth.jpg)

* __Source__: [NASA](https://visibleearth.nasa.gov/images/73751/july-blue-marble-next-generation-w-topography-and-bathymetry)
* __Original image size__: 86,400 ×  43,200 pixels
* __Instrument__: Terra MODIS
* __Equatorial resolution__: 463 m / pixel


Moon
----
* __Mean radius__: 1,737.4 km

![USGS 100 m mosaic](Moon.jpg)

* __Source__: [USGS](https://planetarymaps.usgs.gov/mosaic/Lunar_LRO_LROC-WAC_Mosaic_global_100m_June2013.tif)
* __Original image size__: 109,164 ×  54,582 pixels
* __Instrument__: LRO WAC
* __Equatorial resolution__: 100 m / pixel


Mars
-----
* __Mean radius__: 3,389.5 km

![USGS 925 km mosaic](Mars.jpg)

* __Source__: [USGS](https://planetarymaps.usgs.gov/mosaic/Mars_Viking_ClrMosaic_global_925m.tif)
* __Original image size__: 11,530 × 23,059 pixels
* __Instrument__: Viking Orbiter (red and violet filters)
* __Equatorial resolution__: 925 m / pixel


Jupiter
-------
* __Mean radius__: 69,911.3 km

![JPL PIA07782 20 km mosaic](Jupiter.jpg)

__Warning:__ For the Giant Planets (Jupiter, Saturn, Uranus and Neptune) the background maps
provided here are just for illustrative purposes but don't really represent the location
of the main feature on the top of the atmosphere (since they drift rapidly with time).

* __Source__: [JPL PIA07782](https://photojournal.jpl.nasa.gov/tiff/PIA07782.tif)
* __Original image size__: 3,601 ×  1,801 pixels
* __Instrument__: Cassini ISS
* __Equatorial resolution__: 122 km / pixel


Io
--
* __Mean radius__: 1,821.5 km

![USGS/ESA 1 km mosaic](Io.jpg)

* __Source__: [USGS](https://astrogeology.usgs.gov/search/map/Io/Voyager-Galileo/Io_GalileoSSI-Voyager_Global_Mosaic_ClrMerge_1km)
* __Original image size__: 11,445 ×  5,723 pixels
* __Instrument__: Voyager ISS / Galileo SSI
* __Equatorial resolution__: 1 km / pixel


Europa
------
* __Mean radius__: 1,560.8 km

![NASA/JPL/Björn Jónsson 500 m mosaic](Europa.jpg)

* __Source__: [NASA/JPL/Björn Jónsson](https://www.planetary.org/space-images/color-global-map-of-europa)
* __Original image size__: 20,000 × 10,000 pixels
* __Instrument__: Voyager ISS / Galileo SSI
* __Equatorial resolution__: 490 m / pixel

_Note:_ The area without data were masked based on the [previously
published USGS map](https://astrogeology.usgs.gov/search/map/Europa/Voyager-Galileo/Europa_Voyager_GalileoSSI_global_mosaic_500m) for Europa.


Ganymede
--------
* __Mean radius__: 2,631.2 km

![Kersten et al. 2021 * PSS](Ganymede.jpg)

* __Source__: [Kersten et al. 2021 * PSS / DLR](https://doi.org/10.1016/j.pss.2021.105310)
* __Original image size__: 46,080 × 23,039 pixels
* __Instrument__: Voyager ISS / Galileo SSI
* __Equatorial resolution__: 360 m / pixel


Callisto
--------
* __Mean radius__: 2,410.3 km

![USGS/ESA Callisto 1 km mosaic](Callisto.jpg)

* __Source__: [USGS/ESA](https://www.cosmos.esa.int/web/juice/reference-maps-ganymede-europa-callisto-)
* __Original image size__: 15,138 × 7,569 pixels
* __Instrument__: Voyager ISS / Galileo SSI
* __Equatorial resolution__: 1 km / pixel

Saturn
-------
* __Mean radius__: 58,232.0 km

![Saturn map](Saturn.jpg)

* __Source__: [Björn Jónsson](http://bjj.mmedia.is/data/saturn/index.html)
* __Original image size__: 2,880 ×  1,440 pixels
* __Instrument__: Cassini ISS
* __Equatorial resolution__: 122 km / pixel

Enceladus
-------
* __Mean radius__: 252.1 km

![Enceladus map](Enceladus.jpg)

* __Source__: [JPL PIA18435](https://photojournal.jpl.nasa.gov/catalog/PIA18435)
* __Original image size__: 15,960 ×  7,980 pixels
* __Instrument__: Cassini ISS (IR3-GRN-UV3)
* __Equatorial resolution__: 100 m / pixel

Titan
-------
* __Mean radius__: 2,574.8 km

![Titan map](Titan.jpg)

* __Source__: [JPL PIA22770](https://photojournal.jpl.nasa.gov/catalog/PIA22770)
* __Original image size__: 5,760 × 2,880 pixels
* __Instrument__: Cassini ISS (CB3 938 nm)
* __Equatorial resolution__: 2.8 km / pixel

Uranus
-------
* __Mean radius__: 25,362.2 km

![Uranus map](Uranus.jpg)

* __Source__: [Solid color (`#b6e0e3`) extracted from JPL PIA18182](https://photojournal.jpl.nasa.gov/catalog/PIA18182)
* __Original image size__: 1 × 1 pixels
* __Instrument__: Voyager ISS
* __Equatorial resolution__: 0 km / pixel

Neptune
-------
* __Mean radius__: 24,622.2 km

![Neptune map](Neptune.jpg)

* __Source__: [Björn Jónsson](http://bjj.mmedia.is/data/neptune/index.html)
* __Original image size__: 1,800 × 900 pixels
* __Instrument__: Voyager 2 ISS
* __Equatorial resolution__: 86 km / pixel

Pluto
-------
* __Mean radius__: 1,195.0 km

![Pluto map](Pluto.jpg)

* __Source__: [JPL PIA11707](https://photojournal.jpl.nasa.gov/catalog/PIA11707)
* __Original image size__: 5,926 × 2,963 pixels
* __Instrument__: New Horizon LORRI/Ralph
* __Equatorial resolution__: 1.2 km / pixel

Charon
-------
* __Mean radius__: 605.0 km

![Charon map](Charon.jpg)

* __Source__: [Antdoghalo](https://www.flickr.com/photos/60012030@N02/49983125091/)
* __Original image size__: 12,694 × 6,347 pixels
* __Instrument__: New Horizon LORRI/MVIC
* __Equatorial resolution__: 300 m / pixel



How to (re)-generate these maps and the maps assets
---------------------------------------------------
```python
from planetary_coverage.maps import Map

m = Map('Ganymede_Voyager_GalileoSSI_global_mosaic_1km.tif', size=(1024, 2048))

# Save resized image
m.img.save('Ganymede.jpg')

# Create documentation thumbnail with map grid
m.map(fout='Ganymede.jpg')
```
