"""Planetary coverage module."""

from importlib.metadata import version

from .esa import ESA_MK
from .events import read_events
from .maps import (
    CALLISTO, CHARON, EARTH, ENCELADUS, EUROPA, GANYMEDE, IO, JUPITER,
    MAPS, MARS, MERCURY, MOON, NEPTUNE, PLUTO, SATURN, TITAN, URANUS, VENUS
)
from .misc.dotenv import print_kernels_dir
from .misc.ipython import load_ipython_extension
from .rois import (
    ROI, CallistoROIs, GanymedeROIs, GeoJsonROI, KmlROIsCollection
)
from .spice import (
    MetaKernel, SpicePool, SpiceRef, datetime, et, sorted_datetimes, tdb, utc
)
from .trajectory import TourConfig, Trajectory


__all__ = [
    'MERCURY',
    'VENUS',
    'EARTH',
    'MOON',
    'MARS',
    'JUPITER',
    'IO',
    'EUROPA',
    'GANYMEDE',
    'CALLISTO',
    'SATURN',
    'ENCELADUS',
    'TITAN',
    'URANUS',
    'NEPTUNE',
    'PLUTO',
    'CHARON',
    'MAPS',
    'ROI',
    'ESA_MK',
    'GeoJsonROI',
    'KmlROIsCollection',
    'GanymedeROIs',
    'CallistoROIs',
    'MetaKernel',
    'SpicePool',
    'SpiceRef',
    'datetime',
    'sorted_datetimes',
    'et',
    'tdb',
    'utc',
    'read_events',
    'TourConfig',
    'Trajectory',
    'print_kernels_dir',
    'load_ipython_extension',
]

__version__ = version('planetary-coverage')
