# -*- coding: utf-8 -*-
__male_rus_names = {'август', 'агап', 'агафон', 'адам', 'адриан', 'азарий', 'аким', 'алан', 'александр', 'алексей',
                    'альберт', 'анатолий', 'андрей', 'антип', 'антон', 'анфим', 'аполлинарий', 'арий', 'аристарх',
                    'аркадий', 'арно', 'арнольд', 'арсений', 'артем', 'артемий', 'артур', 'архип', 'афанасий',
                    'боголюб', 'болеслав', 'борис', 'борислав', 'бронислав', 'вадим', 'валентин', 'валерий',
                    'вальдемар', 'варфоломей', 'василий', 'ватслав', 'велизар', 'венедикт', 'вениамин', 'викентий',
                    'виктор', 'вилен', 'виссарион', 'виталий', 'владимир', 'владислав', 'владлен', 'власий', 'володар',
                    'всеволод', 'вячеслав', 'гектор', 'геннадий', 'георгий', 'герасим', 'герман', 'глеб', 'горислав',
                    'григорий', 'даниил', 'данислав', 'демид', 'демьян', 'денис', 'дмитрий', 'добрыня', 'дорофей',
                    'евгений', 'евграф', 'евдоким', 'евсей', 'евстафий', 'егор', 'елизар', 'елисей', 'емельян',
                    'еремей', 'ермак', 'ермил', 'ермолай', 'ерофей', 'ефим', 'ефрем', 'жан', 'захар', 'зигмунд',
                    'зиновий', 'зосима', 'зураб', 'иван', 'игнат', 'игнатий', 'игорь', 'илларион', 'илья', 'инокентий',
                    'ипполит', 'казимир', 'кай', 'камиль', 'ким', 'кир', 'кирилл', 'клавдий', 'клим', 'кондрат',
                    'константин', 'корней', 'корнелий', 'кузьма', 'лавр', 'лаврентий', 'лазарь', 'ларион', 'лев',
                    'леонард', 'леонид', 'леонтий', 'лука', 'лукьян', 'любомир', 'макар', 'макарий', 'максим',
                    'максимильян', 'марк', 'маркел', 'марсель', 'мартин', 'матвей', 'мечеслав', 'микула', 'милан',
                    'мирон', 'мирослав', 'митрофан', 'михаил', 'модест', 'мстислав', 'нестор', 'никанор', 'никита',
                    'никифор', 'никодим', 'никола', 'николай', 'олег', 'онисим', 'орест', 'осип', 'остап', 'павел',
                    'панкрат', 'парамон', 'пахом', 'петр', 'порфирий', 'потап', 'прокофий', 'прохор', 'радомир',
                    'радослав', 'рафаэль', 'ренат', 'роберт', 'родион', 'ролан', 'роман', 'ростислав', 'рудольф',
                    'савелий', 'светозар', 'святослав', 'семен', 'серафим', 'сергей', 'спартак', 'спиридон',
                    'станислав', 'степан', 'стефан', 'тарас', 'терентий', 'тимофей', 'тихомир', 'тихон', 'трифон',
                    'трофим', 'ульян', 'устин', 'федор', 'федот', 'феликс', 'феофан', 'филарет', 'филат', 'филимон',
                    'филипп', 'фирс', 'фома', 'фрол', 'харитон', 'эдуард', 'эмилий', 'эраст', 'эрик', 'эрнест', 'юлиан',
                    'юлий', 'юрий', 'юст', 'яков', 'ян', 'януарий', 'яромир', 'ярослав'}
__female_rus_names = {'августа', 'авдотья', 'аврора', 'агата', 'аглая', 'агнесса', 'агния', 'ада', 'адель', 'аза',
                      'азалия', 'аида', 'аксинья', 'акулина', 'алевтина', 'александра', 'алексия', 'алёна', 'алина',
                      'алиса', 'алла', 'альберта', 'амалия', 'анастасия', 'ангелина', 'андриана', 'анеля', 'анжела',
                      'анжелика', 'анисья', 'анита', 'анна', 'антонина', 'анфиса', 'апрелия', 'ариадна', 'арина',
                      'арсения', 'ассоль', 'астра', 'ася', 'аурика', 'аэлита', 'бажена', 'беата', 'беатриса', 'белла',
                      'беляна', 'береслава', 'берта', 'богдана', 'божена', 'бронислава', 'валентина', 'валерия',
                      'ванда', 'ванесса', 'варвара', 'василина', 'василиса', 'васса', 'веда', 'венера', 'вера',
                      'вероника', 'веселина', 'веста', 'вета', 'вивиана', 'видана', 'виктория', 'вилора', 'виола',
                      'виринея', 'виталия', 'влада', 'владилена', 'владимира', 'владислава', 'власта', 'воля',
                      'всеслава', 'габриэлла', 'гайя', 'галина', 'гелия', 'гелла', 'гера', 'герда', 'глафира', 'глория',
                      'грация', 'грета', 'дайна', 'дана', 'даниэла', 'дарина', 'дарья', 'дарьяна', 'декабрина', 'дея',
                      'дженни', 'джулия', 'диана', 'дина', 'добрава', 'доля', 'доминика', 'дорофея', 'ева', 'евгения',
                      'евдокия', 'екатерина', 'елена', 'елизавета', 'емельяна', 'есения', 'ефимия', 'ефросиния',
                      'жанна', 'жасмин', 'ждана', 'забава', 'залина', 'зара', 'зарема', 'зарина', 'звана', 'звенислава',
                      'земфира', 'зинаида', 'зиновия', 'зита', 'злата', 'златослава', 'зоряна', 'зоя', 'иванна',
                      'ивона', 'ида', 'изабелла', 'изольда', 'илона', 'иля', 'инга', 'инесса', 'инна', 'иоанна',
                      'иоланта', 'ирина', 'ирма', 'искра', 'июлия', 'камилла', 'карина', 'каролина', 'катарина', 'кира',
                      'клавдия', 'клара', 'кристина', 'ксения', 'лада', 'лана', 'лара', 'лариса', 'лаура', 'леля',
                      'лера', 'леся', 'лиана', 'лидия', 'лика', 'лилиана', 'лилия', 'лина', 'линда', 'лира', 'лия',
                      'лолита', 'лора', 'луиза', 'любава', 'любовь', 'людмила', 'майя', 'малика', 'мальвина',
                      'маргарита', 'марианна', 'марина', 'мария', 'марта', 'матрена', 'мелания', 'мелисса', 'мила',
                      'милада', 'милана', 'милолика', 'милослава', 'мира', 'мирослава', 'мишель', 'мия', 'млада',
                      'моника', 'муза', 'надежда', 'нана', 'наталья', 'нева', 'нелли', 'ника', 'николина', 'николь',
                      'нила', 'нина', 'нинель', 'нона', 'оксана', 'олеся', 'олимпия', 'ольга', 'пелагея', 'полина',
                      'прасковья', 'рада', 'раиса', 'регина', 'рената', 'риана', 'римма', 'рита', 'роберта', 'рогнеда',
                      'роза', 'роксана', 'ростислава', 'рузана', 'руслана', 'руфина', 'сабрина', 'сандра', 'светлана',
                      'святослава', 'северина', 'селена', 'серафима', 'сильвия', 'слава', 'славяна', 'снежана', 'соня',
                      'софия', 'станислава', 'стелла', 'стефания', 'таисия', 'тамара', 'татьяна', 'ульяна', 'урсула',
                      'услада', 'устина', 'фаина', 'феба', 'фекла', 'фрида', 'хана', 'хельга', 'хлоя', 'христина',
                      'царина', 'цветана', 'цецилия', 'чулпан', 'шанель', 'шарлотта', 'шейла', 'эвелина', 'эдита',
                      'элеонора', 'элина', 'элла', 'элоиза', 'эльвира', 'эльза', 'эльмира', 'эмилия', 'эмма', 'эрика',
                      'эсмеральда', 'эстер', 'эшли', 'юлиана', 'юлия', 'юна', 'юния', 'юнона', 'ядвига', 'яна', 'янина',
                      'ярина', 'яромира', 'ярослава', 'ясмина'}


def get_gender(name: str, use_strings=False) -> int:
    """
    Возвращает пол по имени. 0 - Ж, 1 - М, -1 - если не удалось определить пол
    :param use_strings: если True, вернёт текстовое представление иначе числом
    :param name: полное имя
    :return: пол
    """

    name = name.lower().strip().replace('ё', 'е')
    if name in __female_rus_names:
        return 0 if not use_strings else 'female'
    if name in __male_rus_names:
        return 1 if not use_strings else 'male'
    return -1 if not use_strings else 'undefined'

