import unittest
import os, sys
parentPath = os.path.abspath("..")
if parentPath not in sys.path:
    sys.path.insert(0, parentPath)

from pybtc import *
from binascii import unhexlify
from pybtc import rh2s
from pybtc import *

block_a = """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"""
#            # 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
# block_b = "00000020770aa9d59da8a8d897ed2aa023755d774c859bd7740e3fa6ef11000000000000a1bdc212eaae007129353da83ba81c3361681fcd526a9543f6b0210b4e595d1a5d8a7d5a402b371ae4be5a2202010000000001010000000000000000000000000000000000000000000000000000000000000000ffffffff2b03df891300045d8a7d5a0456360e330c64887d5a73887d5a410f00000a636b706f6f6c07746573746e6574ffffffff02699ea904000000001976a91422ba040f820174c8ad8d3b568c2801390a81fa8c88ac0000000000000000266a24aa21a9ed15e05d39fb8de40813e91f4029eb0c0bdfd27df73bca3253b4c738c1cd8b374e012000000000000000000000000000000000000000000000000000000000000000000000000001000000000101875e650b1096e216784b141f98318ec9c6f4093cade620ffad8c753304b6028101000000171600142392b05ad19a4706f1a5c3feb1f37690b964cab5ffffffff0263190000000000001976a914eb2d08a5e7839661eaf02a39289f991ad8b44d2688ac3d9683d71500000017a914a10bf0bf639376e87a6b94559a67a328e88484f28702483045022100bd9b6f580242576d069b6e0cda91260166b969fbe8748a7238364324c669031a022051e602d7b0de61442d064baaef85a355667ffcb89b45aa7fa0f3eacf68a1aa8401210351286a6b3f8f603f35e8bdcda042973fcfe31385ef436e04c2c733fe8dead8d700000000"
# block_c ="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"
# block_template = {
#   "capabilities": [
#     "proposal"
#   ],
#   "version": 536870912,
#   "rules": [
#     "csv",
#     "segwit"
#   ],
#   "vbavailable": {
#   },
#   "vbrequired": 0,
#   "previousblockhash": "000000000000289f2c0ddd382204f00a074f3dc45ee67dd24931c332769678a2",
#   "transactions": [
#     {
#       "data": "02000000018d391ad038d0ab892bfe778fbca922570006b5433c794150fc0b6cdc0d4d8c24010000006b483045022100d47d2e260d15014bc76e8bfabc5b24d3861b3f5546912ccf25448ec3a99713df02203d6400d31a67c95b080aec14287295518d936f235fc0ae9f1dcbd2b38bdf8f9a01210265e757b7789d4207a6c8b31f6f61fffb7e77f38466a09f854503e79ba9921042ffffffff01647648050000000017a9145f49aacdc4f9a50e71073e8ed3c449a2775951768700000000",
#       "txid": "adedea018281f4634bbbb8a9ab59c22d898a2f9b0a7e99645fcde5881a2b9297",
#       "hash": "adedea018281f4634bbbb8a9ab59c22d898a2f9b0a7e99645fcde5881a2b9297",
#       "depends": [
#       ],
#       "fee": 211890,
#       "sigops": 0,
#       "weight": 760
#     },
#     {
#       "data": "0200000001778242b7e893a75eac2f23d4fdd1089dddb96f15a6180888a74e0afa1039bb89000000006a47304402202607e5e111fbea1be4c522492d8ec75261295ff67c7ae2e178b40e632acbd2df02201c793fcec0c40e136dd940df7086b9251bcb0400fab81fc6a11bbc9cd57a9346012103f20010e67b3b8c4570ecd5e41e2e5c76aca47a2875ed8baf81d03e0ee58362b3feffffff02c09c6a150000000017a914c69533f8dee891ab00b10a53ca5da3a0aeb1338d871520009f390000001976a91443f8560c317db0cc9cffe2493cdb666d8af8fb4888ac218a1300",
#       "txid": "1102b32f8d3178906f6f7eedf55c1db8065410287d6f2bb63f845be3732ca423",
#       "hash": "1102b32f8d3178906f6f7eedf55c1db8065410287d6f2bb63f845be3732ca423",
#       "depends": [
#       ],
#       "fee": 112000,
#       "sigops": 4,
#       "weight": 892
#     },
#     {
#       "data": "0200000001ddaa8cb4301386aac07445316ea6e77c415c7c1b55b1c8fc157bf4dbad904f48000000006a47304402200cc11f209b4d711e3bea37d5cb590aa5e93bcac3139f70e283550aaecc6e41860220422655042d71f539aa8c58d83e4647986db544fad6529a4c4b4decb2bef64063012102f9077641d9bcc3f4b1cd88806bc3753db9163c7c3e30973733efe2eb158048e6feffffff02dc85ba0b0000000017a914c69537336abdf1fbff7c402961588bd6f7c0612487344f7431220000001976a914f0f058cf6a10e06eb566e807c0d46975eb528f5e88ac218a1300",
#       "txid": "e0cdcdbde06d28370ceabca5858383063ca49f5401d0b1f1eef07d7590ac9730",
#       "hash": "e0cdcdbde06d28370ceabca5858383063ca49f5401d0b1f1eef07d7590ac9730",
#       "depends": [
#       ],
#       "fee": 112000,
#       "sigops": 4,
#       "weight": 892
#     },
#     {
#       "data": "020000000123a42c73e35b843fb62b6f7d28105406b81d5cf5ed7e6f6f9078318d2fb30211010000006a47304402206dec928bbfb1b528d12cbc0616d5216670662b79df6c2aa23ba49c89d8c4e52402206cb09aeee2673908276cfa3985daddc7cb8c76415e64fcf42b59323c7ff40593012102627faadf34ee604025f928eecaf4b82fdbbfdcaee3f6d73bedd1debdfe922973feffffff020069328e390000001976a914ff840cb02ec485aadf183587dac007012c0522bd88ac9501cc100000000017a914c69533f8dee891ab00b10a53ca5da3a0aeb1338d87218a1300",
#       "txid": "534aad37f7ebac88e1230ebcbf03e39478fe67c85d7819f4d7cc18969951b349",
#       "hash": "534aad37f7ebac88e1230ebcbf03e39478fe67c85d7819f4d7cc18969951b349",
#       "depends": [
#         2
#       ],
#       "fee": 112000,
#       "sigops": 4,
#       "weight": 892
#     },
#     {
#       "data": "02000000013097ac90757df0eef1b1d001549fa43c06838385a5bcea0c37286de0bdcdcde0010000006b483045022100b26745d16059f2696cbe302fdbaea61ee1d9c5a853e3b058f279a59c5b057854022064e6ef71ac851225d6b9fc8ecf97b904cc228d02b83555903850b890e3d65da00121021fe6ff371efd74e52f04f890a4399de7e54e948356146cb8716ec1be2306afc6feffffff0253383d060000000017a914c6953588f38d06d640a838e7cf6e6fe4f4d17b92876161352b220000001976a914c3e56e70feb2af70d7bf587643016cc1aa1edcc088ac218a1300",
#       "txid": "0ee0cf5f7cd415e1ceeb57919ee99c71cb495163aa44bc3dee2c25e198f81147",
#       "hash": "0ee0cf5f7cd415e1ceeb57919ee99c71cb495163aa44bc3dee2c25e198f81147",
#       "depends": [
#         3
#       ],
#       "fee": 112000,
#       "sigops": 4,
#       "weight": 896
#     },
#     {
#       "data": "02000000014711f898e1252cee3dbc44aa635149cb719ce99e9157ebcee115d47c5fcfe00e010000006a47304402200875e97f19b8d2d282aef47b2b2ede0f780ec585f6fa741d900d05db168d09740220622ef6777fa4f109ab42af6976caa7864b29df05f66fc75f805040b29cfe1e1a012102e732d6c1283a35c3cf0565d4c2c09da3647b9913651ff0a7115bfee409aaa7e5feffffff02d973ed1f220000001976a914679d6a545c45516f4cb00320558a5665a8ea33a488ac0838460b0000000017a914c69536e5aaa50fcf53f6e433454797dce14f62ba87e9891300",
#       "txid": "d1084adf211f17f828dd5e976b1cb96ef2ca9654314cb3d535361b7a2fc7834b",
#       "hash": "d1084adf211f17f828dd5e976b1cb96ef2ca9654314cb3d535361b7a2fc7834b",
#       "depends": [
#         5
#       ],
#       "fee": 112000,
#       "sigops": 4,
#       "weight": 892
#     },
#     {
#       "data": "02000000014b83c72f7a1b3635d5b34c315496caf26eb91c6b975edd28f8171f21df4a08d1000000006a47304402204a33e70bd1ef6db33c4efe26f76c6a6cf998cce2e43bdd95f500f734c9b5a1b4022045fd6d337cc37f8f37704daedbc6a7174837910ec432dedb4b976f1e38bf4808012103abf4c59ba16be83fe0f89beb343e0fe85a3ecbeae21cfa456de76e7c12d9b483feffffff02771c19030000000017a9143207c5cfc389ec7fa6d18b55557b1c419ceb548e87e2a1d21c220000001976a9143af2d13f3344b16051efe30fa2e1de68930e76ba88ac218a1300",
#       "txid": "161464d9ea88b48876520d7187ae7a0770741c97cc5cbceb649b20ab5bfc893a",
#       "hash": "161464d9ea88b48876520d7187ae7a0770741c97cc5cbceb649b20ab5bfc893a",
#       "depends": [
#         6
#       ],
#       "fee": 112000,
#       "sigops": 4,
#       "weight": 892
#     },
#     {
#       "data": "010000000142b3b77c33c6cd2faef69ce87b7c5340e6ba1508580dd5dae671adaebd48d623010000006b4830450221008ffcc0bda2eac358ad6f1f95f0e8affe87e72c6e9d1358fda83eeb2aa6ac9ebb0220078e0a5280f49fe9847cade71896e5bab8f733a96d1a6e85544dda61a8ba15cb012103b403539e4175cde64cc99b71d0d9cfc701c193bed1d6df17ae37b92e8506f141ffffffff0200000000000000001e6a1c504f45540000000206b49b2877a2c3617c2baa3715a5f1d281f0dd42c30638510a0000001976a9140fcc88829c46f85443edcce2150a8edbf57b48be88ac00000000",
#       "txid": "07e290439427132272fc4659e73ba8ea3dd8acc9c5a1e1af237b0c543ed1009f",
#       "hash": "07e290439427132272fc4659e73ba8ea3dd8acc9c5a1e1af237b0c543ed1009f",
#       "depends": [
#       ],
#       "fee": 100000,
#       "sigops": 4,
#       "weight": 924
#     },
#     {
#       "data": "01000000019f00d13e540c7b23afe1a1c5c9acd83deaa83be75946fc72221327944390e207010000006a473044022039c5760f1360a116d97ead676b03ce411eac1e0a3c4034b41d451c460e06c8ca0220772dcff5e02f9072c3e415bde162028f1e4a153dda75be5c019532e5004fb54c012103b403539e4175cde64cc99b71d0d9cfc701c193bed1d6df17ae37b92e8506f141ffffffff0200000000000000001e6a1c504f45540000000220429bbb2843aa1c5a07be2f656c4e9def1f2ddc238036510a0000001976a9140fcc88829c46f85443edcce2150a8edbf57b48be88ac00000000",
#       "txid": "d70b312bebc09451c727518c94c3e917899f3717fb54ce266f609640f23a320e",
#       "hash": "d70b312bebc09451c727518c94c3e917899f3717fb54ce266f609640f23a320e",
#       "depends": [
#         8
#       ],
#       "fee": 100000,
#       "sigops": 4,
#       "weight": 920
#     },
#     {
#       "data": "01000000010e323af24096606f26ce54fb17379f8917e9c3948c5127c75194c0eb2b310bd7010000006a473044022076d55c94f6e0a7857aceefc14f07d8ef97bbe4a85021955a771df7d20386261802207ee1cbf67783fd5fcc30d6ff5c38cc40c9668893095f9cdda0657cb4b357bf76012103b403539e4175cde64cc99b71d0d9cfc701c193bed1d6df17ae37b92e8506f141ffffffff0200000000000000001e6a1c504f4554000000025dedcff71eee29a04aea8109e73df3e96e9fa62a83f934510a0000001976a9140fcc88829c46f85443edcce2150a8edbf57b48be88ac00000000",
#       "txid": "d22fa8f3177db58eb88f8d19bc10743efbe0ea64735ab39d91149ba140150666",
#       "hash": "d22fa8f3177db58eb88f8d19bc10743efbe0ea64735ab39d91149ba140150666",
#       "depends": [
#         9
#       ],
#       "fee": 100000,
#       "sigops": 4,
#       "weight": 920
#     },
#     {
#       "data": "010000000166061540a19b14919db35a7364eae0fb3e7410bc198d8fb88eb57d17f3a82fd2010000006b483045022100c219d21caad88f89d9b807d06e13369ffa0d787aa6e12ae74db7faeb8363c79e02206ea3949f8a2eaffe247ff3807cec8d9d334a8b1ae2002da72aa779175bdb7611012103b403539e4175cde64cc99b71d0d9cfc701c193bed1d6df17ae37b92e8506f141ffffffff0200000000000000001e6a1c504f4554000000022ee8eb5c24137b5ca1e6456f1a339120c3e94a4ee37233510a0000001976a9140fcc88829c46f85443edcce2150a8edbf57b48be88ac00000000",
#       "txid": "ef0b785703cc62c142120f5fe11b846af79e90fce506054dcbf7aa647a7d22ad",
#       "hash": "ef0b785703cc62c142120f5fe11b846af79e90fce506054dcbf7aa647a7d22ad",
#       "depends": [
#         10
#       ],
#       "fee": 100000,
#       "sigops": 4,
#       "weight": 924
#     },
#     {
#       "data": "0100000001ad227d7a64aaf7cb4d0506e5fc909ef76a841be15f0f1242c162cc0357780bef0100000069463043022029d58814ccf9e7db0e409e1f93aad3176f931e54f8ab0727bc198b39272932b1021f41814b2fb78284772078b0761a2b7f8c51ab76d035d0dd68bb391577f2468e012103b403539e4175cde64cc99b71d0d9cfc701c193bed1d6df17ae37b92e8506f141ffffffff0200000000000000001e6a1c504f4554000000024feec14d383bb9cd8e1ea0dacbe9025d1da1c40743ec31510a0000001976a9140fcc88829c46f85443edcce2150a8edbf57b48be88ac00000000",
#       "txid": "965264b41005f4a6b92402ed4ba1be4891200ecb4a7b11576bb75b22211bc06e",
#       "hash": "965264b41005f4a6b92402ed4ba1be4891200ecb4a7b11576bb75b22211bc06e",
#       "depends": [
#         11
#       ],
#       "fee": 100000,
#       "sigops": 4,
#       "weight": 916
#     },
#     {
#       "data": "01000000016ec01b21225bb76b57117b4acb0e209148bea14bed0224b9a6f40510b4645296010000006b483045022100eaa7dbcb42fdadf3353e7b9f911b85781f455fe9410a27e02ad12f4b78ea4a1302202e3593b28b4144fe6eff3071b0a7ef3b705098851f79a75206c2a5b0ca7a6c4b012103b403539e4175cde64cc99b71d0d9cfc701c193bed1d6df17ae37b92e8506f141ffffffff0200000000000000001e6a1c504f455400000002e918a50a8246ac707f6dcbbcc703883c897e3ad0a36530510a0000001976a9140fcc88829c46f85443edcce2150a8edbf57b48be88ac00000000",
#       "txid": "86d114198075a64957f4fe3b6c4f715d077715bd173aaa219b75fd8456df0f34",
#       "hash": "86d114198075a64957f4fe3b6c4f715d077715bd173aaa219b75fd8456df0f34",
#       "depends": [
#         12
#       ],
#       "fee": 100000,
#       "sigops": 4,
#       "weight": 924
#     },
#     {
#       "data": "0100000001340fdf5684fd759b21aa3a17bd1577075d714f6c3bfef45749a675801914d186010000006b483045022100fa604226490c53e881d7c92a91054d65a25c77fd6694d1cd57e1e4fe47792b4f022072d64b98fa015b8f2d033cf7e59192cd35128ae8074e788bdf47f49490ed48f4012103b403539e4175cde64cc99b71d0d9cfc701c193bed1d6df17ae37b92e8506f141ffffffff0200000000000000001e6a1c504f455400000002fe7f46991263a0c17b12c047aaa527e4a286b90403df2e510a0000001976a9140fcc88829c46f85443edcce2150a8edbf57b48be88ac00000000",
#       "txid": "daffe22de98438784938c1ef4ba00bb69034a389f8d77bbd804e8a5a1df68371",
#       "hash": "daffe22de98438784938c1ef4ba00bb69034a389f8d77bbd804e8a5a1df68371",
#       "depends": [
#         13
#       ],
#       "fee": 100000,
#       "sigops": 4,
#       "weight": 924
#     },
#     {
#       "data": "01000000017183f61d5a8a4e80bd7bd7f889a33490b60ba04befc13849783884e92de2ffda010000006b483045022100ba449372778edd289742645a87173eef982043fd5a77279b0257ed101fb54657022061dc724a036851cb48c45143e0013929ddb944425295c0b410ea89cb46b823cf012103b403539e4175cde64cc99b71d0d9cfc701c193bed1d6df17ae37b92e8506f141ffffffff0200000000000000001e6a1c504f45540000000244f768bda67a4c83cb61f92b31382437517704f063582d510a0000001976a9140fcc88829c46f85443edcce2150a8edbf57b48be88ac00000000",
#       "txid": "59909e0a12cb923355a2fb1eba803a5590e754911e79c0970b90bec15f6f473a",
#       "hash": "59909e0a12cb923355a2fb1eba803a5590e754911e79c0970b90bec15f6f473a",
#       "depends": [
#         14
#       ],
#       "fee": 100000,
#       "sigops": 4,
#       "weight": 924
#     },
#     {
#       "data": "01000000014648b8a94c92cd11476e44786f6cfe23f18a901311cb5b901ec51dcb4bd4b73e00000000fd660100473044022013776d60a557095260eb6426b99273fbf4055ee63c3088eacfaadc53398e6354022042652562df50eb28ff9305f7aa3349db05bedd93211073c54acde89e9bc2e8ee01473044022018206acb46c7649fdfcf3e731267e599af6e31977e3eddb75ab13aaf6da5f39f02207a0e5b4d431fdde697c785c14fb437c2fa8a58ea393af4cfca55b58f40b7974201473044022033e1c29d740319a1c5e84c8fb49cced35efac7a0cdb488ce1a11d454516ae404022043ae86f96103cb1decf778982e1eb7baf106353220ff1e1d43782fa11f8ddf08014c8b532103bd459027722b7bf77849734fa3518e45adb1fc807e34452ebf675e6c864ec04a21037f1dc7d470b1b9a9dc22e816cb4077b614c171cc7e6a4e7423546104b34197202102564afded0cd71cb3125d2b9a1a6c1877557a9b72b4a5fe51234f583f4836dcf6210272f3486792803285182bbc138a11092f0448dc30fa6f028cbc1ba69b59e3a64454aeffffffff02a01d1f320000000017a91481dd0b8e0572b6e4e2b6db741d210af7d754bcc0870000000000000000326a3045584f4e554d010058731b0000000000c26de7c90145db427d7bfc91dab1ae33a11083a3714c4afc3cb07357df95b55f00000000",
#       "txid": "0f37a946a8ce7a5eb67f57809ffe2f99147bf13d538be618e386fbb0376d59ee",
#       "hash": "0f37a946a8ce7a5eb67f57809ffe2f99147bf13d538be618e386fbb0376d59ee",
#       "depends": [
#       ],
#       "fee": 100000,
#       "sigops": 16,
#       "weight": 2008
#     },
#     {
#       "data": "0100000001ee596d37b0fb86e318e68b533df17b14992ffe9f80577fb65e7acea846a9370f00000000fd690100483045022100d81e1a01ab9a019fdacc40602fe7a3fe5fdbb9de5169b7aa26f2632a44a6d4df0220026118a23cdd5828d97346babfc7c13073db0c93cca28d71ace0cb0dd0b462a0014830450221009e5f9824ab5af66aee0c045454a590c7d5f3d6ff20ca1cb2b6aa2fa4f187fdb30220607e34292e967b12733300d8f3c603dd0b0c9f59c770556af3a9cb2b50cd4d2d014830450221008c635780d98a52168a34f3e7ea974c33258b33a569a72f43c8e7bab5d7287cda02205ef909417385f34269db0d4ba89ea411d84b28e35247bbcaddd46997f26112b9014c8b532103bd459027722b7bf77849734fa3518e45adb1fc807e34452ebf675e6c864ec04a21037f1dc7d470b1b9a9dc22e816cb4077b614c171cc7e6a4e7423546104b34197202102564afded0cd71cb3125d2b9a1a6c1877557a9b72b4a5fe51234f583f4836dcf6210272f3486792803285182bbc138a11092f0448dc30fa6f028cbc1ba69b59e3a64454aeffffffff0200971d320000000017a91481dd0b8e0572b6e4e2b6db741d210af7d754bcc0870000000000000000326a3045584f4e554d01004c751b000000000087421894b1b27c9d501cffd85479e073a8d62bd285e71d3fe8fdff757c67085a00000000",
#       "txid": "c56308d23a194a9cf49df67aa6998b8009b56f89213a29a2efc735300f50b51e",
#       "hash": "c56308d23a194a9cf49df67aa6998b8009b56f89213a29a2efc735300f50b51e",
#       "depends": [
#         16
#       ],
#       "fee": 100000,
#       "sigops": 16,
#       "weight": 2020
#     },
#     {
#       "data": "01000000011eb5500f3035c7efa2293a21896fb509808b99a67af69df49c4a193ad20863c500000000fd670100483045022100e70fa760c5cb6427e9d900a4a44e7e13ab60d0e8c6ddfa7e8a3e488c5f099d2d02204ffaa6f4a60a10191314f1cd425526c95abc7fab5821453fa178013e81f57ae701473044022008a9fe9c5ea3a7bbc3b023708bf469b37139f5813bc13a7b25eecd2ddb44db8202203bf8d6cbb75011cf1fcb29b923763bb84e70a76a132ffa362afeea1adb32ac070147304402200486f7c49c92e5f18aabee8073d6a357ac9288dd0cb95a51c39e6ad935f5417c02200fe7f1aa094abebe0d711b32383655bd2b7b8a1fb36a3170f92274173b90dc99014c8b532103bd459027722b7bf77849734fa3518e45adb1fc807e34452ebf675e6c864ec04a21037f1dc7d470b1b9a9dc22e816cb4077b614c171cc7e6a4e7423546104b34197202102564afded0cd71cb3125d2b9a1a6c1877557a9b72b4a5fe51234f583f4836dcf6210272f3486792803285182bbc138a11092f0448dc30fa6f028cbc1ba69b59e3a64454aeffffffff0260101c320000000017a91481dd0b8e0572b6e4e2b6db741d210af7d754bcc0870000000000000000326a3045584f4e554d010040771b0000000000403563620e665717afce2d109ac6141360dca9b4d83eb2a65f4aaa992c69dfa300000000",
#       "txid": "44cb042ca67dfc2147773a5aebf711be4607e6793338f5ec0cdabafeeb8364f8",
#       "hash": "44cb042ca67dfc2147773a5aebf711be4607e6793338f5ec0cdabafeeb8364f8",
#       "depends": [
#         17
#       ],
#       "fee": 100000,
#       "sigops": 16,
#       "weight": 2012
#     },
#     {
#       "data": "0100000001f86483ebfebada0cecf5383379e60746be11f7eb5a3a774721fc7da62c04cb4400000000fd680100483045022100c89aafbed082f3b219d711ac7ba557fd7e577b2825329d8d37cbada266e9318c02206cdfd97f4b30d2ed9b1f5bdd72d28f4600a043c86a0d428fff9a309b426bc9ed01473044022036a307ca516340ae3b4b76bc2c09e2e5c593247a4ae1308a212bf1f1665cdc3c022042f84158faa45d1c256bae73746d8490632d6a1fa785e7a138a17bb3145e651e01483045022100a99217f70fd1175b09f81a052d9ec5bec10c1e482f7aaadb777f03063100b0c20220324fe8e2d6de21296ca007c6ad8a7b609bcfe81c76e36040c82393f611c9f42a014c8b532103bd459027722b7bf77849734fa3518e45adb1fc807e34452ebf675e6c864ec04a21037f1dc7d470b1b9a9dc22e816cb4077b614c171cc7e6a4e7423546104b34197202102564afded0cd71cb3125d2b9a1a6c1877557a9b72b4a5fe51234f583f4836dcf6210272f3486792803285182bbc138a11092f0448dc30fa6f028cbc1ba69b59e3a64454aeffffffff02c0891a320000000017a91481dd0b8e0572b6e4e2b6db741d210af7d754bcc0870000000000000000326a3045584f4e554d010034791b0000000000b37029c8da51a2ecc3adabfbc6e9a16b424c43f184ea2c4c2e7664bc2f309c3f00000000",
#       "txid": "6b4e2e8ba7479507c39e4e1707ef2b9a04be0e0370876611be419ab9e45e084d",
#       "hash": "6b4e2e8ba7479507c39e4e1707ef2b9a04be0e0370876611be419ab9e45e084d",
#       "depends": [
#         18
#       ],
#       "fee": 100000,
#       "sigops": 16,
#       "weight": 2016
#     },
#     {
#       "data": "0100000001f6f9a7022660908e28c264b1525befe7ce015ae9f275510c4d228eab7bb7e8dd000000006b483045022100ba26217a6fa085604c3677d6c09a3095eead45de896b810279a11211cab79cad02204cdfec263563e312b26da66350d897a80851b160a2080abad2320f93a0b26cd901210256e3af2b1e059fc6643eeedd0efc7c9157dac3dbce7f29b515af72af03b54fdbffffffff02e8030000000000001976a914df59d5dc48fd0e5d3e6479c7ad70f020eabcfdca88ac2c717b00000000001976a914362f017f2f13f33aa9ad23d2888591f19982b3d988ac00000000",
#       "txid": "13357efa88c12aa54ad31cb1ab0407032da420f198a63e5f1f18abd5b901c1f2",
#       "hash": "13357efa88c12aa54ad31cb1ab0407032da420f198a63e5f1f18abd5b901c1f2",
#       "depends": [
#       ],
#       "fee": 34100,
#       "sigops": 8,
#       "weight": 904
#     },
#     {
#       "data": "010000000140765a90de9a68e10349f3b24d181c56b954adf42eebfd990baa20badf95ac9b010000006a47304402202e256cac98f12c5f8c31819875df25494aa752cd1c7fd811ae325cafc93a31070220123a82c4479590a6b3ac1f2b6aa8990751402261a10995643e61eeda6619b5ec012103fe1d271eccc2c31fe8796287cfc9514b12463326224b2f1c69e2e1ccd7c671feffffffff020100000000000000296a27334d6b317a37786b4347446d5955427853794a7844726d71517a5943456a72633573635475704b78240900000000001976a914604169e04cc48bc3b667a62daf284c8d58bc19a188ac00000000",
#       "txid": "f6b183e9b4694eabc0258f1a0fb4e9d0a7fac0ab53246295b67ca81ae9af2032",
#       "hash": "f6b183e9b4694eabc0258f1a0fb4e9d0a7fac0ab53246295b67ca81ae9af2032",
#       "depends": [
#       ],
#       "fee": 30000,
#       "sigops": 4,
#       "weight": 964
#     },
#     {
#       "data": "0100000001ef4323258df915d04a5a37e8509acda9913bdbd9ec1f6e5ae9a5ce2901545257000000006a47304402201a153b3cfa3d79ffef91c23db2da28e62a6dbc6b01853284ea3ab5097d8816c6022011129be21297395be97e727e2132acb893be0ac9d28af8d257958e48447df43f012102da594c0921a4735ef9fd6ed1336cf2388c56d8267bcc28e058248f1c6ddd3025ffffffff0263cd850e000000001976a9146f6fdda6575a09ebad60dd07624ebe5b918eb20d88acaa0a000000000000446a4222646364316135633936643937616263666133376533613332396566653733326362333162616530323032393734386162623766373033343335663866353934322200000000",
#       "txid": "53a6682b9af4460dc478ecd0f1bd87c3bda64a9da4bef74512154bb36e57c5e0",
#       "hash": "53a6682b9af4460dc478ecd0f1bd87c3bda64a9da4bef74512154bb36e57c5e0",
#       "depends": [
#       ],
#       "fee": 25000,
#       "sigops": 4,
#       "weight": 1072
#     },
#     {
#       "data": "0200000001e6ea865621229b159b120b85499a7ac21692a7027c06fe1e8a52a0bdbe7af6f9010000006a473044022075117a78c2057474dbe41e084faa9d3e4d824b1880236428eb233082a5df8d7702207af57cd221910f7240cc14f7912fa2809a95631f6d10123211c7e0d9aabae4990121027841ffb9dedd74e7e867467b343a804e1b3c05f31c808100480bddf3b18466baffffffff0201000000000000001976a914b4f9e3aed8382696b31330b9cc6bbf0bc140569e88acc35a935a000000001976a9142b616be2d203180500099fc0c57a54012617ccd588ac00000000",
#       "txid": "8ae11a1ce273f26c53789d495ea3ebd94b6b7d884cb17459c37798cf7c95c3c2",
#       "hash": "8ae11a1ce273f26c53789d495ea3ebd94b6b7d884cb17459c37798cf7c95c3c2",
#       "depends": [
#       ],
#       "fee": 20518,
#       "sigops": 8,
#       "weight": 900
#     },
#     {
#       "data": "0200000001c2c3957ccf9877c35974b14c887d6b4bd9eba35e499d78536cf273e21c1ae18a010000006b483045022100cb22ad51cd399f2eae08ad8b4ae7a9eb6887b5c7ff6f214a9a70da617502933e02203592f34cf57458c45255d8ed1c41fef418525acbe4411ffba05b59ff7761d8fc0121027841ffb9dedd74e7e867467b343a804e1b3c05f31c808100480bddf3b18466baffffffff02a0860100000000001976a914b4f9e3aed8382696b31330b9cc6bbf0bc140569e88ac9283915a000000001976a9142b616be2d203180500099fc0c57a54012617ccd588ac00000000",
#       "txid": "995c2c60270b185165307992fc11be89d161dbfe16f8ecbc5883447b6ca9c661",
#       "hash": "995c2c60270b185165307992fc11be89d161dbfe16f8ecbc5883447b6ca9c661",
#       "depends": [
#         23
#       ],
#       "fee": 20625,
#       "sigops": 8,
#       "weight": 904
#     },
#     {
#       "data": "020000000161c6a96c7b448358bcecf816fedb61d189be11fc9279306551180b27602c5c99010000006a4730440220197c304ab9324a06dc342f9dde5784faa106107a4ee99a2ce6807ce818a1fd8f022039b74e0a5ee0ba896b98b50fc5ba4c32a9125e7d55a4ba3719311b960d8178870121027841ffb9dedd74e7e867467b343a804e1b3c05f31c808100480bddf3b18466baffffffff02a0860100000000001976a914b4f9e3aed8382696b31330b9cc6bbf0bc140569e88ac61ac8f5a000000001976a9142b616be2d203180500099fc0c57a54012617ccd588ac00000000",
#       "txid": "b81fc0b5c5ccce3ac2ec7ffef3b1894be0d904596b36d19fce8fbb95c48aca86",
#       "hash": "b81fc0b5c5ccce3ac2ec7ffef3b1894be0d904596b36d19fce8fbb95c48aca86",
#       "depends": [
#         24
#       ],
#       "fee": 20625,
#       "sigops": 8,
#       "weight": 900
#     },
#     {
#       "data": "01000000019e2c9b409c594b306cab3e249fbe24000fc192555e47e5f1e8a5b5462334fffa000000006b48304502210094ec2f34f709b793bfbbd74004e1498212d30af188857f2d9bdb779b423230ea022075aab04833dce8a6ca4f15a6648a5a233de6997837a56146a0f8d09551e15b47012102ce696461c14e328f8e82abf32e51251e05d45046f8e1874c9b90fb1afd187b3effffffff0240420f0000000000160014c823decbc9d30a10fb2600d65f5369b228a6040d3c8b6c00000000001600142a8da2900ddb1c18b3f7d403dae147e278a0fbad00000000",
#       "txid": "1342b516d5e8801e9a6c045ed0b48d7026b8ecd7e37fb32fd7c9b91eb85d7e2a",
#       "hash": "1342b516d5e8801e9a6c045ed0b48d7026b8ecd7e37fb32fd7c9b91eb85d7e2a",
#       "depends": [
#       ],
#       "fee": 11468,
#       "sigops": 0,
#       "weight": 880
#     },
#     {
#       "data": "0100000001fbce4a04141699f9feb982dabc33a9f5702f3f1f3005a4e68340e7487cd2c34f010000006a47304402202410bfd95cf6f7535fa379e64b28e099a48e39b3e6b144542a0fa44bdba1c37102203b98fb33e1610fcf0e0cf4bc74aed7b632c2697437a8a5e0ec0d418fe6999e9d012102187fa162ef131370d02c74f116824d38a1e75aaa8ca65ae551f4f8298f8528a5ffffffff0300000000000000003d6a3b4343020156d362eeba9521daaa5b20766bd033bf107fece8d2cd054a8daba5070f546cf2d86472f193f7ba4061c7bf18defc6e9e8c0f1e69201640f0b9ee02000000001976a914900fb705e0d29eb70ee73d6b33b239945cb7101488ac58020000000000001976a914900fb705e0d29eb70ee73d6b33b239945cb7101488ac00000000",
#       "txid": "81eb68d4b55e82c821f955ca4d56dbf943d1feb9d253d13ce7778b23b5eed1a3",
#       "hash": "81eb68d4b55e82c821f955ca4d56dbf943d1feb9d253d13ce7778b23b5eed1a3",
#       "depends": [
#       ],
#       "fee": 5000,
#       "sigops": 8,
#       "weight": 1180
#     },
#     {
#       "data": "02000000016ec20f21eeacbe3eb2c8fc3c6284b194ca13ffaf1abda395ead497b5235cf0e8210100006a47304402204f1a95be3a12ba6d1551a6bb28c761f13e726d2c4a0cf03781fca301ba0ff0600220342a8bee6f82ee5bdfe5dfe22206e3558774a2f76de33f83ceb6594ad745f26d01210240a07049fc5de766efff66be4ef4ed71424bafee24c1217313c8d7190ec5c126ffffffff01d7030000000000001976a91493a7ae5575446d36982d44a896a3f72162990a6088ac00000000",
#       "txid": "d2a6d21ff93662a6ba901432be4afe1e3e948c59f5f41857839249b67c892250",
#       "hash": "d2a6d21ff93662a6ba901432be4afe1e3e948c59f5f41857839249b67c892250",
#       "depends": [
#       ],
#       "fee": 1517,
#       "sigops": 4,
#       "weight": 764
#     },
#     {
#       "data": "02000000016ec20f21eeacbe3eb2c8fc3c6284b194ca13ffaf1abda395ead497b5235cf0e8120100006a47304402201ac7a6e1b209082631cb16956bba69ce054bea70c92ae1408c2aa2e9320de45c02201d7240d2b096670781193b36cf26497096d48fb28666eeca0070a56568088cc30121025c4803138e05435693f1cc67b2b30e7c14f4a7bd3ea709c53d682cb3a54ef4eaffffffff01bb040000000000001976a914fefb15153442233172df7cdd21349c737204d48388ac00000000",
#       "txid": "03c7a6b7b546a80d7940988b6d4fbd0ffc752a4f352297cd4bee31053cd26923",
#       "hash": "03c7a6b7b546a80d7940988b6d4fbd0ffc752a4f352297cd4bee31053cd26923",
#       "depends": [
#       ],
#       "fee": 1289,
#       "sigops": 4,
#       "weight": 764
#     },
#     {
#       "data": "02000000016ec20f21eeacbe3eb2c8fc3c6284b194ca13ffaf1abda395ead497b5235cf0e8220100006a473044022036d865f8c217d193a31e18e5c34e4888d91b087e6678eb353948efa54e31539902204cb8956223feee8bf09fb879120562325313acf49b7249ff21d614b6bda65cdb01210243a954f68dfe0acc49e54517a82f7632c221f60cefd2b7fa876cec5cf17c7231ffffffff01bc040000000000001976a914ffa73d19c1d7b4a81f7eb42df1731b499734da9488ac00000000",
#       "txid": "d3b17f8356f214c7552649cbb08635fe5a187c283fe9ed23ce0e5e06420cf7a3",
#       "hash": "d3b17f8356f214c7552649cbb08635fe5a187c283fe9ed23ce0e5e06420cf7a3",
#       "depends": [
#       ],
#       "fee": 1288,
#       "sigops": 4,
#       "weight": 764
#     },
#     {
#       "data": "02000000016ec20f21eeacbe3eb2c8fc3c6284b194ca13ffaf1abda395ead497b5235cf0e8180100006a4730440220281f5e01b52472a418148c9639d158c8ef8764f8f983f0a30a0856aeb04e733b02206a41521df30b2ed4b45c2e33fe5713886f7708e7c928935d9f7bfcf1f2f8daed012102a0feffa63be4ac0d22f49c62e5d21780088068ad062426ddbfaedbdc1a5b0f24ffffffff01bd040000000000001976a914feab34ee0375b9ab712cd57d50694d288f93e72288ac00000000",
#       "txid": "59afb58aa33e567959bfeb2dca4c0a2086c5c7f7d6250d5a2fd59b98184c5a03",
#       "hash": "59afb58aa33e567959bfeb2dca4c0a2086c5c7f7d6250d5a2fd59b98184c5a03",
#       "depends": [
#       ],
#       "fee": 1287,
#       "sigops": 4,
#       "weight": 764
#     },
#     {
#       "data": "02000000016ec20f21eeacbe3eb2c8fc3c6284b194ca13ffaf1abda395ead497b5235cf0e8240100006a473044022026db2d25e1e9a3d6d818622dd99a3ea5be4735b4ca761bd104bfbb3edcff7df50220036b416af07ea9ab21e25cd18592bad5bd3f03e681abc55383aa80145582ca790121035b2bfb889224341b12a240222e6df998ae77cb382d06793af4c1b318816f3282ffffffff01bd040000000000001976a914ffa73d19c1d7b4a81f7eb42df1731b499734da9488ac00000000",
#       "txid": "e87c9d3e8a8890a5994acead3be4e2d946a8c8715d18a8553d4f5b9e43fbeb3f",
#       "hash": "e87c9d3e8a8890a5994acead3be4e2d946a8c8715d18a8553d4f5b9e43fbeb3f",
#       "depends": [
#       ],
#       "fee": 1287,
#       "sigops": 4,
#       "weight": 764
#     },
#     {
#       "data": "02000000016ec20f21eeacbe3eb2c8fc3c6284b194ca13ffaf1abda395ead497b5235cf0e8160100006a47304402206d4bb7b31d5dff4719136d321d7f98f5184db44a421bdee4f6f51bc5304eb05f02200b300c8f5b264aeb1532e0354784b9748af2e1641ea616f9729971e092429384012103261e0837961d28a6ccc8eb6b2e1de96cdf15b10063701ef8470d67129f3ca4c9ffffffff01bf040000000000001976a914feab34ee0375b9ab712cd57d50694d288f93e72288ac00000000",
#       "txid": "c6b70556a3768a593e0ffd3a4c285ec54336f9a526a70a662fef44cee57c8e82",
#       "hash": "c6b70556a3768a593e0ffd3a4c285ec54336f9a526a70a662fef44cee57c8e82",
#       "depends": [
#       ],
#       "fee": 1285,
#       "sigops": 4,
#       "weight": 764
#     },
#     {
#       "data": "02000000016ec20f21eeacbe3eb2c8fc3c6284b194ca13ffaf1abda395ead497b5235cf0e81e0100006b483045022100cb629d7528de21423f311cdb5e746c43ba3a946042033792aa84de40e6509c0902203555595bb72650b8736bd3804370ad46d240d0022d75d105cea4b41dcba1543c01210242ad04f550d9e3a9ec5c574a7a43f1e1b2192e396b08f4d85f7732bf2f01d99bffffffff01bc040000000000001976a91493a7ae5575446d36982d44a896a3f72162990a6088ac00000000",
#       "txid": "b8cb1ac6e12586ce44f00b26a1e435da90932a0b8522ec8796e2451cda48c64b",
#       "hash": "b8cb1ac6e12586ce44f00b26a1e435da90932a0b8522ec8796e2451cda48c64b",
#       "depends": [
#       ],
#       "fee": 1288,
#       "sigops": 4,
#       "weight": 768
#     },
#     {
#       "data": "02000000016ec20f21eeacbe3eb2c8fc3c6284b194ca13ffaf1abda395ead497b5235cf0e8200100006b483045022100ce298a47ace7d97b5845306ee35f5c1484fcf317cafc796dbe270bb3daa973e802205c06c0bd6e9e8473277896fb22527401a31edd69264369d73dbf8ebd81acb7bb01210310272de0afe4643768c2304cd214320b3a02dc37d783ed573af4e674f6c768bfffffffff01bc040000000000001976a91493a7ae5575446d36982d44a896a3f72162990a6088ac00000000",
#       "txid": "57275e1562ea68136f49015fc556f775449e8a1c3e7790c62e1e6400ee73d674",
#       "hash": "57275e1562ea68136f49015fc556f775449e8a1c3e7790c62e1e6400ee73d674",
#       "depends": [
#       ],
#       "fee": 1288,
#       "sigops": 4,
#       "weight": 768
#     },
#     {
#       "data": "02000000016ec20f21eeacbe3eb2c8fc3c6284b194ca13ffaf1abda395ead497b5235cf0e81a0100006b483045022100e5f06ddafdf6ce3655feeb38581a4bf87334349715907220b9f0ec654a8dfda90220736af4ed2af359e753453ad10885800f1137cf3f4c8a08cdaa18441d9e660a73012102a6bd333798681cd37787a39bba3a4dd913358a49bdab6b5ccc5d5f778147d2d2ffffffff01bc040000000000001976a914ffa73d19c1d7b4a81f7eb42df1731b499734da9488ac00000000",
#       "txid": "d66276de43202bd610037252358e56ff4b67c88073d267158d8ceb2cbaac2e79",
#       "hash": "d66276de43202bd610037252358e56ff4b67c88073d267158d8ceb2cbaac2e79",
#       "depends": [
#       ],
#       "fee": 1288,
#       "sigops": 4,
#       "weight": 768
#     },
#     {
#       "data": "02000000016ec20f21eeacbe3eb2c8fc3c6284b194ca13ffaf1abda395ead497b5235cf0e81c0100006b483045022100f884253db9ae698f81ad72b478e1174c86155c37c37805a752a1b79cb0bb168502200dd181423033d9b90054cb62fafece5bd967330e987e51acdf10a2e5f20b44fa012103eafd3542b7d2174e51fbeff7b63d71e5af3abffde86b3d3a266f900c2ddcd71fffffffff01bc040000000000001976a914ffa73d19c1d7b4a81f7eb42df1731b499734da9488ac00000000",
#       "txid": "386d66caf586327093b4adcf6b236f16f2a684e2205187a3fd8ef30d21966d79",
#       "hash": "386d66caf586327093b4adcf6b236f16f2a684e2205187a3fd8ef30d21966d79",
#       "depends": [
#       ],
#       "fee": 1288,
#       "sigops": 4,
#       "weight": 768
#     },
#     {
#       "data": "02000000016ec20f21eeacbe3eb2c8fc3c6284b194ca13ffaf1abda395ead497b5235cf0e8140100006b483045022100a21f09e4543a9432fd4b52aeebeee829d6d88fb9c7c8a7bc920e10b886005274022049f16cda4db7366fa62fc5d0ddba3efe4e95f30d62ce2b371617e101c9056532012102d4bfff213b594336f27c4ea88b7bdaf064ef9a1be2ef477db5b9306dd1870e44ffffffff01bd040000000000001976a914fefb15153442233172df7cdd21349c737204d48388ac00000000",
#       "txid": "0c594c6119de615f5314ed3f9deaa7066c8e4b67bb9250b6d44f1faf5ccb9ec7",
#       "hash": "0c594c6119de615f5314ed3f9deaa7066c8e4b67bb9250b6d44f1faf5ccb9ec7",
#       "depends": [
#       ],
#       "fee": 1287,
#       "sigops": 4,
#       "weight": 768
#     },
#     {
#       "data": "0100000001ef255c42de05c4cbdfb21ca7a811b973a12ff934c105a87d8733604439b78642000000006f0047304402203a634b47cdfd459e5334d093586ee6f35b7ab4211449c389afc9f2283d8d86c50220524a9d330abc89821386f4eae4a736fbaf2f4961f5b1742a60cd3588d61a105f0125512102473e862a0e90d86a1c97bc838b23b60ad39bf13706a6a88166331f194b87f04a51aeffffffff02405471040000000017a914d769dd9a7816a92829461ccf828a2626db246802870000000000000000326a3045584f4e554d0100d4c0fb0000000000bebe2813300b5a23bb73e25d7150a5267133c69137c7edd374b0ed7871b6f57100000000",
#       "txid": "38d401ab8ef311b62b45e4fd9a5825b60aa4683f6a53b28cebdc923fdd05f381",
#       "hash": "38d401ab8ef311b62b45e4fd9a5825b60aa4683f6a53b28cebdc923fdd05f381",
#       "depends": [
#       ],
#       "fee": 1000,
#       "sigops": 4,
#       "weight": 1012
#     },
#     {
#       "data": "010000000181f305dd3f92dceb8cb2536a3f68a40ab625589afde4452bb611f38eab01d438000000006f0047304402205ba8351b70a4152c2e892c85d5afb7778d5929a366301c97c19bd39d62ca78590220413c8e2a9559b14ddab0d0b4e3e7c656f4cb1abc14a5856b9f21c535224d0b210125512102473e862a0e90d86a1c97bc838b23b60ad39bf13706a6a88166331f194b87f04a51aeffffffff02585071040000000017a914d769dd9a7816a92829461ccf828a2626db246802870000000000000000326a3045584f4e554d010020c5fb0000000000ba47b7fe4e9ecf98509611f074b2ebfe340b9e6372ab15d295b923664f56ff1c00000000",
#       "txid": "ec124f6ee44393c74b9be5dfa26426818c60010aa964d4d0b3238fae1b229e6f",
#       "hash": "ec124f6ee44393c74b9be5dfa26426818c60010aa964d4d0b3238fae1b229e6f",
#       "depends": [
#         39
#       ],
#       "fee": 1000,
#       "sigops": 4,
#       "weight": 1012
#     },
#     {
#       "data": "01000000025f9c4842cf2566c1318982f0629c8bd55e67ad96138df9c7d62be8b20ea2dd0a01000000fc0047304402206280789760de064f76974b8a1143e26bfa11e84459cb60507018f5eebdb319a802203efe872d9b869d2ef4a8e598a714d6681b6a839fcfe2f35b92abc8491f8f90e901473044022028d0b2f3b1d878ec67ee0480d38eb85eb3a9f6e0d43f3f4dd56a3cab3de01e9802206f7e03da0d94a104693f3359049d953f4b778ae1fec432d898e6a2b0b2b0da3b014c69522102ca37b73048d3ba3a0e67229efc7e6b236bd0706c3bb291d13a8d0f61cef044fd2103b572ee1331b5b66d68dca39ec5d8b65e50c271598bb8b8f098926b0437fe636c2103e45681e0f194688977189a780c40b366733a2990b83eedf27d8750ebbcc50d9253aeffffffff6703c4bdb92e4c60d28cc6fceedf6ec8c6bbf9a572f074824a5572ce70d8fc3500000000fdfd000047304402200fc00d2316afeb42cb5419bdb12c7aad2cb9e3960f5c7a476b5a55968e32cbd102204599d9ed36b6fa0cc40e03ebb97fa736df19f04414b8b948c83d8fc038645b7b0148304502210098879ceb526efb641356f2cdc49a736628909cfdc1a06c52eae05592515154c802200664eb6ca4b2f2533ef03bf84b6f392b562a49c1f6f9ac30b38b4de691d3c124014c695221029462cfdefa0f1a790c2bcc6a8e0201ab663be0e65d92c71f5e04727fd0bb2ab42102177373a3da72987fe3e39fe800ba1d2dbeb7d6fcd404db051329cbba28ecbbf82102478a976eef94fba38c86da8dca474593a9149ee9d08b7550e751df8c1509b52e53aeffffffff02a08601000000000017a914b78eaa6e1b0d4510dfc78bece72f3a517e0a162687e92f01000000000017a9148467ccafba030f5dc81501ba62ff9090069c4c2e8700000000",
#       "txid": "ab48a745e7e597c0c7463b4d0867a99357d8788bcef90b37fd66d3a709ec0afd",
#       "hash": "ab48a745e7e597c0c7463b4d0867a99357d8788bcef90b37fd66d3a709ec0afd",
#       "depends": [
#       ],
#       "fee": 2004,
#       "sigops": 24,
#       "weight": 2652
#     },
#     {
#       "data": "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",
#       "txid": "5b7ede913eedfe8d365ddc50f5f5313a3b8bd45e5beb3cbd98237569e901056b",
#       "hash": "5b7ede913eedfe8d365ddc50f5f5313a3b8bd45e5beb3cbd98237569e901056b",
#       "depends": [
#       ],
#       "fee": 13509,
#       "sigops": 180,
#       "weight": 17904
#     },
#     {
#       "data": "0100000002f7b06000fd0336c892f6bfd949d621276fe5eae00521e6e940a2bf4148d8085800000000fc004730440220562dee7f14a7aa5f46745d41243cdbaa30d1cf29a8707efa279be3551505736602203481f9fdf38fc01cce922c1cf070caa2915a1966583db7059ca0b041fca633ea01473044022019022362bd96ca5f769419a2f0958649ede599fe1946bcfbdb1b193ceb9464f6022076fa7ce7a9679f3ff7dfe6b61b626717e0bd202e085e42a1411ec8aeffc58e00014c69522103e6652b1082ff638872453a90b19b673a0b8e33f6e87b589ae97743e7da20fa572102061fd01a8e0f411b02023441e1499d9712f9e92fd363f93eed29600e9b8a1ba42103f14c7b86ee3f7a130a28c16953b719a558c8f6c67e23ab96739ea384ecbe7bea53aeffffffff9876d47aa59178030ac4218f3acea3a543727375604ebd5e655b69f3a1097f9b00000000fdfe0000483045022100c9cbd3e86b48f38a90cf248dc35d84e57cf94ff222eb0116b9eb028139979fef02200aeb7d23c8b1c7c6a349bfe1a33bf661045c91b763aa9ddf0ebbcb9cc2100eda01483045022100823cb1b88b27fa406a4fc1a8b9a5f688fbcb0ba43f5818c73476dddeec7a318502206d4df7146923f303a89c1be3118603dfc8fdc3512b080f00624ec51bd365d9f8014c695221029462cfdefa0f1a790c2bcc6a8e0201ab663be0e65d92c71f5e04727fd0bb2ab42102177373a3da72987fe3e39fe800ba1d2dbeb7d6fcd404db051329cbba28ecbbf82102478a976eef94fba38c86da8dca474593a9149ee9d08b7550e751df8c1509b52e53aeffffffff02e92f01000000000017a914a3b3b77175dc3127777ac32f2f0b0081b7a6dda387a08601000000000017a914b78eaa6e1b0d4510dfc78bece72f3a517e0a16268700000000",
#       "txid": "54dda7ffcf9b6a0f100b5a4911b66f47605d425552e22cc5fe354b7a559b7e62",
#       "hash": "54dda7ffcf9b6a0f100b5a4911b66f47605d425552e22cc5fe354b7a559b7e62",
#       "depends": [
#       ],
#       "fee": 2004,
#       "sigops": 24,
#       "weight": 2656
#     },
#     {
#       "data": "0100000002dcdc1ce34e62eedf01ddc0fcd0933a79c10488973f6dd99b2be3270ed171c03400000000fdfd00004730440220241d27f52ca3e83c7b28680fccfd2217b6d20dd2770dc78d33ac4ddb154f3f150220264024407a4c2079c25e58ef91f2a5d686a95bd6d1d66470637b45013ef7f17601483045022100f9949bcaefb3d1396b44f6e9ad92ab92e31b7ba1c3783ad989521f235907214002200d3467ee2d69963992ed2bed827476b7e18fc95668b158827721a702fc0f7a8e014c69522102cfadd42b716069884e333d344c0332184b84d3e7a836c9edd4f1e122dc7acd9e2103c8c939344dc786f81bfcce775df2297973f044521f0759be8c302dc051de171e210398cba8ace481e1aaaedeb525026f6ba234cc8a7af35d2694fdc34614099ed3d653aeffffffff0a233dc87198f7f93e27339320b0f86fb4e0aa863f7cd15426708f04f50e853900000000fdfd00004730440220496f062b953b72db71ee7f22e79a5ae5ebdf1cef0c433e30d6b78fe508000a06022071f3522fee5f7310258d2b13a8c1df5f431a1a10fd16e9d228fe7e41d9c7ce2d01483045022100b56930919fcd06fb74e503e02473a45ffccd1c148102892a2c61884ff97ebb8302205ef0a92497b3e4c7df26f222ff972a2458be58d4a6971933c1b49a6a918702b7014c695221029462cfdefa0f1a790c2bcc6a8e0201ab663be0e65d92c71f5e04727fd0bb2ab42102177373a3da72987fe3e39fe800ba1d2dbeb7d6fcd404db051329cbba28ecbbf82102478a976eef94fba38c86da8dca474593a9149ee9d08b7550e751df8c1509b52e53aeffffffff02e92f01000000000017a91446b939d49d6010e274d3d11f4d586d53bbf2eb8b87a08601000000000017a914b78eaa6e1b0d4510dfc78bece72f3a517e0a16268700000000",
#       "txid": "3532f27421afe25db0ab9ae1ec7ebbc048ee5ebd81a7ed36da70bb44d7585fc4",
#       "hash": "3532f27421afe25db0ab9ae1ec7ebbc048ee5ebd81a7ed36da70bb44d7585fc4",
#       "depends": [
#       ],
#       "fee": 2004,
#       "sigops": 24,
#       "weight": 2664
#     },
#     {
#       "data": "01000000027bd49fe5ae5006930c7142ee822d62531e702d40628d3fb608d2acafe95e50c501000000fdfe00004830450221008bdc48e2c56e43a99e4e77a934629ccd518b3cf547aacd6f433e6795b2a062260220683ff581f348a42e3112abccc793b2b51a90d09f87af16d885af1f24c35f90820148304502210089534ad07704188722eb3005782a77d8628134be3575e02a5749f886ccf17d20022018ee18fec60b1dfc34fc7dccca88f550a74c79f48759cf761b2cb81daeaf9156014c695221020c389b2ca27811467764990cea19811f967cb7726ede896de86efb661b2cd44f210209ac1a9d8c56a46b25bd5023078ed77fb87845248a6359717c0eaf5059d26fea210291f50e312e02c02e55d0b9ddb8383cd09861df0ac4618dc0e3793e0b21cca13653aeffffffffaa8fab8147cfe9b943724ffb5b1a1869ec6f5bf355c1087410bf7d3cab642b5101000000fdfe0000483045022100be1ca6660bf70b5b04e1f32ae29c12e821567f110ece92bb85441daffbbbea8702207fe79cfe298d1a751724455ef9bf7e9fe006b79a7deb618888669fa676e08d1901483045022100881abfed3d66be0084b04c96fffa47ee6dcc1b2542e195742bd464c30653dbc8022003d13fd8e9376b0f1e4630663ce2bb2aa23cba61ba46b2a79614499a5c0b0978014c695221029462cfdefa0f1a790c2bcc6a8e0201ab663be0e65d92c71f5e04727fd0bb2ab42102177373a3da72987fe3e39fe800ba1d2dbeb7d6fcd404db051329cbba28ecbbf82102478a976eef94fba38c86da8dca474593a9149ee9d08b7550e751df8c1509b52e53aeffffffff02a08601000000000017a914b78eaa6e1b0d4510dfc78bece72f3a517e0a162687d55101000000000017a9142a05ceca707b2a7cc208005374271196885eace08700000000",
#       "txid": "9f7db5106fabd89e59a9f896f5f5c6d1e3db5821d3ccd160937cb3ac71a3ddb2",
#       "hash": "9f7db5106fabd89e59a9f896f5f5c6d1e3db5821d3ccd160937cb3ac71a3ddb2",
#       "depends": [
#       ],
#       "fee": 2004,
#       "sigops": 24,
#       "weight": 2672
#     },
#     {
#       "data": "020000000135d8552c7d7fad924c6bd8b9b86fa98e0ab547c54f32be74f5a12ae264660629000000006b483045022100b46a60f57e917b619da2888bd49bbeef3f487972149887292a2fffda717a81380220319b7cad0d873ac59452959d17719cd3061263b1970e9cac374b113355d41edb012102c57b26b4b3ee0e9ff245d8b41f218001ab7fcb5d60e796ae68692f0386057791feffffff03e0723603000000001976a914d46a447e07f4711b85c15a7dd2be823588a6afa888ac9d850100000000001976a914a317bdecc0d3423c023d6af06f6d14e3a82cf87088acbdd30100000000001976a9143a883183c8bb41b67ba65fcfdb6def025c1f510288ac218a1300",
#       "txid": "77c170a321bc551ed34e75c3e58fa03f12ef9dc754c9ecf5cf7a33623272322c",
#       "hash": "77c170a321bc551ed34e75c3e58fa03f12ef9dc754c9ecf5cf7a33623272322c",
#       "depends": [
#       ],
#       "fee": 518,
#       "sigops": 12,
#       "weight": 1040
#     },
#     {
#       "data": "0200000001154666678b3ff44110b472f4276599f3b90c4bbd71c070b05ca4516edbf3bdad000000006b483045022100dc17329b2b5f31c3f2a6adc4fccbf89e5a3340bfd824daca5ad61d4155314820022070568fee8dcf04b283ad2df1ba5ac1af9c2c39d20a41667e88143ebd49c18595012103667ae71dcc019583b88d307b4da7279860e7965955309a120844a0e78e7c1969feffffff03e076dc03000000001976a91471fe18427d3d850f0d542324047334eb1d5e60a288ac9d850100000000001976a914a9449e46dcca187f210e5933323d5ff5fe71a96b88acbdd30100000000001976a9146ad0fc92fdc6a599f4a4ad0dd27b36f6f98707f688ac218a1300",
#       "txid": "dde6a0b677dd051ef4039d9ed26959dbcbd2fa7837e4f71d895f069fea887f65",
#       "hash": "dde6a0b677dd051ef4039d9ed26959dbcbd2fa7837e4f71d895f069fea887f65",
#       "depends": [
#       ],
#       "fee": 518,
#       "sigops": 12,
#       "weight": 1040
#     },
#     {
#       "data": "0200000001127cd7f81d56e3c1d33bc4c1e26a905a75f45ce3df0b37579f72e28da1f553c1020000006b4830450221009fd055980d2a963cb7b65fd8cb18eb964ea51c50372fc9f19e776e7de7d0b4d1022042a1027a2e534a1122a40a0037ed5e83b648731912929f52dd42064b7754366201210295eb27c319e1e8352818f10f59870f69c9f5ebd725c584cd2fa398a077fee110feffffff039d850100000000001976a914fb78d4cec69c038c2b498386fbaf3beee5a495ed88aca0500401000000001976a914ca722ee4eab5cdf295a62ba5b7a5d63fcdf3f9e088acbdd30100000000001976a914c21597182ff31f88bcd6c6165fa540d90048ffc188ac218a1300",
#       "txid": "834b8f1af6f80733a8c5cc0b40815f369dcdbcb9f10b77c0ff14311f39b8edcd",
#       "hash": "834b8f1af6f80733a8c5cc0b40815f369dcdbcb9f10b77c0ff14311f39b8edcd",
#       "depends": [
#       ],
#       "fee": 518,
#       "sigops": 12,
#       "weight": 1040
#     },
#     {
#       "data": "0200000001ffe238f441a121162501b77485d4231930b94bf307c569473b6d1ce784ff124d010000006b483045022100f6d85bb5e215dba891f4570d7f10abdc9140918063641c7f4934f1b05225ac790220154ef58b860dcbfa01624065aa68cd51fdd4c71a0d3ae2b6275a455f1043bba901210241bc0cbaed50af10d8bdc80181f1affdc03a4a7a6b14e980227056b202c8136cfeffffff039d850100000000001976a914e52789ac907f9d4935eaf572f86db422864806f388acbdd30100000000001976a914215cf46ecd67abd925ce0989b26f7544beedfd2888ac82428404000000001976a914f80d74fee3c3d4a7fcbf9f4080fc90fc0bb8657a88ac218a1300",
#       "txid": "dfe4dad848b41b7fa5fba396d68f3434ed49788ef85dbe36f195e9b804b2ecd6",
#       "hash": "dfe4dad848b41b7fa5fba396d68f3434ed49788ef85dbe36f195e9b804b2ecd6",
#       "depends": [
#       ],
#       "fee": 518,
#       "sigops": 12,
#       "weight": 1040
#     },
#     {
#       "data": "0100000001913e404e169428df65e1ac54fa001e60b3071a522d9eaf725b1bdfb957f5d12d00000000fd680100483045022100aed51a530084a7e3e29856fbd95540964eb08d4cc04a7273104ed9c77c8a39f702206e54b92d0f0d15e4190ecc2e6b357e04a6ea0b702f91cc9c76b17a68665195fb0147304402202a8dc1829e35aca47dbe1db1ffbc5e7a93812a016ab69ee80d34d4e269a360d4022033a83adef0c6ad8627cecca2cd09f4bda7e66c59770f965be4988e47a955c7f301483045022100c3082de7199e8b9c84c426a07cbfc6bd0534473aca718811de7c5f8572a8fdea02201d2bb9409f1734ffdd36d7a08ddec6cc212916f2c136e686d33b2cb486d6f141014c8b5321026623c05897d7992801d6c9e0dd8b606d4adddad50222dee6104c6de0c3d6413921033cd669b1958acf253f27c772773068dd42707aab9d1bbb30b1f970f222a989f8210310c8d0297e9b5d9ec2ec2d5cd78ae56b3292a8390673f23eb50e6ab6cbaf248021030d1609be5798176a46297d6202054b4bcd53bf07d5c30d295903ea91558ad6a354aeffffffff0288af0a770000000017a91415997c1f6fbd09b23ca2e79f4ed2e8b4458a1fe3870000000000000000326a3045584f4e554d01005876d60000000000da1f151dff11efba29d58df6642ea1a34c6f333ebec5ee417b90ea48c6ef541900000000",
#       "txid": "992012004f12fa3cbf536d139b78a8e094a535d58d53650c641cc0bff1ed1c2a",
#       "hash": "992012004f12fa3cbf536d139b78a8e094a535d58d53650c641cc0bff1ed1c2a",
#       "depends": [
#       ],
#       "fee": 1000,
#       "sigops": 16,
#       "weight": 2016
#     },
#     {
#       "data": "01000000017b7633162cb73e9afd473b958234d6c06926d3c8456fe29d9e05e803b76c089700000000fd680100483045022100aaa6ed4219730ad83c835a5f7aded14cb67128895bbd10c913dff4e95a34fb8002202ad868ea4fb12bb2152b721e2efff453ffcba2e85abdf108f706c9f96b11040401483045022100948db14c57de90ab7f5831e9f31945ddb3b08986318e2238be4b37be4dd25cc00220127bb8680241b7a797db67db2c090a86d5aa6af135d6712c5287530a0092d0f8014730440220693c2d5a2a10cdc18216942d25ceebd1f8a005a9deaad6d584585ff7bf53a4190220728060b5abbc1d4ae1c84d5dbfac8030026687bd157298a0848176c3e1840792014c8b532102949dcb6f05bc5b1fb8855aa0cbbd883edc70b1785a492bf1fa0c0287a8befc3321023193f287b227fb572f63d11aaa03a05fafc47f29caa5f8bb350359bc24191cee2103cd4aa05c4952acf1c29185df960e68787ac59aa30d6e748ff833522e4d11c8e3210221b476c94496bef7c4ace3af3e9c7bc805587f67870c425cafc6dc4a7bafe74754aeffffffff0200290e000000000017a914b68c3488d295902dd465b486cc51be2d29af2408870000000000000000326a3045584f4e554d0100b86a05000000000066d7024aa1924f74d90c71421d428fe24da8e194b52da1ae2d6df582523711ff00000000",
#       "txid": "0f5dd231f62ded09b135ae3acdc14341afa24d7acae5bec30a0a6995aaadbc44",
#       "hash": "0f5dd231f62ded09b135ae3acdc14341afa24d7acae5bec30a0a6995aaadbc44",
#       "depends": [
#       ],
#       "fee": 1000,
#       "sigops": 16,
#       "weight": 2016
#     },
#     {
#       "data": "01000000016e01155212f111e44c88c1dfa1043e5b49f483f4e2838d6b4c3e8aae5ee2615900000000fd680100483045022100c94d493ab5ab23b87beba84ed6eb8154e193793fa248ff5e69034204de977444022076c40a6635535986efb065a9b9d8ddc715a8c83bb5fcf3e989323f1c2dabf58501483045022100de9d93fcf5f03b68dd261552bc47fc26071a9eeaea9b5e3fdff7d801c7faa914022079649d4ab3cc58d2ae4249a3a446039e7fc31719ffd8484e0c759c7281c62c710147304402204b7be291918aa913cd7a7a02185b8a1d09b55872ad48cb60789c24a7644764f8022053c8848b99a5b7b34f1773df54fd90bd4a5f3608864e360c921f86ea8f818e5f014c8b5321028861613180bf9b975a92848a3481f69e0526773ec67a3fa74e050afabdd69f7621026423a45e3fafd2d558e9bc28cded5534b31fd10a890ba3314e1ac35efdf0360e21031e40f1faa6dc9e89747c9eb89ce83c15263bdaf705e2d67c162adedad8ca6a0321022f7437bfc3f0009d8802b9e57a34a2515032132dd479b9992a9de09570fb88f854aeffffffff0288b90e000000000017a9144113ab6d74a100be6ff45daf3877cc536a6c9b6e870000000000000000326a3045584f4e554d010098ab0200000000000e6c5fd922fbe68a8d1f5514103c1341f14f40f4efb03237dd9453072eec990500000000",
#       "txid": "1d42486a96c75d7672a2345f9c0faeecbdda3f25432887626d480ac478c6df5f",
#       "hash": "1d42486a96c75d7672a2345f9c0faeecbdda3f25432887626d480ac478c6df5f",
#       "depends": [
#       ],
#       "fee": 1000,
#       "sigops": 16,
#       "weight": 2016
#     }
#   ],
#   "coinbaseaux": {
#     "flags": ""
#   },
#   "coinbasevalue": 80419215,
#   "longpollid": "000000000000289f2c0ddd382204f00a074f3dc45ee67dd24931c332769678a250446",
#   "target": "000000000000372b400000000000000000000000000000000000000000000000",
#   "mintime": 1518195745,
#   "mutable": [
#     "time",
#     "transactions",
#     "prevblock"
#   ],
#   "noncerange": "00000000ffffffff",
#   "sigoplimit": 80000,
#   "sizelimit": 4000000,
#   "weightlimit": 4000000,
#   "curtime": 1518198947,
#   "bits": "1a372b40",
#   "height": 1280546
# }
#



class BlockDeserializeTests(unittest.TestCase):
    @classmethod
    def setUpClass(cls):
        print("\nTesting Block class deserialization:\n")
        f = open('./pybtc/test/raw_block.txt')
        cls.test_block = f.readline()[:-1]

    def test_block_merkle(self):
        bt = Block(self.test_block, format="raw")

        raw_hash_list = [tx["txId"] for tx in bt["tx"].values()]
        hex_hash_list = [rh2s(tx["txId"]) for tx in bt["tx"].values()]

        self.assertEqual(merkle_root(raw_hash_list), rh2s(bt["merkleRoot"]))
        self.assertEqual(merkle_root(raw_hash_list, return_hex=False), bt["merkleRoot"])
        self.assertEqual(merkle_root(raw_hash_list, receive_hex=False, return_hex=False), bt["merkleRoot"])
        self.assertEqual(merkle_root(hex_hash_list, return_hex=False), bt["merkleRoot"])

        self.assertEqual(merkle_tree(raw_hash_list)[0][0], bt["merkleRoot"])
        self.assertEqual(merkle_tree(raw_hash_list, return_hex=True)[0][0], rh2s(bt["merkleRoot"]))
        self.assertEqual(merkle_tree(raw_hash_list, receive_hex=False, return_hex=True)[0][0], rh2s(bt["merkleRoot"]))
        self.assertEqual(merkle_tree(hex_hash_list, receive_hex=True, return_hex=True)[0][0], rh2s(bt["merkleRoot"]))
        m = merkle_tree(raw_hash_list)

        block_e = "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"

        bt = Block(block_e, format="raw")
        m_root = rh2s(bt["merkleRoot"])
        hl = [tx["txId"] for tx in bt["tx"].values()]
        m_tree = merkle_tree(tx["txId"] for tx in bt["tx"].values())
        proofs = [merkle_proof(m_tree, i) for i in range(len(hl))]
        [self.assertEqual(merkle_root_from_proof(proof, hl[i], i), m_root) for i, proof in enumerate(proofs)]

        bt = Block(self.test_block, format="raw")
        m_root = rh2s(bt["merkleRoot"])
        hl = [tx["txId"] for tx in bt["tx"].values()]
        m_tree = merkle_tree(hl)

        proofs = [merkle_proof(m_tree, i) for i in range(len(hl))]
        print(proofs)
        [self.assertEqual(merkle_root_from_proof(proof, hl[i], i), m_root) for i, proof in enumerate(proofs)]


    def test_block_class(self):
        block_c = "2000000000000000000029a1a0390376afd72db120d698c2d8ebc41c545c7d4bc2b9033c303dd3d09d455da1c587406820a4dd77c5aa3fcc546dcceb1becc639829c4fe6535e815a1a372b405cc0829701010000000001010000000000000000000000000000000000000000000000000000000000000000ffffffff2303f88e130068747470733a5c6170692e6269746170732e636f6d20f251bec0cb000000ffffffff02c817a804000000001976a914d4e49947b9f545218cd20389244c249d3520545d88ac0000000000000000266a24aa21a9ede2f61c3f71d1defd3fa999dfa36953755c690689799962b48bebd836974e8cf90120000000000000000000000000000000000000000000000000000000000000000000000000"
        block_e = "2000000000000000000029a1a0390376afd72db120d698c2d8ebc41c545c7d4bc2b9033c303dd3d09d455da1c587406820a4dd77c5aa3fcc546dcceb1becc639829c4fe65a815e531a372b405cc0829701010000000001010000000000000000000000000000000000000000000000000000000000000000ffffffff2303f88e130068747470733a5c6170692e6269746170732e636f6d20f251bec0cb000000ffffffff02c817a804000000001976a914d4e49947b9f545218cd20389244c249d3520545d88ac0000000000000000266a24aa21a9ede2f61c3f71d1defd3fa999dfa36953755c690689799962b48bebd836974e8cf90120000000000000000000000000000000000000000000000000000000000000000000000000"
        l = Block(block_a, format="decoded")
        f = open('./pybtc/test/raw_block.txt')
        fc = f.readline()
        qt = time.time()
        bt = Block(fc[:-1], format="raw", keep_raw_tx=False)
        # print(bt["tx"])
        # print([t["txId"] for t in bt["tx"].values()])

        # print(merkle_tree([t["txId"] for t in bt["tx"].values()]))

        # import   pickle
        # qt = time.time()
        # k = pickle.dumps(bt[0]["tx"][0])
        # print("decoded block dump", time.time() - qt)
        # qt = time.time()
        # p = pickle.loads(k)
        # print("decoded block load", time.time() - qt)
        # print(p)



        import cProfile

        # cProfile.run("import pybtc;"
        #              "f = open('./pybtc/test/raw_block.txt');"
        #              "fc = f.readline();"
        #              "pybtc.Block(fc[:-1], format='raw', keep_raw_tx=False)")
        # cProfile.run("import pybtc;"
        #              "f = open('./pybtc/test/raw_block.txt');"
        #              "fc = f.readline();"
        #              "pybtc.Block(fc[:-1], format='raw')")
        # print(">>>",block.bits)
        # print(">>>",block.hash)
        # print(">>>",block.timestamp)
        # target = int.from_bytes(block.bits[1:], 'big') * (2 ** (8 * (block.bits[0] - 3)))
        # print(int.from_bytes(block.hash, 'big')<target)

        # print(rh2s(block.transactions[0].hash))
        # cbm = block.coinbase
        # cb = block.transactions.pop(0)
        # outs = []
        # for out in cb.tx_out:
        #     if out.pk_script.ntype != 3:
        #         outs.append((out.value, out.pk_script.raw))
        # cb2 = block.create_coinbase_transaction(block.height, outs, cbm )
        # print(cb.serialize(hex=True))
        # print(cb2.serialize(hex=True))
        # print(cb.serialize(segwit = 0,hex=True) == cb2.serialize(segwit = 0 ,hex=True))
        # print(cb.serialize(segwit = 1,hex=True) == cb2.serialize(segwit = 1 ,hex=True))
        #
        # b = block.serialize(hex=1)
        # print(b ==  block_a)
        # print(b)