"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosAntiBruteForceRule = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosAntiBruteForceRuleProps`
 *
 * @param properties - the TypeScript properties of a `RosAntiBruteForceRuleProps`
 *
 * @returns the result of the validation.
 */
function RosAntiBruteForceRulePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('defaultRule', ros.validateBoolean)(properties.defaultRule));
    errors.collect(ros.propertyValidator('antiBruteForceRuleName', ros.requiredValidator)(properties.antiBruteForceRuleName));
    errors.collect(ros.propertyValidator('antiBruteForceRuleName', ros.validateString)(properties.antiBruteForceRuleName));
    errors.collect(ros.propertyValidator('forbiddenTime', ros.requiredValidator)(properties.forbiddenTime));
    if (properties.forbiddenTime && (typeof properties.forbiddenTime) !== 'object') {
        errors.collect(ros.propertyValidator('forbiddenTime', ros.validateAllowedValues)({
            data: properties.forbiddenTime,
            allowedValues: [5, 15, 30, 60, 120, 360, 720, 1440, 10080, 52560000],
        }));
    }
    errors.collect(ros.propertyValidator('forbiddenTime', ros.validateNumber)(properties.forbiddenTime));
    errors.collect(ros.propertyValidator('uuidList', ros.requiredValidator)(properties.uuidList));
    errors.collect(ros.propertyValidator('uuidList', ros.listValidator(ros.validateString))(properties.uuidList));
    errors.collect(ros.propertyValidator('failCount', ros.requiredValidator)(properties.failCount));
    if (properties.failCount && (typeof properties.failCount) !== 'object') {
        errors.collect(ros.propertyValidator('failCount', ros.validateAllowedValues)({
            data: properties.failCount,
            allowedValues: [2, 3, 4, 5, 10, 50, 80, 100],
        }));
    }
    errors.collect(ros.propertyValidator('failCount', ros.validateNumber)(properties.failCount));
    errors.collect(ros.propertyValidator('span', ros.requiredValidator)(properties.span));
    if (properties.span && (typeof properties.span) !== 'object') {
        errors.collect(ros.propertyValidator('span', ros.validateAllowedValues)({
            data: properties.span,
            allowedValues: [1, 2, 5, 10, 15],
        }));
    }
    errors.collect(ros.propertyValidator('span', ros.validateNumber)(properties.span));
    return errors.wrap('supplied properties not correct for "RosAntiBruteForceRuleProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::ThreatDetection::AntiBruteForceRule` resource
 *
 * @param properties - the TypeScript properties of a `RosAntiBruteForceRuleProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::ThreatDetection::AntiBruteForceRule` resource.
 */
// @ts-ignore TS6133
function rosAntiBruteForceRulePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosAntiBruteForceRulePropsValidator(properties).assertSuccess();
    }
    return {
        AntiBruteForceRuleName: ros.stringToRosTemplate(properties.antiBruteForceRuleName),
        FailCount: ros.numberToRosTemplate(properties.failCount),
        ForbiddenTime: ros.numberToRosTemplate(properties.forbiddenTime),
        Span: ros.numberToRosTemplate(properties.span),
        UuidList: ros.listMapper(ros.stringToRosTemplate)(properties.uuidList),
        DefaultRule: ros.booleanToRosTemplate(properties.defaultRule),
    };
}
/**
 * A ROS template type:  `ALIYUN::ThreatDetection::AntiBruteForceRule`
 */
class RosAntiBruteForceRule extends ros.RosResource {
    /**
     * Create a new `ALIYUN::ThreatDetection::AntiBruteForceRule`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosAntiBruteForceRule.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrAntiBruteForceRuleId = this.getAtt('AntiBruteForceRuleId');
        this.attrAntiBruteForceRuleName = this.getAtt('AntiBruteForceRuleName');
        this.attrDefaultRule = this.getAtt('DefaultRule');
        this.attrFailCount = this.getAtt('FailCount');
        this.attrForbiddenTime = this.getAtt('ForbiddenTime');
        this.attrSpan = this.getAtt('Span');
        this.attrUuidList = this.getAtt('UuidList');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.antiBruteForceRuleName = props.antiBruteForceRuleName;
        this.failCount = props.failCount;
        this.forbiddenTime = props.forbiddenTime;
        this.span = props.span;
        this.uuidList = props.uuidList;
        this.defaultRule = props.defaultRule;
    }
    get rosProperties() {
        return {
            antiBruteForceRuleName: this.antiBruteForceRuleName,
            failCount: this.failCount,
            forbiddenTime: this.forbiddenTime,
            span: this.span,
            uuidList: this.uuidList,
            defaultRule: this.defaultRule,
        };
    }
    renderProperties(props) {
        return rosAntiBruteForceRulePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosAntiBruteForceRule = RosAntiBruteForceRule;
/**
 * The resource type name for this resource class.
 */
RosAntiBruteForceRule.ROS_RESOURCE_TYPE_NAME = "ALIYUN::ThreatDetection::AntiBruteForceRule";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGhyZWF0ZGV0ZWN0aW9uLmdlbmVyYXRlZC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInRocmVhdGRldGVjdGlvbi5nZW5lcmF0ZWQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLHlEQUF5RDs7O0FBRXpELDhDQUE4QztBQTJEOUM7Ozs7OztHQU1HO0FBQ0gsU0FBUyxtQ0FBbUMsQ0FBQyxVQUFlO0lBQ3hELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxHQUFHLENBQUMsZUFBZSxDQUFDLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUM7SUFDbEcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsd0JBQXdCLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLHNCQUFzQixDQUFDLENBQUMsQ0FBQztJQUMxSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx3QkFBd0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLHNCQUFzQixDQUFDLENBQUMsQ0FBQztJQUN2SCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxlQUFlLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUM7SUFDeEcsSUFBRyxVQUFVLENBQUMsYUFBYSxJQUFJLENBQUMsT0FBTyxVQUFVLENBQUMsYUFBYSxDQUFDLEtBQUssUUFBUSxFQUFFO1FBQzNFLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGVBQWUsRUFBRSxHQUFHLENBQUMscUJBQXFCLENBQUMsQ0FBQztZQUMvRSxJQUFJLEVBQUUsVUFBVSxDQUFDLGFBQWE7WUFDOUIsYUFBYSxFQUFFLENBQUMsQ0FBQyxFQUFDLEVBQUUsRUFBQyxFQUFFLEVBQUMsRUFBRSxFQUFDLEdBQUcsRUFBQyxHQUFHLEVBQUMsR0FBRyxFQUFDLElBQUksRUFBQyxLQUFLLEVBQUMsUUFBUSxDQUFDO1NBQzVELENBQUMsQ0FBQyxDQUFDO0tBQ1A7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxlQUFlLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDO0lBQ3JHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUM5RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUM5RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7SUFDaEcsSUFBRyxVQUFVLENBQUMsU0FBUyxJQUFJLENBQUMsT0FBTyxVQUFVLENBQUMsU0FBUyxDQUFDLEtBQUssUUFBUSxFQUFFO1FBQ25FLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxHQUFHLENBQUMscUJBQXFCLENBQUMsQ0FBQztZQUMzRSxJQUFJLEVBQUUsVUFBVSxDQUFDLFNBQVM7WUFDMUIsYUFBYSxFQUFFLENBQUMsQ0FBQyxFQUFDLENBQUMsRUFBQyxDQUFDLEVBQUMsQ0FBQyxFQUFDLEVBQUUsRUFBQyxFQUFFLEVBQUMsRUFBRSxFQUFDLEdBQUcsQ0FBQztTQUN0QyxDQUFDLENBQUMsQ0FBQztLQUNQO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztJQUM3RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDdEYsSUFBRyxVQUFVLENBQUMsSUFBSSxJQUFJLENBQUMsT0FBTyxVQUFVLENBQUMsSUFBSSxDQUFDLEtBQUssUUFBUSxFQUFFO1FBQ3pELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMscUJBQXFCLENBQUMsQ0FBQztZQUN0RSxJQUFJLEVBQUUsVUFBVSxDQUFDLElBQUk7WUFDckIsYUFBYSxFQUFFLENBQUMsQ0FBQyxFQUFDLENBQUMsRUFBQyxDQUFDLEVBQUMsRUFBRSxFQUFDLEVBQUUsQ0FBQztTQUM3QixDQUFDLENBQUMsQ0FBQztLQUNQO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUNuRixPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsa0VBQWtFLENBQUMsQ0FBQztBQUMzRixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsdUNBQXVDLENBQUMsVUFBZSxFQUFFLGdDQUF5QztJQUN2RyxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsSUFBRyxnQ0FBZ0MsRUFBRTtRQUNqQyxtQ0FBbUMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztLQUNuRTtJQUNELE9BQU87UUFDTCxzQkFBc0IsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLHNCQUFzQixDQUFDO1FBQ2xGLFNBQVMsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQztRQUN4RCxhQUFhLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUM7UUFDaEUsSUFBSSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDO1FBQzlDLFFBQVEsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUM7UUFDdEUsV0FBVyxFQUFFLEdBQUcsQ0FBQyxvQkFBb0IsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDO0tBQzlELENBQUM7QUFDTixDQUFDO0FBRUQ7O0dBRUc7QUFDSCxNQUFhLHFCQUFzQixTQUFRLEdBQUcsQ0FBQyxXQUFXO0lBdUd0RDs7Ozs7O09BTUc7SUFDSCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQWlDLEVBQUUsZ0NBQXlDO1FBQ3RILEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEVBQUUsSUFBSSxFQUFFLHFCQUFxQixDQUFDLHNCQUFzQixFQUFFLFVBQVUsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDO1FBQzVGLElBQUksQ0FBQyx3QkFBd0IsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLHNCQUFzQixDQUFDLENBQUM7UUFDcEUsSUFBSSxDQUFDLDBCQUEwQixHQUFHLElBQUksQ0FBQyxNQUFNLENBQUMsd0JBQXdCLENBQUMsQ0FBQztRQUN4RSxJQUFJLENBQUMsZUFBZSxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUMsYUFBYSxDQUFDLENBQUM7UUFDbEQsSUFBSSxDQUFDLGFBQWEsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLFdBQVcsQ0FBQyxDQUFDO1FBQzlDLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLGVBQWUsQ0FBQyxDQUFDO1FBQ3RELElBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxNQUFNLENBQUMsQ0FBQztRQUNwQyxJQUFJLENBQUMsWUFBWSxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDLENBQUM7UUFFNUMsSUFBSSxDQUFDLGdDQUFnQyxHQUFHLGdDQUFnQyxDQUFDO1FBQ3pFLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxLQUFLLENBQUMsc0JBQXNCLENBQUM7UUFDM0QsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDO1FBQ2pDLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDLGFBQWEsQ0FBQztRQUN6QyxJQUFJLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUM7UUFDdkIsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO1FBQy9CLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQztJQUN6QyxDQUFDO0lBR0QsSUFBYyxhQUFhO1FBQ3ZCLE9BQU87WUFDSCxzQkFBc0IsRUFBRSxJQUFJLENBQUMsc0JBQXNCO1lBQ25ELFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUztZQUN6QixhQUFhLEVBQUUsSUFBSSxDQUFDLGFBQWE7WUFDakMsSUFBSSxFQUFFLElBQUksQ0FBQyxJQUFJO1lBQ2YsUUFBUSxFQUFFLElBQUksQ0FBQyxRQUFRO1lBQ3ZCLFdBQVcsRUFBRSxJQUFJLENBQUMsV0FBVztTQUNoQyxDQUFDO0lBQ04sQ0FBQztJQUNTLGdCQUFnQixDQUFDLEtBQTJCO1FBQ2xELE9BQU8sdUNBQXVDLENBQUMsS0FBSyxFQUFFLElBQUksQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO0lBQ2pHLENBQUM7O0FBOUlMLHNEQStJQztBQTlJRzs7R0FFRztBQUNvQiw0Q0FBc0IsR0FBRyw2Q0FBNkMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIEdlbmVyYXRlZCBmcm9tIHRoZSBBbGlDbG91ZCBST1MgUmVzb3VyY2UgU3BlY2lmaWNhdGlvblxuXG5pbXBvcnQgKiBhcyByb3MgZnJvbSAnQGFsaWNsb3VkL3Jvcy1jZGstY29yZSc7XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgQUxJWVVOOjpUaHJlYXREZXRlY3Rpb246OkFudGlCcnV0ZUZvcmNlUnVsZWBcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBSb3NBbnRpQnJ1dGVGb3JjZVJ1bGVQcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgYW50aUJydXRlRm9yY2VSdWxlTmFtZTogVGhlIG5hbWUgb2YgdGhlIGRlZmVuc2UgcnVsZS5cbiAgICAgKi9cbiAgICByZWFkb25seSBhbnRpQnJ1dGVGb3JjZVJ1bGVOYW1lOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgZmFpbENvdW50OiBUaGUgbWF4aW11bSBudW1iZXIgb2YgZmFpbGVkIGxvZ29uIGF0dGVtcHRzIGZyb20gYW4gYWNjb3VudC4gXG4gICAgICogVmFsaWQgdmFsdWVzOiAyLCAzLCA0LCA1LCAxMCwgNTAsIDgwLCBhbmQgMTAwLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGZhaWxDb3VudDogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGZvcmJpZGRlblRpbWU6IFRoZSBwZXJpb2Qgb2YgdGltZSBkdXJpbmcgd2hpY2ggbG9nb25zIGZyb20gYW4gYWNjb3VudCBhcmUgbm90IGFsbG93ZWQuXG4gICAgICogVW5pdDogbWludXRlcy4gVmFsaWQgdmFsdWVzOlxuICAgICAqIC0gNTogNSBtaW51dGVzXG4gICAgICogLSAxNTogMTUgbWludXRlc1xuICAgICAqIC0gMzA6IDMwIG1pbnV0ZXNcbiAgICAgKiAtIDYwOiAxIGhvdXJcbiAgICAgKiAtIDEyMDogMiBob3Vyc1xuICAgICAqIC0gMzYwOiA2IGhvdXJzXG4gICAgICogLSA3MjA6IDEyIGhvdXJzXG4gICAgICogLSAxNDQwOiAyNCBob3Vyc1xuICAgICAqIC0gMTAwODA6IDcgZGF5c1xuICAgICAqIC0gNTI1NjAwMDA6IHBlcm1hbmVudFxuICAgICAqL1xuICAgIHJlYWRvbmx5IGZvcmJpZGRlblRpbWU6IG51bWJlciB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBzcGFuOiBUaGUgbWF4aW11bSBwZXJpb2Qgb2YgdGltZSBkdXJpbmcgd2hpY2ggZmFpbGVkIGxvZ29uIGF0dGVtcHRzIGZyb20gYW4gYWNjb3VudCBjYW4gb2NjdXIuXG4gICAgICogVW5pdDogbWludXRlcy4gVmFsaWQgdmFsdWVzOlxuICAgICAqIC0gMVxuICAgICAqIC0gMlxuICAgICAqIC0gNVxuICAgICAqIC0gMTBcbiAgICAgKiAtIDE1XG4gICAgICovXG4gICAgcmVhZG9ubHkgc3BhbjogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHV1aWRMaXN0OiBUaGUgVVVJRHMgb2YgdGhlIHNlcnZlcnMgdG8gd2hpY2ggeW91IHdhbnQgdG8gYXBwbHkgdGhlIGRlZmVuc2UgcnVsZS5cbiAgICAgKi9cbiAgICByZWFkb25seSB1dWlkTGlzdDogQXJyYXk8c3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlPiB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBkZWZhdWx0UnVsZTogU3BlY2lmaWVzIHdoZXRoZXIgdG8gc2V0IHRoZSBkZWZlbnNlIHJ1bGUgYXMgdGhlIGRlZmF1bHQgcnVsZS4gXG4gICAgICogVmFsaWQgdmFsdWVzOlxuICAgICAqIC0gdHJ1ZTogeWVzXG4gICAgICogLSBmYWxzZTogbm9cbiAgICAgKi9cbiAgICByZWFkb25seSBkZWZhdWx0UnVsZT86IGJvb2xlYW4gfCByb3MuSVJlc29sdmFibGU7XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgUm9zQW50aUJydXRlRm9yY2VSdWxlUHJvcHNgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFJvc0FudGlCcnV0ZUZvcmNlUnVsZVByb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIFJvc0FudGlCcnV0ZUZvcmNlUnVsZVByb3BzVmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IHJvcy5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIXJvcy5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiByb3MuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IHJvcy5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZGVmYXVsdFJ1bGUnLCByb3MudmFsaWRhdGVCb29sZWFuKShwcm9wZXJ0aWVzLmRlZmF1bHRSdWxlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdhbnRpQnJ1dGVGb3JjZVJ1bGVOYW1lJywgcm9zLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmFudGlCcnV0ZUZvcmNlUnVsZU5hbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2FudGlCcnV0ZUZvcmNlUnVsZU5hbWUnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuYW50aUJydXRlRm9yY2VSdWxlTmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZm9yYmlkZGVuVGltZScsIHJvcy5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5mb3JiaWRkZW5UaW1lKSk7XG4gICAgaWYocHJvcGVydGllcy5mb3JiaWRkZW5UaW1lICYmICh0eXBlb2YgcHJvcGVydGllcy5mb3JiaWRkZW5UaW1lKSAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdmb3JiaWRkZW5UaW1lJywgcm9zLnZhbGlkYXRlQWxsb3dlZFZhbHVlcykoe1xuICAgICAgICAgIGRhdGE6IHByb3BlcnRpZXMuZm9yYmlkZGVuVGltZSxcbiAgICAgICAgICBhbGxvd2VkVmFsdWVzOiBbNSwxNSwzMCw2MCwxMjAsMzYwLDcyMCwxNDQwLDEwMDgwLDUyNTYwMDAwXSxcbiAgICAgICAgfSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2ZvcmJpZGRlblRpbWUnLCByb3MudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMuZm9yYmlkZGVuVGltZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigndXVpZExpc3QnLCByb3MucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMudXVpZExpc3QpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3V1aWRMaXN0Jywgcm9zLmxpc3RWYWxpZGF0b3Iocm9zLnZhbGlkYXRlU3RyaW5nKSkocHJvcGVydGllcy51dWlkTGlzdCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZmFpbENvdW50Jywgcm9zLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmZhaWxDb3VudCkpO1xuICAgIGlmKHByb3BlcnRpZXMuZmFpbENvdW50ICYmICh0eXBlb2YgcHJvcGVydGllcy5mYWlsQ291bnQpICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2ZhaWxDb3VudCcsIHJvcy52YWxpZGF0ZUFsbG93ZWRWYWx1ZXMpKHtcbiAgICAgICAgICBkYXRhOiBwcm9wZXJ0aWVzLmZhaWxDb3VudCxcbiAgICAgICAgICBhbGxvd2VkVmFsdWVzOiBbMiwzLDQsNSwxMCw1MCw4MCwxMDBdLFxuICAgICAgICB9KSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZmFpbENvdW50Jywgcm9zLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLmZhaWxDb3VudCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignc3BhbicsIHJvcy5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5zcGFuKSk7XG4gICAgaWYocHJvcGVydGllcy5zcGFuICYmICh0eXBlb2YgcHJvcGVydGllcy5zcGFuKSAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdzcGFuJywgcm9zLnZhbGlkYXRlQWxsb3dlZFZhbHVlcykoe1xuICAgICAgICAgIGRhdGE6IHByb3BlcnRpZXMuc3BhbixcbiAgICAgICAgICBhbGxvd2VkVmFsdWVzOiBbMSwyLDUsMTAsMTVdLFxuICAgICAgICB9KSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignc3BhbicsIHJvcy52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5zcGFuKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIlJvc0FudGlCcnV0ZUZvcmNlUnVsZVByb3BzXCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBbGlDbG91ZCBST1MgUmVzb3VyY2UgcHJvcGVydGllcyBvZiBhbiBgQUxJWVVOOjpUaHJlYXREZXRlY3Rpb246OkFudGlCcnV0ZUZvcmNlUnVsZWAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgUm9zQW50aUJydXRlRm9yY2VSdWxlUHJvcHNgXG4gKlxuICogQHJldHVybnMgdGhlIEFsaUNsb3VkIFJPUyBSZXNvdXJjZSBwcm9wZXJ0aWVzIG9mIGFuIGBBTElZVU46OlRocmVhdERldGVjdGlvbjo6QW50aUJydXRlRm9yY2VSdWxlYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIHJvc0FudGlCcnV0ZUZvcmNlUnVsZVByb3BzVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzOiBhbnksIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50OiBib29sZWFuKTogYW55IHtcbiAgICBpZiAoIXJvcy5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgaWYoZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQpIHtcbiAgICAgICAgUm9zQW50aUJydXRlRm9yY2VSdWxlUHJvcHNWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIH1cbiAgICByZXR1cm4ge1xuICAgICAgQW50aUJydXRlRm9yY2VSdWxlTmFtZTogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5hbnRpQnJ1dGVGb3JjZVJ1bGVOYW1lKSxcbiAgICAgIEZhaWxDb3VudDogcm9zLm51bWJlclRvUm9zVGVtcGxhdGUocHJvcGVydGllcy5mYWlsQ291bnQpLFxuICAgICAgRm9yYmlkZGVuVGltZTogcm9zLm51bWJlclRvUm9zVGVtcGxhdGUocHJvcGVydGllcy5mb3JiaWRkZW5UaW1lKSxcbiAgICAgIFNwYW46IHJvcy5udW1iZXJUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuc3BhbiksXG4gICAgICBVdWlkTGlzdDogcm9zLmxpc3RNYXBwZXIocm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUpKHByb3BlcnRpZXMudXVpZExpc3QpLFxuICAgICAgRGVmYXVsdFJ1bGU6IHJvcy5ib29sZWFuVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmRlZmF1bHRSdWxlKSxcbiAgICB9O1xufVxuXG4vKipcbiAqIEEgUk9TIHRlbXBsYXRlIHR5cGU6ICBgQUxJWVVOOjpUaHJlYXREZXRlY3Rpb246OkFudGlCcnV0ZUZvcmNlUnVsZWBcbiAqL1xuZXhwb3J0IGNsYXNzIFJvc0FudGlCcnV0ZUZvcmNlUnVsZSBleHRlbmRzIHJvcy5Sb3NSZXNvdXJjZSB7XG4gICAgLyoqXG4gICAgICogVGhlIHJlc291cmNlIHR5cGUgbmFtZSBmb3IgdGhpcyByZXNvdXJjZSBjbGFzcy5cbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFJPU19SRVNPVVJDRV9UWVBFX05BTUUgPSBcIkFMSVlVTjo6VGhyZWF0RGV0ZWN0aW9uOjpBbnRpQnJ1dGVGb3JjZVJ1bGVcIjtcblxuICAgIC8qKlxuICAgICAqIEEgZmFjdG9yeSBtZXRob2QgdGhhdCBjcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoaXMgY2xhc3MgZnJvbSBhbiBvYmplY3RcbiAgICAgKiBjb250YWluaW5nIHRoZSBwcm9wZXJ0aWVzIG9mIHRoaXMgUk9TIHJlc291cmNlLlxuICAgICAqL1xuXG4gICAgLyoqXG4gICAgICogQEF0dHJpYnV0ZSBBbnRpQnJ1dGVGb3JjZVJ1bGVJZDogVGhlIElEIG9mIHRoZSBkZWZlbnNlIHJ1bGUuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJBbnRpQnJ1dGVGb3JjZVJ1bGVJZDogcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQEF0dHJpYnV0ZSBBbnRpQnJ1dGVGb3JjZVJ1bGVOYW1lOiBUaGUgbmFtZSBvZiB0aGUgZGVmZW5zZSBydWxlLlxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyQW50aUJydXRlRm9yY2VSdWxlTmFtZTogcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQEF0dHJpYnV0ZSBEZWZhdWx0UnVsZTogU3BlY2lmaWVzIHdoZXRoZXIgdG8gc2V0IHRoZSBkZWZlbnNlIHJ1bGUgYXMgdGhlIGRlZmF1bHQgcnVsZS4gXG5WYWxpZCB2YWx1ZXM6XG4tIHRydWU6IHllc1xuLSBmYWxzZTogbm9cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckRlZmF1bHRSdWxlOiByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAQXR0cmlidXRlIEZhaWxDb3VudDogVGhlIHRocmVzaG9sZCBmb3IgdGhlIG51bWJlciBvZiBmYWlsZWQgdXNlciBsb2dpbnMgd2hlbiB0aGUgYnJ1dGUtZm9yY2UgZGVmZW5zZSBydWxlIHRha2VzIGVmZmVjdC5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckZhaWxDb3VudDogcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQEF0dHJpYnV0ZSBGb3JiaWRkZW5UaW1lOiBUaGUgcGVyaW9kIG9mIHRpbWUgZHVyaW5nIHdoaWNoIGxvZ29ucyBmcm9tIGFuIGFjY291bnQgYXJlIG5vdCBhbGxvd2VkLiBVbml0OiBtaW51dGVzLlxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyRm9yYmlkZGVuVGltZTogcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQEF0dHJpYnV0ZSBTcGFuOiBUaGUgcGVyaW9kIG9mIHRpbWUgZHVyaW5nIHdoaWNoIGxvZ29uIGZhaWx1cmVzIGZyb20gYW4gYWNjb3VudCBhcmUgbWVhc3VyZWQuIFVuaXQ6IG1pbnV0ZXMuIElmIFNwYW4gaXMgc2V0IHRvIDEwLCB0aGUgZGVmZW5zZSBydWxlIHRha2VzIGVmZmVjdCB3aGVuIHRoZSBsb2dvbiBmYWlsdXJlcyBtZWFzdXJlZCB3aXRoaW4gMTAgbWludXRlcyByZWFjaGVzIHRoZSBzcGVjaWZpZWQgdGhyZXNob2xkLiBUaGUgSVAgYWRkcmVzc2VzIG9mIGF0dGFja2VycyBjYW5ub3QgYmUgdXNlZCB0byBsb2cgb24gdG8gdGhlIHNlcnZlciB3aXRoaW4gdGhlIHNwZWNpZmllZCBwZXJpb2Qgb2YgdGltZS5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0clNwYW46IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBBdHRyaWJ1dGUgVXVpZExpc3Q6IFRoZSBVVUlEcyBvZiB0aGUgc2VydmVyIHRvIHdoaWNoIHRoZSBkZWZlbnNlIHJ1bGUgaXMgYXBwbGllZC5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0clV1aWRMaXN0OiByb3MuSVJlc29sdmFibGU7XG5cbiAgICBwdWJsaWMgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6IGJvb2xlYW47XG5cblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBhbnRpQnJ1dGVGb3JjZVJ1bGVOYW1lOiBUaGUgbmFtZSBvZiB0aGUgZGVmZW5zZSBydWxlLlxuICAgICAqL1xuICAgIHB1YmxpYyBhbnRpQnJ1dGVGb3JjZVJ1bGVOYW1lOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgZmFpbENvdW50OiBUaGUgbWF4aW11bSBudW1iZXIgb2YgZmFpbGVkIGxvZ29uIGF0dGVtcHRzIGZyb20gYW4gYWNjb3VudC4gXG4gICAgICogVmFsaWQgdmFsdWVzOiAyLCAzLCA0LCA1LCAxMCwgNTAsIDgwLCBhbmQgMTAwLlxuICAgICAqL1xuICAgIHB1YmxpYyBmYWlsQ291bnQ6IG51bWJlciB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBmb3JiaWRkZW5UaW1lOiBUaGUgcGVyaW9kIG9mIHRpbWUgZHVyaW5nIHdoaWNoIGxvZ29ucyBmcm9tIGFuIGFjY291bnQgYXJlIG5vdCBhbGxvd2VkLlxuICAgICAqIFVuaXQ6IG1pbnV0ZXMuIFZhbGlkIHZhbHVlczpcbiAgICAgKiAtIDU6IDUgbWludXRlc1xuICAgICAqIC0gMTU6IDE1IG1pbnV0ZXNcbiAgICAgKiAtIDMwOiAzMCBtaW51dGVzXG4gICAgICogLSA2MDogMSBob3VyXG4gICAgICogLSAxMjA6IDIgaG91cnNcbiAgICAgKiAtIDM2MDogNiBob3Vyc1xuICAgICAqIC0gNzIwOiAxMiBob3Vyc1xuICAgICAqIC0gMTQ0MDogMjQgaG91cnNcbiAgICAgKiAtIDEwMDgwOiA3IGRheXNcbiAgICAgKiAtIDUyNTYwMDAwOiBwZXJtYW5lbnRcbiAgICAgKi9cbiAgICBwdWJsaWMgZm9yYmlkZGVuVGltZTogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHNwYW46IFRoZSBtYXhpbXVtIHBlcmlvZCBvZiB0aW1lIGR1cmluZyB3aGljaCBmYWlsZWQgbG9nb24gYXR0ZW1wdHMgZnJvbSBhbiBhY2NvdW50IGNhbiBvY2N1ci5cbiAgICAgKiBVbml0OiBtaW51dGVzLiBWYWxpZCB2YWx1ZXM6XG4gICAgICogLSAxXG4gICAgICogLSAyXG4gICAgICogLSA1XG4gICAgICogLSAxMFxuICAgICAqIC0gMTVcbiAgICAgKi9cbiAgICBwdWJsaWMgc3BhbjogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHV1aWRMaXN0OiBUaGUgVVVJRHMgb2YgdGhlIHNlcnZlcnMgdG8gd2hpY2ggeW91IHdhbnQgdG8gYXBwbHkgdGhlIGRlZmVuc2UgcnVsZS5cbiAgICAgKi9cbiAgICBwdWJsaWMgdXVpZExpc3Q6IEFycmF5PHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZT4gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgZGVmYXVsdFJ1bGU6IFNwZWNpZmllcyB3aGV0aGVyIHRvIHNldCB0aGUgZGVmZW5zZSBydWxlIGFzIHRoZSBkZWZhdWx0IHJ1bGUuIFxuICAgICAqIFZhbGlkIHZhbHVlczpcbiAgICAgKiAtIHRydWU6IHllc1xuICAgICAqIC0gZmFsc2U6IG5vXG4gICAgICovXG4gICAgcHVibGljIGRlZmF1bHRSdWxlOiBib29sZWFuIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQ3JlYXRlIGEgbmV3IGBBTElZVU46OlRocmVhdERldGVjdGlvbjo6QW50aUJydXRlRm9yY2VSdWxlYC5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgICAqIEBwYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBAcGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXG4gICAgICovXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IHJvcy5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBSb3NBbnRpQnJ1dGVGb3JjZVJ1bGVQcm9wcywgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6IGJvb2xlYW4pIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkLCB7IHR5cGU6IFJvc0FudGlCcnV0ZUZvcmNlUnVsZS5ST1NfUkVTT1VSQ0VfVFlQRV9OQU1FLCBwcm9wZXJ0aWVzOiBwcm9wcyB9KTtcbiAgICAgICAgdGhpcy5hdHRyQW50aUJydXRlRm9yY2VSdWxlSWQgPSB0aGlzLmdldEF0dCgnQW50aUJydXRlRm9yY2VSdWxlSWQnKTtcbiAgICAgICAgdGhpcy5hdHRyQW50aUJydXRlRm9yY2VSdWxlTmFtZSA9IHRoaXMuZ2V0QXR0KCdBbnRpQnJ1dGVGb3JjZVJ1bGVOYW1lJyk7XG4gICAgICAgIHRoaXMuYXR0ckRlZmF1bHRSdWxlID0gdGhpcy5nZXRBdHQoJ0RlZmF1bHRSdWxlJyk7XG4gICAgICAgIHRoaXMuYXR0ckZhaWxDb3VudCA9IHRoaXMuZ2V0QXR0KCdGYWlsQ291bnQnKTtcbiAgICAgICAgdGhpcy5hdHRyRm9yYmlkZGVuVGltZSA9IHRoaXMuZ2V0QXR0KCdGb3JiaWRkZW5UaW1lJyk7XG4gICAgICAgIHRoaXMuYXR0clNwYW4gPSB0aGlzLmdldEF0dCgnU3BhbicpO1xuICAgICAgICB0aGlzLmF0dHJVdWlkTGlzdCA9IHRoaXMuZ2V0QXR0KCdVdWlkTGlzdCcpO1xuXG4gICAgICAgIHRoaXMuZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQgPSBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludDtcbiAgICAgICAgdGhpcy5hbnRpQnJ1dGVGb3JjZVJ1bGVOYW1lID0gcHJvcHMuYW50aUJydXRlRm9yY2VSdWxlTmFtZTtcbiAgICAgICAgdGhpcy5mYWlsQ291bnQgPSBwcm9wcy5mYWlsQ291bnQ7XG4gICAgICAgIHRoaXMuZm9yYmlkZGVuVGltZSA9IHByb3BzLmZvcmJpZGRlblRpbWU7XG4gICAgICAgIHRoaXMuc3BhbiA9IHByb3BzLnNwYW47XG4gICAgICAgIHRoaXMudXVpZExpc3QgPSBwcm9wcy51dWlkTGlzdDtcbiAgICAgICAgdGhpcy5kZWZhdWx0UnVsZSA9IHByb3BzLmRlZmF1bHRSdWxlO1xuICAgIH1cblxuXG4gICAgcHJvdGVjdGVkIGdldCByb3NQcm9wZXJ0aWVzKCk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGFudGlCcnV0ZUZvcmNlUnVsZU5hbWU6IHRoaXMuYW50aUJydXRlRm9yY2VSdWxlTmFtZSxcbiAgICAgICAgICAgIGZhaWxDb3VudDogdGhpcy5mYWlsQ291bnQsXG4gICAgICAgICAgICBmb3JiaWRkZW5UaW1lOiB0aGlzLmZvcmJpZGRlblRpbWUsXG4gICAgICAgICAgICBzcGFuOiB0aGlzLnNwYW4sXG4gICAgICAgICAgICB1dWlkTGlzdDogdGhpcy51dWlkTGlzdCxcbiAgICAgICAgICAgIGRlZmF1bHRSdWxlOiB0aGlzLmRlZmF1bHRSdWxlLFxuICAgICAgICB9O1xuICAgIH1cbiAgICBwcm90ZWN0ZWQgcmVuZGVyUHJvcGVydGllcyhwcm9wczoge1trZXk6IHN0cmluZ106IGFueX0pOiB7IFtrZXk6IHN0cmluZ106IGFueSB9ICB7XG4gICAgICAgIHJldHVybiByb3NBbnRpQnJ1dGVGb3JjZVJ1bGVQcm9wc1RvUm9zVGVtcGxhdGUocHJvcHMsIHRoaXMuZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQpO1xuICAgIH1cbn1cbiJdfQ==