# Generated by Django 2.2 on 2020-07-30 05:58

import cms.models.fields
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import filer.fields.image


class Migration(migrations.Migration):

    dependencies = [
        ("cms", "0022_auto_20180620_1551"),
        migrations.swappable_dependency(settings.FILER_IMAGE_MODEL),
        ("giant_plugins", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="HeroImage",
            fields=[
                (
                    "cmsplugin_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="giant_plugins_heroimage",
                        serialize=False,
                        to="cms.CMSPlugin",
                    ),
                ),
                (
                    "external_url",
                    models.URLField(
                        blank=True, help_text="Overrides the internal link if set"
                    ),
                ),
                ("title", models.CharField(blank=True, max_length=255)),
                ("strapline", models.CharField(blank=True, max_length=255)),
                (
                    "height",
                    models.CharField(
                        choices=[
                            ("square", "Square"),
                            ("4_3", "4:3"),
                            ("16_9", "16:9"),
                            ("21_9", "21:9"),
                        ],
                        default="square",
                        help_text="We recommend selecting the aspect ratio that most closely matches the image that you are using. We will use this to aid with the image position.",
                        max_length=255,
                    ),
                ),
                ("cta_text", models.CharField(blank=True, max_length=255)),
                (
                    "image",
                    filer.fields.image.FilerImageField(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.FILER_IMAGE_MODEL,
                    ),
                ),
                (
                    "internal_link",
                    cms.models.fields.PageField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="cms.Page",
                    ),
                ),
            ],
            options={"abstract": False,},
            bases=("cms.cmsplugin", models.Model),
        ),
    ]
