"""added episodes table

Revision ID: e1d164c37112
Revises: 554178515c27
Create Date: 2017-08-07 21:31:35.799509

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "e1d164c37112"
down_revision = "554178515c27"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "episodes",
        sa.Column("episode_id", sa.Integer(), nullable=False),
        sa.Column("episode_name", sa.String(length=128), nullable=False),
        sa.Column("episode_date", sa.String(length=10), nullable=True),
        sa.Column("timestamp_add_episode", sa.String(length=10), nullable=False),
        sa.Column("series_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["series_id"],
            ["series.series_id"],
        ),
        sa.PrimaryKeyConstraint("episode_id"),
    )
    op.add_column("faces", sa.Column("episode_id", sa.Integer(), nullable=True))
    op.create_foreign_key(None, "faces", "episodes", ["episode_id"], ["episode_id"])
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, "faces", type_="foreignkey")
    op.drop_column("faces", "episode_id")
    op.drop_table("episodes")
    # ### end Alembic commands ###
