"""removed face tables and added to objects tables

Revision ID: d6ffb5f09ed6
Revises: 73cf781b10ad
Create Date: 2017-10-29 22:36:24.766985

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision = "d6ffb5f09ed6"
down_revision = "73cf781b10ad"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "objects",
        sa.Column("object_id", sa.Integer(), nullable=False),
        sa.Column("video_id", sa.Integer(), nullable=True),
        sa.Column("frame_id", sa.Integer(), nullable=True),
        sa.Column("episode_id", sa.Integer(), nullable=True),
        sa.Column("object_number", sa.Integer(), nullable=False),
        sa.Column("object_x", sa.Integer(), nullable=False),
        sa.Column("object_y", sa.Integer(), nullable=False),
        sa.Column("object_w", sa.Integer(), nullable=False),
        sa.Column("object_h", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["episode_id"],
            ["episodes.episode_id"],
        ),
        sa.ForeignKeyConstraint(
            ["frame_id"],
            ["frames.frame_id"],
        ),
        sa.ForeignKeyConstraint(
            ["video_id"],
            ["videos.video_id"],
        ),
        sa.PrimaryKeyConstraint("object_id"),
        sa.UniqueConstraint("video_id", "frame_id", "object_number", name="object"),
    )
    # op.execute("SET foreign_key_checks=0")
    # op.drop_table('faces')
    # op.execute("SET foreign_key_checks=1")
    # op.drop_table('face_classifications')
    # op.add_column('character_labels', sa.Column('character_label_id', sa.Integer(), nullable=False))
    # op.add_column('character_labels', sa.Column('object_id', sa.Integer(), nullable=True))
    # op.execute("ALTER TABLE character_labels DROP FOREIGN KEY character_labels_ibfk_2")
    # op.drop_constraint('character_labels_ibfk_2', 'character_labels', type_='foreignkey')
    op.drop_constraint("object_label", "character_labels", type_="unique")
    op.create_unique_constraint(
        "object_label", "character_labels", ["object_id", "character_id"]
    )
    op.create_foreign_key(
        None, "character_labels", "objects", ["object_id"], ["object_id"]
    )
    op.drop_column("character_labels", "object_x")
    op.drop_column("character_labels", "object_y")
    op.drop_column("character_labels", "object_number")
    op.drop_column("character_labels", "object_w")
    op.drop_column("character_labels", "object_h")
    op.drop_column("character_labels", "label_id")
    op.drop_column("character_labels", "frame_number")
    op.drop_column("character_labels", "video_id")
    op.create_unique_constraint("video_frame", "frames", ["video_id", "frame_number"])
    op.drop_constraint("frames_ibfk_2", "frames", type_="foreignkey")
    op.drop_column("frames", "user_id")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "frames",
        sa.Column(
            "user_id",
            mysql.INTEGER(display_width=11),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.create_foreign_key("frames_ibfk_2", "frames", "users", ["user_id"], ["id"])
    op.drop_constraint("video_frame", "frames", type_="unique")
    op.add_column(
        "character_labels",
        sa.Column(
            "video_id",
            mysql.INTEGER(display_width=11),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "character_labels",
        sa.Column(
            "frame_number",
            mysql.INTEGER(display_width=11),
            autoincrement=False,
            nullable=False,
        ),
    )
    op.add_column(
        "character_labels",
        sa.Column("label_id", mysql.INTEGER(display_width=11), nullable=False),
    )
    op.add_column(
        "character_labels",
        sa.Column(
            "object_h",
            mysql.INTEGER(display_width=11),
            autoincrement=False,
            nullable=False,
        ),
    )
    op.add_column(
        "character_labels",
        sa.Column(
            "object_w",
            mysql.INTEGER(display_width=11),
            autoincrement=False,
            nullable=False,
        ),
    )
    op.add_column(
        "character_labels",
        sa.Column(
            "object_number",
            mysql.INTEGER(display_width=11),
            autoincrement=False,
            nullable=False,
        ),
    )
    op.add_column(
        "character_labels",
        sa.Column(
            "object_y",
            mysql.INTEGER(display_width=11),
            autoincrement=False,
            nullable=False,
        ),
    )
    op.add_column(
        "character_labels",
        sa.Column(
            "object_x",
            mysql.INTEGER(display_width=11),
            autoincrement=False,
            nullable=False,
        ),
    )
    op.drop_constraint(None, "character_labels", type_="foreignkey")
    op.create_foreign_key(
        "character_labels_ibfk_2",
        "character_labels",
        "videos",
        ["video_id"],
        ["video_id"],
    )
    op.drop_constraint("object_label", "character_labels", type_="unique")
    op.create_unique_constraint(
        "object_label",
        "character_labels",
        ["video_id", "frame_number", "object_number"],
    )
    op.drop_column("character_labels", "object_id")
    op.drop_column("character_labels", "character_label_id")
    op.create_table(
        "face_classifications",
        sa.Column(
            "face_classification_id", mysql.INTEGER(display_width=11), nullable=False
        ),
        sa.Column(
            "user_id",
            mysql.INTEGER(display_width=11),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "video_id",
            mysql.INTEGER(display_width=11),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "frame_id",
            mysql.INTEGER(display_width=11),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "face_id",
            mysql.INTEGER(display_width=11),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column("who", mysql.VARCHAR(length=128), nullable=False),
        sa.Column("confidence", mysql.FLOAT(), nullable=False),
        sa.Column(
            "timestamp_face_classified", mysql.VARCHAR(length=10), nullable=False
        ),
        sa.ForeignKeyConstraint(
            ["face_id"], ["faces.face_id"], name="face_classifications_ibfk_2"
        ),
        sa.ForeignKeyConstraint(
            ["frame_id"], ["frames.frame_id"], name="face_classifications_ibfk_1"
        ),
        sa.ForeignKeyConstraint(
            ["user_id"], ["users.id"], name="face_classifications_ibfk_4"
        ),
        sa.ForeignKeyConstraint(
            ["video_id"], ["videos.video_id"], name="face_classifications_ibfk_3"
        ),
        sa.PrimaryKeyConstraint("face_classification_id"),
        mysql_default_charset="utf8",
        mysql_engine="InnoDB",
    )
    op.create_table(
        "faces",
        sa.Column("face_id", mysql.INTEGER(display_width=11), nullable=False),
        sa.Column(
            "user_id",
            mysql.INTEGER(display_width=11),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "video_id",
            mysql.INTEGER(display_width=11),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "frame_id",
            mysql.INTEGER(display_width=11),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "face_x",
            mysql.INTEGER(display_width=11),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "face_y",
            mysql.INTEGER(display_width=11),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "face_w",
            mysql.INTEGER(display_width=11),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "face_h",
            mysql.INTEGER(display_width=11),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "episode_id",
            mysql.INTEGER(display_width=11),
            autoincrement=False,
            nullable=True,
        ),
        sa.ForeignKeyConstraint(
            ["episode_id"], ["episodes.episode_id"], name="faces_ibfk_4"
        ),
        sa.ForeignKeyConstraint(["frame_id"], ["frames.frame_id"], name="faces_ibfk_3"),
        sa.ForeignKeyConstraint(["user_id"], ["users.id"], name="faces_ibfk_2"),
        sa.ForeignKeyConstraint(["video_id"], ["videos.video_id"], name="faces_ibfk_1"),
        sa.PrimaryKeyConstraint("face_id"),
        mysql_default_charset="utf8",
        mysql_engine="InnoDB",
    )
    op.drop_table("objects")
    # ### end Alembic commands ###
