"""test revision with autogenerate

Revision ID: bc0978602558
Revises: 63fcb6f73f50
Create Date: 2017-07-29 12:30:02.705362

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision = "bc0978602558"
down_revision = "63fcb6f73f50"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("migrate_version")
    op.create_foreign_key(
        None, "face_classifications", "frames", ["frame_id"], ["frame_id"]
    )
    op.create_foreign_key(
        None, "face_classifications", "faces", ["face_id"], ["face_id"]
    )
    op.create_foreign_key(
        None, "face_classifications", "videos", ["video_id"], ["video_id"]
    )
    op.create_foreign_key(None, "face_classifications", "users", ["user_id"], ["id"])
    op.create_foreign_key(None, "faces", "videos", ["video_id"], ["video_id"])
    op.create_foreign_key(None, "faces", "users", ["user_id"], ["id"])
    op.create_foreign_key(None, "faces", "frames", ["frame_id"], ["frame_id"])
    op.create_foreign_key(None, "frames", "videos", ["video_id"], ["video_id"])
    op.create_foreign_key(None, "frames", "users", ["user_id"], ["id"])
    op.create_unique_constraint(None, "videos", ["video_display_name"])
    op.create_unique_constraint(None, "videos", ["video_name"])
    op.create_foreign_key(None, "videos", "users", ["user_id"], ["id"])
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, "videos", type_="foreignkey")
    op.drop_constraint(None, "videos", type_="unique")
    op.drop_constraint(None, "videos", type_="unique")
    op.drop_constraint(None, "frames", type_="foreignkey")
    op.drop_constraint(None, "frames", type_="foreignkey")
    op.drop_constraint(None, "faces", type_="foreignkey")
    op.drop_constraint(None, "faces", type_="foreignkey")
    op.drop_constraint(None, "faces", type_="foreignkey")
    op.drop_constraint(None, "face_classifications", type_="foreignkey")
    op.drop_constraint(None, "face_classifications", type_="foreignkey")
    op.drop_constraint(None, "face_classifications", type_="foreignkey")
    op.drop_constraint(None, "face_classifications", type_="foreignkey")
    op.create_table(
        "migrate_version",
        sa.Column("repository_id", mysql.VARCHAR(length=250), nullable=False),
        sa.Column("repository_path", mysql.TEXT(), nullable=True),
        sa.Column(
            "version",
            mysql.INTEGER(display_width=11),
            autoincrement=False,
            nullable=True,
        ),
        sa.PrimaryKeyConstraint("repository_id"),
        mysql_default_charset="utf8",
        mysql_engine="InnoDB",
    )
    # ### end Alembic commands ###
