"""add columns to actors autogen

Revision ID: ae93ed2eb8f0
Revises: 1b019da65d4f
Create Date: 2017-07-29 17:36:19.692127

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "ae93ed2eb8f0"
down_revision = "1b019da65d4f"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "actors", sa.Column("actor_name", sa.String(length=128), nullable=False)
    )
    op.add_column("characters", sa.Column("actor_id", sa.Integer(), nullable=True))
    op.add_column(
        "characters", sa.Column("character_name", sa.String(length=128), nullable=False)
    )
    op.add_column("characters", sa.Column("series_id", sa.Integer(), nullable=True))
    op.create_foreign_key(None, "characters", "series", ["series_id"], ["series_id"])
    op.create_foreign_key(None, "characters", "actors", ["actor_id"], ["actor_id"])
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, "characters", type_="foreignkey")
    op.drop_constraint(None, "characters", type_="foreignkey")
    op.drop_column("characters", "series_id")
    op.drop_column("characters", "character_name")
    op.drop_column("characters", "actor_id")
    op.drop_column("actors", "actor_name")
    # ### end Alembic commands ###
