"""Added faces table to database

Revision ID: aa0ccca01f54
Revises: d36bdd1852b5
Create Date: 2020-05-15 17:20:56.645157

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "aa0ccca01f54"
down_revision = "d36bdd1852b5"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "faces",
        sa.Column("face_id", sa.Integer(), nullable=False),
        sa.Column("object_id", sa.Integer(), nullable=True),
        sa.Column("video_id", sa.Integer(), nullable=True),
        sa.Column("frame_id", sa.Integer(), nullable=True),
        sa.Column("episode_id", sa.Integer(), nullable=True),
        sa.Column("object_number", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["episode_id"],
            ["episodes.episode_id"],
        ),
        sa.ForeignKeyConstraint(
            ["frame_id"],
            ["frames.frame_id"],
        ),
        sa.ForeignKeyConstraint(
            ["object_id"],
            ["objects.object_id"],
        ),
        sa.ForeignKeyConstraint(
            ["video_id"],
            ["videos.video_id"],
        ),
        sa.PrimaryKeyConstraint("face_id"),
        sa.UniqueConstraint("video_id", "frame_id", "object_number", name="object"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("faces")
    # ### end Alembic commands ###
