"""added actor_groups

Revision ID: 8f5ca94205dc
Revises: 02d94cd8a1ce
Create Date: 2018-07-18 18:44:12.886902

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "8f5ca94205dc"
down_revision = "02d94cd8a1ce"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "actor_groups",
        sa.Column("actor_group_id", sa.Integer(), nullable=False),
        sa.Column("actor_group_name", sa.String(length=64), nullable=False),
        sa.Column("timestamp_add_actor_group", sa.String(length=10), nullable=False),
        sa.PrimaryKeyConstraint("actor_group_id"),
    )
    op.create_table(
        "actor_group_lookup",
        sa.Column("actor_group_lookup_id", sa.Integer(), nullable=False),
        sa.Column("actor_group_id", sa.Integer(), nullable=False),
        sa.Column("actor_id", sa.Integer(), nullable=False),
        sa.Column(
            "timestamp_add_actor_group_lookup", sa.String(length=10), nullable=False
        ),
        sa.ForeignKeyConstraint(
            ["actor_group_id"],
            ["actor_groups.actor_group_id"],
        ),
        sa.ForeignKeyConstraint(
            ["actor_id"],
            ["actors.actor_id"],
        ),
        sa.PrimaryKeyConstraint("actor_group_lookup_id"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("actor_group_lookup")
    op.drop_table("actor_groups")
    # ### end Alembic commands ###
