"""Added seasons table

Revision ID: 60a827c82297
Revises: 6c12ddacf663
Create Date: 2017-08-11 19:43:01.130858

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "60a827c82297"
down_revision = "6c12ddacf663"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "seasons",
        sa.Column("season_id", sa.Integer(), nullable=False),
        sa.Column("season_number", sa.Integer(), nullable=False),
        sa.Column("season_year_start", sa.Integer(), nullable=False),
        sa.Column("series_id", sa.Integer(), nullable=True),
        sa.Column("timestamp_add_season", sa.String(length=10), nullable=False),
        sa.ForeignKeyConstraint(
            ["series_id"],
            ["series.series_id"],
        ),
        sa.PrimaryKeyConstraint("season_id"),
    )
    op.add_column("episodes", sa.Column("episode_number", sa.Integer(), nullable=False))
    op.add_column("episodes", sa.Column("season_id", sa.Integer(), nullable=True))
    op.create_foreign_key(None, "episodes", "seasons", ["season_id"], ["season_id"])
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, "episodes", type_="foreignkey")
    op.drop_column("episodes", "season_id")
    op.drop_column("episodes", "episode_number")
    op.drop_table("seasons")
    # ### end Alembic commands ###
