"""Added process_order to processes table

Revision ID: 2a3a19b776c5
Revises: aa0ccca01f54
Create Date: 2020-05-28 16:56:35.636004

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision = "2a3a19b776c5"
down_revision = "aa0ccca01f54"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("haar_faces_deduplicated")
    op.add_column("processes", sa.Column("process_order", sa.Integer(), nullable=True))
    op.create_unique_constraint(None, "processes", ["airflow_dag_id"])
    op.create_unique_constraint(None, "processes", ["process_name"])
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, "processes", type_="unique")
    op.drop_constraint(None, "processes", type_="unique")
    op.drop_column("processes", "process_order")
    op.create_table(
        "haar_faces_deduplicated",
        sa.Column(
            "object_id",
            mysql.BIGINT(display_width=20),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "video_id",
            mysql.BIGINT(display_width=20),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "frame_id",
            mysql.BIGINT(display_width=20),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column("episode_id", mysql.TEXT(), nullable=True),
        sa.Column(
            "object_number",
            mysql.BIGINT(display_width=20),
            autoincrement=False,
            nullable=True,
        ),
        mysql_default_charset="latin1",
        mysql_engine="InnoDB",
    )
    # ### end Alembic commands ###
