"""本模块提供了一系列函数来从浏览器接收用户不同的形式的输入。

输入函数大致分为两类，一类是单项输入，另一类是使用 '输入组'。
输入组中需要在每一项输入函数中提供 '名称' 参数，以用于在结果中标识不同输入项。

本模块中的输入函数都是阻塞式的，输入表单会在成功提交后销毁。
如果你想让表单可以一直显示在页面上并可以持续接收输入，可以考虑使用 '持久输入' 模块。

函数清单
中文        英文
输入        input
文本域      textarea
选择框      select
复选框      checkbox
单选按钮    radio
按钮选项    actions
文件上传    file_upload
滑块        slider
输入组      input_group
输入更新    input_update
"""

从 pywebio.input 导入 *

从 . 导入 _类型字典, _按钮选项翻译


套路 输入(标签='', 类型='文本', *, 验证=空, 名称=空, 值=空, 操作=空,
         当改变时=空, 占位符=空, 必填=空, 只读=空, 数据列表=空,
         帮助文本=空, **其他html属性):
    """input
    输入框
    类型选项: '文本', '数字', '浮点数', '密码', 'url', '日期', '时间', 
             '颜色', '本地日期时间'
    
    操作: 传入一个元组 (标签, 回调函数), 效果是在输入框右侧显示一个按钮，
          用户可通过点击按钮为输入框设置值。回调函数需要接收一个位置参数
          '设置值'; '设置值' 是一个可调用对象, 支持单参数或双参数调用.

          套路 设置此刻时间戳(设置值):
              设置值(整型(时间.时间))
          
          时间戳 = 输入('时间戳', 类型='数字', 操作=('此刻', 设置此刻时间戳))

    数据列表: 输入建议内容列表，在页面上的显示效果为下拉候选列表，
            用户可以忽略建议内容列表而输入其他内容。仅当输入类型为 '文本' 时可用.
    """
    类型 = _类型字典.获取(类型, 类型)
    返回 input(label=标签, type=类型, validate=验证, name=名称, value=值,
               action=操作, onchange=当改变时, placeholder=占位符, 
               required=必填, readonly=只读, datalist=数据列表,
               help_text=帮助文本, **其他html属性)


套路 文本域(标签='', *, 行数=6, 代码=空, 最大长度=空, 最小长度=空,
           验证=空, 名称=空, 值=空, 当改变时=空, 占位符=空,
           必填=空, 只读=空, 帮助文本=空, **其他html属性):
    """textarea
    多行文本输入
    代码: 字典或布尔值, 例如 代码 = {'模式': 'python', '主题': 'darcula'}
        可以直接使用 代码={} 或 代码=真 来开启代码编辑样式
    """
    如果 是实例(代码, 字典型):
        如果 '模式' 在 代码:
            代码['mode'] = 代码.弹出('模式')
        如果 '主题' 在 代码:
            代码['theme'] = 代码.弹出('主题')
    返回 textarea(label=标签, rows=行数, code=代码, maxlength=最大长度,
                  minlength=最小长度, validate=验证, name=名称, value=值,
                  onchange=当改变时, placeholder=占位符, required=必填,
                  readonly=只读, help_text=帮助文本, **其他html属性)


套路 选择框(标签='', 选项々=空, *, 多选=空, 验证=空, 名称=空, 值=空,
           当改变时=空, 必填=空, 帮助文本=空, **其他html属性):
    """select
    下拉选择框
    选项々: 列表, 其元素可以是元组、列表或单值
            元组或列表的格式为 (选项标签, 值, [是否默认选中], [是否禁用])
            若为单值, 则 选项标签 和 值 具有相同的值
    """
    返回 select(label=标签, options=选项々, multiple=多选, validate=验证,
                name=名称, value=值, onchange=当改变时, required=必填,
                help_text=帮助文本, **其他html属性)


套路 复选框(标签='', 选项々=空, *, 行内=空, 验证=空, 名称=空, 值=空,
           当改变时=空, 必填=空, 帮助文本=空, **其他html属性):
    """checkbox
    复选框
    选项々: 格式参见选择框"""
    返回 checkbox(label=标签, options=选项々, inline=行内, validate=验证,
                name=名称, value=值, onchange=当改变时,
                help_text=帮助文本, **其他html属性)


套路 单选按钮(标签='', 选项々=空, *, 行内=空, 验证=空, 名称=空, 值=空,
           当改变时=空, 必填=空, 帮助文本=空, **其他html属性):
    """radio
    单选按钮
    选项々: 格式参见选择框"""
    返回 radio(label=标签, options=选项々, inline=行内, validate=验证,
                name=名称, value=值, onchange=当改变时, required=必填,
                help_text=帮助文本, **其他html属性)


套路 按钮选项(标签='', 按钮々=空, 名称=空, 帮助文本=空):
    """actions
    在表单上显示为一组按钮，用户点击按钮后依据按钮类型的不同有不同的表现。
    按钮々: 按钮列表, 列表元素的可用形式如下:
            1. 字典:
                {
                    '标签': 字符串, 按钮标签
                    '值': 对象, 按钮值
                    '类型': 可选, 字符串, 按钮类型
                    '禁用': 可选, 布尔值, 是否禁用
                    '颜色': 可选, 字符串, 按钮颜色
                }
                若 '类型' 为 '重置'/'取消' 或 '禁用' 为真, 可省略 '值'
            2. 元组或列表: (按钮标签, 按钮值, [按钮类型], [禁用]); 注意: 不支持指定颜色
            3. 单值, 此时按钮标签和按钮值具有相同的值
        按钮类型可选值有: '提交' (默认值), '取消', '重置'
        按钮颜色值可以为: '主色', '副色', '成功', '危险', '警告', '信息', '浅色', '深色'
    """
    _按钮选项翻译(按钮々)

    返回 actions(label=标签, buttons=按钮々, name=名称, help_text=帮助文本)


套路 文件上传(标签='', 接受=空, 名称=空, 占位符='请选择文件', 多选=假,
             最大=0, 总计最大=0, 必填=空, 帮助文本=空, **其他html属性):
    """file_upload
    上传文件
    接受: '.jpg', 'txt', '.png', '.doc', ..., 'image/*', 'video/*', 'application/pdf', ...
    """
    返回 file_upload(label=标签, accept=接受, name=名称, placeholder=占位符,
                multiple=多选, max_size=最大, max_total_size=总计最大,
                required=必填, help_text=帮助文本, **其他html属性)


套路 滑块(标签='', *, 名称=空, 值=0, 最小=0, 最大=100, 步长=1, 验证=空,
           当改变时=空, 必填=空, 帮助文本=空, **其他html属性):
    """slider
    范围输入"""
    返回 slider(label=标签, name=名称, value=值, min_value=最小, max_value=最大,
                step=步长, validate=验证, onchange=当改变时, required=必填,
                help_text=帮助文本, **其他html属性)


套路 输入组(标签='', 输入々=空, 验证=空, 可取消=假):
    """input_group
    要求用户一次提供一组输入"""
    返回 input_group(label=标签, inputs=输入々, validate=验证, cancelable=可取消)


# 套路 解析输入更新规格(规格): 无操作


套路 输入更新(名称=空, **参数々):
    """input_update
    更新输入项的属性。本函数仅能在输入函数的 '当改变时' 回调中使用。"""
    如果 '选项々' 在 参数々:
        参数々['options'] = 参数々.弹出('选项々')
    如果 '值' 在 参数々:
        参数々['value'] = 参数々.弹出('值')
    如果 '数据列表' 在 参数々:
        参数々['datalist'] = 参数々.弹出('数据列表')
    返回 input_update(name=名称, **参数々)

