"""
我们知道，PyWebIO 中的输入函数是阻塞式的，输入表单会在成功提交后被销毁。
在大多数场景下，使用这种方式接收用户输入已经够用了。但在一些场景下，
你或许希望输入表单在提交后不消失，并且可以继续接收输入。

所以，PyWebIO 提供了 '持久输入' 模块来实现持续性输入。

本模块主要有三部分内容:

首先，本模块提供了一些持久输入控件，这些控件和 '输出' 模块中的输出控件并没有什么不同，
只不过它还可以接收输入。

函数清单
中文        英文
输出输入框      put_input
输出文本域      put_textarea
输出选择框      put_select
输出复选框      put_checkbox
输出单选按钮    put_radio
输出按钮选项    put_actions
输出滑块        put_slider

其次，你可以使用 '持久' 对象来获取持久输入控件的值。

最后，本模块还有两个有用的函数: '持久_等待改变()' 和 '持久输入更新()'。

持久输入控件输出函数是非阻塞的， 所以使用 '持久_等待改变()' 来等待
一组持久输入控件的值发生变化。它是一个阻塞式函数。

'持久输入更新()' 可以用来更新持久输入控件的输出属性。
"""

从 pywebio.pin 导入 *

从 . 导入 _类型字典, _按钮选项翻译
从 .输出 导入 〇输出位置


套路 输出输入框(名称, 类型='文本', *, 标签='', 值=空, 占位符=空, 
         只读=空, 数据列表=空, 帮助文本=空, 容器=空, 位置=〇输出位置.底部):
    """put_input
    持久输入框
    类型选项: '文本', '数字', '浮点数', '密码', 'url', '日期', '时间', 
             '颜色', '本地日期时间'
    """
    类型 = _类型字典.获取(类型, 类型)
    返回 put_input(名称, type=类型, label=标签, value=值, placeholder=占位符,
            readonly=只读, datalist=数据列表, help_text=帮助文本,
            scope=容器, position=位置)


套路 输出文本域(名称, *, 标签='', 行数=6, 代码=空, 最大长度=空, 最小长度=空,
           值=空, 占位符=空, 只读=空, 帮助文本=空, 容器=空, 位置=〇输出位置.底部):
    """put_textarea
    持久多行文本输入
    代码: 字典或布尔值, 例如 代码 = {'模式': 'python', '主题': 'darcula'}
        可以直接使用 代码={} 或 代码=真 来开启代码编辑样式
    """
    如果 是实例(代码, 字典型):
        如果 '模式' 在 代码:
            代码['mode'] = 代码.弹出('模式')
        如果 '主题' 在 代码:
            代码['theme'] = 代码.弹出('主题')
    返回 put_textarea(名称, label=标签, rows=行数, code=代码, maxlength=最大长度,
                  minlength=最小长度, value=值, placeholder=占位符,
                  readonly=只读, help_text=帮助文本, scope=容器, position=位置)


套路 输出选择框(名称, 选项々=空, *, 标签='', 多选=空, 值=空,
           帮助文本=空, 容器=空, 位置=〇输出位置.底部):
    """put_select
    持久下拉选择框
    选项々: 列表, 其元素可以是元组、列表或单值
            元组或列表的格式为 (选项标签, 值, [是否默认选中], [是否禁用])
            若为单值, 则 选项标签 和 值 具有相同的值
    """
    返回 put_select(名称, options=选项々, label=标签, multiple=多选, 
            value=值, help_text=帮助文本, scope=容器, position=位置)


套路 输出复选框(名称, 选项々=空, *, 标签='', 行内=空, 值=空,
           帮助文本=空, 容器=空, 位置=〇输出位置.底部):
    """put_checkbox
    持久复选框
    选项々: 格式参见选择框"""
    返回 put_checkbox(名称, options=选项々, label=标签, inline=行内,
                value=值, help_text=帮助文本, scope=容器, position=位置)


套路 输出单选按钮(名称, 选项々=空, *, 标签='', 行内=空, 值=空,
           帮助文本=空, 容器=空, 位置=〇输出位置.底部):
    """put_radio
    持久单选按钮
    选项々: 格式参见选择框"""
    返回 put_radio(名称, options=选项々, label=标签, inline=行内,
                value=值, help_text=帮助文本, scope=容器, position=位置)


套路 输出按钮选项(名称, *, 标签='', 按钮々=空, 帮助文本=空,
            容器=空, 位置=〇输出位置.底部):
    """put_actions
    在表单上显示为一组按钮，用户点击按钮后依据按钮类型的不同有不同的表现。
    按钮々: 参见输入模块的对应参数
    """
    _按钮选项翻译(按钮々)

    返回 put_actions(名称, label=标签, buttons=按钮々,
                help_text=帮助文本, scope=容器, position=位置)


套路 输出滑块(名称, *, 标签='', 值=0, 最小=0, 最大=100, 步长=1,
        必填=空, 帮助文本=空, 容器=空, 位置=〇输出位置.底部):
    """put_slider
    持久范围输入"""
    返回 put_slider(名称, label=标签, value=值, min_value=最小, max_value=最大,
                step=步长, required=必填, help_text=帮助文本,
                scope=容器, position=位置)


持久 = pin


套路 持久_等待改变(*名称々, 超时=空):
    """pin_wait_change
    侦听一系列持久输入控件, 当其中任一控件的值发生改变时, 返回相应控件的名称和值"""
    返回 pin_wait_change(*名称々, timeout=超时)


套路 持久输入更新(名称, **参数々):
    """pin_update
    更新持久输入控件的属性"""
    如果 '选项々' 在 参数々:
        参数々['options'] = 参数々.弹出('选项々')
    如果 '值' 在 参数々:
        参数々['value'] = 参数々.弹出('值')
    如果 '数据列表' 在 参数々:
        参数々['datalist'] = 参数々.弹出('数据列表')
    返回 pin_update(名称, **参数々)


套路 持久_当改变时(名称, 当改变时=空, 清除=假, 初始化运行=假, **回调选项々):
    """pin_on_change
    将一个回调函数与一个持久输入控件绑定"""
    返回 pin_on_change(名称, onchange=当改变时, clear=清除,
                init_run=初始化运行, **回调选项々)
