# -*- coding: utf-8 -*-
"""Add outflow_ prefix to internal outflow tables

Revision ID: c07e04312313
Revises: 596bc3fce180
Create Date: 2021-10-18 16:25:02.427135

"""
from alembic import op


# revision identifiers, used by Alembic.
revision = "c07e04312313"
down_revision = "596bc3fce180"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.rename_table("run", "outflow_run")
    op.rename_table("configuration", "outflow_configuration")
    op.rename_table("edge", "outflow_edge")
    op.rename_table("runtime_exception", "outflow_runtime_exception")
    op.rename_table("task", "outflow_task")
    op.rename_table("workflow", "outflow_workflow")
    if op.get_context().dialect.name == "postgresql":
        # sequences
        op.execute("ALTER SEQUENCE  run_id_seq RENAME TO outflow_run_id_seq")
        op.execute(
            "ALTER SEQUENCE  configuration_id_seq RENAME TO outflow_configuration_id_seq"
        )
        op.execute(
            "ALTER SEQUENCE  runtime_exception_id_seq RENAME TO outflow_runtime_exception_id_seq"
        )
        op.execute("ALTER SEQUENCE  task_id_seq RENAME TO outflow_task_id_seq")
        op.execute("ALTER SEQUENCE  workflow_id_seq RENAME TO outflow_workflow_id_seq")

        # indices
        op.execute("ALTER INDEX task_pkey RENAME TO outflow_task_pkey")
        op.execute(
            "ALTER INDEX configuration_pkey RENAME TO outflow_configuration_pkey"
        )
        op.execute("ALTER INDEX workflow_pkey RENAME TO outflow_workflow_pkey")
        op.execute(
            "ALTER INDEX runtime_exception_pkey RENAME TO outflow_runtime_exception_pkey"
        )
        op.execute("ALTER INDEX run_pkey RENAME TO outflow_run_pkey")
        op.execute("ALTER INDEX task_uuid_key  RENAME TO outflow_task_uuid_key")
        op.execute("ALTER INDEX run_uuid_key  RENAME TO outflow_run_uuid_key")
        op.execute("ALTER INDEX edge_pkey  RENAME TO outflow_edge_pkey")
        op.execute(
            "ALTER INDEX configuration_hash_key  RENAME TO outflow_configuration_hash_key"
        )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.rename_table("outflow_run", "run")
    op.rename_table("outflow_configuration", "configuration")
    op.rename_table("outflow_edge", "edge")
    op.rename_table("outflow_runtime_exception", "runtime_exception")
    op.rename_table("outflow_task", "task")
    op.rename_table("outflow_workflow", "workflow")
    if op.get_context().dialect.name == "postgresql":
        op.execute("ALTER SEQUENCE  outflow_run_id_seq RENAME TO  run_id_seq")
        op.execute(
            "ALTER SEQUENCE  outflow_configuration_id_seq RENAME TO  configuration_id_seq"
        )
        op.execute(
            "ALTER SEQUENCE  outflow_runtime_exception_id_seq RENAME TO  runtime_exception_id_seq"
        )
        op.execute("ALTER SEQUENCE  outflow_task_id_seq RENAME TO  task_id_seq")
        op.execute("ALTER SEQUENCE  outflow_workflow_id_seq RENAME TO  workflow_id_seq")

        # indices
        op.execute("ALTER INDEX outflow_task_pkey RENAME TO task_pkey")
        op.execute(
            "ALTER INDEX outflow_configuration_pkey RENAME TO configuration_pkey"
        )
        op.execute("ALTER INDEX outflow_workflow_pkey RENAME TO workflow_pkey")
        op.execute(
            "ALTER INDEX outflow_runtime_exception_pkey RENAME TO runtime_exception_pkey"
        )
        op.execute("ALTER INDEX outflow_run_pkey RENAME TO run_pkey")
        op.execute("ALTER INDEX outflow_task_uuid_key  RENAME TO task_uuid_key")
        op.execute("ALTER INDEX outflow_run_uuid_key  RENAME TO run_uuid_key")
        op.execute("ALTER INDEX outflow_edge_pkey  RENAME TO edge_pkey")
        op.execute(
            "ALTER INDEX outflow_configuration_hash_key  RENAME TO configuration_hash_key"
        )
    # ### end Alembic commands ###
