# -*- coding: utf-8 -*-
"""Add column hostname and input_values

Revision ID: 596bc3fce180
Revises: 094e0007ec5c
Create Date: 2021-10-08 18:00:02.521437

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "596bc3fce180"
down_revision = "094e0007ec5c"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("run", sa.Column("hostname", sa.String(length=256), nullable=True))
    op.add_column("task", sa.Column("hostname", sa.String(length=256), nullable=True))
    op.add_column(
        "task", sa.Column("input_values", sa.JSON(), server_default="{}", nullable=True)
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("task") as batch_op:
        batch_op.drop_column("input_values")
        batch_op.drop_column("hostname")

    with op.batch_alter_table("run") as batch_op:
        batch_op.drop_column("hostname")
    # ### end Alembic commands ###
