from scotty.fun_general import freq_GHz_to_wavenumber, find_nearest

from scipy.constants import c as speed_of_light
import numpy as np


def test_freq_GHz_to_wavenumber():
    assert np.isclose(freq_GHz_to_wavenumber(1.0 / (2 * np.pi)), 1e9 / speed_of_light)


def test_find_nearest():
    data = [1, 3, 5, 7, 9]
    assert find_nearest(data, 5.5) == 2
    assert find_nearest(data, 6.5) == 3
    assert find_nearest(data, 0.5) == 0
    assert find_nearest(data, 10) == 4
