"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeSigningConfig = exports.UntrustedArtifactOnDeployment = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const lambda_generated_1 = require("./lambda.generated");
/**
 * Code signing configuration policy for deployment validation failure.
 */
var UntrustedArtifactOnDeployment;
(function (UntrustedArtifactOnDeployment) {
    /**
     * Lambda blocks the deployment request if signature validation checks fail.
     */
    UntrustedArtifactOnDeployment["ENFORCE"] = "Enforce";
    /**
     * Lambda allows the deployment of the code package, but issues a warning.
     * Lambda issues a new Amazon CloudWatch metric, called a signature validation error and also stores the warning in CloudTrail.
     */
    UntrustedArtifactOnDeployment["WARN"] = "Warn";
})(UntrustedArtifactOnDeployment = exports.UntrustedArtifactOnDeployment || (exports.UntrustedArtifactOnDeployment = {}));
/**
 * Defines a Code Signing Config.
 *
 * @resource AWS::Lambda::CodeSigningConfig
 */
class CodeSigningConfig extends core_1.Resource {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_lambda_CodeSigningConfigProps(props);
        const signingProfileVersionArns = props.signingProfiles.map(signingProfile => {
            return signingProfile.signingProfileVersionArn;
        });
        const resource = new lambda_generated_1.CfnCodeSigningConfig(this, 'Resource', {
            allowedPublishers: {
                signingProfileVersionArns,
            },
            codeSigningPolicies: {
                untrustedArtifactOnDeployment: (_b = props.untrustedArtifactOnDeployment) !== null && _b !== void 0 ? _b : UntrustedArtifactOnDeployment.WARN,
            },
            description: props.description,
        });
        this.codeSigningConfigArn = resource.attrCodeSigningConfigArn;
        this.codeSigningConfigId = resource.attrCodeSigningConfigId;
    }
    /**
     * Creates a Signing Profile construct that represents an external Signing Profile.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param codeSigningConfigArn The ARN of code signing config.
     */
    static fromCodeSigningConfigArn(scope, id, codeSigningConfigArn) {
        const codeSigningProfileId = core_1.Stack.of(scope).splitArn(codeSigningConfigArn, core_1.ArnFormat.SLASH_RESOURCE_NAME).resourceName;
        if (!codeSigningProfileId) {
            throw new Error(`Code signing config ARN must be in the format 'arn:aws:lambda:<region>:<account>:code-signing-config:<codeSigningConfigArn>', got: '${codeSigningConfigArn}'`);
        }
        const assertedCodeSigningProfileId = codeSigningProfileId;
        class Import extends core_1.Resource {
            constructor() {
                super(scope, id);
                this.codeSigningConfigArn = codeSigningConfigArn;
                this.codeSigningConfigId = assertedCodeSigningProfileId;
            }
        }
        return new Import();
    }
}
exports.CodeSigningConfig = CodeSigningConfig;
_a = JSII_RTTI_SYMBOL_1;
CodeSigningConfig[_a] = { fqn: "@aws-cdk/aws-lambda.CodeSigningConfig", version: "1.151.0" };
//# sourceMappingURL=data:application/json;base64,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