# generated by datamodel-codegen:
#   filename:  argo-workflows-3.4.4.json

from __future__ import annotations

from typing import Any, Dict, List, Optional

from pydantic import Field

from hera.shared._base_model import BaseModel

from ...k8s.api.core import v1
from ...k8s.api.policy import v1beta1
from ...k8s.apimachinery.pkg.apis.meta import v1 as v1_1
from ...k8s.apimachinery.pkg.util import intstr


class Amount(BaseModel):
    __root__: float = Field(..., description="Amount represent a numeric amount.")


class ArchivedWorkflowDeletedResponse(BaseModel):
    pass


class ArtGCStatus(BaseModel):
    not_specified: Optional[bool] = Field(
        default=None,
        alias="notSpecified",
        description=("if this is true, we already checked to see if we need to do it and we" " don't"),
    )
    pods_recouped: Optional[Dict[str, bool]] = Field(
        default=None,
        alias="podsRecouped",
        description=(
            "have completed Pods been processed? (mapped by Pod name) used to prevent"
            " re-processing the Status of a Pod more than once"
        ),
    )
    strategies_processed: Optional[Dict[str, bool]] = Field(
        default=None,
        alias="strategiesProcessed",
        description=(
            "have Pods been started to perform this strategy? (enables us not to"
            " re-process what we've already done)"
        ),
    )


class ArtifactRepositoryRef(BaseModel):
    config_map: Optional[str] = Field(
        default=None,
        alias="configMap",
        description='The name of the config map. Defaults to "artifact-repositories".',
    )
    key: Optional[str] = Field(
        default=None,
        description=(
            "The config map key. Defaults to the value of the"
            ' "workflows.argoproj.io/default-artifact-repository" annotation.'
        ),
    )


class ArtifactResult(BaseModel):
    error: Optional[str] = Field(
        default=None,
        description=("Error is an optional error message which should be set if Success==false"),
    )
    name: str = Field(..., description="Name is the name of the Artifact")
    success: Optional[bool] = Field(default=None, description="Success describes whether the deletion succeeded")


class ArtifactResultNodeStatus(BaseModel):
    artifact_results: Optional[Dict[str, ArtifactResult]] = Field(
        default=None,
        alias="artifactResults",
        description="ArtifactResults maps Artifact name to result of the deletion",
    )


class ClusterWorkflowTemplateDeleteResponse(BaseModel):
    pass


class CollectEventRequest(BaseModel):
    name: Optional[str] = None


class CollectEventResponse(BaseModel):
    pass


class Condition(BaseModel):
    message: Optional[str] = Field(default=None, description="Message is the condition message")
    status: Optional[str] = Field(default=None, description="Status is the status of the condition")
    type: Optional[str] = Field(default=None, description="Type is the type of condition")


class ContinueOn(BaseModel):
    error: Optional[bool] = None
    failed: Optional[bool] = None


class Counter(BaseModel):
    value: str = Field(..., description="Value is the value of the metric")


class CreateS3BucketOptions(BaseModel):
    object_locking: Optional[bool] = Field(
        default=None,
        alias="objectLocking",
        description="ObjectLocking Enable object locking",
    )


class CronWorkflowDeletedResponse(BaseModel):
    pass


class CronWorkflowResumeRequest(BaseModel):
    name: Optional[str] = None
    namespace: Optional[str] = None


class CronWorkflowSuspendRequest(BaseModel):
    name: Optional[str] = None
    namespace: Optional[str] = None


class Event(BaseModel):
    selector: str = Field(
        ...,
        description=(
            "Selector (https://github.com/antonmedv/expr) that we must must match the"
            ' io.argoproj.workflow.v1alpha1. E.g. `payload.message == "test"`'
        ),
    )


class EventResponse(BaseModel):
    pass


class ExecutorConfig(BaseModel):
    service_account_name: Optional[str] = Field(
        default=None,
        alias="serviceAccountName",
        description=("ServiceAccountName specifies the service account name of the executor" " container."),
    )


class Gauge(BaseModel):
    realtime: bool = Field(..., description="Realtime emits this metric in real time if applicable")
    value: str = Field(..., description="Value is the value of the metric")


class GetUserInfoResponse(BaseModel):
    email: Optional[str] = None
    email_verified: Optional[bool] = Field(default=None, alias="emailVerified")
    groups: Optional[List[str]] = None
    issuer: Optional[str] = None
    service_account_name: Optional[str] = Field(default=None, alias="serviceAccountName")
    service_account_namespace: Optional[str] = Field(default=None, alias="serviceAccountNamespace")
    subject: Optional[str] = None


class HTTPBodySource(BaseModel):
    bytes: Optional[str] = None


class Header(BaseModel):
    name: str = Field(..., description="Name is the header name")
    value: str = Field(..., description="Value is the literal value to use for the header")


class Histogram(BaseModel):
    buckets: List[Amount] = Field(..., description="Buckets is a list of bucket divisors for the histogram")
    value: str = Field(..., description="Value is the value of the metric")


class Item(BaseModel):
    __root__: Any = Field(
        ...,
        description=(
            "Item expands a single workflow step into multiple parallel steps The value"
            " of Item can be a map, string, bool, or number"
        ),
    )


class LabelKeys(BaseModel):
    items: Optional[List[str]] = None


class LabelValueFrom(BaseModel):
    expression: str


class LabelValues(BaseModel):
    items: Optional[List[str]] = None


class Link(BaseModel):
    name: str = Field(..., description='The name of the link, E.g. "Workflow Logs" or "Pod Logs"')
    scope: str = Field(
        ...,
        description=('"workflow", "pod", "pod-logs", "event-source-logs", "sensor-logs" or' ' "chat"'),
    )
    url: str = Field(
        ...,
        description=(
            'The URL. Can contain "${metadata.namespace}", "${metadata.name}",'
            ' "${status.startedAt}", "${status.finishedAt}" or any other element in'
            " workflow yaml, e.g."
            ' "${io.argoproj.workflow.v1alpha1.metadata.annotations.userDefinedKey}"'
        ),
    )


class LogEntry(BaseModel):
    content: Optional[str] = None
    pod_name: Optional[str] = Field(default=None, alias="podName")


class MemoizationStatus(BaseModel):
    cache_name: str = Field(
        ...,
        alias="cacheName",
        description="Cache is the name of the cache that was used",
    )
    hit: bool = Field(
        ...,
        description="Hit indicates whether this node was created from a cache entry",
    )
    key: str = Field(..., description="Key is the name of the key used for this node's cache")


class Metadata(BaseModel):
    annotations: Optional[Dict[str, str]] = None
    labels: Optional[Dict[str, str]] = None


class MetricLabel(BaseModel):
    key: str
    value: str


class Mutex(BaseModel):
    name: Optional[str] = Field(default=None, description="name of the mutex")


class MutexHolding(BaseModel):
    holder: Optional[str] = Field(
        default=None,
        description=(
            "Holder is a reference to the object which holds the Mutex. Holding"
            " Scenario:\n  1. Current workflow's NodeID which is holding the lock.\n   "
            "  e.g: ${NodeID}\nWaiting Scenario:\n  1. Current workflow or other"
            " workflow NodeID which is holding the lock.\n     e.g:"
            " ${WorkflowName}/${NodeID}"
        ),
    )
    mutex: Optional[str] = Field(
        default=None,
        description="Reference for the mutex e.g: ${namespace}/mutex/${mutexName}",
    )


class MutexStatus(BaseModel):
    holding: Optional[List[MutexHolding]] = Field(
        default=None,
        description=(
            "Holding is a list of mutexes and their respective objects that are held by"
            " mutex lock for this io.argoproj.workflow.v1alpha1."
        ),
    )
    waiting: Optional[List[MutexHolding]] = Field(
        default=None,
        description=("Waiting is a list of mutexes and their respective objects this workflow is" " waiting for."),
    )


class NodeSynchronizationStatus(BaseModel):
    waiting: Optional[str] = Field(
        default=None,
        description="Waiting is the name of the lock that this node is waiting for",
    )


class NoneStrategy(BaseModel):
    pass


class OAuth2EndpointParam(BaseModel):
    key: str = Field(..., description="Name is the header name")
    value: Optional[str] = Field(default=None, description="Value is the literal value to use for the header")


class OSSLifecycleRule(BaseModel):
    mark_deletion_after_days: Optional[int] = Field(
        default=None,
        alias="markDeletionAfterDays",
        description=("MarkDeletionAfterDays is the number of days before we delete objects in" " the bucket"),
    )
    mark_infrequent_access_after_days: Optional[int] = Field(
        default=None,
        alias="markInfrequentAccessAfterDays",
        description=(
            "MarkInfrequentAccessAfterDays is the number of days before we convert the"
            " objects in the bucket to Infrequent Access (IA) storage type"
        ),
    )


class Plugin(BaseModel):
    pass


class Prometheus(BaseModel):
    counter: Optional[Counter] = Field(default=None, description="Counter is a counter metric")
    gauge: Optional[Gauge] = Field(default=None, description="Gauge is a gauge metric")
    help: str = Field(..., description="Help is a string that describes the metric")
    histogram: Optional[Histogram] = Field(default=None, description="Histogram is a histogram metric")
    labels: Optional[List[MetricLabel]] = Field(default=None, description="Labels is a list of metric labels")
    name: str = Field(..., description="Name is the name of the metric")
    when: Optional[str] = Field(
        default=None,
        description=("When is a conditional statement that decides when to emit the metric"),
    )


class RawArtifact(BaseModel):
    data: str = Field(..., description="Data is the string contents of the artifact")


class ResubmitArchivedWorkflowRequest(BaseModel):
    memoized: Optional[bool] = None
    name: Optional[str] = None
    namespace: Optional[str] = None
    parameters: Optional[List[str]] = None
    uid: Optional[str] = None


class RetryArchivedWorkflowRequest(BaseModel):
    name: Optional[str] = None
    namespace: Optional[str] = None
    node_field_selector: Optional[str] = Field(default=None, alias="nodeFieldSelector")
    parameters: Optional[List[str]] = None
    restart_successful: Optional[bool] = Field(default=None, alias="restartSuccessful")
    uid: Optional[str] = None


class RetryNodeAntiAffinity(BaseModel):
    pass


class SemaphoreHolding(BaseModel):
    holders: Optional[List[str]] = Field(
        default=None,
        description=("Holders stores the list of current holder names in the" " io.argoproj.workflow.v1alpha1."),
    )
    semaphore: Optional[str] = Field(default=None, description="Semaphore stores the semaphore name.")


class SemaphoreStatus(BaseModel):
    holding: Optional[List[SemaphoreHolding]] = Field(
        default=None,
        description=("Holding stores the list of resource acquired synchronization lock for" " workflows."),
    )
    waiting: Optional[List[SemaphoreHolding]] = Field(
        default=None,
        description=("Waiting indicates the list of current synchronization lock holders."),
    )


class SuppliedValueFrom(BaseModel):
    pass


class SuspendTemplate(BaseModel):
    duration: Optional[str] = Field(
        default=None,
        description=(
            "Duration is the seconds to wait before automatically resuming a template."
            " Must be a string. Default unit is seconds. Could also be a Duration,"
            ' e.g.: "2m", "6h", "1d"'
        ),
    )


class SynchronizationStatus(BaseModel):
    mutex: Optional[MutexStatus] = Field(default=None, description="Mutex stores this workflow's mutex holder details")
    semaphore: Optional[SemaphoreStatus] = Field(
        default=None,
        description="Semaphore stores this workflow's Semaphore holder details",
    )


class TTLStrategy(BaseModel):
    seconds_after_completion: Optional[int] = Field(
        default=None,
        alias="secondsAfterCompletion",
        description=("SecondsAfterCompletion is the number of seconds to live after completion"),
    )
    seconds_after_failure: Optional[int] = Field(
        default=None,
        alias="secondsAfterFailure",
        description=("SecondsAfterFailure is the number of seconds to live after failure"),
    )
    seconds_after_success: Optional[int] = Field(
        default=None,
        alias="secondsAfterSuccess",
        description=("SecondsAfterSuccess is the number of seconds to live after success"),
    )


class TarStrategy(BaseModel):
    compression_level: Optional[int] = Field(
        default=None,
        alias="compressionLevel",
        description=(
            "CompressionLevel specifies the gzip compression level to use for the"
            " artifact. Defaults to gzip.DefaultCompression."
        ),
    )


class TemplateRef(BaseModel):
    cluster_scope: Optional[bool] = Field(
        default=None,
        alias="clusterScope",
        description=(
            "ClusterScope indicates the referred template is cluster scoped (i.e. a" " ClusterWorkflowTemplate)."
        ),
    )
    name: Optional[str] = Field(default=None, description="Name is the resource name of the template.")
    template: Optional[str] = Field(
        default=None,
        description="Template is the name of referred template in the resource.",
    )


class TransformationStep(BaseModel):
    expression: str = Field(..., description="Expression defines an expr expression to apply")


class Version(BaseModel):
    build_date: str = Field(..., alias="buildDate")
    compiler: str
    git_commit: str = Field(..., alias="gitCommit")
    git_tag: str = Field(..., alias="gitTag")
    git_tree_state: str = Field(..., alias="gitTreeState")
    go_version: str = Field(..., alias="goVersion")
    platform: str
    version: str


class VolumeClaimGC(BaseModel):
    strategy: Optional[str] = Field(
        default=None,
        description=('Strategy is the strategy to use. One of "OnWorkflowCompletion",' ' "OnWorkflowSuccess"'),
    )


class WorkflowDeleteResponse(BaseModel):
    pass


class WorkflowMetadata(BaseModel):
    annotations: Optional[Dict[str, str]] = None
    labels: Optional[Dict[str, str]] = None
    labels_from: Optional[Dict[str, LabelValueFrom]] = Field(default=None, alias="labelsFrom")


class WorkflowResubmitRequest(BaseModel):
    memoized: Optional[bool] = None
    name: Optional[str] = None
    namespace: Optional[str] = None
    parameters: Optional[List[str]] = None


class WorkflowResumeRequest(BaseModel):
    name: Optional[str] = None
    namespace: Optional[str] = None
    node_field_selector: Optional[str] = Field(default=None, alias="nodeFieldSelector")


class WorkflowRetryRequest(BaseModel):
    name: Optional[str] = None
    namespace: Optional[str] = None
    node_field_selector: Optional[str] = Field(default=None, alias="nodeFieldSelector")
    parameters: Optional[List[str]] = None
    restart_successful: Optional[bool] = Field(default=None, alias="restartSuccessful")


class WorkflowSetRequest(BaseModel):
    message: Optional[str] = None
    name: Optional[str] = None
    namespace: Optional[str] = None
    node_field_selector: Optional[str] = Field(default=None, alias="nodeFieldSelector")
    output_parameters: Optional[str] = Field(default=None, alias="outputParameters")
    phase: Optional[str] = None


class WorkflowStopRequest(BaseModel):
    message: Optional[str] = None
    name: Optional[str] = None
    namespace: Optional[str] = None
    node_field_selector: Optional[str] = Field(default=None, alias="nodeFieldSelector")


class WorkflowSuspendRequest(BaseModel):
    name: Optional[str] = None
    namespace: Optional[str] = None


class WorkflowTemplateDeleteResponse(BaseModel):
    pass


class WorkflowTemplateRef(BaseModel):
    cluster_scope: Optional[bool] = Field(
        default=None,
        alias="clusterScope",
        description=(
            "ClusterScope indicates the referred template is cluster scoped (i.e. a" " ClusterWorkflowTemplate)."
        ),
    )
    name: Optional[str] = Field(default=None, description="Name is the resource name of the workflow template.")


class WorkflowTerminateRequest(BaseModel):
    name: Optional[str] = None
    namespace: Optional[str] = None


class ZipStrategy(BaseModel):
    pass


class ArchiveStrategy(BaseModel):
    none: Optional[NoneStrategy] = None
    tar: Optional[TarStrategy] = None
    zip: Optional[ZipStrategy] = None


class ArtifactGC(BaseModel):
    pod_metadata: Optional[Metadata] = Field(
        default=None,
        alias="podMetadata",
        description=(
            "PodMetadata is an optional field for specifying the Labels and Annotations"
            " that should be assigned to the Pod doing the deletion"
        ),
    )
    service_account_name: Optional[str] = Field(
        default=None,
        alias="serviceAccountName",
        description=(
            "ServiceAccountName is an optional field for specifying the Service Account"
            " that should be assigned to the Pod doing the deletion"
        ),
    )
    strategy: Optional[str] = Field(default=None, description="Strategy is the strategy to use.")


class ArtifactGCStatus(BaseModel):
    artifact_results_by_node: Optional[Dict[str, ArtifactResultNodeStatus]] = Field(
        default=None,
        alias="artifactResultsByNode",
        description="ArtifactResultsByNode maps Node name to result",
    )


class ArtifactoryArtifact(BaseModel):
    password_secret: Optional[v1.SecretKeySelector] = Field(
        default=None,
        alias="passwordSecret",
        description="PasswordSecret is the secret selector to the repository password",
    )
    url: str = Field(..., description="URL of the artifact")
    username_secret: Optional[v1.SecretKeySelector] = Field(
        default=None,
        alias="usernameSecret",
        description="UsernameSecret is the secret selector to the repository username",
    )


class ArtifactoryArtifactRepository(BaseModel):
    password_secret: Optional[v1.SecretKeySelector] = Field(
        default=None,
        alias="passwordSecret",
        description="PasswordSecret is the secret selector to the repository password",
    )
    repo_url: Optional[str] = Field(
        default=None,
        alias="repoURL",
        description="RepoURL is the url for artifactory repo.",
    )
    username_secret: Optional[v1.SecretKeySelector] = Field(
        default=None,
        alias="usernameSecret",
        description="UsernameSecret is the secret selector to the repository username",
    )


class AzureArtifact(BaseModel):
    account_key_secret: Optional[v1.SecretKeySelector] = Field(
        default=None,
        alias="accountKeySecret",
        description=("AccountKeySecret is the secret selector to the Azure Blob Storage account" " access key"),
    )
    blob: str = Field(
        ...,
        description=("Blob is the blob name (i.e., path) in the container where the artifact" " resides"),
    )
    container: str = Field(..., description="Container is the container where resources will be stored")
    endpoint: str = Field(
        ...,
        description=(
            "Endpoint is the service url associated with an account. It is most likely"
            ' "https://<ACCOUNT_NAME>.blob.core.windows.net"'
        ),
    )
    use_sdk_creds: Optional[bool] = Field(
        default=None,
        alias="useSDKCreds",
        description=("UseSDKCreds tells the driver to figure out credentials based on sdk" " defaults."),
    )


class AzureArtifactRepository(BaseModel):
    account_key_secret: Optional[v1.SecretKeySelector] = Field(
        default=None,
        alias="accountKeySecret",
        description=("AccountKeySecret is the secret selector to the Azure Blob Storage account" " access key"),
    )
    blob_name_format: Optional[str] = Field(
        default=None,
        alias="blobNameFormat",
        description=(
            "BlobNameFormat is defines the format of how to store blob names. Can" " reference workflow variables"
        ),
    )
    container: str = Field(..., description="Container is the container where resources will be stored")
    endpoint: str = Field(
        ...,
        description=(
            "Endpoint is the service url associated with an account. It is most likely"
            ' "https://<ACCOUNT_NAME>.blob.core.windows.net"'
        ),
    )
    use_sdk_creds: Optional[bool] = Field(
        default=None,
        alias="useSDKCreds",
        description=("UseSDKCreds tells the driver to figure out credentials based on sdk" " defaults."),
    )


class Backoff(BaseModel):
    duration: Optional[str] = Field(
        default=None,
        description=(
            "Duration is the amount to back off. Default unit is seconds, but could"
            ' also be a duration (e.g. "2m", "1h")'
        ),
    )
    factor: Optional[intstr.IntOrString] = Field(
        default=None,
        description=("Factor is a factor to multiply the base duration after each failed retry"),
    )
    max_duration: Optional[str] = Field(
        default=None,
        alias="maxDuration",
        description=("MaxDuration is the maximum amount of time allowed for the backoff strategy"),
    )


class BasicAuth(BaseModel):
    password_secret: Optional[v1.SecretKeySelector] = Field(
        default=None,
        alias="passwordSecret",
        description="PasswordSecret is the secret selector to the repository password",
    )
    username_secret: Optional[v1.SecretKeySelector] = Field(
        default=None,
        alias="usernameSecret",
        description="UsernameSecret is the secret selector to the repository username",
    )


class Cache(BaseModel):
    config_map: v1.ConfigMapKeySelector = Field(
        ..., alias="configMap", description="ConfigMap sets a ConfigMap-based cache"
    )


class ClientCertAuth(BaseModel):
    client_cert_secret: Optional[v1.SecretKeySelector] = Field(default=None, alias="clientCertSecret")
    client_key_secret: Optional[v1.SecretKeySelector] = Field(default=None, alias="clientKeySecret")


class ContainerSetRetryStrategy(BaseModel):
    duration: Optional[str] = Field(
        default=None,
        description=(
            'Duration is the time between each retry, examples values are "300ms", "1s"'
            ' or "5m". Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".'
        ),
    )
    retries: intstr.IntOrString = Field(..., description="Nbr of retries")


class CronWorkflowStatus(BaseModel):
    active: Optional[List[v1.ObjectReference]] = Field(
        default=None,
        description=("Active is a list of active workflows stemming from this CronWorkflow"),
    )
    conditions: Optional[List[Condition]] = Field(
        default=None,
        description="Conditions is a list of conditions the CronWorkflow may have",
    )
    last_scheduled_time: Optional[v1_1.Time] = Field(
        default=None,
        alias="lastScheduledTime",
        description="LastScheduleTime is the last time the CronWorkflow was scheduled",
    )


class GCSArtifact(BaseModel):
    bucket: Optional[str] = Field(default=None, description="Bucket is the name of the bucket")
    key: str = Field(..., description="Key is the path in the bucket where the artifact resides")
    service_account_key_secret: Optional[v1.SecretKeySelector] = Field(
        default=None,
        alias="serviceAccountKeySecret",
        description=("ServiceAccountKeySecret is the secret selector to the bucket's service" " account key"),
    )


class GCSArtifactRepository(BaseModel):
    bucket: Optional[str] = Field(default=None, description="Bucket is the name of the bucket")
    key_format: Optional[str] = Field(
        default=None,
        alias="keyFormat",
        description=("KeyFormat is defines the format of how to store keys. Can reference" " workflow variables"),
    )
    service_account_key_secret: Optional[v1.SecretKeySelector] = Field(
        default=None,
        alias="serviceAccountKeySecret",
        description=("ServiceAccountKeySecret is the secret selector to the bucket's service" " account key"),
    )


class GitArtifact(BaseModel):
    branch: Optional[str] = Field(
        default=None,
        description="Branch is the branch to fetch when `SingleBranch` is enabled",
    )
    depth: Optional[int] = Field(
        default=None,
        description=(
            "Depth specifies clones/fetches should be shallow and include the given"
            " number of commits from the branch tip"
        ),
    )
    disable_submodules: Optional[bool] = Field(
        default=None,
        alias="disableSubmodules",
        description="DisableSubmodules disables submodules during git clone",
    )
    fetch: Optional[List[str]] = Field(
        default=None,
        description=("Fetch specifies a number of refs that should be fetched before checkout"),
    )
    insecure_ignore_host_key: Optional[bool] = Field(
        default=None,
        alias="insecureIgnoreHostKey",
        description=("InsecureIgnoreHostKey disables SSH strict host key checking during git" " clone"),
    )
    password_secret: Optional[v1.SecretKeySelector] = Field(
        default=None,
        alias="passwordSecret",
        description="PasswordSecret is the secret selector to the repository password",
    )
    repo: str = Field(..., description="Repo is the git repository")
    revision: Optional[str] = Field(default=None, description="Revision is the git commit, tag, branch to checkout")
    single_branch: Optional[bool] = Field(
        default=None,
        alias="singleBranch",
        description=("SingleBranch enables single branch clone, using the `branch` parameter"),
    )
    ssh_private_key_secret: Optional[v1.SecretKeySelector] = Field(
        default=None,
        alias="sshPrivateKeySecret",
        description=("SSHPrivateKeySecret is the secret selector to the repository ssh" " private key"),
    )
    username_secret: Optional[v1.SecretKeySelector] = Field(
        default=None,
        alias="usernameSecret",
        description="UsernameSecret is the secret selector to the repository username",
    )


class HDFSArtifact(BaseModel):
    addresses: Optional[List[str]] = Field(
        default=None, description="Addresses is accessible addresses of HDFS name nodes"
    )
    force: Optional[bool] = Field(default=None, description="Force copies a file forcibly even if it exists")
    hdfs_user: Optional[str] = Field(
        default=None,
        alias="hdfsUser",
        description=(
            "HDFSUser is the user to access HDFS file system. It is ignored if either" " ccache or keytab is used."
        ),
    )
    krb_c_cache_secret: Optional[v1.SecretKeySelector] = Field(
        default=None,
        alias="krbCCacheSecret",
        description=(
            "KrbCCacheSecret is the secret selector for Kerberos ccache Either ccache"
            " or keytab can be set to use Kerberos."
        ),
    )
    krb_config_config_map: Optional[v1.ConfigMapKeySelector] = Field(
        default=None,
        alias="krbConfigConfigMap",
        description=(
            "KrbConfig is the configmap selector for Kerberos config as string It must"
            " be set if either ccache or keytab is used."
        ),
    )
    krb_keytab_secret: Optional[v1.SecretKeySelector] = Field(
        default=None,
        alias="krbKeytabSecret",
        description=(
            "KrbKeytabSecret is the secret selector for Kerberos keytab Either ccache"
            " or keytab can be set to use Kerberos."
        ),
    )
    krb_realm: Optional[str] = Field(
        default=None,
        alias="krbRealm",
        description=("KrbRealm is the Kerberos realm used with Kerberos keytab It must be set if" " keytab is used."),
    )
    krb_service_principal_name: Optional[str] = Field(
        default=None,
        alias="krbServicePrincipalName",
        description=(
            "KrbServicePrincipalName is the principal name of Kerberos service It must"
            " be set if either ccache or keytab is used."
        ),
    )
    krb_username: Optional[str] = Field(
        default=None,
        alias="krbUsername",
        description=(
            "KrbUsername is the Kerberos username used with Kerberos keytab It must be" " set if keytab is used."
        ),
    )
    path: str = Field(..., description="Path is a file path in HDFS")


class HDFSArtifactRepository(BaseModel):
    addresses: Optional[List[str]] = Field(
        default=None, description="Addresses is accessible addresses of HDFS name nodes"
    )
    force: Optional[bool] = Field(default=None, description="Force copies a file forcibly even if it exists")
    hdfs_user: Optional[str] = Field(
        default=None,
        alias="hdfsUser",
        description=(
            "HDFSUser is the user to access HDFS file system. It is ignored if either" " ccache or keytab is used."
        ),
    )
    krb_c_cache_secret: Optional[v1.SecretKeySelector] = Field(
        default=None,
        alias="krbCCacheSecret",
        description=(
            "KrbCCacheSecret is the secret selector for Kerberos ccache Either ccache"
            " or keytab can be set to use Kerberos."
        ),
    )
    krb_config_config_map: Optional[v1.ConfigMapKeySelector] = Field(
        default=None,
        alias="krbConfigConfigMap",
        description=(
            "KrbConfig is the configmap selector for Kerberos config as string It must"
            " be set if either ccache or keytab is used."
        ),
    )
    krb_keytab_secret: Optional[v1.SecretKeySelector] = Field(
        default=None,
        alias="krbKeytabSecret",
        description=(
            "KrbKeytabSecret is the secret selector for Kerberos keytab Either ccache"
            " or keytab can be set to use Kerberos."
        ),
    )
    krb_realm: Optional[str] = Field(
        default=None,
        alias="krbRealm",
        description=("KrbRealm is the Kerberos realm used with Kerberos keytab It must be set if" " keytab is used."),
    )
    krb_service_principal_name: Optional[str] = Field(
        default=None,
        alias="krbServicePrincipalName",
        description=(
            "KrbServicePrincipalName is the principal name of Kerberos service It must"
            " be set if either ccache or keytab is used."
        ),
    )
    krb_username: Optional[str] = Field(
        default=None,
        alias="krbUsername",
        description=(
            "KrbUsername is the Kerberos username used with Kerberos keytab It must be" " set if keytab is used."
        ),
    )
    path_format: Optional[str] = Field(
        default=None,
        alias="pathFormat",
        description=("PathFormat is defines the format of path to store a file. Can reference" " workflow variables"),
    )


class HTTPHeaderSource(BaseModel):
    secret_key_ref: Optional[v1.SecretKeySelector] = Field(default=None, alias="secretKeyRef")


class InfoResponse(BaseModel):
    links: Optional[List[Link]] = None
    managed_namespace: Optional[str] = Field(default=None, alias="managedNamespace")
    modals: Optional[Dict[str, bool]] = Field(default=None, title="which modals to show")
    nav_color: Optional[str] = Field(default=None, alias="navColor")


class Memoize(BaseModel):
    cache: Cache = Field(..., description="Cache sets and configures the kind of cache")
    key: str = Field(..., description="Key is the key to use as the caching key")
    max_age: str = Field(
        ...,
        alias="maxAge",
        description=(
            'MaxAge is the maximum age (e.g. "180s", "24h") of an entry that is still'
            " considered valid. If an entry is older than the MaxAge, it will be"
            " ignored."
        ),
    )


class Metrics(BaseModel):
    prometheus: Optional[List[Prometheus]] = Field(
        default=None,
        description="Prometheus is a list of prometheus metrics to be emitted",
    )


class OAuth2Auth(BaseModel):
    client_id_secret: Optional[v1.SecretKeySelector] = Field(default=None, alias="clientIDSecret")
    client_secret_secret: Optional[v1.SecretKeySelector] = Field(default=None, alias="clientSecretSecret")
    endpoint_params: Optional[List[OAuth2EndpointParam]] = Field(default=None, alias="endpointParams")
    scopes: Optional[List[str]] = None
    token_url_secret: Optional[v1.SecretKeySelector] = Field(default=None, alias="tokenURLSecret")


class OSSArtifact(BaseModel):
    access_key_secret: Optional[v1.SecretKeySelector] = Field(
        default=None,
        alias="accessKeySecret",
        description="AccessKeySecret is the secret selector to the bucket's access key",
    )
    bucket: Optional[str] = Field(default=None, description="Bucket is the name of the bucket")
    create_bucket_if_not_present: Optional[bool] = Field(
        default=None,
        alias="createBucketIfNotPresent",
        description=(
            "CreateBucketIfNotPresent tells the driver to attempt to create the OSS"
            " bucket for output artifacts, if it doesn't exist"
        ),
    )
    endpoint: Optional[str] = Field(default=None, description="Endpoint is the hostname of the bucket endpoint")
    key: str = Field(..., description="Key is the path in the bucket where the artifact resides")
    lifecycle_rule: Optional[OSSLifecycleRule] = Field(
        default=None,
        alias="lifecycleRule",
        description="LifecycleRule specifies how to manage bucket's lifecycle",
    )
    secret_key_secret: Optional[v1.SecretKeySelector] = Field(
        default=None,
        alias="secretKeySecret",
        description="SecretKeySecret is the secret selector to the bucket's secret key",
    )
    security_token: Optional[str] = Field(
        default=None,
        alias="securityToken",
        description=(
            "SecurityToken is the user's temporary security token. For more details,"
            " check out: https://www.alibabacloud.com/help/doc-detail/100624.htm"
        ),
    )


class OSSArtifactRepository(BaseModel):
    access_key_secret: Optional[v1.SecretKeySelector] = Field(
        default=None,
        alias="accessKeySecret",
        description="AccessKeySecret is the secret selector to the bucket's access key",
    )
    bucket: Optional[str] = Field(default=None, description="Bucket is the name of the bucket")
    create_bucket_if_not_present: Optional[bool] = Field(
        default=None,
        alias="createBucketIfNotPresent",
        description=(
            "CreateBucketIfNotPresent tells the driver to attempt to create the OSS"
            " bucket for output artifacts, if it doesn't exist"
        ),
    )
    endpoint: Optional[str] = Field(default=None, description="Endpoint is the hostname of the bucket endpoint")
    key_format: Optional[str] = Field(
        default=None,
        alias="keyFormat",
        description=("KeyFormat is defines the format of how to store keys. Can reference" " workflow variables"),
    )
    lifecycle_rule: Optional[OSSLifecycleRule] = Field(
        default=None,
        alias="lifecycleRule",
        description="LifecycleRule specifies how to manage bucket's lifecycle",
    )
    secret_key_secret: Optional[v1.SecretKeySelector] = Field(
        default=None,
        alias="secretKeySecret",
        description="SecretKeySecret is the secret selector to the bucket's secret key",
    )
    security_token: Optional[str] = Field(
        default=None,
        alias="securityToken",
        description=(
            "SecurityToken is the user's temporary security token. For more details,"
            " check out: https://www.alibabacloud.com/help/doc-detail/100624.htm"
        ),
    )


class RetryAffinity(BaseModel):
    node_anti_affinity: Optional[RetryNodeAntiAffinity] = Field(default=None, alias="nodeAntiAffinity")


class RetryStrategy(BaseModel):
    affinity: Optional[RetryAffinity] = Field(
        default=None,
        description="Affinity prevents running workflow's step on the same host",
    )
    backoff: Optional[Backoff] = Field(default=None, description="Backoff is a backoff strategy")
    expression: Optional[str] = Field(
        default=None,
        description=(
            "Expression is a condition expression for when a node will be retried. If"
            " it evaluates to false, the node will not be retried and the retry"
            " strategy will be ignored"
        ),
    )
    limit: Optional[intstr.IntOrString] = Field(
        default=None,
        description=(
            "Limit is the maximum number of retry attempts when retrying a container."
            " It does not include the original container; the maximum number of total"
            " attempts will be `limit + 1`."
        ),
    )
    retry_policy: Optional[str] = Field(
        default=None,
        alias="retryPolicy",
        description=("RetryPolicy is a policy of NodePhase statuses that will be retried"),
    )


class S3EncryptionOptions(BaseModel):
    enable_encryption: Optional[bool] = Field(
        default=None,
        alias="enableEncryption",
        description=(
            "EnableEncryption tells the driver to encrypt objects if set to true. If"
            " kmsKeyId and serverSideCustomerKeySecret are not set, SSE-S3 will be used"
        ),
    )
    kms_encryption_context: Optional[str] = Field(
        default=None,
        alias="kmsEncryptionContext",
        description=(
            "KmsEncryptionContext is a json blob that contains an encryption context."
            " See https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context"
            " for more information"
        ),
    )
    kms_key_id: Optional[str] = Field(
        default=None,
        alias="kmsKeyId",
        description=("KMSKeyId tells the driver to encrypt the object using the specified KMS" " Key."),
    )
    server_side_customer_key_secret: Optional[v1.SecretKeySelector] = Field(
        default=None,
        alias="serverSideCustomerKeySecret",
        description=(
            "ServerSideCustomerKeySecret tells the driver to encrypt the output"
            " artifacts using SSE-C with the specified secret."
        ),
    )


class SemaphoreRef(BaseModel):
    config_map_key_ref: Optional[v1.ConfigMapKeySelector] = Field(
        default=None,
        alias="configMapKeyRef",
        description="ConfigMapKeyRef is configmap selector for Semaphore configuration",
    )


class Sequence(BaseModel):
    count: Optional[intstr.IntOrString] = Field(
        default=None,
        description=("Count is number of elements in the sequence (default: 0). Not to be used" " with end"),
    )
    end: Optional[intstr.IntOrString] = Field(
        default=None,
        description=("Number at which to end the sequence (default: 0). Not to be used with" " Count"),
    )
    format: Optional[str] = Field(
        default=None,
        description=("Format is a printf format string to format the value in the sequence"),
    )
    start: Optional[intstr.IntOrString] = Field(
        default=None, description="Number at which to start the sequence (default: 0)"
    )


class SubmitOpts(BaseModel):
    annotations: Optional[str] = Field(default=None, description="Annotations adds to metadata.labels")
    dry_run: Optional[bool] = Field(
        default=None,
        alias="dryRun",
        description=(
            "DryRun validates the workflow on the client-side without creating it. This"
            " option is not supported in API"
        ),
    )
    entry_point: Optional[str] = Field(
        default=None,
        alias="entryPoint",
        description="Entrypoint overrides spec.entrypoint",
    )
    generate_name: Optional[str] = Field(
        default=None,
        alias="generateName",
        description="GenerateName overrides metadata.generateName",
    )
    labels: Optional[str] = Field(default=None, description="Labels adds to metadata.labels")
    name: Optional[str] = Field(default=None, description="Name overrides metadata.name")
    owner_reference: Optional[v1_1.OwnerReference] = Field(
        default=None,
        alias="ownerReference",
        description="OwnerReference creates a metadata.ownerReference",
    )
    parameters: Optional[List[str]] = Field(default=None, description="Parameters passes input parameters to workflow")
    pod_priority_class_name: Optional[str] = Field(
        default=None,
        alias="podPriorityClassName",
        description="Set the podPriorityClassName of the workflow",
    )
    priority: Optional[int] = Field(
        default=None,
        description=(
            "Priority is used if controller is configured to process limited number of"
            " workflows in parallel, higher priority workflows are processed first."
        ),
    )
    server_dry_run: Optional[bool] = Field(
        default=None,
        alias="serverDryRun",
        description=("ServerDryRun validates the workflow on the server-side without creating it"),
    )
    service_account: Optional[str] = Field(
        default=None,
        alias="serviceAccount",
        description=("ServiceAccount runs all pods in the workflow using specified" " ServiceAccount."),
    )


class Synchronization(BaseModel):
    mutex: Optional[Mutex] = Field(default=None, description="Mutex holds the Mutex lock details")
    semaphore: Optional[SemaphoreRef] = Field(default=None, description="Semaphore holds the Semaphore configuration")


class ValueFrom(BaseModel):
    config_map_key_ref: Optional[v1.ConfigMapKeySelector] = Field(
        default=None,
        alias="configMapKeyRef",
        description=("ConfigMapKeyRef is configmap selector for input parameter configuration"),
    )
    default: Optional[str] = Field(
        default=None,
        description=(
            "Default specifies a value to be used if retrieving the value from the" " specified source fails"
        ),
    )
    event: Optional[str] = Field(
        default=None,
        description=(
            "Selector (https://github.com/antonmedv/expr) that is evaluated against the"
            " event to get the value of the parameter. E.g. `payload.message`"
        ),
    )
    expression: Optional[str] = Field(
        default=None,
        description=("Expression, if defined, is evaluated to specify the value for the" " parameter"),
    )
    jq_filter: Optional[str] = Field(
        default=None,
        alias="jqFilter",
        description=("JQFilter expression against the resource object in resource templates"),
    )
    json_path: Optional[str] = Field(
        default=None,
        alias="jsonPath",
        description=("JSONPath of a resource to retrieve an output parameter value from in" " resource templates"),
    )
    parameter: Optional[str] = Field(
        default=None,
        description=(
            "Parameter reference to a step or dag task in which to retrieve an output"
            " parameter value from (e.g. '{{steps.mystep.outputs.myparam}}')"
        ),
    )
    path: Optional[str] = Field(
        default=None,
        description=("Path in the container to retrieve an output parameter value from in" " container templates"),
    )
    supplied: Optional[SuppliedValueFrom] = Field(
        default=None,
        description=("Supplied value to be filled in directly, either through the CLI, API, etc."),
    )


class WorkflowSubmitRequest(BaseModel):
    namespace: Optional[str] = None
    resource_kind: Optional[str] = Field(default=None, alias="resourceKind")
    resource_name: Optional[str] = Field(default=None, alias="resourceName")
    submit_options: Optional[SubmitOpts] = Field(default=None, alias="submitOptions")


class HTTPAuth(BaseModel):
    basic_auth: Optional[BasicAuth] = Field(default=None, alias="basicAuth")
    client_cert: Optional[ClientCertAuth] = Field(default=None, alias="clientCert")
    oauth2: Optional[OAuth2Auth] = None


class HTTPHeader(BaseModel):
    name: str
    value: Optional[str] = None
    value_from: Optional[HTTPHeaderSource] = Field(default=None, alias="valueFrom")


class Parameter(BaseModel):
    default: Optional[str] = Field(
        default=None,
        description=("Default is the default value to use for an input parameter if a value was" " not supplied"),
    )
    description: Optional[str] = Field(default=None, description="Description is the parameter description")
    enum: Optional[List[str]] = Field(
        default=None,
        description=("Enum holds a list of string values to choose from, for the actual value of" " the parameter"),
    )
    global_name: Optional[str] = Field(
        default=None,
        alias="globalName",
        description=(
            "GlobalName exports an output parameter to the global scope, making it"
            " available as '{{io.argoproj.workflow.v1alpha1.outputs.parameters.XXXX}}"
            " and in workflow.status.outputs.parameters"
        ),
    )
    name: str = Field(..., description="Name is the parameter name")
    value: Optional[str] = Field(
        default=None,
        description=(
            "Value is the literal value to use for the parameter. If specified in the"
            " context of an input parameter, the value takes precedence over any passed"
            " values"
        ),
    )
    value_from: Optional[ValueFrom] = Field(
        default=None,
        alias="valueFrom",
        description="ValueFrom is the source for the output parameter's value",
    )


class PodGC(BaseModel):
    label_selector: Optional[v1_1.LabelSelector] = Field(
        default=None,
        alias="labelSelector",
        description=(
            "LabelSelector is the label selector to check if the pods match the labels"
            " before being added to the pod GC queue."
        ),
    )
    strategy: Optional[str] = Field(
        default=None,
        description=(
            'Strategy is the strategy to use. One of "OnPodCompletion", "OnPodSuccess",'
            ' "OnWorkflowCompletion", "OnWorkflowSuccess"'
        ),
    )


class S3Artifact(BaseModel):
    access_key_secret: Optional[v1.SecretKeySelector] = Field(
        default=None,
        alias="accessKeySecret",
        description="AccessKeySecret is the secret selector to the bucket's access key",
    )
    bucket: Optional[str] = Field(default=None, description="Bucket is the name of the bucket")
    create_bucket_if_not_present: Optional[CreateS3BucketOptions] = Field(
        default=None,
        alias="createBucketIfNotPresent",
        description=(
            "CreateBucketIfNotPresent tells the driver to attempt to create the S3"
            " bucket for output artifacts, if it doesn't exist. Setting Enabled"
            " Encryption will apply either SSE-S3 to the bucket if KmsKeyId is not set"
            " or SSE-KMS if it is."
        ),
    )
    encryption_options: Optional[S3EncryptionOptions] = Field(default=None, alias="encryptionOptions")
    endpoint: Optional[str] = Field(default=None, description="Endpoint is the hostname of the bucket endpoint")
    insecure: Optional[bool] = Field(default=None, description="Insecure will connect to the service with TLS")
    key: Optional[str] = Field(
        default=None,
        description="Key is the key in the bucket where the artifact resides",
    )
    region: Optional[str] = Field(default=None, description="Region contains the optional bucket region")
    role_arn: Optional[str] = Field(
        default=None,
        alias="roleARN",
        description="RoleARN is the Amazon Resource Name (ARN) of the role to assume.",
    )
    secret_key_secret: Optional[v1.SecretKeySelector] = Field(
        default=None,
        alias="secretKeySecret",
        description="SecretKeySecret is the secret selector to the bucket's secret key",
    )
    use_sdk_creds: Optional[bool] = Field(
        default=None,
        alias="useSDKCreds",
        description=("UseSDKCreds tells the driver to figure out credentials based on sdk" " defaults."),
    )


class S3ArtifactRepository(BaseModel):
    access_key_secret: Optional[v1.SecretKeySelector] = Field(
        default=None,
        alias="accessKeySecret",
        description="AccessKeySecret is the secret selector to the bucket's access key",
    )
    bucket: Optional[str] = Field(default=None, description="Bucket is the name of the bucket")
    create_bucket_if_not_present: Optional[CreateS3BucketOptions] = Field(
        default=None,
        alias="createBucketIfNotPresent",
        description=(
            "CreateBucketIfNotPresent tells the driver to attempt to create the S3"
            " bucket for output artifacts, if it doesn't exist. Setting Enabled"
            " Encryption will apply either SSE-S3 to the bucket if KmsKeyId is not set"
            " or SSE-KMS if it is."
        ),
    )
    encryption_options: Optional[S3EncryptionOptions] = Field(default=None, alias="encryptionOptions")
    endpoint: Optional[str] = Field(default=None, description="Endpoint is the hostname of the bucket endpoint")
    insecure: Optional[bool] = Field(default=None, description="Insecure will connect to the service with TLS")
    key_format: Optional[str] = Field(
        default=None,
        alias="keyFormat",
        description=("KeyFormat is defines the format of how to store keys. Can reference" " workflow variables"),
    )
    key_prefix: Optional[str] = Field(
        default=None,
        alias="keyPrefix",
        description=(
            "KeyPrefix is prefix used as part of the bucket key in which the controller"
            " will store artifacts. DEPRECATED. Use KeyFormat instead"
        ),
    )
    region: Optional[str] = Field(default=None, description="Region contains the optional bucket region")
    role_arn: Optional[str] = Field(
        default=None,
        alias="roleARN",
        description="RoleARN is the Amazon Resource Name (ARN) of the role to assume.",
    )
    secret_key_secret: Optional[v1.SecretKeySelector] = Field(
        default=None,
        alias="secretKeySecret",
        description="SecretKeySecret is the secret selector to the bucket's secret key",
    )
    use_sdk_creds: Optional[bool] = Field(
        default=None,
        alias="useSDKCreds",
        description=("UseSDKCreds tells the driver to figure out credentials based on sdk" " defaults."),
    )


class ArtifactRepository(BaseModel):
    archive_logs: Optional[bool] = Field(
        default=None,
        alias="archiveLogs",
        description="ArchiveLogs enables log archiving",
    )
    artifactory: Optional[ArtifactoryArtifactRepository] = Field(
        default=None, description="Artifactory stores artifacts to JFrog Artifactory"
    )
    azure: Optional[AzureArtifactRepository] = Field(
        default=None, description="Azure stores artifact in an Azure Storage account"
    )
    gcs: Optional[GCSArtifactRepository] = Field(default=None, description="GCS stores artifact in a GCS object store")
    hdfs: Optional[HDFSArtifactRepository] = Field(default=None, description="HDFS stores artifacts in HDFS")
    oss: Optional[OSSArtifactRepository] = Field(
        default=None, description="OSS stores artifact in a OSS-compliant object store"
    )
    s3: Optional[S3ArtifactRepository] = Field(
        default=None, description="S3 stores artifact in a S3-compliant object store"
    )


class ArtifactRepositoryRefStatus(BaseModel):
    artifact_repository: Optional[ArtifactRepository] = Field(
        default=None,
        alias="artifactRepository",
        description=("The repository the workflow will use. This maybe empty before v3.1."),
    )
    config_map: Optional[str] = Field(
        default=None,
        alias="configMap",
        description='The name of the config map. Defaults to "artifact-repositories".',
    )
    default: Optional[bool] = Field(
        default=None,
        description=("If this ref represents the default artifact repository, rather than a" " config map."),
    )
    key: Optional[str] = Field(
        default=None,
        description=(
            "The config map key. Defaults to the value of the"
            ' "workflows.argoproj.io/default-artifact-repository" annotation.'
        ),
    )
    namespace: Optional[str] = Field(
        default=None,
        description=(
            "The namespace of the config map. Defaults to the workflow's namespace, or"
            " the controller's namespace (if found)."
        ),
    )


class HTTP(BaseModel):
    body: Optional[str] = Field(default=None, description="Body is content of the HTTP Request")
    body_from: Optional[HTTPBodySource] = Field(
        default=None,
        alias="bodyFrom",
        description="BodyFrom is  content of the HTTP Request as Bytes",
    )
    headers: Optional[List[HTTPHeader]] = Field(
        default=None,
        description=("Headers are an optional list of headers to send with HTTP requests"),
    )
    insecure_skip_verify: Optional[bool] = Field(
        default=None,
        alias="insecureSkipVerify",
        description=(
            "InsecureSkipVerify is a bool when if set to true will skip TLS" " verification for the HTTP client"
        ),
    )
    method: Optional[str] = Field(default=None, description="Method is HTTP methods for HTTP Request")
    success_condition: Optional[str] = Field(
        default=None,
        alias="successCondition",
        description=("SuccessCondition is an expression if evaluated to true is considered" " successful"),
    )
    timeout_seconds: Optional[int] = Field(
        default=None,
        alias="timeoutSeconds",
        description=("TimeoutSeconds is request timeout for HTTP Request. Default is 30 seconds"),
    )
    url: str = Field(..., description="URL of the HTTP Request")


class HTTPArtifact(BaseModel):
    auth: Optional[HTTPAuth] = Field(default=None, description="Auth contains information for client authentication")
    headers: Optional[List[Header]] = Field(
        default=None,
        description=("Headers are an optional list of headers to send with HTTP requests for" " artifacts"),
    )
    url: str = Field(..., description="URL of the artifact")


class Artifact(BaseModel):
    archive: Optional[ArchiveStrategy] = Field(
        default=None,
        description=("Archive controls how the artifact will be saved to the artifact" " repository."),
    )
    archive_logs: Optional[bool] = Field(
        default=None,
        alias="archiveLogs",
        description="ArchiveLogs indicates if the container logs should be archived",
    )
    artifact_gc: Optional[ArtifactGC] = Field(
        default=None,
        alias="artifactGC",
        description=(
            "ArtifactGC describes the strategy to use when to deleting an artifact from"
            " completed or deleted workflows"
        ),
    )
    artifactory: Optional[ArtifactoryArtifact] = Field(
        default=None,
        description="Artifactory contains artifactory artifact location details",
    )
    azure: Optional[AzureArtifact] = Field(
        default=None,
        description="Azure contains Azure Storage artifact location details",
    )
    deleted: Optional[bool] = Field(default=None, description="Has this been deleted?")
    from_: Optional[str] = Field(
        default=None,
        alias="from",
        description=("From allows an artifact to reference an artifact from a previous step"),
    )
    from_expression: Optional[str] = Field(
        default=None,
        alias="fromExpression",
        description=("FromExpression, if defined, is evaluated to specify the value for the" " artifact"),
    )
    gcs: Optional[GCSArtifact] = Field(default=None, description="GCS contains GCS artifact location details")
    git: Optional[GitArtifact] = Field(default=None, description="Git contains git artifact location details")
    global_name: Optional[str] = Field(
        default=None,
        alias="globalName",
        description=(
            "GlobalName exports an output artifact to the global scope, making it"
            " available as '{{io.argoproj.workflow.v1alpha1.outputs.artifacts.XXXX}}"
            " and in workflow.status.outputs.artifacts"
        ),
    )
    hdfs: Optional[HDFSArtifact] = Field(default=None, description="HDFS contains HDFS artifact location details")
    http: Optional[HTTPArtifact] = Field(default=None, description="HTTP contains HTTP artifact location details")
    mode: Optional[int] = Field(
        default=None,
        description=(
            "mode bits to use on this file, must be a value between 0 and 0777 set when" " loading input artifacts."
        ),
    )
    name: str = Field(
        ...,
        description=("name of the artifact. must be unique within a template's inputs/outputs."),
    )
    optional: Optional[bool] = Field(
        default=None,
        description="Make Artifacts optional, if Artifacts doesn't generate or exist",
    )
    oss: Optional[OSSArtifact] = Field(default=None, description="OSS contains OSS artifact location details")
    path: Optional[str] = Field(default=None, description="Path is the container path to the artifact")
    raw: Optional[RawArtifact] = Field(default=None, description="Raw contains raw artifact location details")
    recurse_mode: Optional[bool] = Field(
        default=None,
        alias="recurseMode",
        description=("If mode is set, apply the permission recursively into the artifact if it" " is a folder"),
    )
    s3: Optional[S3Artifact] = Field(default=None, description="S3 contains S3 artifact location details")
    sub_path: Optional[str] = Field(
        default=None,
        alias="subPath",
        description=("SubPath allows an artifact to be sourced from a subpath within the" " specified source"),
    )


class ArtifactLocation(BaseModel):
    archive_logs: Optional[bool] = Field(
        default=None,
        alias="archiveLogs",
        description="ArchiveLogs indicates if the container logs should be archived",
    )
    artifactory: Optional[ArtifactoryArtifact] = Field(
        default=None,
        description="Artifactory contains artifactory artifact location details",
    )
    azure: Optional[AzureArtifact] = Field(
        default=None,
        description="Azure contains Azure Storage artifact location details",
    )
    gcs: Optional[GCSArtifact] = Field(default=None, description="GCS contains GCS artifact location details")
    git: Optional[GitArtifact] = Field(default=None, description="Git contains git artifact location details")
    hdfs: Optional[HDFSArtifact] = Field(default=None, description="HDFS contains HDFS artifact location details")
    http: Optional[HTTPArtifact] = Field(default=None, description="HTTP contains HTTP artifact location details")
    oss: Optional[OSSArtifact] = Field(default=None, description="OSS contains OSS artifact location details")
    raw: Optional[RawArtifact] = Field(default=None, description="Raw contains raw artifact location details")
    s3: Optional[S3Artifact] = Field(default=None, description="S3 contains S3 artifact location details")


class ArtifactNodeSpec(BaseModel):
    archive_location: Optional[ArtifactLocation] = Field(
        default=None,
        alias="archiveLocation",
        description=("ArchiveLocation is the template-level Artifact location specification"),
    )
    artifacts: Optional[Dict[str, Artifact]] = Field(
        default=None, description="Artifacts maps artifact name to Artifact description"
    )


class ArtifactPaths(BaseModel):
    archive: Optional[ArchiveStrategy] = Field(
        default=None,
        description=("Archive controls how the artifact will be saved to the artifact" " repository."),
    )
    archive_logs: Optional[bool] = Field(
        default=None,
        alias="archiveLogs",
        description="ArchiveLogs indicates if the container logs should be archived",
    )
    artifact_gc: Optional[ArtifactGC] = Field(
        default=None,
        alias="artifactGC",
        description=(
            "ArtifactGC describes the strategy to use when to deleting an artifact from"
            " completed or deleted workflows"
        ),
    )
    artifactory: Optional[ArtifactoryArtifact] = Field(
        default=None,
        description="Artifactory contains artifactory artifact location details",
    )
    azure: Optional[AzureArtifact] = Field(
        default=None,
        description="Azure contains Azure Storage artifact location details",
    )
    deleted: Optional[bool] = Field(default=None, description="Has this been deleted?")
    from_: Optional[str] = Field(
        default=None,
        alias="from",
        description=("From allows an artifact to reference an artifact from a previous step"),
    )
    from_expression: Optional[str] = Field(
        default=None,
        alias="fromExpression",
        description=("FromExpression, if defined, is evaluated to specify the value for the" " artifact"),
    )
    gcs: Optional[GCSArtifact] = Field(default=None, description="GCS contains GCS artifact location details")
    git: Optional[GitArtifact] = Field(default=None, description="Git contains git artifact location details")
    global_name: Optional[str] = Field(
        default=None,
        alias="globalName",
        description=(
            "GlobalName exports an output artifact to the global scope, making it"
            " available as '{{io.argoproj.workflow.v1alpha1.outputs.artifacts.XXXX}}"
            " and in workflow.status.outputs.artifacts"
        ),
    )
    hdfs: Optional[HDFSArtifact] = Field(default=None, description="HDFS contains HDFS artifact location details")
    http: Optional[HTTPArtifact] = Field(default=None, description="HTTP contains HTTP artifact location details")
    mode: Optional[int] = Field(
        default=None,
        description=(
            "mode bits to use on this file, must be a value between 0 and 0777 set when" " loading input artifacts."
        ),
    )
    name: str = Field(
        ...,
        description=("name of the artifact. must be unique within a template's inputs/outputs."),
    )
    optional: Optional[bool] = Field(
        default=None,
        description="Make Artifacts optional, if Artifacts doesn't generate or exist",
    )
    oss: Optional[OSSArtifact] = Field(default=None, description="OSS contains OSS artifact location details")
    path: Optional[str] = Field(default=None, description="Path is the container path to the artifact")
    raw: Optional[RawArtifact] = Field(default=None, description="Raw contains raw artifact location details")
    recurse_mode: Optional[bool] = Field(
        default=None,
        alias="recurseMode",
        description=("If mode is set, apply the permission recursively into the artifact if it" " is a folder"),
    )
    s3: Optional[S3Artifact] = Field(default=None, description="S3 contains S3 artifact location details")
    sub_path: Optional[str] = Field(
        default=None,
        alias="subPath",
        description=("SubPath allows an artifact to be sourced from a subpath within the" " specified source"),
    )


class ContainerNode(BaseModel):
    args: Optional[List[str]] = Field(
        default=None,
        description=(
            "Arguments to the entrypoint. The container image's CMD is used if this is"
            " not provided. Variable references $(VAR_NAME) are expanded using the"
            " container's environment. If a variable cannot be resolved, the reference"
            " in the input string will be unchanged. Double $$ are reduced to a single"
            ' $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)"'
            ' will produce the string literal "$(VAR_NAME)". Escaped references will'
            " never be expanded, regardless of whether the variable exists or not."
            " Cannot be updated. More info:"
            " https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell"
        ),
    )
    command: Optional[List[str]] = Field(
        default=None,
        description=(
            "Entrypoint array. Not executed within a shell. The container image's"
            " ENTRYPOINT is used if this is not provided. Variable references"
            " $(VAR_NAME) are expanded using the container's environment. If a"
            " variable cannot be resolved, the reference in the input string will be"
            " unchanged. Double $$ are reduced to a single $, which allows for escaping"
            ' the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string'
            ' literal "$(VAR_NAME)". Escaped references will never be expanded,'
            " regardless of whether the variable exists or not. Cannot be updated. More"
            " info:"
            " https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell"
        ),
    )
    dependencies: Optional[List[str]] = None
    env: Optional[List[v1.EnvVar]] = Field(
        default=None,
        description=("List of environment variables to set in the container. Cannot be updated."),
    )
    env_from: Optional[List[v1.EnvFromSource]] = Field(
        default=None,
        alias="envFrom",
        description=(
            "List of sources to populate environment variables in the container. The"
            " keys defined within a source must be a C_IDENTIFIER. All invalid keys"
            " will be reported as an event when the container is starting. When a key"
            " exists in multiple sources, the value associated with the last source"
            " will take precedence. Values defined by an Env with a duplicate key will"
            " take precedence. Cannot be updated."
        ),
    )
    image: Optional[str] = Field(
        default=None,
        description=(
            "Container image name. More info:"
            " https://kubernetes.io/docs/concepts/containers/images This field is"
            " optional to allow higher level config management to default or override"
            " container images in workload controllers like Deployments and"
            " StatefulSets."
        ),
    )
    image_pull_policy: Optional[str] = Field(
        default=None,
        alias="imagePullPolicy",
        description=(
            "Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always"
            " if :latest tag is specified, or IfNotPresent otherwise. Cannot be"
            " updated. More info:"
            " https://kubernetes.io/docs/concepts/containers/images#updating-images"
        ),
    )
    lifecycle: Optional[v1.Lifecycle] = Field(
        default=None,
        description=(
            "Actions that the management system should take in response to container"
            " lifecycle events. Cannot be updated."
        ),
    )
    liveness_probe: Optional[v1.Probe] = Field(
        default=None,
        alias="livenessProbe",
        description=(
            "Periodic probe of container liveness. Container will be restarted if the"
            " probe fails. Cannot be updated. More info:"
            " https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes"
        ),
    )
    name: str = Field(
        ...,
        description=(
            "Name of the container specified as a DNS_LABEL. Each container in a pod"
            " must have a unique name (DNS_LABEL). Cannot be updated."
        ),
    )
    ports: Optional[List[v1.ContainerPort]] = Field(
        default=None,
        description=(
            "List of ports to expose from the container. Exposing a port here gives the"
            " system additional information about the network connections a container"
            " uses, but is primarily informational. Not specifying a port here DOES NOT"
            " prevent that port from being exposed. Any port which is listening on the"
            ' default "0.0.0.0" address inside a container will be accessible from the'
            " network. Cannot be updated."
        ),
    )
    readiness_probe: Optional[v1.Probe] = Field(
        default=None,
        alias="readinessProbe",
        description=(
            "Periodic probe of container service readiness. Container will be removed"
            " from service endpoints if the probe fails. Cannot be updated. More info:"
            " https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes"
        ),
    )
    resources: Optional[v1.ResourceRequirements] = Field(
        default=None,
        description=(
            "Compute Resources required by this container. Cannot be updated. More"
            " info:"
            " https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/"
        ),
    )
    security_context: Optional[v1.SecurityContext] = Field(
        default=None,
        alias="securityContext",
        description=(
            "SecurityContext defines the security options the container should be run"
            " with. If set, the fields of SecurityContext override the equivalent"
            " fields of PodSecurityContext. More info:"
            " https://kubernetes.io/docs/tasks/configure-pod-container/security-context/"
        ),
    )
    startup_probe: Optional[v1.Probe] = Field(
        default=None,
        alias="startupProbe",
        description=(
            "StartupProbe indicates that the Pod has successfully initialized. If"
            " specified, no other probes are executed until this completes"
            " successfully. If this probe fails, the Pod will be restarted, just as if"
            " the livenessProbe failed. This can be used to provide different probe"
            " parameters at the beginning of a Pod's lifecycle, when it might take a"
            " long time to load data or warm a cache, than during steady-state"
            " operation. This cannot be updated. More info:"
            " https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes"
        ),
    )
    stdin: Optional[bool] = Field(
        default=None,
        description=(
            "Whether this container should allocate a buffer for stdin in the container"
            " runtime. If this is not set, reads from stdin in the container will"
            " always result in EOF. Default is false."
        ),
    )
    stdin_once: Optional[bool] = Field(
        default=None,
        alias="stdinOnce",
        description=(
            "Whether the container runtime should close the stdin channel after it has"
            " been opened by a single attach. When stdin is true the stdin stream will"
            " remain open across multiple attach sessions. If stdinOnce is set to true,"
            " stdin is opened on container start, is empty until the first client"
            " attaches to stdin, and then remains open and accepts data until the"
            " client disconnects, at which time stdin is closed and remains closed"
            " until the container is restarted. If this flag is false, a container"
            " processes that reads from stdin will never receive an EOF. Default is"
            " false"
        ),
    )
    termination_message_path: Optional[str] = Field(
        default=None,
        alias="terminationMessagePath",
        description=(
            "Optional: Path at which the file to which the container's termination"
            " message will be written is mounted into the container's filesystem."
            " Message written is intended to be brief final status, such as an"
            " assertion failure message. Will be truncated by the node if greater than"
            " 4096 bytes. The total message length across all containers will be"
            " limited to 12kb. Defaults to /dev/termination-log. Cannot be updated."
        ),
    )
    termination_message_policy: Optional[str] = Field(
        default=None,
        alias="terminationMessagePolicy",
        description=(
            "Indicate how the termination message should be populated. File will use"
            " the contents of terminationMessagePath to populate the container status"
            " message on both success and failure. FallbackToLogsOnError will use the"
            " last chunk of container log output if the termination message file is"
            " empty and the container exited with an error. The log output is limited"
            " to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot"
            " be updated."
        ),
    )
    tty: Optional[bool] = Field(
        default=None,
        description=(
            "Whether this container should allocate a TTY for itself, also requires"
            " 'stdin' to be true. Default is false."
        ),
    )
    volume_devices: Optional[List[v1.VolumeDevice]] = Field(
        default=None,
        alias="volumeDevices",
        description=("volumeDevices is the list of block devices to be used by the container."),
    )
    volume_mounts: Optional[List[v1.VolumeMount]] = Field(
        default=None,
        alias="volumeMounts",
        description=("Pod volumes to mount into the container's filesystem. Cannot be updated."),
    )
    working_dir: Optional[str] = Field(
        default=None,
        alias="workingDir",
        description=(
            "Container's working directory. If not specified, the container runtime's"
            " default will be used, which might be configured in the container image."
            " Cannot be updated."
        ),
    )


class ContainerSetTemplate(BaseModel):
    containers: List[ContainerNode]
    retry_strategy: Optional[ContainerSetRetryStrategy] = Field(
        default=None,
        alias="retryStrategy",
        description=(
            "RetryStrategy describes how to retry a container nodes in the container"
            " set if it fails. Nbr of retries(default 0) and sleep duration between"
            " retries(default 0s, instant retry) can be set."
        ),
    )
    volume_mounts: Optional[List[v1.VolumeMount]] = Field(default=None, alias="volumeMounts")


class DataSource(BaseModel):
    artifact_paths: Optional[ArtifactPaths] = Field(
        default=None,
        alias="artifactPaths",
        description=("ArtifactPaths is a data transformation that collects a list of artifact" " paths"),
    )


class Inputs(BaseModel):
    artifacts: Optional[List[Artifact]] = Field(
        default=None, description="Artifact are a list of artifacts passed as inputs"
    )
    parameters: Optional[List[Parameter]] = Field(
        default=None, description="Parameters are a list of parameters passed as inputs"
    )


class ManifestFrom(BaseModel):
    artifact: Artifact = Field(..., description="Artifact contains the artifact to use")


class Outputs(BaseModel):
    artifacts: Optional[List[Artifact]] = Field(
        default=None,
        description="Artifacts holds the list of output artifacts produced by a step",
    )
    exit_code: Optional[str] = Field(
        default=None,
        alias="exitCode",
        description="ExitCode holds the exit code of a script template",
    )
    parameters: Optional[List[Parameter]] = Field(
        default=None,
        description="Parameters holds the list of output parameters produced by a step",
    )
    result: Optional[str] = Field(
        default=None,
        description="Result holds the result (stdout) of a script template",
    )


class ResourceTemplate(BaseModel):
    action: str = Field(
        ...,
        description=(
            "Action is the action to perform to the resource. Must be one of: get,"
            " create, apply, delete, replace, patch"
        ),
    )
    failure_condition: Optional[str] = Field(
        default=None,
        alias="failureCondition",
        description=(
            "FailureCondition is a label selector expression which describes the"
            " conditions of the k8s resource in which the step was considered failed"
        ),
    )
    flags: Optional[List[str]] = Field(
        default=None,
        description=(
            "Flags is a set of additional options passed to kubectl before submitting a"
            " resource I.e. to disable resource validation: flags:"
            ' [\n\t"--validate=false"  # disable resource validation\n]'
        ),
    )
    manifest: Optional[str] = Field(default=None, description="Manifest contains the kubernetes manifest")
    manifest_from: Optional[ManifestFrom] = Field(
        default=None,
        alias="manifestFrom",
        description="ManifestFrom is the source for a single kubernetes manifest",
    )
    merge_strategy: Optional[str] = Field(
        default=None,
        alias="mergeStrategy",
        description=(
            "MergeStrategy is the strategy used to merge a patch. It defaults to"
            ' "strategic" Must be one of: strategic, merge, json'
        ),
    )
    set_owner_reference: Optional[bool] = Field(
        default=None,
        alias="setOwnerReference",
        description=(
            "SetOwnerReference sets the reference to the workflow on the OwnerReference" " of generated resource."
        ),
    )
    success_condition: Optional[str] = Field(
        default=None,
        alias="successCondition",
        description=(
            "SuccessCondition is a label selector expression which describes the"
            " conditions of the k8s resource in which it is acceptable to proceed to"
            " the following step"
        ),
    )


class ScriptTemplate(BaseModel):
    args: Optional[List[str]] = Field(
        default=None,
        description=(
            "Arguments to the entrypoint. The container image's CMD is used if this is"
            " not provided. Variable references $(VAR_NAME) are expanded using the"
            " container's environment. If a variable cannot be resolved, the reference"
            " in the input string will be unchanged. Double $$ are reduced to a single"
            ' $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)"'
            ' will produce the string literal "$(VAR_NAME)". Escaped references will'
            " never be expanded, regardless of whether the variable exists or not."
            " Cannot be updated. More info:"
            " https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell"
        ),
    )
    command: Optional[List[str]] = Field(
        default=None,
        description=(
            "Entrypoint array. Not executed within a shell. The container image's"
            " ENTRYPOINT is used if this is not provided. Variable references"
            " $(VAR_NAME) are expanded using the container's environment. If a"
            " variable cannot be resolved, the reference in the input string will be"
            " unchanged. Double $$ are reduced to a single $, which allows for escaping"
            ' the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string'
            ' literal "$(VAR_NAME)". Escaped references will never be expanded,'
            " regardless of whether the variable exists or not. Cannot be updated. More"
            " info:"
            " https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell"
        ),
    )
    env: Optional[List[v1.EnvVar]] = Field(
        default=None,
        description=("List of environment variables to set in the container. Cannot be updated."),
    )
    env_from: Optional[List[v1.EnvFromSource]] = Field(
        default=None,
        alias="envFrom",
        description=(
            "List of sources to populate environment variables in the container. The"
            " keys defined within a source must be a C_IDENTIFIER. All invalid keys"
            " will be reported as an event when the container is starting. When a key"
            " exists in multiple sources, the value associated with the last source"
            " will take precedence. Values defined by an Env with a duplicate key will"
            " take precedence. Cannot be updated."
        ),
    )
    image: str = Field(
        ...,
        description=(
            "Container image name. More info:"
            " https://kubernetes.io/docs/concepts/containers/images This field is"
            " optional to allow higher level config management to default or override"
            " container images in workload controllers like Deployments and"
            " StatefulSets."
        ),
    )
    image_pull_policy: Optional[str] = Field(
        default=None,
        alias="imagePullPolicy",
        description=(
            "Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always"
            " if :latest tag is specified, or IfNotPresent otherwise. Cannot be"
            " updated. More info:"
            " https://kubernetes.io/docs/concepts/containers/images#updating-images"
        ),
    )
    lifecycle: Optional[v1.Lifecycle] = Field(
        default=None,
        description=(
            "Actions that the management system should take in response to container"
            " lifecycle events. Cannot be updated."
        ),
    )
    liveness_probe: Optional[v1.Probe] = Field(
        default=None,
        alias="livenessProbe",
        description=(
            "Periodic probe of container liveness. Container will be restarted if the"
            " probe fails. Cannot be updated. More info:"
            " https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes"
        ),
    )
    name: Optional[str] = Field(
        default=None,
        description=(
            "Name of the container specified as a DNS_LABEL. Each container in a pod"
            " must have a unique name (DNS_LABEL). Cannot be updated."
        ),
    )
    ports: Optional[List[v1.ContainerPort]] = Field(
        default=None,
        description=(
            "List of ports to expose from the container. Exposing a port here gives the"
            " system additional information about the network connections a container"
            " uses, but is primarily informational. Not specifying a port here DOES NOT"
            " prevent that port from being exposed. Any port which is listening on the"
            ' default "0.0.0.0" address inside a container will be accessible from the'
            " network. Cannot be updated."
        ),
    )
    readiness_probe: Optional[v1.Probe] = Field(
        default=None,
        alias="readinessProbe",
        description=(
            "Periodic probe of container service readiness. Container will be removed"
            " from service endpoints if the probe fails. Cannot be updated. More info:"
            " https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes"
        ),
    )
    resources: Optional[v1.ResourceRequirements] = Field(
        default=None,
        description=(
            "Compute Resources required by this container. Cannot be updated. More"
            " info:"
            " https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/"
        ),
    )
    security_context: Optional[v1.SecurityContext] = Field(
        default=None,
        alias="securityContext",
        description=(
            "SecurityContext defines the security options the container should be run"
            " with. If set, the fields of SecurityContext override the equivalent"
            " fields of PodSecurityContext. More info:"
            " https://kubernetes.io/docs/tasks/configure-pod-container/security-context/"
        ),
    )
    source: str = Field(..., description="Source contains the source code of the script to execute")
    startup_probe: Optional[v1.Probe] = Field(
        default=None,
        alias="startupProbe",
        description=(
            "StartupProbe indicates that the Pod has successfully initialized. If"
            " specified, no other probes are executed until this completes"
            " successfully. If this probe fails, the Pod will be restarted, just as if"
            " the livenessProbe failed. This can be used to provide different probe"
            " parameters at the beginning of a Pod's lifecycle, when it might take a"
            " long time to load data or warm a cache, than during steady-state"
            " operation. This cannot be updated. More info:"
            " https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes"
        ),
    )
    stdin: Optional[bool] = Field(
        default=None,
        description=(
            "Whether this container should allocate a buffer for stdin in the container"
            " runtime. If this is not set, reads from stdin in the container will"
            " always result in EOF. Default is false."
        ),
    )
    stdin_once: Optional[bool] = Field(
        default=None,
        alias="stdinOnce",
        description=(
            "Whether the container runtime should close the stdin channel after it has"
            " been opened by a single attach. When stdin is true the stdin stream will"
            " remain open across multiple attach sessions. If stdinOnce is set to true,"
            " stdin is opened on container start, is empty until the first client"
            " attaches to stdin, and then remains open and accepts data until the"
            " client disconnects, at which time stdin is closed and remains closed"
            " until the container is restarted. If this flag is false, a container"
            " processes that reads from stdin will never receive an EOF. Default is"
            " false"
        ),
    )
    termination_message_path: Optional[str] = Field(
        default=None,
        alias="terminationMessagePath",
        description=(
            "Optional: Path at which the file to which the container's termination"
            " message will be written is mounted into the container's filesystem."
            " Message written is intended to be brief final status, such as an"
            " assertion failure message. Will be truncated by the node if greater than"
            " 4096 bytes. The total message length across all containers will be"
            " limited to 12kb. Defaults to /dev/termination-log. Cannot be updated."
        ),
    )
    termination_message_policy: Optional[str] = Field(
        default=None,
        alias="terminationMessagePolicy",
        description=(
            "Indicate how the termination message should be populated. File will use"
            " the contents of terminationMessagePath to populate the container status"
            " message on both success and failure. FallbackToLogsOnError will use the"
            " last chunk of container log output if the termination message file is"
            " empty and the container exited with an error. The log output is limited"
            " to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot"
            " be updated."
        ),
    )
    tty: Optional[bool] = Field(
        default=None,
        description=(
            "Whether this container should allocate a TTY for itself, also requires"
            " 'stdin' to be true. Default is false."
        ),
    )
    volume_devices: Optional[List[v1.VolumeDevice]] = Field(
        default=None,
        alias="volumeDevices",
        description=("volumeDevices is the list of block devices to be used by the container."),
    )
    volume_mounts: Optional[List[v1.VolumeMount]] = Field(
        default=None,
        alias="volumeMounts",
        description=("Pod volumes to mount into the container's filesystem. Cannot be updated."),
    )
    working_dir: Optional[str] = Field(
        default=None,
        alias="workingDir",
        description=(
            "Container's working directory. If not specified, the container runtime's"
            " default will be used, which might be configured in the container image."
            " Cannot be updated."
        ),
    )


class UserContainer(BaseModel):
    args: Optional[List[str]] = Field(
        default=None,
        description=(
            "Arguments to the entrypoint. The container image's CMD is used if this is"
            " not provided. Variable references $(VAR_NAME) are expanded using the"
            " container's environment. If a variable cannot be resolved, the reference"
            " in the input string will be unchanged. Double $$ are reduced to a single"
            ' $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)"'
            ' will produce the string literal "$(VAR_NAME)". Escaped references will'
            " never be expanded, regardless of whether the variable exists or not."
            " Cannot be updated. More info:"
            " https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell"
        ),
    )
    command: Optional[List[str]] = Field(
        default=None,
        description=(
            "Entrypoint array. Not executed within a shell. The container image's"
            " ENTRYPOINT is used if this is not provided. Variable references"
            " $(VAR_NAME) are expanded using the container's environment. If a"
            " variable cannot be resolved, the reference in the input string will be"
            " unchanged. Double $$ are reduced to a single $, which allows for escaping"
            ' the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string'
            ' literal "$(VAR_NAME)". Escaped references will never be expanded,'
            " regardless of whether the variable exists or not. Cannot be updated. More"
            " info:"
            " https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell"
        ),
    )
    env: Optional[List[v1.EnvVar]] = Field(
        default=None,
        description=("List of environment variables to set in the container. Cannot be updated."),
    )
    env_from: Optional[List[v1.EnvFromSource]] = Field(
        default=None,
        alias="envFrom",
        description=(
            "List of sources to populate environment variables in the container. The"
            " keys defined within a source must be a C_IDENTIFIER. All invalid keys"
            " will be reported as an event when the container is starting. When a key"
            " exists in multiple sources, the value associated with the last source"
            " will take precedence. Values defined by an Env with a duplicate key will"
            " take precedence. Cannot be updated."
        ),
    )
    image: Optional[str] = Field(
        default=None,
        description=(
            "Container image name. More info:"
            " https://kubernetes.io/docs/concepts/containers/images This field is"
            " optional to allow higher level config management to default or override"
            " container images in workload controllers like Deployments and"
            " StatefulSets."
        ),
    )
    image_pull_policy: Optional[str] = Field(
        default=None,
        alias="imagePullPolicy",
        description=(
            "Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always"
            " if :latest tag is specified, or IfNotPresent otherwise. Cannot be"
            " updated. More info:"
            " https://kubernetes.io/docs/concepts/containers/images#updating-images"
        ),
    )
    lifecycle: Optional[v1.Lifecycle] = Field(
        default=None,
        description=(
            "Actions that the management system should take in response to container"
            " lifecycle events. Cannot be updated."
        ),
    )
    liveness_probe: Optional[v1.Probe] = Field(
        default=None,
        alias="livenessProbe",
        description=(
            "Periodic probe of container liveness. Container will be restarted if the"
            " probe fails. Cannot be updated. More info:"
            " https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes"
        ),
    )
    mirror_volume_mounts: Optional[bool] = Field(
        default=None,
        alias="mirrorVolumeMounts",
        description=(
            "MirrorVolumeMounts will mount the same volumes specified in the main"
            " container to the container (including artifacts), at the same mountPaths."
            " This enables dind daemon to partially see the same filesystem as the main"
            " container in order to use features such as docker volume binding"
        ),
    )
    name: str = Field(
        ...,
        description=(
            "Name of the container specified as a DNS_LABEL. Each container in a pod"
            " must have a unique name (DNS_LABEL). Cannot be updated."
        ),
    )
    ports: Optional[List[v1.ContainerPort]] = Field(
        default=None,
        description=(
            "List of ports to expose from the container. Exposing a port here gives the"
            " system additional information about the network connections a container"
            " uses, but is primarily informational. Not specifying a port here DOES NOT"
            " prevent that port from being exposed. Any port which is listening on the"
            ' default "0.0.0.0" address inside a container will be accessible from the'
            " network. Cannot be updated."
        ),
    )
    readiness_probe: Optional[v1.Probe] = Field(
        default=None,
        alias="readinessProbe",
        description=(
            "Periodic probe of container service readiness. Container will be removed"
            " from service endpoints if the probe fails. Cannot be updated. More info:"
            " https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes"
        ),
    )
    resources: Optional[v1.ResourceRequirements] = Field(
        default=None,
        description=(
            "Compute Resources required by this container. Cannot be updated. More"
            " info:"
            " https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/"
        ),
    )
    security_context: Optional[v1.SecurityContext] = Field(
        default=None,
        alias="securityContext",
        description=(
            "SecurityContext defines the security options the container should be run"
            " with. If set, the fields of SecurityContext override the equivalent"
            " fields of PodSecurityContext. More info:"
            " https://kubernetes.io/docs/tasks/configure-pod-container/security-context/"
        ),
    )
    startup_probe: Optional[v1.Probe] = Field(
        default=None,
        alias="startupProbe",
        description=(
            "StartupProbe indicates that the Pod has successfully initialized. If"
            " specified, no other probes are executed until this completes"
            " successfully. If this probe fails, the Pod will be restarted, just as if"
            " the livenessProbe failed. This can be used to provide different probe"
            " parameters at the beginning of a Pod's lifecycle, when it might take a"
            " long time to load data or warm a cache, than during steady-state"
            " operation. This cannot be updated. More info:"
            " https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes"
        ),
    )
    stdin: Optional[bool] = Field(
        default=None,
        description=(
            "Whether this container should allocate a buffer for stdin in the container"
            " runtime. If this is not set, reads from stdin in the container will"
            " always result in EOF. Default is false."
        ),
    )
    stdin_once: Optional[bool] = Field(
        default=None,
        alias="stdinOnce",
        description=(
            "Whether the container runtime should close the stdin channel after it has"
            " been opened by a single attach. When stdin is true the stdin stream will"
            " remain open across multiple attach sessions. If stdinOnce is set to true,"
            " stdin is opened on container start, is empty until the first client"
            " attaches to stdin, and then remains open and accepts data until the"
            " client disconnects, at which time stdin is closed and remains closed"
            " until the container is restarted. If this flag is false, a container"
            " processes that reads from stdin will never receive an EOF. Default is"
            " false"
        ),
    )
    termination_message_path: Optional[str] = Field(
        default=None,
        alias="terminationMessagePath",
        description=(
            "Optional: Path at which the file to which the container's termination"
            " message will be written is mounted into the container's filesystem."
            " Message written is intended to be brief final status, such as an"
            " assertion failure message. Will be truncated by the node if greater than"
            " 4096 bytes. The total message length across all containers will be"
            " limited to 12kb. Defaults to /dev/termination-log. Cannot be updated."
        ),
    )
    termination_message_policy: Optional[str] = Field(
        default=None,
        alias="terminationMessagePolicy",
        description=(
            "Indicate how the termination message should be populated. File will use"
            " the contents of terminationMessagePath to populate the container status"
            " message on both success and failure. FallbackToLogsOnError will use the"
            " last chunk of container log output if the termination message file is"
            " empty and the container exited with an error. The log output is limited"
            " to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot"
            " be updated."
        ),
    )
    tty: Optional[bool] = Field(
        default=None,
        description=(
            "Whether this container should allocate a TTY for itself, also requires"
            " 'stdin' to be true. Default is false."
        ),
    )
    volume_devices: Optional[List[v1.VolumeDevice]] = Field(
        default=None,
        alias="volumeDevices",
        description=("volumeDevices is the list of block devices to be used by the container."),
    )
    volume_mounts: Optional[List[v1.VolumeMount]] = Field(
        default=None,
        alias="volumeMounts",
        description=("Pod volumes to mount into the container's filesystem. Cannot be updated."),
    )
    working_dir: Optional[str] = Field(
        default=None,
        alias="workingDir",
        description=(
            "Container's working directory. If not specified, the container runtime's"
            " default will be used, which might be configured in the container image."
            " Cannot be updated."
        ),
    )


class Arguments(BaseModel):
    artifacts: Optional[List[Artifact]] = Field(
        default=None,
        description=("Artifacts is the list of artifacts to pass to the template or workflow"),
    )
    parameters: Optional[List[Parameter]] = Field(
        default=None,
        description=("Parameters is the list of parameters to pass to the template or workflow"),
    )


class ArtifactGCSpec(BaseModel):
    artifacts_by_node: Optional[Dict[str, ArtifactNodeSpec]] = Field(
        default=None,
        alias="artifactsByNode",
        description=("ArtifactsByNode maps Node name to information pertaining to Artifacts on" " that Node"),
    )


class Data(BaseModel):
    source: DataSource = Field(..., description="Source sources external data into a data template")
    transformation: List[TransformationStep] = Field(
        ..., description="Transformation applies a set of transformations"
    )


class LifecycleHook(BaseModel):
    arguments: Optional[Arguments] = Field(default=None, description="Arguments hold arguments to the template")
    expression: Optional[str] = Field(
        default=None,
        description=(
            "Expression is a condition expression for when a node will be retried. If"
            " it evaluates to false, the node will not be retried and the retry"
            " strategy will be ignored"
        ),
    )
    template: Optional[str] = Field(
        default=None,
        description="Template is the name of the template to execute by the hook",
    )
    template_ref: Optional[TemplateRef] = Field(
        default=None,
        alias="templateRef",
        description=("TemplateRef is the reference to the template resource to execute by the" " hook"),
    )


class NodeResult(BaseModel):
    message: Optional[str] = None
    outputs: Optional[Outputs] = None
    phase: Optional[str] = None
    progress: Optional[str] = None


class NodeStatus(BaseModel):
    boundary_id: Optional[str] = Field(
        default=None,
        alias="boundaryID",
        description=(
            "BoundaryID indicates the node ID of the associated template root node in" " which this node belongs to"
        ),
    )
    children: Optional[List[str]] = Field(default=None, description="Children is a list of child node IDs")
    daemoned: Optional[bool] = Field(
        default=None,
        description=("Daemoned tracks whether or not this node was daemoned and need to be" " terminated"),
    )
    display_name: Optional[str] = Field(
        default=None,
        alias="displayName",
        description=(
            "DisplayName is a human readable representation of the node. Unique within" " a template boundary"
        ),
    )
    estimated_duration: Optional[int] = Field(
        default=None,
        alias="estimatedDuration",
        description="EstimatedDuration in seconds.",
    )
    finished_at: Optional[v1_1.Time] = Field(
        default=None,
        alias="finishedAt",
        description="Time at which this node completed",
    )
    host_node_name: Optional[str] = Field(
        default=None,
        alias="hostNodeName",
        description=("HostNodeName name of the Kubernetes node on which the Pod is running, if" " applicable"),
    )
    id: str = Field(
        ...,
        description=(
            "ID is a unique identifier of a node within the worklow It is implemented"
            " as a hash of the node name, which makes the ID deterministic"
        ),
    )
    inputs: Optional[Inputs] = Field(
        default=None,
        description=(
            "Inputs captures input parameter values and artifact locations supplied to" " this template invocation"
        ),
    )
    memoization_status: Optional[MemoizationStatus] = Field(
        default=None,
        alias="memoizationStatus",
        description="MemoizationStatus holds information about cached nodes",
    )
    message: Optional[str] = Field(
        default=None,
        description=("A human readable message indicating details about why the node is in this" " condition."),
    )
    name: str = Field(
        ...,
        description="Name is unique name in the node tree used to generate the node ID",
    )
    outbound_nodes: Optional[List[str]] = Field(
        default=None,
        alias="outboundNodes",
        description=(
            'OutboundNodes tracks the node IDs which are considered "outbound" nodes to'
            " a template invocation. For every invocation of a template, there are"
            ' nodes which we considered as "outbound". Essentially, these are last'
            " nodes in the execution sequence to run, before the template is considered"
            " completed. These nodes are then connected as parents to a following"
            " step.\n\nIn the case of single pod steps (i.e. container, script,"
            " resource templates), this list will be nil since the pod itself is"
            ' already considered the "outbound" node. In the case of DAGs, outbound'
            ' nodes are the "target" tasks (tasks with no children). In the case of'
            " steps, outbound nodes are all the containers involved in the last step"
            " group. NOTE: since templates are composable, the list of outbound nodes"
            " are carried upwards when a DAG/steps template invokes another DAG/steps"
            " template. In other words, the outbound nodes of a template, will be a"
            " superset of the outbound nodes of its last children."
        ),
    )
    outputs: Optional[Outputs] = Field(
        default=None,
        description=(
            "Outputs captures output parameter values and artifact locations produced" " by this template invocation"
        ),
    )
    phase: Optional[str] = Field(
        default=None,
        description=(
            "Phase a simple, high-level summary of where the node is in its lifecycle."
            " Can be used as a state machine."
        ),
    )
    pod_ip: Optional[str] = Field(
        default=None,
        alias="podIP",
        description="PodIP captures the IP of the pod for daemoned steps",
    )
    progress: Optional[str] = Field(default=None, description="Progress to completion")
    resources_duration: Optional[Dict[str, int]] = Field(
        default=None,
        alias="resourcesDuration",
        description=(
            "ResourcesDuration is indicative, but not accurate, resource duration. This"
            " is populated when the nodes completes."
        ),
    )
    started_at: Optional[v1_1.Time] = Field(
        default=None, alias="startedAt", description="Time at which this node started"
    )
    synchronization_status: Optional[NodeSynchronizationStatus] = Field(
        default=None,
        alias="synchronizationStatus",
        description="SynchronizationStatus is the synchronization status of the node",
    )
    template_name: Optional[str] = Field(
        default=None,
        alias="templateName",
        description=(
            "TemplateName is the template name which this node corresponds to. Not"
            " applicable to virtual nodes (e.g. Retry, StepGroup)"
        ),
    )
    template_ref: Optional[TemplateRef] = Field(
        default=None,
        alias="templateRef",
        description=(
            "TemplateRef is the reference to the template resource which this node"
            " corresponds to. Not applicable to virtual nodes (e.g. Retry, StepGroup)"
        ),
    )
    template_scope: Optional[str] = Field(
        default=None,
        alias="templateScope",
        description=("TemplateScope is the template scope in which the template of this node was" " retrieved."),
    )
    type: str = Field(..., description="Type indicates type of node")


class Submit(BaseModel):
    arguments: Optional[Arguments] = Field(
        default=None,
        description=("Arguments extracted from the event and then set as arguments to the" " workflow created."),
    )
    metadata: Optional[v1_1.ObjectMeta] = Field(
        default=None,
        description=("Metadata optional means to customize select fields of the workflow" " metadata"),
    )
    workflow_template_ref: WorkflowTemplateRef = Field(
        ...,
        alias="workflowTemplateRef",
        description="WorkflowTemplateRef the workflow template to submit",
    )


class WorkflowEventBindingSpec(BaseModel):
    event: Event = Field(..., description="Event is the event to bind to")
    submit: Optional[Submit] = Field(default=None, description="Submit is the workflow template to submit")


class WorkflowTaskSetStatus(BaseModel):
    nodes: Optional[Dict[str, NodeResult]] = None


class WorkflowEventBinding(BaseModel):
    api_version: Optional[str] = Field(
        default=None,
        alias="apiVersion",
        description=(
            "APIVersion defines the versioned schema of this representation of an"
            " object. Servers should convert recognized schemas to the latest internal"
            " value, and may reject unrecognized values. More info:"
            " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#resources"
        ),
    )
    kind: Optional[str] = Field(
        default=None,
        description=(
            "Kind is a string value representing the REST resource this object"
            " represents. Servers may infer this from the endpoint the client submits"
            " requests to. Cannot be updated. In CamelCase. More info:"
            " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
        ),
    )
    metadata: v1_1.ObjectMeta
    spec: WorkflowEventBindingSpec


class WorkflowEventBindingList(BaseModel):
    api_version: Optional[str] = Field(
        default=None,
        alias="apiVersion",
        description=(
            "APIVersion defines the versioned schema of this representation of an"
            " object. Servers should convert recognized schemas to the latest internal"
            " value, and may reject unrecognized values. More info:"
            " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#resources"
        ),
    )
    items: Optional[List[WorkflowEventBinding]] = None
    kind: Optional[str] = Field(
        default=None,
        description=(
            "Kind is a string value representing the REST resource this object"
            " represents. Servers may infer this from the endpoint the client submits"
            " requests to. Cannot be updated. In CamelCase. More info:"
            " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
        ),
    )
    metadata: v1_1.ListMeta


class ClusterWorkflowTemplate(BaseModel):
    api_version: Optional[str] = Field(
        default=None,
        alias="apiVersion",
        description=(
            "APIVersion defines the versioned schema of this representation of an"
            " object. Servers should convert recognized schemas to the latest internal"
            " value, and may reject unrecognized values. More info:"
            " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#resources"
        ),
    )
    kind: Optional[str] = Field(
        default=None,
        description=(
            "Kind is a string value representing the REST resource this object"
            " represents. Servers may infer this from the endpoint the client submits"
            " requests to. Cannot be updated. In CamelCase. More info:"
            " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
        ),
    )
    metadata: v1_1.ObjectMeta
    spec: WorkflowSpec


class ClusterWorkflowTemplateCreateRequest(BaseModel):
    create_options: Optional[v1_1.CreateOptions] = Field(default=None, alias="createOptions")
    template: Optional[ClusterWorkflowTemplate] = None


class ClusterWorkflowTemplateLintRequest(BaseModel):
    create_options: Optional[v1_1.CreateOptions] = Field(default=None, alias="createOptions")
    template: Optional[ClusterWorkflowTemplate] = None


class ClusterWorkflowTemplateList(BaseModel):
    api_version: Optional[str] = Field(
        default=None,
        alias="apiVersion",
        description=(
            "APIVersion defines the versioned schema of this representation of an"
            " object. Servers should convert recognized schemas to the latest internal"
            " value, and may reject unrecognized values. More info:"
            " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#resources"
        ),
    )
    items: Optional[List[ClusterWorkflowTemplate]] = None
    kind: Optional[str] = Field(
        default=None,
        description=(
            "Kind is a string value representing the REST resource this object"
            " represents. Servers may infer this from the endpoint the client submits"
            " requests to. Cannot be updated. In CamelCase. More info:"
            " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
        ),
    )
    metadata: v1_1.ListMeta


class ClusterWorkflowTemplateUpdateRequest(BaseModel):
    name: Optional[str] = Field(default=None, description="DEPRECATED: This field is ignored.")
    template: Optional[ClusterWorkflowTemplate] = None


class CreateCronWorkflowRequest(BaseModel):
    create_options: Optional[v1_1.CreateOptions] = Field(default=None, alias="createOptions")
    cron_workflow: Optional[CronWorkflow] = Field(default=None, alias="cronWorkflow")
    namespace: Optional[str] = None


class CronWorkflow(BaseModel):
    api_version: Optional[str] = Field(
        default=None,
        alias="apiVersion",
        description=(
            "APIVersion defines the versioned schema of this representation of an"
            " object. Servers should convert recognized schemas to the latest internal"
            " value, and may reject unrecognized values. More info:"
            " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#resources"
        ),
    )
    kind: Optional[str] = Field(
        default=None,
        description=(
            "Kind is a string value representing the REST resource this object"
            " represents. Servers may infer this from the endpoint the client submits"
            " requests to. Cannot be updated. In CamelCase. More info:"
            " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
        ),
    )
    metadata: v1_1.ObjectMeta
    spec: CronWorkflowSpec
    status: Optional[CronWorkflowStatus] = None


class CronWorkflowList(BaseModel):
    api_version: Optional[str] = Field(
        default=None,
        alias="apiVersion",
        description=(
            "APIVersion defines the versioned schema of this representation of an"
            " object. Servers should convert recognized schemas to the latest internal"
            " value, and may reject unrecognized values. More info:"
            " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#resources"
        ),
    )
    items: Optional[List[CronWorkflow]] = None
    kind: Optional[str] = Field(
        default=None,
        description=(
            "Kind is a string value representing the REST resource this object"
            " represents. Servers may infer this from the endpoint the client submits"
            " requests to. Cannot be updated. In CamelCase. More info:"
            " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
        ),
    )
    metadata: v1_1.ListMeta


class CronWorkflowSpec(BaseModel):
    concurrency_policy: Optional[str] = Field(
        default=None,
        alias="concurrencyPolicy",
        description=("ConcurrencyPolicy is the K8s-style concurrency policy that will be used"),
    )
    failed_jobs_history_limit: Optional[int] = Field(
        default=None,
        alias="failedJobsHistoryLimit",
        description=("FailedJobsHistoryLimit is the number of failed jobs to be kept at a time"),
    )
    schedule: str = Field(..., description="Schedule is a schedule to run the Workflow in Cron format")
    starting_deadline_seconds: Optional[int] = Field(
        default=None,
        alias="startingDeadlineSeconds",
        description=(
            "StartingDeadlineSeconds is the K8s-style deadline that will limit the time"
            " a CronWorkflow will be run after its original scheduled time if it is"
            " missed."
        ),
    )
    successful_jobs_history_limit: Optional[int] = Field(
        default=None,
        alias="successfulJobsHistoryLimit",
        description=("SuccessfulJobsHistoryLimit is the number of successful jobs to be kept at" " a time"),
    )
    suspend: Optional[bool] = Field(
        default=None,
        description=("Suspend is a flag that will stop new CronWorkflows from running if set to" " true"),
    )
    timezone: Optional[str] = Field(
        default=None,
        description=(
            "Timezone is the timezone against which the cron schedule will be"
            ' calculated, e.g. "Asia/Tokyo". Default is machine\'s local time.'
        ),
    )
    workflow_metadata: Optional[v1_1.ObjectMeta] = Field(
        default=None,
        alias="workflowMetadata",
        description="WorkflowMetadata contains some metadata of the workflow to be run",
    )
    workflow_spec: WorkflowSpec = Field(
        ...,
        alias="workflowSpec",
        description="WorkflowSpec is the spec of the workflow to be run",
    )


class DAGTask(BaseModel):
    arguments: Optional[Arguments] = Field(
        default=None,
        description=("Arguments are the parameter and artifact arguments to the template"),
    )
    continue_on: Optional[ContinueOn] = Field(
        default=None,
        alias="continueOn",
        description=(
            "ContinueOn makes argo to proceed with the following step even if this step"
            " fails. Errors and Failed states can be specified"
        ),
    )
    dependencies: Optional[List[str]] = Field(
        default=None,
        description="Dependencies are name of other targets which this depends on",
    )
    depends: Optional[str] = Field(
        default=None,
        description="Depends are name of other targets which this depends on",
    )
    hooks: Optional[Dict[str, LifecycleHook]] = Field(
        default=None,
        description=(
            "Hooks hold the lifecycle hook which is invoked at lifecycle of task,"
            " irrespective of the success, failure, or error status of the primary task"
        ),
    )
    inline: Optional[Template] = Field(
        default=None,
        description=("Inline is the template. Template must be empty if this is declared (and" " vice-versa)."),
    )
    name: str = Field(..., description="Name is the name of the target")
    on_exit: Optional[str] = Field(
        default=None,
        alias="onExit",
        description=(
            "OnExit is a template reference which is invoked at the end of the"
            " template, irrespective of the success, failure, or error of the primary"
            " template. DEPRECATED: Use Hooks[exit].Template instead."
        ),
    )
    template: Optional[str] = Field(default=None, description="Name of template to execute")
    template_ref: Optional[TemplateRef] = Field(
        default=None,
        alias="templateRef",
        description="TemplateRef is the reference to the template resource to execute.",
    )
    when: Optional[str] = Field(
        default=None,
        description=("When is an expression in which the task should conditionally execute"),
    )
    with_items: Optional[List[Item]] = Field(
        default=None,
        alias="withItems",
        description=("WithItems expands a task into multiple parallel tasks from the items in" " the list"),
    )
    with_param: Optional[str] = Field(
        default=None,
        alias="withParam",
        description=(
            "WithParam expands a task into multiple parallel tasks from the value in"
            " the parameter, which is expected to be a JSON list."
        ),
    )
    with_sequence: Optional[Sequence] = Field(
        default=None,
        alias="withSequence",
        description="WithSequence expands a task into a numeric sequence",
    )


class DAGTemplate(BaseModel):
    fail_fast: Optional[bool] = Field(
        default=None,
        alias="failFast",
        description=(
            'This flag is for DAG logic. The DAG logic has a built-in "fail fast"'
            " feature to stop scheduling new steps, as soon as it detects that one of"
            " the DAG nodes is failed. Then it waits until all DAG nodes are completed"
            " before failing the DAG itself. The FailFast flag default is true,  if set"
            " to false, it will allow a DAG to run all branches of the DAG to"
            " completion (either success or failure), regardless of the failed outcomes"
            " of branches in the DAG. More info and example about this feature at"
            " https://github.com/argoproj/argo-workflows/issues/1442"
        ),
    )
    target: Optional[str] = Field(
        default=None,
        description="Target are one or more names of targets to execute in a DAG",
    )
    tasks: List[DAGTask] = Field(..., description="Tasks are a list of DAG tasks")


class LintCronWorkflowRequest(BaseModel):
    cron_workflow: Optional[CronWorkflow] = Field(default=None, alias="cronWorkflow")
    namespace: Optional[str] = None


class ParallelSteps(BaseModel):
    __root__: List[WorkflowStep]


class Template(BaseModel):
    active_deadline_seconds: Optional[intstr.IntOrString] = Field(
        default=None,
        alias="activeDeadlineSeconds",
        description=(
            "Optional duration in seconds relative to the StartTime that the pod may be"
            " active on a node before the system actively tries to terminate the pod;"
            " value must be positive integer This field is only applicable to container"
            " and script templates."
        ),
    )
    affinity: Optional[v1.Affinity] = Field(
        default=None,
        description=(
            "Affinity sets the pod's scheduling constraints Overrides the affinity set"
            " at the workflow level (if any)"
        ),
    )
    archive_location: Optional[ArtifactLocation] = Field(
        default=None,
        alias="archiveLocation",
        description=(
            "Location in which all files related to the step will be stored (logs,"
            " artifacts, etc...). Can be overridden by individual items in Outputs. If"
            " omitted, will use the default artifact repository location configured in"
            " the controller, appended with the <workflowname>/<nodename> in the key."
        ),
    )
    automount_service_account_token: Optional[bool] = Field(
        default=None,
        alias="automountServiceAccountToken",
        description=(
            "AutomountServiceAccountToken indicates whether a service account token"
            " should be automatically mounted in pods. ServiceAccountName of"
            " ExecutorConfig must be specified if this value is false."
        ),
    )
    container: Optional[v1.Container] = Field(
        default=None,
        description="Container is the main container image to run in the pod",
    )
    container_set: Optional[ContainerSetTemplate] = Field(
        default=None,
        alias="containerSet",
        description="ContainerSet groups multiple containers within a single pod.",
    )
    daemon: Optional[bool] = Field(
        default=None,
        description=(
            "Deamon will allow a workflow to proceed to the next step so long as the" " container reaches readiness"
        ),
    )
    dag: Optional[DAGTemplate] = Field(default=None, description="DAG template subtype which runs a DAG")
    data: Optional[Data] = Field(default=None, description="Data is a data template")
    executor: Optional[ExecutorConfig] = Field(
        default=None,
        description="Executor holds configurations of the executor container.",
    )
    fail_fast: Optional[bool] = Field(
        default=None,
        alias="failFast",
        description=(
            "FailFast, if specified, will fail this template if any of its child pods"
            " has failed. This is useful for when this template is expanded with"
            " `withItems`, etc."
        ),
    )
    host_aliases: Optional[List[v1.HostAlias]] = Field(
        default=None,
        alias="hostAliases",
        description=("HostAliases is an optional list of hosts and IPs that will be injected" " into the pod spec"),
    )
    http: Optional[HTTP] = Field(default=None, description="HTTP makes a HTTP request")
    init_containers: Optional[List[UserContainer]] = Field(
        default=None,
        alias="initContainers",
        description=("InitContainers is a list of containers which run before the main" " container."),
    )
    inputs: Optional[Inputs] = Field(
        default=None,
        description=("Inputs describe what inputs parameters and artifacts are supplied to this" " template"),
    )
    memoize: Optional[Memoize] = Field(
        default=None,
        description=("Memoize allows templates to use outputs generated from already executed" " templates"),
    )
    metadata: Optional[Metadata] = Field(
        default=None,
        description="Metdata sets the pods's metadata, i.e. annotations and labels",
    )
    metrics: Optional[Metrics] = Field(
        default=None,
        description="Metrics are a list of metrics emitted from this template",
    )
    name: Optional[str] = Field(default=None, description="Name is the name of the template")
    node_selector: Optional[Dict[str, str]] = Field(
        default=None,
        alias="nodeSelector",
        description=(
            "NodeSelector is a selector to schedule this step of the workflow to be run"
            " on the selected node(s). Overrides the selector set at the workflow"
            " level."
        ),
    )
    outputs: Optional[Outputs] = Field(
        default=None,
        description=("Outputs describe the parameters and artifacts that this template produces"),
    )
    parallelism: Optional[int] = Field(
        default=None,
        description=(
            "Parallelism limits the max total parallel pods that can execute at the"
            " same time within the boundaries of this template invocation. If"
            " additional steps/dag templates are invoked, the pods created by those"
            " templates will not be counted towards this total."
        ),
    )
    plugin: Optional[Plugin] = Field(default=None, description="Plugin is a plugin template")
    pod_spec_patch: Optional[str] = Field(
        default=None,
        alias="podSpecPatch",
        description=(
            "PodSpecPatch holds strategic merge patch to apply against the pod spec."
            " Allows parameterization of container fields which are not strings (e.g."
            " resource limits)."
        ),
    )
    priority: Optional[int] = Field(default=None, description="Priority to apply to workflow pods.")
    priority_class_name: Optional[str] = Field(
        default=None,
        alias="priorityClassName",
        description="PriorityClassName to apply to workflow pods.",
    )
    resource: Optional[ResourceTemplate] = Field(
        default=None,
        description="Resource template subtype which can run k8s resources",
    )
    retry_strategy: Optional[RetryStrategy] = Field(
        default=None,
        alias="retryStrategy",
        description="RetryStrategy describes how to retry a template when it fails",
    )
    scheduler_name: Optional[str] = Field(
        default=None,
        alias="schedulerName",
        description=(
            "If specified, the pod will be dispatched by specified scheduler. Or it"
            " will be dispatched by workflow scope scheduler if specified. If neither"
            " specified, the pod will be dispatched by default scheduler."
        ),
    )
    script: Optional[ScriptTemplate] = Field(
        default=None, description="Script runs a portion of code against an interpreter"
    )
    security_context: Optional[v1.PodSecurityContext] = Field(
        default=None,
        alias="securityContext",
        description=(
            "SecurityContext holds pod-level security attributes and common container"
            " settings. Optional: Defaults to empty.  See type description for default"
            " values of each field."
        ),
    )
    service_account_name: Optional[str] = Field(
        default=None,
        alias="serviceAccountName",
        description="ServiceAccountName to apply to workflow pods",
    )
    sidecars: Optional[List[UserContainer]] = Field(
        default=None,
        description=(
            "Sidecars is a list of containers which run alongside the main container"
            " Sidecars are automatically killed when the main container completes"
        ),
    )
    steps: Optional[List[ParallelSteps]] = Field(
        default=None,
        description="Steps define a series of sequential/parallel workflow steps",
    )
    suspend: Optional[SuspendTemplate] = Field(
        default=None,
        description=("Suspend template subtype which can suspend a workflow when reaching the" " step"),
    )
    synchronization: Optional[Synchronization] = Field(
        default=None,
        description=("Synchronization holds synchronization lock configuration for this template"),
    )
    timeout: Optional[str] = Field(
        default=None,
        description=(
            "Timeout allows to set the total node execution timeout duration counting"
            " from the node's start time. This duration also includes time in which the"
            " node spends in Pending state. This duration may not be applied to Step or"
            " DAG templates."
        ),
    )
    tolerations: Optional[List[v1.Toleration]] = Field(
        default=None, description="Tolerations to apply to workflow pods."
    )
    volumes: Optional[List[v1.Volume]] = Field(
        default=None,
        description=("Volumes is a list of volumes that can be mounted by containers in a" " template."),
    )


class UpdateCronWorkflowRequest(BaseModel):
    cron_workflow: Optional[CronWorkflow] = Field(default=None, alias="cronWorkflow")
    name: Optional[str] = Field(default=None, description="DEPRECATED: This field is ignored.")
    namespace: Optional[str] = None


class Workflow(BaseModel):
    api_version: Optional[str] = Field(
        default=None,
        alias="apiVersion",
        description=(
            "APIVersion defines the versioned schema of this representation of an"
            " object. Servers should convert recognized schemas to the latest internal"
            " value, and may reject unrecognized values. More info:"
            " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#resources"
        ),
    )
    kind: Optional[str] = Field(
        default=None,
        description=(
            "Kind is a string value representing the REST resource this object"
            " represents. Servers may infer this from the endpoint the client submits"
            " requests to. Cannot be updated. In CamelCase. More info:"
            " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
        ),
    )
    metadata: v1_1.ObjectMeta
    spec: WorkflowSpec
    status: Optional[WorkflowStatus] = None


class WorkflowCreateRequest(BaseModel):
    create_options: Optional[v1_1.CreateOptions] = Field(default=None, alias="createOptions")
    instance_id: Optional[str] = Field(default=None, alias="instanceID", description="This field is no longer used.")
    namespace: Optional[str] = None
    server_dry_run: Optional[bool] = Field(default=None, alias="serverDryRun")
    workflow: Optional[Workflow] = None


class WorkflowLintRequest(BaseModel):
    namespace: Optional[str] = None
    workflow: Optional[Workflow] = None


class WorkflowList(BaseModel):
    api_version: Optional[str] = Field(
        default=None,
        alias="apiVersion",
        description=(
            "APIVersion defines the versioned schema of this representation of an"
            " object. Servers should convert recognized schemas to the latest internal"
            " value, and may reject unrecognized values. More info:"
            " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#resources"
        ),
    )
    items: Optional[List[Workflow]] = None
    kind: Optional[str] = Field(
        default=None,
        description=(
            "Kind is a string value representing the REST resource this object"
            " represents. Servers may infer this from the endpoint the client submits"
            " requests to. Cannot be updated. In CamelCase. More info:"
            " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
        ),
    )
    metadata: v1_1.ListMeta


class WorkflowSpec(BaseModel):
    active_deadline_seconds: Optional[int] = Field(
        default=None,
        alias="activeDeadlineSeconds",
        description=(
            "Optional duration in seconds relative to the workflow start time which the"
            " workflow is allowed to run before the controller terminates the"
            " io.argoproj.workflow.v1alpha1. A value of zero is used to terminate a"
            " Running workflow"
        ),
    )
    affinity: Optional[v1.Affinity] = Field(
        default=None,
        description=(
            "Affinity sets the scheduling constraints for all pods in the"
            " io.argoproj.workflow.v1alpha1. Can be overridden by an affinity specified"
            " in the template"
        ),
    )
    archive_logs: Optional[bool] = Field(
        default=None,
        alias="archiveLogs",
        description="ArchiveLogs indicates if the container logs should be archived",
    )
    arguments: Optional[Arguments] = Field(
        default=None,
        description=(
            "Arguments contain the parameters and artifacts sent to the workflow"
            " entrypoint Parameters are referencable globally using the 'workflow'"
            " variable prefix. e.g."
            " {{io.argoproj.workflow.v1alpha1.parameters.myparam}}"
        ),
    )
    artifact_gc: Optional[ArtifactGC] = Field(
        default=None,
        alias="artifactGC",
        description=(
            "ArtifactGC describes the strategy to use when deleting artifacts from"
            " completed or deleted workflows (applies to all output Artifacts unless"
            " Artifact.ArtifactGC is specified, which overrides this)"
        ),
    )
    artifact_repository_ref: Optional[ArtifactRepositoryRef] = Field(
        default=None,
        alias="artifactRepositoryRef",
        description=(
            "ArtifactRepositoryRef specifies the configMap name and key containing the" " artifact repository config."
        ),
    )
    automount_service_account_token: Optional[bool] = Field(
        default=None,
        alias="automountServiceAccountToken",
        description=(
            "AutomountServiceAccountToken indicates whether a service account token"
            " should be automatically mounted in pods. ServiceAccountName of"
            " ExecutorConfig must be specified if this value is false."
        ),
    )
    dns_config: Optional[v1.PodDNSConfig] = Field(
        default=None,
        alias="dnsConfig",
        description=(
            "PodDNSConfig defines the DNS parameters of a pod in addition to those" " generated from DNSPolicy."
        ),
    )
    dns_policy: Optional[str] = Field(
        default=None,
        alias="dnsPolicy",
        description=(
            'Set DNS policy for the pod. Defaults to "ClusterFirst". Valid values are'
            " 'ClusterFirstWithHostNet', 'ClusterFirst', 'Default' or 'None'."
            " DNS parameters given in DNSConfig will be merged with the policy selected"
            " with DNSPolicy. To have DNS options set along with hostNetwork, you have"
            " to specify DNS policy explicitly to 'ClusterFirstWithHostNet'."
        ),
    )
    entrypoint: Optional[str] = Field(
        default=None,
        description=(
            "Entrypoint is a template reference to the starting point of the" " io.argoproj.workflow.v1alpha1."
        ),
    )
    executor: Optional[ExecutorConfig] = Field(
        default=None,
        description=("Executor holds configurations of executor containers of the" " io.argoproj.workflow.v1alpha1."),
    )
    hooks: Optional[Dict[str, LifecycleHook]] = Field(
        default=None,
        description=(
            "Hooks holds the lifecycle hook which is invoked at lifecycle of step,"
            " irrespective of the success, failure, or error status of the primary step"
        ),
    )
    host_aliases: Optional[List[v1.HostAlias]] = Field(default=None, alias="hostAliases")
    host_network: Optional[bool] = Field(
        default=None,
        alias="hostNetwork",
        description=("Host networking requested for this workflow pod. Default to false."),
    )
    image_pull_secrets: Optional[List[v1.LocalObjectReference]] = Field(
        default=None,
        alias="imagePullSecrets",
        description=(
            "ImagePullSecrets is a list of references to secrets in the same namespace"
            " to use for pulling any images in pods that reference this ServiceAccount."
            " ImagePullSecrets are distinct from Secrets because Secrets can be mounted"
            " in the pod, but ImagePullSecrets are only accessed by the kubelet. More"
            " info:"
            " https://kubernetes.io/docs/concepts/containers/images/#specifying-imagepullsecrets-on-a-pod"
        ),
    )
    metrics: Optional[Metrics] = Field(
        default=None,
        description="Metrics are a list of metrics emitted from this Workflow",
    )
    node_selector: Optional[Dict[str, str]] = Field(
        default=None,
        alias="nodeSelector",
        description=(
            "NodeSelector is a selector which will result in all pods of the workflow"
            " to be scheduled on the selected node(s). This is able to be overridden by"
            " a nodeSelector specified in the template."
        ),
    )
    on_exit: Optional[str] = Field(
        default=None,
        alias="onExit",
        description=(
            "OnExit is a template reference which is invoked at the end of the"
            " workflow, irrespective of the success, failure, or error of the primary"
            " io.argoproj.workflow.v1alpha1."
        ),
    )
    parallelism: Optional[int] = Field(
        default=None,
        description=(
            "Parallelism limits the max total parallel pods that can execute at the" " same time in a workflow"
        ),
    )
    pod_disruption_budget: Optional[v1beta1.PodDisruptionBudgetSpec] = Field(
        default=None,
        alias="podDisruptionBudget",
        description=(
            "PodDisruptionBudget holds the number of concurrent disruptions that you"
            " allow for Workflow's Pods. Controller will automatically add the selector"
            " with workflow name, if selector is empty. Optional: Defaults to empty."
        ),
    )
    pod_gc: Optional[PodGC] = Field(
        default=None,
        alias="podGC",
        description="PodGC describes the strategy to use when deleting completed pods",
    )
    pod_metadata: Optional[Metadata] = Field(
        default=None,
        alias="podMetadata",
        description=("PodMetadata defines additional metadata that should be applied to workflow" " pods"),
    )
    pod_priority: Optional[int] = Field(
        default=None,
        alias="podPriority",
        description=("Priority to apply to workflow pods. DEPRECATED: Use PodPriorityClassName" " instead."),
    )
    pod_priority_class_name: Optional[str] = Field(
        default=None,
        alias="podPriorityClassName",
        description="PriorityClassName to apply to workflow pods.",
    )
    pod_spec_patch: Optional[str] = Field(
        default=None,
        alias="podSpecPatch",
        description=(
            "PodSpecPatch holds strategic merge patch to apply against the pod spec."
            " Allows parameterization of container fields which are not strings (e.g."
            " resource limits)."
        ),
    )
    priority: Optional[int] = Field(
        default=None,
        description=(
            "Priority is used if controller is configured to process limited number of"
            " workflows in parallel. Workflows with higher priority are processed"
            " first."
        ),
    )
    retry_strategy: Optional[RetryStrategy] = Field(
        default=None,
        alias="retryStrategy",
        description=("RetryStrategy for all templates in the io.argoproj.workflow.v1alpha1."),
    )
    scheduler_name: Optional[str] = Field(
        default=None,
        alias="schedulerName",
        description=(
            "Set scheduler name for all pods. Will be overridden if container/script"
            " template's scheduler name is set. Default scheduler will be used if"
            " neither specified."
        ),
    )
    security_context: Optional[v1.PodSecurityContext] = Field(
        default=None,
        alias="securityContext",
        description=(
            "SecurityContext holds pod-level security attributes and common container"
            " settings. Optional: Defaults to empty.  See type description for default"
            " values of each field."
        ),
    )
    service_account_name: Optional[str] = Field(
        default=None,
        alias="serviceAccountName",
        description=("ServiceAccountName is the name of the ServiceAccount to run all pods of" " the workflow as."),
    )
    shutdown: Optional[str] = Field(
        default=None,
        description=("Shutdown will shutdown the workflow according to its ShutdownStrategy"),
    )
    suspend: Optional[bool] = Field(
        default=None,
        description=("Suspend will suspend the workflow and prevent execution of any future" " steps in the workflow"),
    )
    synchronization: Optional[Synchronization] = Field(
        default=None,
        description=("Synchronization holds synchronization lock configuration for this Workflow"),
    )
    template_defaults: Optional[Template] = Field(
        default=None,
        alias="templateDefaults",
        description=(
            "TemplateDefaults holds default template values that will apply to all"
            " templates in the Workflow, unless overridden on the template-level"
        ),
    )
    templates: Optional[List[Template]] = Field(
        default=None,
        description="Templates is a list of workflow templates used in a workflow",
    )
    tolerations: Optional[List[v1.Toleration]] = Field(
        default=None, description="Tolerations to apply to workflow pods."
    )
    ttl_strategy: Optional[TTLStrategy] = Field(
        default=None,
        alias="ttlStrategy",
        description=(
            "TTLStrategy limits the lifetime of a Workflow that has finished execution"
            " depending on if it Succeeded or Failed. If this struct is set, once the"
            " Workflow finishes, it will be deleted after the time to live expires. If"
            " this field is unset, the controller config map will hold the default"
            " values."
        ),
    )
    volume_claim_gc: Optional[VolumeClaimGC] = Field(
        default=None,
        alias="volumeClaimGC",
        description=("VolumeClaimGC describes the strategy to use when deleting volumes from" " completed workflows"),
    )
    volume_claim_templates: Optional[List[v1.PersistentVolumeClaim]] = Field(
        default=None,
        alias="volumeClaimTemplates",
        description=(
            "VolumeClaimTemplates is a list of claims that containers are allowed to"
            " reference. The Workflow controller will create the claims at the"
            " beginning of the workflow and delete the claims upon completion of the"
            " workflow"
        ),
    )
    volumes: Optional[List[v1.Volume]] = Field(
        default=None,
        description=(
            "Volumes is a list of volumes that can be mounted by containers in a" " io.argoproj.workflow.v1alpha1."
        ),
    )
    workflow_metadata: Optional[WorkflowMetadata] = Field(
        default=None,
        alias="workflowMetadata",
        description=("WorkflowMetadata contains some metadata of the workflow to refer to"),
    )
    workflow_template_ref: Optional[WorkflowTemplateRef] = Field(
        default=None,
        alias="workflowTemplateRef",
        description=("WorkflowTemplateRef holds a reference to a WorkflowTemplate for execution"),
    )


class WorkflowStatus(BaseModel):
    artifact_gc_status: Optional[ArtGCStatus] = Field(
        default=None,
        alias="artifactGCStatus",
        description=("ArtifactGCStatus maintains the status of Artifact Garbage Collection"),
    )
    artifact_repository_ref: Optional[ArtifactRepositoryRefStatus] = Field(
        default=None,
        alias="artifactRepositoryRef",
        description=(
            "ArtifactRepositoryRef is used to cache the repository to use so we do not"
            " need to determine it everytime we reconcile."
        ),
    )
    compressed_nodes: Optional[str] = Field(
        default=None,
        alias="compressedNodes",
        description="Compressed and base64 decoded Nodes map",
    )
    conditions: Optional[List[Condition]] = Field(
        default=None,
        description="Conditions is a list of conditions the Workflow may have",
    )
    estimated_duration: Optional[int] = Field(
        default=None,
        alias="estimatedDuration",
        description="EstimatedDuration in seconds.",
    )
    finished_at: Optional[v1_1.Time] = Field(
        default=None,
        alias="finishedAt",
        description="Time at which this workflow completed",
    )
    message: Optional[str] = Field(
        default=None,
        description=("A human readable message indicating details about why the workflow is in" " this condition."),
    )
    nodes: Optional[Dict[str, NodeStatus]] = Field(
        default=None,
        description="Nodes is a mapping between a node ID and the node's status.",
    )
    offload_node_status_version: Optional[str] = Field(
        default=None,
        alias="offloadNodeStatusVersion",
        description=(
            "Whether on not node status has been offloaded to a database. If exists,"
            " then Nodes and CompressedNodes will be empty. This will actually be"
            " populated with a hash of the offloaded data."
        ),
    )
    outputs: Optional[Outputs] = Field(
        default=None,
        description=(
            "Outputs captures output values and artifact locations produced by the" " workflow via global outputs"
        ),
    )
    persistent_volume_claims: Optional[List[v1.Volume]] = Field(
        default=None,
        alias="persistentVolumeClaims",
        description=(
            "PersistentVolumeClaims tracks all PVCs that were created as part of the"
            " io.argoproj.workflow.v1alpha1. The contents of this list are drained at"
            " the end of the workflow."
        ),
    )
    phase: Optional[str] = Field(
        default=None,
        description=("Phase a simple, high-level summary of where the workflow is in its" " lifecycle."),
    )
    progress: Optional[str] = Field(default=None, description="Progress to completion")
    resources_duration: Optional[Dict[str, int]] = Field(
        default=None,
        alias="resourcesDuration",
        description="ResourcesDuration is the total for the workflow",
    )
    started_at: Optional[v1_1.Time] = Field(
        default=None,
        alias="startedAt",
        description="Time at which this workflow started",
    )
    stored_templates: Optional[Dict[str, Template]] = Field(
        default=None,
        alias="storedTemplates",
        description=("StoredTemplates is a mapping between a template ref and the node's status."),
    )
    stored_workflow_template_spec: Optional[WorkflowSpec] = Field(
        default=None,
        alias="storedWorkflowTemplateSpec",
        description=("StoredWorkflowSpec stores the WorkflowTemplate spec for future execution."),
    )
    synchronization: Optional[SynchronizationStatus] = Field(
        default=None,
        description="Synchronization stores the status of synchronization locks",
    )


class WorkflowStep(BaseModel):
    arguments: Optional[Arguments] = Field(default=None, description="Arguments hold arguments to the template")
    continue_on: Optional[ContinueOn] = Field(
        default=None,
        alias="continueOn",
        description=(
            "ContinueOn makes argo to proceed with the following step even if this step"
            " fails. Errors and Failed states can be specified"
        ),
    )
    hooks: Optional[Dict[str, LifecycleHook]] = Field(
        default=None,
        description=(
            "Hooks holds the lifecycle hook which is invoked at lifecycle of step,"
            " irrespective of the success, failure, or error status of the primary step"
        ),
    )
    inline: Optional[Template] = Field(
        default=None,
        description=("Inline is the template. Template must be empty if this is declared (and" " vice-versa)."),
    )
    name: Optional[str] = Field(default=None, description="Name of the step")
    on_exit: Optional[str] = Field(
        default=None,
        alias="onExit",
        description=(
            "OnExit is a template reference which is invoked at the end of the"
            " template, irrespective of the success, failure, or error of the primary"
            " template. DEPRECATED: Use Hooks[exit].Template instead."
        ),
    )
    template: Optional[str] = Field(
        default=None,
        description="Template is the name of the template to execute as the step",
    )
    template_ref: Optional[TemplateRef] = Field(
        default=None,
        alias="templateRef",
        description=("TemplateRef is the reference to the template resource to execute as the" " step."),
    )
    when: Optional[str] = Field(
        default=None,
        description=("When is an expression in which the step should conditionally execute"),
    )
    with_items: Optional[List[Item]] = Field(
        default=None,
        alias="withItems",
        description=("WithItems expands a step into multiple parallel steps from the items in" " the list"),
    )
    with_param: Optional[str] = Field(
        default=None,
        alias="withParam",
        description=(
            "WithParam expands a step into multiple parallel steps from the value in"
            " the parameter, which is expected to be a JSON list."
        ),
    )
    with_sequence: Optional[Sequence] = Field(
        default=None,
        alias="withSequence",
        description="WithSequence expands a step into a numeric sequence",
    )


class WorkflowTaskSetSpec(BaseModel):
    tasks: Optional[Dict[str, Template]] = None


class WorkflowTemplate(BaseModel):
    api_version: Optional[str] = Field(
        default=None,
        alias="apiVersion",
        description=(
            "APIVersion defines the versioned schema of this representation of an"
            " object. Servers should convert recognized schemas to the latest internal"
            " value, and may reject unrecognized values. More info:"
            " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#resources"
        ),
    )
    kind: Optional[str] = Field(
        default=None,
        description=(
            "Kind is a string value representing the REST resource this object"
            " represents. Servers may infer this from the endpoint the client submits"
            " requests to. Cannot be updated. In CamelCase. More info:"
            " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
        ),
    )
    metadata: v1_1.ObjectMeta
    spec: WorkflowSpec


class WorkflowTemplateCreateRequest(BaseModel):
    create_options: Optional[v1_1.CreateOptions] = Field(default=None, alias="createOptions")
    namespace: Optional[str] = None
    template: Optional[WorkflowTemplate] = None


class WorkflowTemplateLintRequest(BaseModel):
    create_options: Optional[v1_1.CreateOptions] = Field(default=None, alias="createOptions")
    namespace: Optional[str] = None
    template: Optional[WorkflowTemplate] = None


class WorkflowTemplateList(BaseModel):
    api_version: Optional[str] = Field(
        default=None,
        alias="apiVersion",
        description=(
            "APIVersion defines the versioned schema of this representation of an"
            " object. Servers should convert recognized schemas to the latest internal"
            " value, and may reject unrecognized values. More info:"
            " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#resources"
        ),
    )
    items: Optional[List[WorkflowTemplate]] = None
    kind: Optional[str] = Field(
        default=None,
        description=(
            "Kind is a string value representing the REST resource this object"
            " represents. Servers may infer this from the endpoint the client submits"
            " requests to. Cannot be updated. In CamelCase. More info:"
            " https://git.io.k8s.community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
        ),
    )
    metadata: v1_1.ListMeta


class WorkflowTemplateUpdateRequest(BaseModel):
    name: Optional[str] = Field(default=None, description="DEPRECATED: This field is ignored.")
    namespace: Optional[str] = None
    template: Optional[WorkflowTemplate] = None


class WorkflowWatchEvent(BaseModel):
    object: Optional[Workflow] = Field(default=None, title="the workflow")
    type: Optional[str] = Field(default=None, title="the type of change")


ClusterWorkflowTemplate.update_forward_refs()
CreateCronWorkflowRequest.update_forward_refs()
CronWorkflow.update_forward_refs()
CronWorkflowSpec.update_forward_refs()
DAGTask.update_forward_refs()
ParallelSteps.update_forward_refs()
Workflow.update_forward_refs()
