## ABIs of contracts to be used by client

MarginBank = {
  "_format": "hh-sol-artifact-1",
  "contractName": "MarginBank",
  "sourceName": "contracts/MarginBank.sol",
  "abi": [
    {
      "anonymous": False,
      "inputs": [
        {
          "indexed": False,
          "internalType": "enum MarginBank.Action",
          "name": "action",
          "type": "uint8"
        },
        {
          "indexed": True,
          "internalType": "address",
          "name": "srcAddress",
          "type": "address"
        },
        {
          "indexed": True,
          "internalType": "address",
          "name": "destAddress",
          "type": "address"
        },
        {
          "indexed": False,
          "internalType": "uint128",
          "name": "amount",
          "type": "uint128"
        },
        {
          "indexed": False,
          "internalType": "uint128",
          "name": "srcBalance",
          "type": "uint128"
        },
        {
          "indexed": False,
          "internalType": "uint128",
          "name": "destBalance",
          "type": "uint128"
        },
        {
          "indexed": False,
          "internalType": "uint128",
          "name": "timestamp",
          "type": "uint128"
        }
      ],
      "name": "BankBalanceUpdate",
      "type": "event"
    },
    {
      "anonymous": False,
      "inputs": [
        {
          "indexed": True,
          "internalType": "address",
          "name": "account",
          "type": "address"
        },
        {
          "indexed": False,
          "internalType": "address",
          "name": "destination",
          "type": "address"
        },
        {
          "indexed": False,
          "internalType": "uint128",
          "name": "amount",
          "type": "uint128"
        },
        {
          "indexed": False,
          "internalType": "uint128",
          "name": "balance",
          "type": "uint128"
        },
        {
          "indexed": False,
          "internalType": "uint128",
          "name": "timestamp",
          "type": "uint128"
        }
      ],
      "name": "BankTransferToPerpetual",
      "type": "event"
    },
    {
      "anonymous": False,
      "inputs": [
        {
          "indexed": False,
          "internalType": "uint8",
          "name": "version",
          "type": "uint8"
        }
      ],
      "name": "Initialized",
      "type": "event"
    },
    {
      "anonymous": False,
      "inputs": [
        {
          "indexed": False,
          "internalType": "address",
          "name": "operator",
          "type": "address"
        },
        {
          "indexed": False,
          "internalType": "bool",
          "name": "approved",
          "type": "bool"
        }
      ],
      "name": "MarginBankOperatorUpdate",
      "type": "event"
    },
    {
      "anonymous": False,
      "inputs": [
        {
          "indexed": True,
          "internalType": "address",
          "name": "previousOwner",
          "type": "address"
        },
        {
          "indexed": True,
          "internalType": "address",
          "name": "newOwner",
          "type": "address"
        }
      ],
      "name": "OwnershipTransferred",
      "type": "event"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "",
          "type": "address"
        }
      ],
      "name": "bankBalances",
      "outputs": [
        {
          "internalType": "uint128",
          "name": "",
          "type": "uint128"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "",
          "type": "address"
        }
      ],
      "name": "bankOperators",
      "outputs": [
        {
          "internalType": "bool",
          "name": "",
          "type": "bool"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "candidate",
      "outputs": [
        {
          "internalType": "address",
          "name": "",
          "type": "address"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "_account",
          "type": "address"
        },
        {
          "internalType": "uint128",
          "name": "_amount",
          "type": "uint128"
        }
      ],
      "name": "depositToBank",
      "outputs": [
        {
          "internalType": "bool",
          "name": "",
          "type": "bool"
        }
      ],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "_account",
          "type": "address"
        }
      ],
      "name": "getAccountBankBalance",
      "outputs": [
        {
          "internalType": "uint128",
          "name": "",
          "type": "uint128"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "guardianContract",
      "outputs": [
        {
          "internalType": "address",
          "name": "",
          "type": "address"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "_token",
          "type": "address"
        },
        {
          "internalType": "address",
          "name": "_guardian",
          "type": "address"
        }
      ],
      "name": "initialize",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "isWithdrawalAllowed",
      "outputs": [
        {
          "internalType": "bool",
          "name": "",
          "type": "bool"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "owner",
      "outputs": [
        {
          "internalType": "address",
          "name": "",
          "type": "address"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "renounceOwnership",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "_operator",
          "type": "address"
        },
        {
          "internalType": "bool",
          "name": "_approved",
          "type": "bool"
        }
      ],
      "name": "setBankOperator",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "newOwner",
          "type": "address"
        }
      ],
      "name": "setOwner",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "enum Types.GuardianStatus",
          "name": "_newStatus",
          "type": "uint8"
        }
      ],
      "name": "setWithdrawalStatus",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "token",
      "outputs": [
        {
          "internalType": "address",
          "name": "",
          "type": "address"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "_account",
          "type": "address"
        },
        {
          "internalType": "address",
          "name": "_destination",
          "type": "address"
        },
        {
          "internalType": "uint128",
          "name": "_amount",
          "type": "uint128"
        }
      ],
      "name": "transferMarginToAccount",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "updateOwner",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "_destination",
          "type": "address"
        },
        {
          "internalType": "uint128",
          "name": "_amount",
          "type": "uint128"
        }
      ],
      "name": "withdrawFromBank",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    }
  ],
  "bytecode": "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",
  "deployedBytecode": "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",
  "linkReferences": {},
  "deployedLinkReferences": {}
}

Perpetual = {
  "_format": "hh-sol-artifact-1",
  "contractName": "Perpetual",
  "sourceName": "contracts/Perpetual.sol",
  "abi": [
    {
      "anonymous": False,
      "inputs": [
        {
          "indexed": True,
          "internalType": "address",
          "name": "account",
          "type": "address"
        },
        {
          "indexed": False,
          "internalType": "address",
          "name": "sender",
          "type": "address"
        },
        {
          "components": [
            {
              "internalType": "bool",
              "name": "isPosPositive",
              "type": "bool"
            },
            {
              "internalType": "uint128",
              "name": "mro",
              "type": "uint128"
            },
            {
              "internalType": "uint128",
              "name": "qPos",
              "type": "uint128"
            },
            {
              "internalType": "uint128",
              "name": "margin",
              "type": "uint128"
            },
            {
              "internalType": "uint128",
              "name": "oiOpen",
              "type": "uint128"
            }
          ],
          "indexed": False,
          "internalType": "struct Types.PositionBalance",
          "name": "position",
          "type": "tuple"
        },
        {
          "indexed": False,
          "internalType": "enum Perpetual.Action",
          "name": "action",
          "type": "uint8"
        },
        {
          "indexed": False,
          "internalType": "uint128",
          "name": "timestamp",
          "type": "uint128"
        }
      ],
      "name": "AccountPositionUpdate",
      "type": "event"
    },
    {
      "anonymous": False,
      "inputs": [
        {
          "indexed": True,
          "internalType": "address",
          "name": "account",
          "type": "address"
        },
        {
          "components": [
            {
              "internalType": "bool",
              "name": "isPosPositive",
              "type": "bool"
            },
            {
              "internalType": "uint128",
              "name": "mro",
              "type": "uint128"
            },
            {
              "internalType": "uint128",
              "name": "qPos",
              "type": "uint128"
            },
            {
              "internalType": "uint128",
              "name": "margin",
              "type": "uint128"
            },
            {
              "internalType": "uint128",
              "name": "oiOpen",
              "type": "uint128"
            }
          ],
          "indexed": False,
          "internalType": "struct Types.PositionBalance",
          "name": "balance",
          "type": "tuple"
        },
        {
          "indexed": False,
          "internalType": "bool",
          "name": "settlementIsPositive",
          "type": "bool"
        },
        {
          "indexed": False,
          "internalType": "uint128",
          "name": "settlementAmount",
          "type": "uint128"
        },
        {
          "indexed": False,
          "internalType": "uint128",
          "name": "price",
          "type": "uint128"
        },
        {
          "indexed": False,
          "internalType": "int256",
          "name": "fundingRate",
          "type": "int256"
        },
        {
          "indexed": False,
          "internalType": "uint128",
          "name": "timestamp",
          "type": "uint128"
        }
      ],
      "name": "AccountSettlementUpdate",
      "type": "event"
    },
    {
      "anonymous": False,
      "inputs": [
        {
          "indexed": False,
          "internalType": "uint128",
          "name": "defaultMakerFee",
          "type": "uint128"
        }
      ],
      "name": "DefaultMakerFeeUpdate",
      "type": "event"
    },
    {
      "anonymous": False,
      "inputs": [
        {
          "indexed": False,
          "internalType": "uint128",
          "name": "defaultTakerFee",
          "type": "uint128"
        }
      ],
      "name": "DefaultTakerFeeUpdate",
      "type": "event"
    },
    {
      "anonymous": False,
      "inputs": [
        {
          "indexed": False,
          "internalType": "address",
          "name": "feePool",
          "type": "address"
        }
      ],
      "name": "FeePoolUpdate",
      "type": "event"
    },
    {
      "anonymous": False,
      "inputs": [
        {
          "indexed": False,
          "internalType": "address",
          "name": "funder",
          "type": "address"
        }
      ],
      "name": "FundingOracleUpdate",
      "type": "event"
    },
    {
      "anonymous": False,
      "inputs": [
        {
          "indexed": False,
          "internalType": "int256",
          "name": "",
          "type": "int256"
        },
        {
          "indexed": False,
          "internalType": "uint128",
          "name": "",
          "type": "uint128"
        }
      ],
      "name": "GlobalIndexUpdate",
      "type": "event"
    },
    {
      "anonymous": False,
      "inputs": [
        {
          "indexed": False,
          "internalType": "int256",
          "name": "initialMargin",
          "type": "int256"
        }
      ],
      "name": "IMRUpdate",
      "type": "event"
    },
    {
      "anonymous": False,
      "inputs": [
        {
          "indexed": False,
          "internalType": "uint8",
          "name": "version",
          "type": "uint8"
        }
      ],
      "name": "Initialized",
      "type": "event"
    },
    {
      "anonymous": False,
      "inputs": [
        {
          "indexed": False,
          "internalType": "int256",
          "name": "maintenanceMargin",
          "type": "int256"
        }
      ],
      "name": "MMRUpdate",
      "type": "event"
    },
    {
      "anonymous": False,
      "inputs": [
        {
          "indexed": False,
          "internalType": "address",
          "name": "marginBank",
          "type": "address"
        }
      ],
      "name": "MarginBankUpdate",
      "type": "event"
    },
    {
      "anonymous": False,
      "inputs": [
        {
          "indexed": False,
          "internalType": "address",
          "name": "provider",
          "type": "address"
        }
      ],
      "name": "OffchainFROperatorUpdate",
      "type": "event"
    },
    {
      "anonymous": False,
      "inputs": [
        {
          "indexed": True,
          "internalType": "address",
          "name": "previousOwner",
          "type": "address"
        },
        {
          "indexed": True,
          "internalType": "address",
          "name": "newOwner",
          "type": "address"
        }
      ],
      "name": "OwnershipTransferred",
      "type": "event"
    },
    {
      "anonymous": False,
      "inputs": [
        {
          "indexed": False,
          "internalType": "uint128",
          "name": "settlementPrice",
          "type": "uint128"
        }
      ],
      "name": "PerpetualDelisted",
      "type": "event"
    },
    {
      "anonymous": False,
      "inputs": [
        {
          "indexed": True,
          "internalType": "address",
          "name": "account",
          "type": "address"
        },
        {
          "indexed": False,
          "internalType": "uint128",
          "name": "amount",
          "type": "uint128"
        },
        {
          "indexed": False,
          "internalType": "uint128",
          "name": "timestamp",
          "type": "uint128"
        }
      ],
      "name": "PositionClosed",
      "type": "event"
    },
    {
      "anonymous": False,
      "inputs": [
        {
          "indexed": False,
          "internalType": "address",
          "name": "oracle",
          "type": "address"
        }
      ],
      "name": "PriceOracleUpdate",
      "type": "event"
    },
    {
      "anonymous": False,
      "inputs": [
        {
          "indexed": False,
          "internalType": "address",
          "name": "operator",
          "type": "address"
        },
        {
          "indexed": False,
          "internalType": "bool",
          "name": "approved",
          "type": "bool"
        }
      ],
      "name": "SettlementOperatorUpdate",
      "type": "event"
    },
    {
      "anonymous": False,
      "inputs": [
        {
          "indexed": True,
          "internalType": "address",
          "name": "sender",
          "type": "address"
        },
        {
          "indexed": False,
          "internalType": "address",
          "name": "operator",
          "type": "address"
        },
        {
          "indexed": False,
          "internalType": "bool",
          "name": "approved",
          "type": "bool"
        }
      ],
      "name": "SubAccountUpdate",
      "type": "event"
    },
    {
      "anonymous": False,
      "inputs": [
        {
          "indexed": False,
          "internalType": "address",
          "name": "tradeContract",
          "type": "address"
        },
        {
          "indexed": False,
          "internalType": "bool",
          "name": "approved",
          "type": "bool"
        }
      ],
      "name": "TradeContractUpdate",
      "type": "event"
    },
    {
      "anonymous": False,
      "inputs": [
        {
          "indexed": False,
          "internalType": "address",
          "name": "trader",
          "type": "address"
        },
        {
          "indexed": True,
          "internalType": "address",
          "name": "maker",
          "type": "address"
        },
        {
          "indexed": True,
          "internalType": "address",
          "name": "taker",
          "type": "address"
        },
        {
          "indexed": False,
          "internalType": "bytes32",
          "name": "makerOrderHash",
          "type": "bytes32"
        },
        {
          "indexed": False,
          "internalType": "bytes32",
          "name": "takerOrderHash",
          "type": "bytes32"
        },
        {
          "indexed": False,
          "internalType": "uint128",
          "name": "makerMRO",
          "type": "uint128"
        },
        {
          "indexed": False,
          "internalType": "uint128",
          "name": "takerMRO",
          "type": "uint128"
        },
        {
          "indexed": False,
          "internalType": "uint128",
          "name": "makerFee",
          "type": "uint128"
        },
        {
          "indexed": False,
          "internalType": "uint128",
          "name": "takerFee",
          "type": "uint128"
        },
        {
          "indexed": False,
          "internalType": "int256",
          "name": "makerPnl",
          "type": "int256"
        },
        {
          "indexed": False,
          "internalType": "int256",
          "name": "takerPnl",
          "type": "int256"
        },
        {
          "indexed": False,
          "internalType": "uint128",
          "name": "tradeQuantity",
          "type": "uint128"
        },
        {
          "indexed": False,
          "internalType": "uint128",
          "name": "price",
          "type": "uint128"
        },
        {
          "indexed": False,
          "internalType": "bool",
          "name": "isBuy",
          "type": "bool"
        },
        {
          "indexed": False,
          "internalType": "uint128",
          "name": "timestamp",
          "type": "uint128"
        }
      ],
      "name": "TradeExecuted",
      "type": "event"
    },
    {
      "anonymous": False,
      "inputs": [
        {
          "indexed": False,
          "internalType": "uint128",
          "name": "startTime",
          "type": "uint128"
        }
      ],
      "name": "TradingStarted",
      "type": "event"
    },
    {
      "anonymous": False,
      "inputs": [
        {
          "indexed": False,
          "internalType": "uint128",
          "name": "stopTime",
          "type": "uint128"
        }
      ],
      "name": "TradingStopped",
      "type": "event"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "_account",
          "type": "address"
        },
        {
          "internalType": "uint128",
          "name": "_amount",
          "type": "uint128"
        }
      ],
      "name": "addMargin",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "addresses",
      "outputs": [
        {
          "internalType": "address",
          "name": "marginMath",
          "type": "address"
        },
        {
          "internalType": "address",
          "name": "oracle",
          "type": "address"
        },
        {
          "internalType": "address",
          "name": "funder",
          "type": "address"
        },
        {
          "internalType": "address",
          "name": "marginBank",
          "type": "address"
        },
        {
          "internalType": "address",
          "name": "evaluator",
          "type": "address"
        },
        {
          "internalType": "address",
          "name": "feePool",
          "type": "address"
        },
        {
          "internalType": "address",
          "name": "guardian",
          "type": "address"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "_account",
          "type": "address"
        },
        {
          "internalType": "uint128",
          "name": "_leverage",
          "type": "uint128"
        }
      ],
      "name": "adjustLeverage",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "candidate",
      "outputs": [
        {
          "internalType": "address",
          "name": "",
          "type": "address"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "_account",
          "type": "address"
        }
      ],
      "name": "closePosition",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "defaultMakerFee",
      "outputs": [
        {
          "internalType": "uint128",
          "name": "",
          "type": "uint128"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "defaultTakerFee",
      "outputs": [
        {
          "internalType": "uint128",
          "name": "",
          "type": "uint128"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "uint128",
          "name": "_priceLowerBound",
          "type": "uint128"
        },
        {
          "internalType": "uint128",
          "name": "_priceUpperBound",
          "type": "uint128"
        }
      ],
      "name": "delistPerpetual",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "delisted",
      "outputs": [
        {
          "internalType": "bool",
          "name": "",
          "type": "bool"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "delistingPrice",
      "outputs": [
        {
          "internalType": "uint128",
          "name": "",
          "type": "uint128"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "account",
          "type": "address"
        }
      ],
      "name": "getAccountBalance",
      "outputs": [
        {
          "components": [
            {
              "internalType": "bool",
              "name": "isPosPositive",
              "type": "bool"
            },
            {
              "internalType": "uint128",
              "name": "mro",
              "type": "uint128"
            },
            {
              "internalType": "uint128",
              "name": "qPos",
              "type": "uint128"
            },
            {
              "internalType": "uint128",
              "name": "margin",
              "type": "uint128"
            },
            {
              "internalType": "uint128",
              "name": "oiOpen",
              "type": "uint128"
            }
          ],
          "internalType": "struct Types.PositionBalance",
          "name": "",
          "type": "tuple"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "account",
          "type": "address"
        },
        {
          "internalType": "address",
          "name": "operator",
          "type": "address"
        }
      ],
      "name": "getIsSubAccount",
      "outputs": [
        {
          "internalType": "bool",
          "name": "",
          "type": "bool"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "globalIndex",
      "outputs": [
        {
          "internalType": "uint128",
          "name": "timestamp",
          "type": "uint128"
        },
        {
          "internalType": "int256",
          "name": "value",
          "type": "int256"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "account",
          "type": "address"
        },
        {
          "internalType": "address",
          "name": "operator",
          "type": "address"
        }
      ],
      "name": "hasAccountPermissions",
      "outputs": [
        {
          "internalType": "bool",
          "name": "",
          "type": "bool"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "initialMarginRequired",
      "outputs": [
        {
          "internalType": "int256",
          "name": "",
          "type": "int256"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "string",
          "name": "_marketName",
          "type": "string"
        },
        {
          "components": [
            {
              "internalType": "address",
              "name": "marginMath",
              "type": "address"
            },
            {
              "internalType": "address",
              "name": "oracle",
              "type": "address"
            },
            {
              "internalType": "address",
              "name": "funder",
              "type": "address"
            },
            {
              "internalType": "address",
              "name": "marginBank",
              "type": "address"
            },
            {
              "internalType": "address",
              "name": "evaluator",
              "type": "address"
            },
            {
              "internalType": "address",
              "name": "feePool",
              "type": "address"
            },
            {
              "internalType": "address",
              "name": "guardian",
              "type": "address"
            }
          ],
          "internalType": "struct IPerpetual.Addresses",
          "name": "_addresses",
          "type": "tuple"
        },
        {
          "internalType": "address",
          "name": "_trustedForwarder",
          "type": "address"
        },
        {
          "internalType": "int256",
          "name": "_initialMargin",
          "type": "int256"
        },
        {
          "internalType": "int256",
          "name": "_maintenanceMargin",
          "type": "int256"
        },
        {
          "internalType": "uint128",
          "name": "_defaultMakerFee",
          "type": "uint128"
        },
        {
          "internalType": "uint128",
          "name": "_defaultTakerFee",
          "type": "uint128"
        }
      ],
      "name": "initialize",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "isTradingAllowed",
      "outputs": [
        {
          "internalType": "bool",
          "name": "",
          "type": "bool"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "forwarder",
          "type": "address"
        }
      ],
      "name": "isTrustedForwarder",
      "outputs": [
        {
          "internalType": "bool",
          "name": "",
          "type": "bool"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "maintenanceMarginRequired",
      "outputs": [
        {
          "internalType": "int256",
          "name": "",
          "type": "int256"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "marketName",
      "outputs": [
        {
          "internalType": "string",
          "name": "",
          "type": "string"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "msgSender",
      "outputs": [
        {
          "internalType": "address payable",
          "name": "ret",
          "type": "address"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "owner",
      "outputs": [
        {
          "internalType": "address",
          "name": "",
          "type": "address"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "_account",
          "type": "address"
        },
        {
          "internalType": "uint128",
          "name": "_amount",
          "type": "uint128"
        }
      ],
      "name": "removeMargin",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "renounceOwnership",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "uint128",
          "name": "_defaultMakerFee",
          "type": "uint128"
        }
      ],
      "name": "setDefaultMakerFee",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "uint128",
          "name": "_defaultTakerFee",
          "type": "uint128"
        }
      ],
      "name": "setDefaultTakerFee",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "_feePool",
          "type": "address"
        }
      ],
      "name": "setFeePool",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "_funder",
          "type": "address"
        }
      ],
      "name": "setFunder",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "setFundingRate",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "int256",
          "name": "_initialMargin",
          "type": "int256"
        }
      ],
      "name": "setInitialMargin",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "int256",
          "name": "_maintenanceMargin",
          "type": "int256"
        }
      ],
      "name": "setMaintenanceMargin",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "_marginBank",
          "type": "address"
        }
      ],
      "name": "setMarginBank",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "_newOperator",
          "type": "address"
        }
      ],
      "name": "setOffChainFROperator",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "int256",
          "name": "offchainFundingRate",
          "type": "int256"
        }
      ],
      "name": "setOffChainFundingRate",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "_oracle",
          "type": "address"
        }
      ],
      "name": "setOracle",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "newOwner",
          "type": "address"
        }
      ],
      "name": "setOwner",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "_operator",
          "type": "address"
        },
        {
          "internalType": "bool",
          "name": "_approved",
          "type": "bool"
        }
      ],
      "name": "setSettlementOperator",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "_operator",
          "type": "address"
        },
        {
          "internalType": "bool",
          "name": "_approved",
          "type": "bool"
        }
      ],
      "name": "setSubAccount",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "_trader",
          "type": "address"
        },
        {
          "internalType": "bool",
          "name": "_approved",
          "type": "bool"
        }
      ],
      "name": "setTradeContract",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "enum Types.GuardianStatus",
          "name": "_newStatus",
          "type": "uint8"
        }
      ],
      "name": "setTradingStatus",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "",
          "type": "address"
        }
      ],
      "name": "settlementOperators",
      "outputs": [
        {
          "internalType": "bool",
          "name": "",
          "type": "bool"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "uint128",
          "name": "_startingTime",
          "type": "uint128"
        }
      ],
      "name": "startTrading",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "stopTrading",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address[]",
          "name": "_accounts",
          "type": "address[]"
        },
        {
          "components": [
            {
              "internalType": "uint128",
              "name": "takerIndex",
              "type": "uint128"
            },
            {
              "internalType": "uint128",
              "name": "makerIndex",
              "type": "uint128"
            },
            {
              "internalType": "address",
              "name": "trader",
              "type": "address"
            },
            {
              "internalType": "bytes",
              "name": "data",
              "type": "bytes"
            }
          ],
          "internalType": "struct IPerpetual.TradeArg[]",
          "name": "_trades",
          "type": "tuple[]"
        },
        {
          "internalType": "uint128",
          "name": "gasCharges",
          "type": "uint128"
        }
      ],
      "name": "trade",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "",
          "type": "address"
        }
      ],
      "name": "tradeContracts",
      "outputs": [
        {
          "internalType": "bool",
          "name": "",
          "type": "bool"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "tradingStartTime",
      "outputs": [
        {
          "internalType": "uint128",
          "name": "",
          "type": "uint128"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "trustedForwarder",
      "outputs": [
        {
          "internalType": "address",
          "name": "",
          "type": "address"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "updateOwner",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    }
  ]
}

USDC = {
  "_format": "hh-sol-artifact-1",
  "contractName": "DummyUSDC",
  "sourceName": "contracts/mock/DummyUSDC.sol",
  "abi": [
    {
      "inputs": [
        {
          "internalType": "string",
          "name": "_name",
          "type": "string"
        },
        {
          "internalType": "string",
          "name": "_symbol",
          "type": "string"
        },
        {
          "internalType": "uint128",
          "name": "_initialSupply",
          "type": "uint128"
        }
      ],
      "stateMutability": "nonpayable",
      "type": "constructor"
    },
    {
      "anonymous": False,
      "inputs": [
        {
          "indexed": True,
          "internalType": "address",
          "name": "owner",
          "type": "address"
        },
        {
          "indexed": True,
          "internalType": "address",
          "name": "spender",
          "type": "address"
        },
        {
          "indexed": False,
          "internalType": "uint256",
          "name": "value",
          "type": "uint256"
        }
      ],
      "name": "Approval",
      "type": "event"
    },
    {
      "anonymous": False,
      "inputs": [
        {
          "indexed": True,
          "internalType": "address",
          "name": "from",
          "type": "address"
        },
        {
          "indexed": True,
          "internalType": "address",
          "name": "to",
          "type": "address"
        },
        {
          "indexed": False,
          "internalType": "uint256",
          "name": "value",
          "type": "uint256"
        }
      ],
      "name": "Transfer",
      "type": "event"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "owner",
          "type": "address"
        },
        {
          "internalType": "address",
          "name": "spender",
          "type": "address"
        }
      ],
      "name": "allowance",
      "outputs": [
        {
          "internalType": "uint256",
          "name": "",
          "type": "uint256"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "spender",
          "type": "address"
        },
        {
          "internalType": "uint256",
          "name": "amount",
          "type": "uint256"
        }
      ],
      "name": "approve",
      "outputs": [
        {
          "internalType": "bool",
          "name": "",
          "type": "bool"
        }
      ],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "account",
          "type": "address"
        }
      ],
      "name": "balanceOf",
      "outputs": [
        {
          "internalType": "uint256",
          "name": "",
          "type": "uint256"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "decimals",
      "outputs": [
        {
          "internalType": "uint8",
          "name": "",
          "type": "uint8"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "spender",
          "type": "address"
        },
        {
          "internalType": "uint256",
          "name": "subtractedValue",
          "type": "uint256"
        }
      ],
      "name": "decreaseAllowance",
      "outputs": [
        {
          "internalType": "bool",
          "name": "",
          "type": "bool"
        }
      ],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "spender",
          "type": "address"
        },
        {
          "internalType": "uint256",
          "name": "addedValue",
          "type": "uint256"
        }
      ],
      "name": "increaseAllowance",
      "outputs": [
        {
          "internalType": "bool",
          "name": "",
          "type": "bool"
        }
      ],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "_recipient",
          "type": "address"
        },
        {
          "internalType": "uint128",
          "name": "_amount",
          "type": "uint128"
        }
      ],
      "name": "mint",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "name",
      "outputs": [
        {
          "internalType": "string",
          "name": "",
          "type": "string"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "symbol",
      "outputs": [
        {
          "internalType": "string",
          "name": "",
          "type": "string"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "totalSupply",
      "outputs": [
        {
          "internalType": "uint256",
          "name": "",
          "type": "uint256"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "to",
          "type": "address"
        },
        {
          "internalType": "uint256",
          "name": "amount",
          "type": "uint256"
        }
      ],
      "name": "transfer",
      "outputs": [
        {
          "internalType": "bool",
          "name": "",
          "type": "bool"
        }
      ],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "from",
          "type": "address"
        },
        {
          "internalType": "address",
          "name": "to",
          "type": "address"
        },
        {
          "internalType": "uint256",
          "name": "amount",
          "type": "uint256"
        }
      ],
      "name": "transferFrom",
      "outputs": [
        {
          "internalType": "bool",
          "name": "",
          "type": "bool"
        }
      ],
      "stateMutability": "nonpayable",
      "type": "function"
    }
  ],
  "bytecode": "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",
  "deployedBytecode": "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",
  "linkReferences": {},
  "deployedLinkReferences": {}
}
