
'''List of automatic COCOS transformations

-------
'''
# COCOS signals candidates are generated by running utilities/generate_cocos_signals.py
# Running this script is useful to keep track of new signals that IMAS adds in new data structure releases
#
# In this file you are only allowed to edit/add entries to the `_cocos_signals` dictionary
# The comments indicate `#[ADD_OR_DELETE_SUGGESTION]# MATCHING_SCORE # RATIONALE_FOR_ADD_OR_DELETE`
#
# Proceed as follows:
# 1. Edit transformations in this file (if a signal is missing, it can be added here)
# 2. Run `utilities/generate_cocos_signals.py` (which will update this same file)
# 3. Commit changes
#
# Valid transformations are defined in the `cocos_transform()` function and they are:
#
#        transforms = {}
#        transforms['1/PSI'] = sigma_Ip_eff * sigma_Bp_eff / (2 * numpy.pi) ** exp_Bp_eff
#        transforms['invPSI'] = transforms['1/PSI']
#        transforms['dPSI'] = transforms['1/PSI']
#        transforms['F_FPRIME'] = transforms['dPSI']
#        transforms['PPRIME'] = transforms['dPSI']
#        transforms['PSI'] = sigma_Ip_eff * sigma_Bp_eff * (2 * numpy.pi) ** exp_Bp_eff
#        transforms['Q'] = sigma_Ip_eff * sigma_B0_eff * sigma_rhotp_eff
#        transforms['TOR'] = sigma_B0_eff
#        transforms['BT'] = transforms['TOR']
#        transforms['IP'] = transforms['TOR']
#        transforms['F'] = transforms['TOR']
#        transforms['POL'] = sigma_B0_eff * sigma_rhotp_eff
#        transforms['BP'] = transforms['POL']
#        transforms[None] = 1
#
                
_cocos_signals = {}


# AMNS_DATA

# BAROMETRY
_cocos_signals['barometry.gauge.:.position.phi']='TOR'                               # 2.000000 # phi  [rad]

# BOLOMETER
_cocos_signals['bolometer.channel.:.aperture.:.centre.phi']='TOR'                        # 2.000000 # phi  [rad]
_cocos_signals['bolometer.channel.:.detector.centre.phi']='TOR'                          # 2.000000 # phi  [rad]
_cocos_signals['bolometer.channel.:.line_of_sight.first_point.phi']='TOR'                # 2.000000 # phi  [rad]
_cocos_signals['bolometer.channel.:.line_of_sight.second_point.phi']='TOR'               # 2.000000 # phi  [rad]
_cocos_signals['bolometer.channel.:.line_of_sight.third_point.phi']='TOR'                # 2.000000 # phi  [rad]

# BREMSSTRAHLUNG_VISIBLE
_cocos_signals['bremsstrahlung_visible.channel.:.line_of_sight.first_point.phi']='?'           #[ADD?]# 2.000000 # phi  [rad]
_cocos_signals['bremsstrahlung_visible.channel.:.line_of_sight.second_point.phi']='?'          #[ADD?]# 2.000000 # phi  [rad]

# CALORIMETRY

# CAMERA_IR

# CAMERA_VISIBLE
_cocos_signals['camera_visible.channel.:.aperture.:.centre.phi']='?'                                 #[ADD?]# 2.000000 # phi  [rad]
_cocos_signals['camera_visible.channel.:.detector.:.geometry_matrix.emission_grid.phi']='?'          #[ADD?]# 2.000000 # phi  [rad]

# CHARGE_EXCHANGE
_cocos_signals['charge_exchange.channel.:.ion.:.velocity_pol.data']='?'                                 #[ADD?]# 2.666667 # velocity  _pol  [m.s^-1]
_cocos_signals['charge_exchange.channel.:.ion.:.velocity_tor.data']='?'                                 #[ADD?]# 2.666667 # velocity  _tor  [m.s^-1]
_cocos_signals['charge_exchange.channel.:.momentum_tor.data']='?'                                       #[ADD?]# 2.500000 # momentum  _tor  [kg.m^-1.s^-1]
_cocos_signals['charge_exchange.aperture.centre.phi']='TOR'                                                    # 2.000000 # phi  [rad]
_cocos_signals['charge_exchange.channel.:.position.phi.data']='?'                                       #[ADD?]# 1.800000 # phi  [rad]

# COILS_NON_AXISYMMETRIC
_cocos_signals['coils_non_axisymmetric.coil.:.conductor.:.elements.centres.phi']='TOR'                           # 2.000000 # phi  [rad]
_cocos_signals['coils_non_axisymmetric.coil.:.conductor.:.elements.end_points.phi']='TOR'                        # 2.000000 # phi  [rad]
_cocos_signals['coils_non_axisymmetric.coil.:.conductor.:.elements.intermediate_points.phi']='TOR'               # 2.000000 # phi  [rad]
_cocos_signals['coils_non_axisymmetric.coil.:.conductor.:.elements.start_points.phi']='TOR'                      # 2.000000 # phi  [rad]
_cocos_signals['coils_non_axisymmetric.coil.:.conductor.:.current.data']='?'                              #[ADD?]# 1.833333 # current  [A]
_cocos_signals['coils_non_axisymmetric.coil.:.current.data']='?'                                          #[ADD?]# 1.750000 # current  [A]

# CONTROLLERS

# CORE_INSTANT_CHANGES
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.e_field_parallel']='?'                                                 #[ADD?]# 3.000000 # e_field  parallel  [V.m^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.electrons.velocity_pol']='?'                                           #[ADD?]# 3.000000 # velocity  _pol  [m.s^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.electrons.velocity_tor']='?'                                           #[ADD?]# 3.000000 # velocity  _tor  [m.s^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.ion.:.velocity_pol']='?'                                               #[ADD?]# 3.000000 # velocity  _pol  [m.s^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.ion.:.velocity_tor']='?'                                               #[ADD?]# 3.000000 # velocity  _tor  [m.s^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.j_tor']='?'                                                            #[ADD?]# 3.000000 # j  _tor  [A/m^2]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.momentum_tor']='?'                                                     #[ADD?]# 3.000000 # momentum  _tor  [kg.m^-1.s^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.ion.:.state.:.velocity.parallel']='?'                                  #[ADD?]# 2.900000 # velocity  parallel  [m.s^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.ion.:.state.:.velocity.poloidal']='?'                                  #[ADD?]# 2.900000 # velocity  poloidal  [m.s^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.ion.:.state.:.velocity.toroidal']='?'                                  #[ADD?]# 2.900000 # velocity  toroidal  [m.s^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.neutral.:.state.:.velocity.parallel']='?'                              #[ADD?]# 2.900000 # velocity  parallel  [m.s^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.neutral.:.state.:.velocity.poloidal']='?'                              #[ADD?]# 2.900000 # velocity  poloidal  [m.s^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.neutral.:.state.:.velocity.toroidal']='?'                              #[ADD?]# 2.900000 # velocity  toroidal  [m.s^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.ion.:.velocity.parallel']='?'                                          #[ADD?]# 2.875000 # velocity  parallel  [m.s^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.ion.:.velocity.poloidal']='?'                                          #[ADD?]# 2.875000 # velocity  poloidal  [m.s^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.ion.:.velocity.toroidal']='?'                                          #[ADD?]# 2.875000 # velocity  toroidal  [m.s^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.neutral.:.velocity.parallel']='?'                                      #[ADD?]# 2.875000 # velocity  parallel  [m.s^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.neutral.:.velocity.poloidal']='?'                                      #[ADD?]# 2.875000 # velocity  poloidal  [m.s^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.neutral.:.velocity.toroidal']='?'                                      #[ADD?]# 2.875000 # velocity  toroidal  [m.s^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.electrons.velocity.parallel']='?'                                      #[ADD?]# 2.857143 # velocity  parallel  [m.s^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.electrons.velocity.poloidal']='?'                                      #[ADD?]# 2.857143 # velocity  poloidal  [m.s^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.electrons.velocity.toroidal']='?'                                      #[ADD?]# 2.857143 # velocity  toroidal  [m.s^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.e_field.parallel']='?'                                                 #[ADD?]# 2.833333 # e_field  parallel  [V.m^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.e_field.poloidal']='?'                                                 #[ADD?]# 2.833333 # e_field  poloidal  [V.m^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.e_field.toroidal']='?'                                                 #[ADD?]# 2.833333 # e_field  toroidal  [V.m^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.current_parallel_inside']='?'                                          #[ADD?]# 2.000000 # current  [A]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.grid.psi']='PSI'                                                              # 2.000000 # psi  [Wb]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.grid.psi_boundary']='?'                                                #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.grid.psi_magnetic_axis']='?'                                           #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.ion.:.rotation_frequency_tor']='?'                                     #[ADD?]# 2.000000 # _tor  [rad.s^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.ion.:.state.:.rotation_frequency_tor']='?'                             #[ADD?]# 2.000000 # _tor  [rad.s^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.j_bootstrap']='?'                                                      #[ADD?]# 2.000000 # j  [A/m^2]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.j_non_inductive']='?'                                                  #[ADD?]# 2.000000 # j  [A/m^2]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.j_ohmic']='?'                                                          #[ADD?]# 2.000000 # j  [A/m^2]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.j_total']='?'                                                          #[ADD?]# 2.000000 # j  [A/m^2]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.phi_potential']='?'                                                    #[ADD?]# 2.000000 # phi  [V]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.q']='Q'                                                                       # 2.000000 # q  [-]
_cocos_signals['core_instant_changes.vacuum_toroidal_field.b0']='TOR'                                                                     # 2.000000 # b0  [T]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.ion.:.state.:.velocity.diamagnetic']='?'                               #[ADD?]# 1.900000 # velocity  [m.s^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.neutral.:.state.:.velocity.diamagnetic']='?'                           #[ADD?]# 1.900000 # velocity  [m.s^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.ion.:.velocity.diamagnetic']='?'                                       #[ADD?]# 1.875000 # velocity  [m.s^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.neutral.:.velocity.diamagnetic']='?'                                   #[ADD?]# 1.875000 # velocity  [m.s^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.electrons.velocity.diamagnetic']='?'                                   #[ADD?]# 1.857143 # velocity  [m.s^-1]
_cocos_signals['core_instant_changes.change.:.profiles_1d.:.e_field.diamagnetic']='?'                                              #[ADD?]# 1.833333 # e_field  [V.m^-1]

# CORE_PROFILES
_cocos_signals['core_profiles.profiles_1d.:.e_field_parallel']='TOR'                                                      # 3.000000 # e_field  parallel  [V.m^-1]
_cocos_signals['core_profiles.profiles_1d.:.electrons.velocity_pol']='POL'                                                # 3.000000 # velocity  _pol  [m.s^-1]
_cocos_signals['core_profiles.profiles_1d.:.electrons.velocity_tor']='TOR'                                                # 3.000000 # velocity  _tor  [m.s^-1]
_cocos_signals['core_profiles.profiles_1d.:.ion.:.velocity_pol']='POL'                                                    # 3.000000 # velocity  _pol  [m.s^-1]
_cocos_signals['core_profiles.profiles_1d.:.ion.:.velocity_tor']='TOR'                                                    # 3.000000 # velocity  _tor  [m.s^-1]
_cocos_signals['core_profiles.profiles_1d.:.j_tor']='TOR'                                                                 # 3.000000 # j  _tor  [A/m^2]
_cocos_signals['core_profiles.profiles_1d.:.momentum_tor']='TOR'                                                          # 3.000000 # momentum  _tor  [kg.m^-1.s^-1]
_cocos_signals['core_profiles.profiles_1d.:.ion.:.state.:.velocity.parallel']='TOR'                                       # 2.875000 # velocity  parallel  [m.s^-1]
_cocos_signals['core_profiles.profiles_1d.:.ion.:.state.:.velocity.poloidal']='POL'                                       # 2.875000 # velocity  poloidal  [m.s^-1]
_cocos_signals['core_profiles.profiles_1d.:.ion.:.state.:.velocity.toroidal']='TOR'                                       # 2.875000 # velocity  toroidal  [m.s^-1]
_cocos_signals['core_profiles.profiles_1d.:.neutral.:.state.:.velocity.parallel']='TOR'                                   # 2.875000 # velocity  parallel  [m.s^-1]
_cocos_signals['core_profiles.profiles_1d.:.neutral.:.state.:.velocity.poloidal']='POL'                                   # 2.875000 # velocity  poloidal  [m.s^-1]
_cocos_signals['core_profiles.profiles_1d.:.neutral.:.state.:.velocity.toroidal']='TOR'                                   # 2.875000 # velocity  toroidal  [m.s^-1]
_cocos_signals['core_profiles.profiles_1d.:.ion.:.velocity.parallel']='TOR'                                               # 2.833333 # velocity  parallel  [m.s^-1]
_cocos_signals['core_profiles.profiles_1d.:.ion.:.velocity.poloidal']='POL'                                               # 2.833333 # velocity  poloidal  [m.s^-1]
_cocos_signals['core_profiles.profiles_1d.:.ion.:.velocity.toroidal']='TOR'                                               # 2.833333 # velocity  toroidal  [m.s^-1]
_cocos_signals['core_profiles.profiles_1d.:.neutral.:.velocity.parallel']='TOR'                                           # 2.833333 # velocity  parallel  [m.s^-1]
_cocos_signals['core_profiles.profiles_1d.:.neutral.:.velocity.poloidal']='POL'                                           # 2.833333 # velocity  poloidal  [m.s^-1]
_cocos_signals['core_profiles.profiles_1d.:.neutral.:.velocity.toroidal']='TOR'                                           # 2.833333 # velocity  toroidal  [m.s^-1]
_cocos_signals['core_profiles.profiles_1d.:.electrons.velocity.parallel']='TOR'                                           # 2.800000 # velocity  parallel  [m.s^-1]
_cocos_signals['core_profiles.profiles_1d.:.electrons.velocity.poloidal']='POL'                                           # 2.800000 # velocity  poloidal  [m.s^-1]
_cocos_signals['core_profiles.profiles_1d.:.electrons.velocity.toroidal']='TOR'                                           # 2.800000 # velocity  toroidal  [m.s^-1]
_cocos_signals['core_profiles.profiles_1d.:.e_field.parallel']='TOR'                                                      # 2.750000 # e_field  parallel  [V.m^-1]
_cocos_signals['core_profiles.profiles_1d.:.e_field.poloidal']='POL'                                                      # 2.750000 # e_field  poloidal  [V.m^-1]
_cocos_signals['core_profiles.profiles_1d.:.e_field.toroidal']='TOR'                                                      # 2.750000 # e_field  toroidal  [V.m^-1]
_cocos_signals['core_profiles.global_quantities.current_bootstrap']='TOR'                                                 # 2.000000 # current  [A]
_cocos_signals['core_profiles.global_quantities.current_non_inductive']='TOR'                                             # 2.000000 # current  [A]
_cocos_signals['core_profiles.global_quantities.ip']='TOR'                                                                # 2.000000 # ip  [A]
_cocos_signals['core_profiles.global_quantities.v_loop']='TOR'                                                            # 2.000000 # v  [V]
_cocos_signals['core_profiles.profiles_1d.:.current_parallel_inside']='TOR'                                               # 2.000000 # current  [A]
_cocos_signals['core_profiles.profiles_1d.:.grid.psi']='PSI'                                                              # 2.000000 # psi  [Wb]
_cocos_signals['core_profiles.profiles_1d.:.grid.psi_boundary']='?'                                                #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['core_profiles.profiles_1d.:.grid.psi_magnetic_axis']='?'                                           #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['core_profiles.profiles_1d.:.ion.:.rotation_frequency_tor']='TOR'                                          # 2.000000 # _tor  [rad.s^-1]
_cocos_signals['core_profiles.profiles_1d.:.ion.:.state.:.rotation_frequency_tor']='TOR'                                  # 2.000000 # _tor  [rad.s^-1]
_cocos_signals['core_profiles.profiles_1d.:.j_bootstrap']='TOR'                                                           # 2.000000 # j  [A/m^2]
_cocos_signals['core_profiles.profiles_1d.:.j_non_inductive']='TOR'                                                       # 2.000000 # j  [A/m^2]
_cocos_signals['core_profiles.profiles_1d.:.j_ohmic']='TOR'                                                               # 2.000000 # j  [A/m^2]
_cocos_signals['core_profiles.profiles_1d.:.j_total']='TOR'                                                               # 2.000000 # j  [A/m^2]
_cocos_signals['core_profiles.profiles_1d.:.phi_potential']='?'                                                    #[ADD?]# 2.000000 # phi  [V]
_cocos_signals['core_profiles.profiles_1d.:.q']='Q'                                                                       # 2.000000 # q  [-]
_cocos_signals['core_profiles.vacuum_toroidal_field.b0']='TOR'                                                            # 2.000000 # b0  [T]
_cocos_signals['core_profiles.profiles_1d.:.ion.:.state.:.velocity.diamagnetic']='TOR'                                    # 1.875000 # velocity  [m.s^-1]
_cocos_signals['core_profiles.profiles_1d.:.neutral.:.state.:.velocity.diamagnetic']='TOR'                                # 1.875000 # velocity  [m.s^-1]
_cocos_signals['core_profiles.profiles_1d.:.ion.:.velocity.diamagnetic']='TOR'                                            # 1.833333 # velocity  [m.s^-1]
_cocos_signals['core_profiles.profiles_1d.:.neutral.:.velocity.diamagnetic']='TOR'                                        # 1.833333 # velocity  [m.s^-1]
_cocos_signals['core_profiles.profiles_1d.:.electrons.velocity.diamagnetic']='TOR'                                        # 1.800000 # velocity  [m.s^-1]
_cocos_signals['core_profiles.profiles_1d.:.e_field.diamagnetic']='TOR'                                                   # 1.750000 # e_field  [V.m^-1]

# CORE_SOURCES
_cocos_signals['core_sources.source.:.global_quantities.:.current_parallel']='TOR'                                         # 3.000000 # current  parallel  [A]
_cocos_signals['core_sources.source.:.global_quantities.:.torque_tor']='TOR'                                               # 3.000000 # torque  _tor  [kg.m^2.s^-2]
_cocos_signals['core_sources.source.:.profiles_1d.:.j_parallel']='TOR'                                                     # 3.000000 # j  parallel  [A.m^-2]
_cocos_signals['core_sources.source.:.profiles_1d.:.momentum_tor']='TOR'                                                   # 3.000000 # momentum  _tor  [kg.m^-1.s^-2]
_cocos_signals['core_sources.source.:.profiles_1d.:.ion.:.momentum.parallel']='?'                                   #[ADD?]# 2.875000 # momentum  parallel  [kg.m^-1.s^-2]
_cocos_signals['core_sources.source.:.profiles_1d.:.ion.:.momentum.poloidal']='?'                                   #[ADD?]# 2.875000 # momentum  poloidal  [kg.m^-1.s^-2]
_cocos_signals['core_sources.source.:.profiles_1d.:.ion.:.momentum.toroidal']='?'                                   #[ADD?]# 2.875000 # momentum  toroidal  [kg.m^-1.s^-2]
_cocos_signals['core_sources.source.:.profiles_1d.:.ion.:.momentum.toroidal_decomposed.explicit_part']='?'          #[ADD?]# 2.666667 # momentum  toroidal  [kg.m^2.s^-2]
_cocos_signals['core_sources.source.:.profiles_1d.:.current_parallel_inside']='TOR'                                        # 2.000000 # current  [A]
_cocos_signals['core_sources.source.:.profiles_1d.:.grid.psi']='PSI'                                                       # 2.000000 # psi  [Wb]
_cocos_signals['core_sources.source.:.profiles_1d.:.grid.psi_boundary']='?'                                         #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['core_sources.source.:.profiles_1d.:.grid.psi_magnetic_axis']='?'                                    #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['core_sources.source.:.profiles_1d.:.torque_tor_inside']='TOR'                                              # 2.000000 # torque  [kg.m^2.s^-2]
_cocos_signals['core_sources.vacuum_toroidal_field.b0']='TOR'                                                              # 2.000000 # b0  [T]
_cocos_signals['core_sources.source.:.profiles_1d.:.ion.:.momentum.diamagnetic']='?'                                #[ADD?]# 1.875000 # momentum  [kg.m^-1.s^-2]
_cocos_signals['core_sources.source.:.profiles_1d.:.ion.:.momentum.toroidal_decomposed.implicit_part']='?'          #[ADD?]# 1.666667 # momentum  toroidal

# CORE_TRANSPORT
_cocos_signals['core_transport.model.:.profiles_1d.:.grid_d.psi']='PSI'                                                         # 2.000000 # psi  [Wb]
_cocos_signals['core_transport.model.:.profiles_1d.:.grid_d.psi_boundary']='?'                                           #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['core_transport.model.:.profiles_1d.:.grid_d.psi_magnetic_axis']='?'                                      #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['core_transport.model.:.profiles_1d.:.grid_flux.psi']='PSI'                                                      # 2.000000 # psi  [Wb]
_cocos_signals['core_transport.model.:.profiles_1d.:.grid_flux.psi_boundary']='?'                                        #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['core_transport.model.:.profiles_1d.:.grid_flux.psi_magnetic_axis']='?'                                   #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['core_transport.model.:.profiles_1d.:.grid_v.psi']='PSI'                                                         # 2.000000 # psi  [Wb]
_cocos_signals['core_transport.model.:.profiles_1d.:.grid_v.psi_boundary']='?'                                           #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['core_transport.model.:.profiles_1d.:.grid_v.psi_magnetic_axis']='?'                                      #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['core_transport.vacuum_toroidal_field.b0']='TOR'                                                                 # 2.000000 # b0  [T]

# CRYOSTAT
_cocos_signals['cryostat.description_2d.:.cryostat.unit.:.element.:.j_tor.data']='?'                   #[ADD?]# 2.777778 # j  _tor  [A]
_cocos_signals['cryostat.description_2d.:.thermal_shield.unit.:.element.:.j_tor.data']='?'             #[ADD?]# 2.777778 # j  _tor  [A]

# DATASET_DESCRIPTION

# DISRUPTION
_cocos_signals['disruption.halo_currents.:.area.:.current_halo_pol']='?'                              #[ADD?]# 3.200000 # current  current  _pol  [A]
_cocos_signals['disruption.global_quantities.current_halo_pol']='?'                                   #[ADD?]# 3.000000 # current  _pol  [A]
_cocos_signals['disruption.global_quantities.current_halo_tor']='?'                                   #[ADD?]# 3.000000 # current  _tor  [A]
_cocos_signals['disruption.profiles_1d.:.grid.psi']='PSI'                                                    # 2.000000 # psi  [Wb]
_cocos_signals['disruption.profiles_1d.:.grid.psi_boundary']='?'                                      #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['disruption.profiles_1d.:.grid.psi_magnetic_axis']='?'                                 #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['disruption.profiles_1d.:.j_runaways']='?'                                             #[ADD?]# 2.000000 # j  [A.m^-2]
_cocos_signals['disruption.vacuum_toroidal_field.b0']='TOR'                                                  # 2.000000 # b0  [T]

# DISTRIBUTION_SOURCES
_cocos_signals['distribution_sources.source.:.global_quantities.:.shinethrough.torque_tor']='?'                            #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distribution_sources.source.:.global_quantities.:.torque_tor']='?'                                         #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distribution_sources.source.:.profiles_1d.:.grid.psi']='PSI'                                                      # 2.000000 # psi  [Wb]
_cocos_signals['distribution_sources.source.:.profiles_1d.:.grid.psi_boundary']='?'                                        #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['distribution_sources.source.:.profiles_1d.:.grid.psi_magnetic_axis']='?'                                   #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['distribution_sources.source.:.profiles_1d.:.momentum_tor']='?'                                             #[ADD?]# 2.000000 # momentum  _tor
_cocos_signals['distribution_sources.vacuum_toroidal_field.b0']='TOR'                                                             # 2.000000 # b0  [T]

# DISTRIBUTIONS
_cocos_signals['distributions.distribution.:.profiles_1d.:.co_passing.current_fast_tor']='?'                                          #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
_cocos_signals['distributions.distribution.:.profiles_1d.:.co_passing.current_tor']='?'                                               #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
_cocos_signals['distributions.distribution.:.profiles_1d.:.counter_passing.current_fast_tor']='?'                                     #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
_cocos_signals['distributions.distribution.:.profiles_1d.:.counter_passing.current_tor']='?'                                          #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
_cocos_signals['distributions.distribution.:.profiles_1d.:.current_fast_tor']='?'                                                     #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
_cocos_signals['distributions.distribution.:.profiles_1d.:.current_tor']='?'                                                          #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
_cocos_signals['distributions.distribution.:.profiles_1d.:.trapped.current_fast_tor']='?'                                             #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
_cocos_signals['distributions.distribution.:.profiles_1d.:.trapped.current_tor']='?'                                                  #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
_cocos_signals['distributions.distribution.:.profiles_2d.:.co_passing.current_fast_tor']='?'                                          #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
_cocos_signals['distributions.distribution.:.profiles_2d.:.co_passing.current_tor']='?'                                               #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
_cocos_signals['distributions.distribution.:.profiles_2d.:.counter_passing.current_fast_tor']='?'                                     #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
_cocos_signals['distributions.distribution.:.profiles_2d.:.counter_passing.current_tor']='?'                                          #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
_cocos_signals['distributions.distribution.:.profiles_2d.:.current_fast_tor']='?'                                                     #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
_cocos_signals['distributions.distribution.:.profiles_2d.:.current_tor']='?'                                                          #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
_cocos_signals['distributions.distribution.:.profiles_2d.:.trapped.current_fast_tor']='?'                                             #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
_cocos_signals['distributions.distribution.:.profiles_2d.:.trapped.current_tor']='?'                                                  #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
_cocos_signals['distributions.distribution.:.global_quantities.:.collisions.electrons.torque_fast_tor']='?'                           #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.global_quantities.:.collisions.electrons.torque_thermal_tor']='?'                        #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.global_quantities.:.collisions.ion.:.state.:.torque_fast_tor']='?'                       #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.global_quantities.:.collisions.ion.:.state.:.torque_thermal_tor']='?'                    #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.global_quantities.:.collisions.ion.:.torque_fast_tor']='?'                               #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.global_quantities.:.collisions.ion.:.torque_thermal_tor']='?'                            #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.global_quantities.:.current_tor']='?'                                                    #[ADD?]# 2.000000 # current  _tor
_cocos_signals['distributions.distribution.:.global_quantities.:.source.:.torque_tor']='?'                                            #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_1d.:.co_passing.collisions.electrons.torque_fast_tor']='?'                      #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_1d.:.co_passing.collisions.electrons.torque_thermal_tor']='?'                   #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_1d.:.co_passing.collisions.ion.:.state.:.torque_fast_tor']='?'                  #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_1d.:.co_passing.collisions.ion.:.state.:.torque_thermal_tor']='?'               #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_1d.:.co_passing.collisions.ion.:.torque_fast_tor']='?'                          #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_1d.:.co_passing.collisions.ion.:.torque_thermal_tor']='?'                       #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_1d.:.co_passing.source.:.momentum_tor']='?'                                     #[ADD?]# 2.000000 # momentum  _tor
_cocos_signals['distributions.distribution.:.profiles_1d.:.collisions.electrons.torque_fast_tor']='?'                                 #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_1d.:.collisions.electrons.torque_thermal_tor']='?'                              #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_1d.:.collisions.ion.:.state.:.torque_fast_tor']='?'                             #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_1d.:.collisions.ion.:.state.:.torque_thermal_tor']='?'                          #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_1d.:.collisions.ion.:.torque_fast_tor']='?'                                     #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_1d.:.collisions.ion.:.torque_thermal_tor']='?'                                  #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_1d.:.counter_passing.collisions.electrons.torque_fast_tor']='?'                 #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_1d.:.counter_passing.collisions.electrons.torque_thermal_tor']='?'              #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_1d.:.counter_passing.collisions.ion.:.state.:.torque_fast_tor']='?'             #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_1d.:.counter_passing.collisions.ion.:.state.:.torque_thermal_tor']='?'          #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_1d.:.counter_passing.collisions.ion.:.torque_fast_tor']='?'                     #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_1d.:.counter_passing.collisions.ion.:.torque_thermal_tor']='?'                  #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_1d.:.counter_passing.source.:.momentum_tor']='?'                                #[ADD?]# 2.000000 # momentum  _tor
_cocos_signals['distributions.distribution.:.profiles_1d.:.grid.psi']='PSI'                                                                  # 2.000000 # psi  [Wb]
_cocos_signals['distributions.distribution.:.profiles_1d.:.grid.psi_boundary']='?'                                                    #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['distributions.distribution.:.profiles_1d.:.grid.psi_magnetic_axis']='?'                                               #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['distributions.distribution.:.profiles_1d.:.source.:.momentum_tor']='?'                                                #[ADD?]# 2.000000 # momentum  _tor
_cocos_signals['distributions.distribution.:.profiles_1d.:.thermalisation.momentum_tor']='?'                                          #[ADD?]# 2.000000 # momentum  _tor
_cocos_signals['distributions.distribution.:.profiles_1d.:.trapped.collisions.electrons.torque_fast_tor']='?'                         #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_1d.:.trapped.collisions.electrons.torque_thermal_tor']='?'                      #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_1d.:.trapped.collisions.ion.:.state.:.torque_fast_tor']='?'                     #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_1d.:.trapped.collisions.ion.:.state.:.torque_thermal_tor']='?'                  #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_1d.:.trapped.collisions.ion.:.torque_fast_tor']='?'                             #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_1d.:.trapped.collisions.ion.:.torque_thermal_tor']='?'                          #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_1d.:.trapped.source.:.momentum_tor']='?'                                        #[ADD?]# 2.000000 # momentum  _tor
_cocos_signals['distributions.distribution.:.profiles_2d.:.co_passing.collisions.electrons.torque_fast_tor']='?'                      #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_2d.:.co_passing.collisions.electrons.torque_thermal_tor']='?'                   #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_2d.:.co_passing.collisions.ion.:.state.:.torque_fast_tor']='?'                  #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_2d.:.co_passing.collisions.ion.:.state.:.torque_thermal_tor']='?'               #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_2d.:.co_passing.collisions.ion.:.torque_fast_tor']='?'                          #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_2d.:.co_passing.collisions.ion.:.torque_thermal_tor']='?'                       #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_2d.:.collisions.electrons.torque_fast_tor']='?'                                 #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_2d.:.collisions.electrons.torque_thermal_tor']='?'                              #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_2d.:.collisions.ion.:.state.:.torque_fast_tor']='?'                             #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_2d.:.collisions.ion.:.state.:.torque_thermal_tor']='?'                          #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_2d.:.collisions.ion.:.torque_fast_tor']='?'                                     #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_2d.:.collisions.ion.:.torque_thermal_tor']='?'                                  #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_2d.:.counter_passing.collisions.electrons.torque_fast_tor']='?'                 #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_2d.:.counter_passing.collisions.electrons.torque_thermal_tor']='?'              #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_2d.:.counter_passing.collisions.ion.:.state.:.torque_fast_tor']='?'             #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_2d.:.counter_passing.collisions.ion.:.state.:.torque_thermal_tor']='?'          #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_2d.:.counter_passing.collisions.ion.:.torque_fast_tor']='?'                     #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_2d.:.counter_passing.collisions.ion.:.torque_thermal_tor']='?'                  #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_2d.:.grid.psi']='?'                                                             #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['distributions.distribution.:.profiles_2d.:.trapped.collisions.electrons.torque_fast_tor']='?'                         #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_2d.:.trapped.collisions.electrons.torque_thermal_tor']='?'                      #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_2d.:.trapped.collisions.ion.:.state.:.torque_fast_tor']='?'                     #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_2d.:.trapped.collisions.ion.:.state.:.torque_thermal_tor']='?'                  #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_2d.:.trapped.collisions.ion.:.torque_fast_tor']='?'                             #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.distribution.:.profiles_2d.:.trapped.collisions.ion.:.torque_thermal_tor']='?'                          #[ADD?]# 2.000000 # torque  _tor
_cocos_signals['distributions.vacuum_toroidal_field.b0']='TOR'                                                                               # 2.000000 # b0  [T]
_cocos_signals['distributions.distribution.:.global_quantities.:.energy_fast_parallel']='?'                                           #[ADD?]# 1.000000 # parallel

# EC_LAUNCHERS
_cocos_signals['ec_launchers.launcher.:.launching_position.phi']='?'             #[ADD?]# 2.000000 # phi  [rad]
_cocos_signals['ec_launchers.launcher.:.steering_angle_pol.data']='?'            #[ADD?]# 1.750000 # _pol  [rad]
_cocos_signals['ec_launchers.launcher.:.steering_angle_tor.data']='?'            #[ADD?]# 1.750000 # _tor  [rad]

# ECE
_cocos_signals['ece.channel.:.delta_position_suprathermal.phi']='?'                   #[ADD?]# 2.000000 # phi  [rad]
_cocos_signals['ece.channel.:.position.phi']='?'                                      #[ADD?]# 2.000000 # phi  [rad]
_cocos_signals['ece.line_of_sight.first_point.phi']='TOR'                                    # 2.000000 # phi  [rad]
_cocos_signals['ece.line_of_sight.second_point.phi']='TOR'                                   # 2.000000 # phi  [rad]
_cocos_signals['ece.psi_normalization.psi_boundary']='?'                              #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['ece.psi_normalization.psi_magnetic_axis']='?'                         #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['ece.channel.:.delta_position_suprathermal.psi']='?'                   #[ADD?]# 1.000000 # psi
_cocos_signals['ece.channel.:.position.psi']='?'                                      #[ADD?]# 1.000000 # psi

# EDGE_PROFILES
_cocos_signals['edge_profiles.profiles_1d.:.e_field_parallel']='?'                                                   #[ADD?]# 3.000000 # e_field  parallel  [V.m^-1]
_cocos_signals['edge_profiles.profiles_1d.:.electrons.velocity_pol']='?'                                             #[ADD?]# 3.000000 # velocity  _pol  [m.s^-1]
_cocos_signals['edge_profiles.profiles_1d.:.electrons.velocity_tor']='?'                                             #[ADD?]# 3.000000 # velocity  _tor  [m.s^-1]
_cocos_signals['edge_profiles.profiles_1d.:.ion.:.velocity_pol']='?'                                                 #[ADD?]# 3.000000 # velocity  _pol  [m.s^-1]
_cocos_signals['edge_profiles.profiles_1d.:.ion.:.velocity_tor']='?'                                                 #[ADD?]# 3.000000 # velocity  _tor  [m.s^-1]
_cocos_signals['edge_profiles.profiles_1d.:.j_tor']='?'                                                              #[ADD?]# 3.000000 # j  _tor  [A/m^2]
_cocos_signals['edge_profiles.profiles_1d.:.momentum_tor']='?'                                                       #[ADD?]# 3.000000 # momentum  _tor  [kg.m^-1.s^-1]
_cocos_signals['edge_profiles.profiles_1d.:.ion.:.state.:.velocity.parallel']='?'                                    #[ADD?]# 2.875000 # velocity  parallel  [m.s^-1]
_cocos_signals['edge_profiles.profiles_1d.:.ion.:.state.:.velocity.poloidal']='?'                                    #[ADD?]# 2.875000 # velocity  poloidal  [m.s^-1]
_cocos_signals['edge_profiles.profiles_1d.:.ion.:.state.:.velocity.toroidal']='?'                                    #[ADD?]# 2.875000 # velocity  toroidal  [m.s^-1]
_cocos_signals['edge_profiles.profiles_1d.:.neutral.:.state.:.velocity.parallel']='?'                                #[ADD?]# 2.875000 # velocity  parallel  [m.s^-1]
_cocos_signals['edge_profiles.profiles_1d.:.neutral.:.state.:.velocity.poloidal']='?'                                #[ADD?]# 2.875000 # velocity  poloidal  [m.s^-1]
_cocos_signals['edge_profiles.profiles_1d.:.neutral.:.state.:.velocity.toroidal']='?'                                #[ADD?]# 2.875000 # velocity  toroidal  [m.s^-1]
_cocos_signals['edge_profiles.profiles_1d.:.ion.:.velocity.parallel']='?'                                            #[ADD?]# 2.833333 # velocity  parallel  [m.s^-1]
_cocos_signals['edge_profiles.profiles_1d.:.ion.:.velocity.poloidal']='?'                                            #[ADD?]# 2.833333 # velocity  poloidal  [m.s^-1]
_cocos_signals['edge_profiles.profiles_1d.:.ion.:.velocity.toroidal']='?'                                            #[ADD?]# 2.833333 # velocity  toroidal  [m.s^-1]
_cocos_signals['edge_profiles.profiles_1d.:.neutral.:.velocity.parallel']='?'                                        #[ADD?]# 2.833333 # velocity  parallel  [m.s^-1]
_cocos_signals['edge_profiles.profiles_1d.:.neutral.:.velocity.poloidal']='?'                                        #[ADD?]# 2.833333 # velocity  poloidal  [m.s^-1]
_cocos_signals['edge_profiles.profiles_1d.:.neutral.:.velocity.toroidal']='?'                                        #[ADD?]# 2.833333 # velocity  toroidal  [m.s^-1]
_cocos_signals['edge_profiles.profiles_1d.:.electrons.velocity.parallel']='?'                                        #[ADD?]# 2.800000 # velocity  parallel  [m.s^-1]
_cocos_signals['edge_profiles.profiles_1d.:.electrons.velocity.poloidal']='?'                                        #[ADD?]# 2.800000 # velocity  poloidal  [m.s^-1]
_cocos_signals['edge_profiles.profiles_1d.:.electrons.velocity.toroidal']='?'                                        #[ADD?]# 2.800000 # velocity  toroidal  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.ion.:.state.:.velocity.:.parallel']='?'                                          #[ADD?]# 2.777778 # velocity  parallel  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.ion.:.state.:.velocity.:.poloidal']='?'                                          #[ADD?]# 2.777778 # velocity  poloidal  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.ion.:.state.:.velocity.:.toroidal']='?'                                          #[ADD?]# 2.777778 # velocity  toroidal  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.ion.:.state.:.velocity_diamagnetic.:.parallel']='?'                              #[ADD?]# 2.777778 # velocity  parallel  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.ion.:.state.:.velocity_diamagnetic.:.poloidal']='?'                              #[ADD?]# 2.777778 # velocity  poloidal  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.ion.:.state.:.velocity_diamagnetic.:.toroidal']='?'                              #[ADD?]# 2.777778 # velocity  toroidal  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.ion.:.state.:.velocity_exb.:.parallel']='?'                                      #[ADD?]# 2.777778 # velocity  parallel  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.ion.:.state.:.velocity_exb.:.poloidal']='?'                                      #[ADD?]# 2.777778 # velocity  poloidal  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.ion.:.state.:.velocity_exb.:.toroidal']='?'                                      #[ADD?]# 2.777778 # velocity  toroidal  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.neutral.:.state.:.velocity.:.parallel']='?'                                      #[ADD?]# 2.777778 # velocity  parallel  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.neutral.:.state.:.velocity.:.poloidal']='?'                                      #[ADD?]# 2.777778 # velocity  poloidal  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.neutral.:.state.:.velocity.:.toroidal']='?'                                      #[ADD?]# 2.777778 # velocity  toroidal  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.neutral.:.state.:.velocity_diamagnetic.:.parallel']='?'                          #[ADD?]# 2.777778 # velocity  parallel  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.neutral.:.state.:.velocity_diamagnetic.:.poloidal']='?'                          #[ADD?]# 2.777778 # velocity  poloidal  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.neutral.:.state.:.velocity_diamagnetic.:.toroidal']='?'                          #[ADD?]# 2.777778 # velocity  toroidal  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.neutral.:.state.:.velocity_exb.:.parallel']='?'                                  #[ADD?]# 2.777778 # velocity  parallel  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.neutral.:.state.:.velocity_exb.:.poloidal']='?'                                  #[ADD?]# 2.777778 # velocity  poloidal  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.neutral.:.state.:.velocity_exb.:.toroidal']='?'                                  #[ADD?]# 2.777778 # velocity  toroidal  [m.s^-1]
_cocos_signals['edge_profiles.profiles_1d.:.e_field.parallel']='?'                                                   #[ADD?]# 2.750000 # e_field  parallel  [V.m^-1]
_cocos_signals['edge_profiles.profiles_1d.:.e_field.poloidal']='?'                                                   #[ADD?]# 2.750000 # e_field  poloidal  [V.m^-1]
_cocos_signals['edge_profiles.profiles_1d.:.e_field.toroidal']='?'                                                   #[ADD?]# 2.750000 # e_field  toroidal  [V.m^-1]
_cocos_signals['edge_profiles.ggd.:.ion.:.velocity.:.parallel']='?'                                                  #[ADD?]# 2.714286 # velocity  parallel  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.ion.:.velocity.:.poloidal']='?'                                                  #[ADD?]# 2.714286 # velocity  poloidal  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.ion.:.velocity.:.toroidal']='?'                                                  #[ADD?]# 2.714286 # velocity  toroidal  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.neutral.:.velocity.:.parallel']='?'                                              #[ADD?]# 2.714286 # velocity  parallel  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.neutral.:.velocity.:.poloidal']='?'                                              #[ADD?]# 2.714286 # velocity  poloidal  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.neutral.:.velocity.:.toroidal']='?'                                              #[ADD?]# 2.714286 # velocity  toroidal  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.electrons.velocity.:.parallel']='?'                                              #[ADD?]# 2.666667 # velocity  parallel  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.electrons.velocity.:.poloidal']='?'                                              #[ADD?]# 2.666667 # velocity  poloidal  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.electrons.velocity.:.toroidal']='?'                                              #[ADD?]# 2.666667 # velocity  toroidal  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.e_field.:.parallel']='?'                                                         #[ADD?]# 2.600000 # e_field  parallel  [V.m^-1]
_cocos_signals['edge_profiles.ggd.:.e_field.:.poloidal']='?'                                                         #[ADD?]# 2.600000 # e_field  poloidal  [V.m^-1]
_cocos_signals['edge_profiles.ggd.:.e_field.:.toroidal']='?'                                                         #[ADD?]# 2.600000 # e_field  toroidal  [V.m^-1]
_cocos_signals['edge_profiles.ggd.:.j_anomalous.:.parallel']='?'                                                     #[ADD?]# 2.600000 # j  parallel  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.j_anomalous.:.poloidal']='?'                                                     #[ADD?]# 2.600000 # j  poloidal  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.j_anomalous.:.toroidal']='?'                                                     #[ADD?]# 2.600000 # j  toroidal  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.j_diamagnetic.:.parallel']='?'                                                   #[ADD?]# 2.600000 # j  parallel  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.j_diamagnetic.:.poloidal']='?'                                                   #[ADD?]# 2.600000 # j  poloidal  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.j_diamagnetic.:.toroidal']='?'                                                   #[ADD?]# 2.600000 # j  toroidal  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.j_heat_viscosity.:.parallel']='?'                                                #[ADD?]# 2.600000 # j  parallel  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.j_heat_viscosity.:.poloidal']='?'                                                #[ADD?]# 2.600000 # j  poloidal  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.j_heat_viscosity.:.toroidal']='?'                                                #[ADD?]# 2.600000 # j  toroidal  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.j_inertial.:.parallel']='?'                                                      #[ADD?]# 2.600000 # j  parallel  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.j_inertial.:.poloidal']='?'                                                      #[ADD?]# 2.600000 # j  poloidal  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.j_inertial.:.toroidal']='?'                                                      #[ADD?]# 2.600000 # j  toroidal  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.j_ion_neutral_friction.:.parallel']='?'                                          #[ADD?]# 2.600000 # j  parallel  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.j_ion_neutral_friction.:.poloidal']='?'                                          #[ADD?]# 2.600000 # j  poloidal  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.j_ion_neutral_friction.:.toroidal']='?'                                          #[ADD?]# 2.600000 # j  toroidal  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.j_parallel_viscosity.:.parallel']='?'                                            #[ADD?]# 2.600000 # j  parallel  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.j_parallel_viscosity.:.poloidal']='?'                                            #[ADD?]# 2.600000 # j  poloidal  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.j_parallel_viscosity.:.toroidal']='?'                                            #[ADD?]# 2.600000 # j  toroidal  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.j_perpendicular_viscosity.:.parallel']='?'                                       #[ADD?]# 2.600000 # j  parallel  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.j_perpendicular_viscosity.:.poloidal']='?'                                       #[ADD?]# 2.600000 # j  poloidal  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.j_perpendicular_viscosity.:.toroidal']='?'                                       #[ADD?]# 2.600000 # j  toroidal  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.j_pfirsch_schlueter.:.parallel']='?'                                             #[ADD?]# 2.600000 # j  parallel  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.j_pfirsch_schlueter.:.poloidal']='?'                                             #[ADD?]# 2.600000 # j  poloidal  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.j_pfirsch_schlueter.:.toroidal']='?'                                             #[ADD?]# 2.600000 # j  toroidal  [A.m^-2]
_cocos_signals['edge_profiles.profiles_1d.:.current_parallel_inside']='?'                                            #[ADD?]# 2.000000 # current  [A]
_cocos_signals['edge_profiles.profiles_1d.:.grid.psi']='?'                                                           #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['edge_profiles.profiles_1d.:.grid.psi_boundary']='?'                                                  #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['edge_profiles.profiles_1d.:.grid.psi_magnetic_axis']='?'                                             #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['edge_profiles.profiles_1d.:.ion.:.rotation_frequency_tor']='?'                                       #[ADD?]# 2.000000 # _tor  [rad.s^-1]
_cocos_signals['edge_profiles.profiles_1d.:.ion.:.state.:.rotation_frequency_tor']='?'                               #[ADD?]# 2.000000 # _tor  [rad.s^-1]
_cocos_signals['edge_profiles.profiles_1d.:.j_bootstrap']='?'                                                        #[ADD?]# 2.000000 # j  [A/m^2]
_cocos_signals['edge_profiles.profiles_1d.:.j_non_inductive']='?'                                                    #[ADD?]# 2.000000 # j  [A/m^2]
_cocos_signals['edge_profiles.profiles_1d.:.j_ohmic']='?'                                                            #[ADD?]# 2.000000 # j  [A/m^2]
_cocos_signals['edge_profiles.profiles_1d.:.j_total']='?'                                                            #[ADD?]# 2.000000 # j  [A/m^2]
_cocos_signals['edge_profiles.profiles_1d.:.phi_potential']='?'                                                      #[ADD?]# 2.000000 # phi  [V]
_cocos_signals['edge_profiles.profiles_1d.:.q']='Q'                                                                         # 2.000000 # q  [-]
_cocos_signals['edge_profiles.vacuum_toroidal_field.b0']='TOR'                                                              # 2.000000 # b0  [T]
_cocos_signals['edge_profiles.profiles_1d.:.ion.:.state.:.velocity.diamagnetic']='?'                                 #[ADD?]# 1.875000 # velocity  [m.s^-1]
_cocos_signals['edge_profiles.profiles_1d.:.neutral.:.state.:.velocity.diamagnetic']='?'                             #[ADD?]# 1.875000 # velocity  [m.s^-1]
_cocos_signals['edge_profiles.profiles_1d.:.ion.:.velocity.diamagnetic']='?'                                         #[ADD?]# 1.833333 # velocity  [m.s^-1]
_cocos_signals['edge_profiles.profiles_1d.:.neutral.:.velocity.diamagnetic']='?'                                     #[ADD?]# 1.833333 # velocity  [m.s^-1]
_cocos_signals['edge_profiles.profiles_1d.:.electrons.velocity.diamagnetic']='?'                                     #[ADD?]# 1.800000 # velocity  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.ion.:.state.:.velocity.:.diamagnetic']='?'                                       #[ADD?]# 1.777778 # velocity  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.ion.:.state.:.velocity_diamagnetic.:.diamagnetic']='?'                           #[ADD?]# 1.777778 # velocity  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.ion.:.state.:.velocity_exb.:.diamagnetic']='?'                                   #[ADD?]# 1.777778 # velocity  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.neutral.:.state.:.velocity.:.diamagnetic']='?'                                   #[ADD?]# 1.777778 # velocity  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.neutral.:.state.:.velocity_diamagnetic.:.diamagnetic']='?'                       #[ADD?]# 1.777778 # velocity  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.neutral.:.state.:.velocity_exb.:.diamagnetic']='?'                               #[ADD?]# 1.777778 # velocity  [m.s^-1]
_cocos_signals['edge_profiles.profiles_1d.:.e_field.diamagnetic']='?'                                                #[ADD?]# 1.750000 # e_field  [V.m^-1]
_cocos_signals['edge_profiles.ggd.:.ion.:.velocity.:.diamagnetic']='?'                                               #[ADD?]# 1.714286 # velocity  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.neutral.:.velocity.:.diamagnetic']='?'                                           #[ADD?]# 1.714286 # velocity  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.electrons.velocity.:.diamagnetic']='?'                                           #[ADD?]# 1.666667 # velocity  [m.s^-1]
_cocos_signals['edge_profiles.ggd.:.e_field.:.diamagnetic']='?'                                                      #[ADD?]# 1.600000 # e_field  [V.m^-1]
_cocos_signals['edge_profiles.ggd.:.j_anomalous.:.diamagnetic']='?'                                                  #[ADD?]# 1.600000 # j  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.j_diamagnetic.:.diamagnetic']='?'                                                #[ADD?]# 1.600000 # j  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.j_heat_viscosity.:.diamagnetic']='?'                                             #[ADD?]# 1.600000 # j  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.j_inertial.:.diamagnetic']='?'                                                   #[ADD?]# 1.600000 # j  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.j_ion_neutral_friction.:.diamagnetic']='?'                                       #[ADD?]# 1.600000 # j  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.j_parallel_viscosity.:.diamagnetic']='?'                                         #[ADD?]# 1.600000 # j  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.j_perpendicular_viscosity.:.diamagnetic']='?'                                    #[ADD?]# 1.600000 # j  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.j_pfirsch_schlueter.:.diamagnetic']='?'                                          #[ADD?]# 1.600000 # j  [A.m^-2]
_cocos_signals['edge_profiles.ggd.:.phi_potential.:.values']='?'                                                     #[ADD?]# 1.600000 # phi  [V]

# EDGE_SOURCES
_cocos_signals['edge_sources.source.:.ggd.:.ion.:.state.:.momentum.:.parallel']='?'                              #[ADD?]# 2.818182 # momentum  parallel  [kg.m^-1.s^-2]
_cocos_signals['edge_sources.source.:.ggd.:.ion.:.state.:.momentum.:.poloidal']='?'                              #[ADD?]# 2.818182 # momentum  poloidal  [kg.m^-1.s^-2]
_cocos_signals['edge_sources.source.:.ggd.:.ion.:.state.:.momentum.:.toroidal']='?'                              #[ADD?]# 2.818182 # momentum  toroidal  [kg.m^-1.s^-2]
_cocos_signals['edge_sources.source.:.ggd.:.neutral.:.state.:.momentum.:.parallel']='?'                          #[ADD?]# 2.818182 # momentum  parallel  [kg.m^-1.s^-2]
_cocos_signals['edge_sources.source.:.ggd.:.neutral.:.state.:.momentum.:.poloidal']='?'                          #[ADD?]# 2.818182 # momentum  poloidal  [kg.m^-1.s^-2]
_cocos_signals['edge_sources.source.:.ggd.:.neutral.:.state.:.momentum.:.toroidal']='?'                          #[ADD?]# 2.818182 # momentum  toroidal  [kg.m^-1.s^-2]
_cocos_signals['edge_sources.source.:.ggd.:.ion.:.momentum.:.parallel']='?'                                      #[ADD?]# 2.777778 # momentum  parallel  [kg.m^-1.s^-2]
_cocos_signals['edge_sources.source.:.ggd.:.ion.:.momentum.:.poloidal']='?'                                      #[ADD?]# 2.777778 # momentum  poloidal  [kg.m^-1.s^-2]
_cocos_signals['edge_sources.source.:.ggd.:.ion.:.momentum.:.toroidal']='?'                                      #[ADD?]# 2.777778 # momentum  toroidal  [kg.m^-1.s^-2]
_cocos_signals['edge_sources.source.:.ggd.:.neutral.:.momentum.:.parallel']='?'                                  #[ADD?]# 2.777778 # momentum  parallel  [kg.m^-1.s^-2]
_cocos_signals['edge_sources.source.:.ggd.:.neutral.:.momentum.:.poloidal']='?'                                  #[ADD?]# 2.777778 # momentum  poloidal  [kg.m^-1.s^-2]
_cocos_signals['edge_sources.source.:.ggd.:.neutral.:.momentum.:.toroidal']='?'                                  #[ADD?]# 2.777778 # momentum  toroidal  [kg.m^-1.s^-2]
_cocos_signals['edge_sources.source.:.ggd.:.momentum.:.parallel']='?'                                            #[ADD?]# 2.714286 # momentum  parallel  [kg.m^-1.s^-2]
_cocos_signals['edge_sources.source.:.ggd.:.momentum.:.poloidal']='?'                                            #[ADD?]# 2.714286 # momentum  poloidal  [kg.m^-1.s^-2]
_cocos_signals['edge_sources.source.:.ggd.:.momentum.:.toroidal']='?'                                            #[ADD?]# 2.714286 # momentum  toroidal  [kg.m^-1.s^-2]
_cocos_signals['edge_sources.source.:.ggd.:.ion.:.state.:.momentum.:.diamagnetic']='?'                           #[ADD?]# 1.818182 # momentum  [kg.m^-1.s^-2]
_cocos_signals['edge_sources.source.:.ggd.:.neutral.:.state.:.momentum.:.diamagnetic']='?'                       #[ADD?]# 1.818182 # momentum  [kg.m^-1.s^-2]
_cocos_signals['edge_sources.source.:.ggd.:.ion.:.momentum.:.diamagnetic']='?'                                   #[ADD?]# 1.777778 # momentum  [kg.m^-1.s^-2]
_cocos_signals['edge_sources.source.:.ggd.:.neutral.:.momentum.:.diamagnetic']='?'                               #[ADD?]# 1.777778 # momentum  [kg.m^-1.s^-2]
_cocos_signals['edge_sources.source.:.ggd.:.current.:.values']='?'                                               #[ADD?]# 1.714286 # current  [A.m^-2]
_cocos_signals['edge_sources.source.:.ggd.:.momentum.:.diamagnetic']='?'                                         #[ADD?]# 1.714286 # momentum  [kg.m^-1.s^-2]

# EDGE_TRANSPORT
_cocos_signals['edge_transport.model.:.ggd.:.ion.:.state.:.momentum.flux_limiter.:.parallel']='?'                              #[ADD?]# 2.750000 # momentum  parallel  [-]
_cocos_signals['edge_transport.model.:.ggd.:.ion.:.state.:.momentum.flux_limiter.:.poloidal']='?'                              #[ADD?]# 2.750000 # momentum  poloidal  [-]
_cocos_signals['edge_transport.model.:.ggd.:.ion.:.state.:.momentum.flux_limiter.:.toroidal']='?'                              #[ADD?]# 2.750000 # momentum  toroidal  [-]
_cocos_signals['edge_transport.model.:.ggd.:.neutral.:.state.:.momentum.flux_limiter.:.parallel']='?'                          #[ADD?]# 2.750000 # momentum  parallel  [-]
_cocos_signals['edge_transport.model.:.ggd.:.neutral.:.state.:.momentum.flux_limiter.:.poloidal']='?'                          #[ADD?]# 2.750000 # momentum  poloidal  [-]
_cocos_signals['edge_transport.model.:.ggd.:.neutral.:.state.:.momentum.flux_limiter.:.toroidal']='?'                          #[ADD?]# 2.750000 # momentum  toroidal  [-]
_cocos_signals['edge_transport.model.:.ggd.:.ion.:.momentum.flux_limiter.:.parallel']='?'                                      #[ADD?]# 2.700000 # momentum  parallel  [-]
_cocos_signals['edge_transport.model.:.ggd.:.ion.:.momentum.flux_limiter.:.poloidal']='?'                                      #[ADD?]# 2.700000 # momentum  poloidal  [-]
_cocos_signals['edge_transport.model.:.ggd.:.ion.:.momentum.flux_limiter.:.toroidal']='?'                                      #[ADD?]# 2.700000 # momentum  toroidal  [-]
_cocos_signals['edge_transport.model.:.ggd.:.neutral.:.momentum.flux_limiter.:.parallel']='?'                                  #[ADD?]# 2.700000 # momentum  parallel  [-]
_cocos_signals['edge_transport.model.:.ggd.:.neutral.:.momentum.flux_limiter.:.poloidal']='?'                                  #[ADD?]# 2.700000 # momentum  poloidal  [-]
_cocos_signals['edge_transport.model.:.ggd.:.neutral.:.momentum.flux_limiter.:.toroidal']='?'                                  #[ADD?]# 2.700000 # momentum  toroidal  [-]
_cocos_signals['edge_transport.model.:.ggd.:.momentum.flux_limiter.:.parallel']='?'                                            #[ADD?]# 2.625000 # momentum  parallel  [-]
_cocos_signals['edge_transport.model.:.ggd.:.momentum.flux_limiter.:.poloidal']='?'                                            #[ADD?]# 2.625000 # momentum  poloidal  [-]
_cocos_signals['edge_transport.model.:.ggd.:.momentum.flux_limiter.:.toroidal']='?'                                            #[ADD?]# 2.625000 # momentum  toroidal  [-]
_cocos_signals['edge_transport.model.:.ggd.:.ion.:.state.:.momentum.flux_limiter.:.diamagnetic']='?'                           #[ADD?]# 1.750000 # momentum  [-]
_cocos_signals['edge_transport.model.:.ggd.:.neutral.:.state.:.momentum.flux_limiter.:.diamagnetic']='?'                       #[ADD?]# 1.750000 # momentum  [-]
_cocos_signals['edge_transport.model.:.ggd.:.ion.:.momentum.flux_limiter.:.diamagnetic']='?'                                   #[ADD?]# 1.700000 # momentum  [-]
_cocos_signals['edge_transport.model.:.ggd.:.neutral.:.momentum.flux_limiter.:.diamagnetic']='?'                               #[ADD?]# 1.700000 # momentum  [-]
_cocos_signals['edge_transport.model.:.ggd.:.momentum.flux_limiter.:.diamagnetic']='?'                                         #[ADD?]# 1.625000 # momentum  [-]
_cocos_signals['edge_transport.model.:.ggd.:.conductivity.:.parallel']='?'                                                     #[ADD?]# 1.000000 # parallel
_cocos_signals['edge_transport.model.:.ggd.:.conductivity.:.poloidal']='?'                                                     #[ADD?]# 1.000000 # poloidal
_cocos_signals['edge_transport.model.:.ggd.:.conductivity.:.toroidal']='?'                                                     #[ADD?]# 1.000000 # toroidal

# EM_COUPLING

# EQUILIBRIUM
_cocos_signals['equilibrium.time_slice.:.global_quantities.magnetic_axis.b_field_tor']='TOR'                                    # 4.000000 # b  b_field  _tor  [T]
_cocos_signals['equilibrium.time_slice.:.profiles_2d.:.b_field_tor']='TOR'                                                      # 4.000000 # b  b_field  _tor  [T]
_cocos_signals['equilibrium.time_slice.:.ggd.:.b_field_tor.:.values']='TOR'                                                     # 3.142857 # b  b_field  _tor  [T]
_cocos_signals['equilibrium.time_slice.:.global_quantities.magnetic_axis.b_tor']='TOR'                                          # 3.000000 # b  _tor  [T]
_cocos_signals['equilibrium.time_slice.:.profiles_1d.f_df_dpsi']='dPSI'                                                         # 3.000000 # f  _dpsi  [T^2.m^2/Wb]
_cocos_signals['equilibrium.time_slice.:.profiles_1d.j_parallel']='TOR'                                                         # 3.000000 # j  parallel  [A/m^2]
_cocos_signals['equilibrium.time_slice.:.profiles_1d.j_tor']='TOR'                                                              # 3.000000 # j  _tor  [A.m^-2]
_cocos_signals['equilibrium.time_slice.:.profiles_2d.:.b_tor']='TOR'                                                            # 3.000000 # b  _tor  [T]
_cocos_signals['equilibrium.time_slice.:.profiles_2d.:.j_parallel']='TOR'                                                       # 3.000000 # j  parallel  [A.m^-2]
_cocos_signals['equilibrium.time_slice.:.profiles_2d.:.j_tor']='TOR'                                                            # 3.000000 # j  _tor  [A.m^-2]
_cocos_signals['equilibrium.time_slice.:.constraints.b_field_tor_vacuum_r.measured']='TOR'                                      # 2.600000 # b  b_field  [T.m]
_cocos_signals['equilibrium.time_slice.:.constraints.b_field_tor_vacuum_r.reconstructed']='TOR'                                 # 2.600000 # b  b_field  [T.m]
_cocos_signals['equilibrium.time_slice.:.constraints.q.:.position.phi']='Q'                                                     # 2.571429 # q  phi  [rad]
_cocos_signals['equilibrium.time_slice.:.ggd.:.j_parallel.:.values']='TOR'                                                      # 2.428571 # j  parallel  [A.m^-2]
_cocos_signals['equilibrium.time_slice.:.ggd.:.j_tor.:.values']='TOR'                                                           # 2.428571 # j  _tor  [A.m^-2]
_cocos_signals['equilibrium.time_slice.:.boundary.b_flux_pol_norm']='?'                                                  #[ADD?]# 2.000000 # b  [-]
_cocos_signals['equilibrium.time_slice.:.boundary.psi']='?'                                                              #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['equilibrium.time_slice.:.boundary_separatrix.psi']='?'                                                   #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['equilibrium.time_slice.:.global_quantities.ip']='TOR'                                                           # 2.000000 # ip  [A]
_cocos_signals['equilibrium.time_slice.:.global_quantities.psi_axis']='PSI'                                                     # 2.000000 # psi  [Wb]
_cocos_signals['equilibrium.time_slice.:.global_quantities.psi_boundary']='PSI'                                                 # 2.000000 # psi  [Wb]
_cocos_signals['equilibrium.time_slice.:.global_quantities.q_95']='Q'                                                           # 2.000000 # q  [-]
_cocos_signals['equilibrium.time_slice.:.global_quantities.q_axis']='Q'                                                         # 2.000000 # q  [-]
_cocos_signals['equilibrium.time_slice.:.profiles_1d.b_average']='TOR'                                                          # 2.000000 # b  [T]
_cocos_signals['equilibrium.time_slice.:.profiles_1d.b_max']='TOR'                                                              # 2.000000 # b  [T]
_cocos_signals['equilibrium.time_slice.:.profiles_1d.b_min']='TOR'                                                              # 2.000000 # b  [T]
_cocos_signals['equilibrium.time_slice.:.profiles_1d.darea_dpsi']='dPSI'                                                        # 2.000000 # _dpsi  [m^2.Wb^-1]
_cocos_signals['equilibrium.time_slice.:.profiles_1d.dpressure_dpsi']='dPSI'                                                    # 2.000000 # _dpsi  [Pa.Wb^-1]
_cocos_signals['equilibrium.time_slice.:.profiles_1d.dpsi_drho_tor']='PSI'                                                      # 2.000000 # _tor  [Wb/m]
_cocos_signals['equilibrium.time_slice.:.profiles_1d.dvolume_dpsi']='dPSI'                                                      # 2.000000 # _dpsi  [m^3.Wb^-1]
_cocos_signals['equilibrium.time_slice.:.profiles_1d.f']='TOR'                                                                  # 2.000000 # f  [T.m]
_cocos_signals['equilibrium.time_slice.:.profiles_1d.phi']='TOR'                                                                # 2.000000 # phi  [Wb]
_cocos_signals['equilibrium.time_slice.:.profiles_1d.psi']='PSI'                                                                # 2.000000 # psi  [Wb]
_cocos_signals['equilibrium.time_slice.:.profiles_1d.q']='Q'                                                                    # 2.000000 # q  [-]
_cocos_signals['equilibrium.time_slice.:.profiles_2d.:.phi']='TOR'                                                              # 2.000000 # phi  [Wb]
_cocos_signals['equilibrium.time_slice.:.profiles_2d.:.psi']='PSI'                                                              # 2.000000 # psi  [Wb]
_cocos_signals['equilibrium.vacuum_toroidal_field.b0']='TOR'                                                                    # 2.000000 # b0  [T]
_cocos_signals['equilibrium.time_slice.:.constraints.ip.measured']='TOR'                                                        # 1.800000 # ip  [A]
_cocos_signals['equilibrium.time_slice.:.constraints.ip.reconstructed']='TOR'                                                   # 1.800000 # ip  [A]
_cocos_signals['equilibrium.time_slice.:.global_quantities.q_min.value']='Q'                                                    # 1.800000 # q  [-]
_cocos_signals['equilibrium.time_slice.:.ggd.:.phi.:.values']='TOR'                                                             # 1.714286 # phi  [Wb]
_cocos_signals['equilibrium.time_slice.:.ggd.:.psi.:.values']='PSI'                                                             # 1.714286 # psi  [Wb]
_cocos_signals['equilibrium.time_slice.:.constraints.pf_current.:.measured']='?'                                         #[ADD?]# 1.666667 # current  [A]
_cocos_signals['equilibrium.time_slice.:.constraints.pf_current.:.reconstructed']='?'                                    #[ADD?]# 1.666667 # current  [A]
_cocos_signals['equilibrium.time_slice.:.constraints.pf_passive_current.:.measured']='?'                                 #[ADD?]# 1.666667 # current  [A]
_cocos_signals['equilibrium.time_slice.:.constraints.pf_passive_current.:.reconstructed']='?'                            #[ADD?]# 1.666667 # current  [A]
_cocos_signals['equilibrium.time_slice.:.constraints.q.:.measured']='Q'                                                         # 1.666667 # q  [-]
_cocos_signals['equilibrium.time_slice.:.constraints.q.:.reconstructed']='Q'                                                    # 1.666667 # q  [-]

# GAS_INJECTION
_cocos_signals['gas_injection.pipe.:.exit_position.phi']='TOR'                                      # 2.000000 # phi  [rad]
_cocos_signals['gas_injection.pipe.:.second_point.phi']='TOR'                                       # 2.000000 # phi  [rad]

# GYROKINETICS
_cocos_signals['gyrokinetics.flux_surface.b_field_tor_sign']='?'                                                                                                   #[ADD?]# 3.000000 # b  b_field  [-]
_cocos_signals['gyrokinetics.fluxes_integrated_norm.:.energy_b_field_parallel']='?'                                                                                #[ADD?]# 3.000000 # b_field  parallel  [-]
_cocos_signals['gyrokinetics.fluxes_integrated_norm.:.momentum_tor_parallel_a_field_parallel']='?'                                                                 #[ADD?]# 3.000000 # momentum  parallel  [-]
_cocos_signals['gyrokinetics.fluxes_integrated_norm.:.momentum_tor_parallel_b_field_parallel']='?'                                                                 #[ADD?]# 3.000000 # b_field  parallel  [-]
_cocos_signals['gyrokinetics.fluxes_integrated_norm.:.momentum_tor_perpendicular_a_field_parallel']='?'                                                            #[ADD?]# 3.000000 # momentum  parallel  [-]
_cocos_signals['gyrokinetics.fluxes_integrated_norm.:.momentum_tor_perpendicular_b_field_parallel']='?'                                                            #[ADD?]# 3.000000 # b_field  parallel  [-]
_cocos_signals['gyrokinetics.fluxes_integrated_norm.:.particles_b_field_parallel']='?'                                                                             #[ADD?]# 3.000000 # b_field  parallel  [-]
_cocos_signals['gyrokinetics.wavevector.:.eigenmode.:.b_field_parallel_perturbed_norm_imaginary']='?'                                                              #[ADD?]# 3.000000 # b  b_field  [-]
_cocos_signals['gyrokinetics.wavevector.:.eigenmode.:.b_field_parallel_perturbed_norm_real']='?'                                                                   #[ADD?]# 3.000000 # b  b_field  [-]
_cocos_signals['gyrokinetics.wavevector.:.eigenmode.:.b_field_parallel_perturbed_parity']='?'                                                                      #[ADD?]# 3.000000 # b  b_field  [-]
_cocos_signals['gyrokinetics.wavevector.:.eigenmode.:.fluxes_moments.:.fluxes_norm.energy_b_field_parallel']='?'                                                   #[ADD?]# 3.000000 # b_field  parallel  [-]
_cocos_signals['gyrokinetics.wavevector.:.eigenmode.:.fluxes_moments.:.fluxes_norm.momentum_tor_parallel_a_field_parallel']='?'                                    #[ADD?]# 3.000000 # momentum  parallel  [-]
_cocos_signals['gyrokinetics.wavevector.:.eigenmode.:.fluxes_moments.:.fluxes_norm.momentum_tor_parallel_b_field_parallel']='?'                                    #[ADD?]# 3.000000 # b_field  parallel  [-]
_cocos_signals['gyrokinetics.wavevector.:.eigenmode.:.fluxes_moments.:.fluxes_norm.momentum_tor_perpendicular_a_field_parallel']='?'                               #[ADD?]# 3.000000 # momentum  parallel  [-]
_cocos_signals['gyrokinetics.wavevector.:.eigenmode.:.fluxes_moments.:.fluxes_norm.momentum_tor_perpendicular_b_field_parallel']='?'                               #[ADD?]# 3.000000 # b_field  parallel  [-]
_cocos_signals['gyrokinetics.wavevector.:.eigenmode.:.fluxes_moments.:.fluxes_norm.particles_b_field_parallel']='?'                                                #[ADD?]# 3.000000 # b_field  parallel  [-]
_cocos_signals['gyrokinetics.flux_surface.ip_sign']='?'                                                                                                            #[ADD?]# 2.000000 # ip  [-]
_cocos_signals['gyrokinetics.flux_surface.q']='?'                                                                                                                  #[ADD?]# 2.000000 # q  [-]
_cocos_signals['gyrokinetics.fluxes_integrated_norm.:.energy_a_field_parallel']='?'                                                                                #[ADD?]# 2.000000 # parallel  [-]
_cocos_signals['gyrokinetics.fluxes_integrated_norm.:.momentum_tor_parallel_phi_potential']='?'                                                                    #[ADD?]# 2.000000 # momentum  [-]
_cocos_signals['gyrokinetics.fluxes_integrated_norm.:.momentum_tor_perpendicular_phi_potential']='?'                                                               #[ADD?]# 2.000000 # momentum  [-]
_cocos_signals['gyrokinetics.fluxes_integrated_norm.:.particles_a_field_parallel']='?'                                                                             #[ADD?]# 2.000000 # parallel  [-]
_cocos_signals['gyrokinetics.species.:.velocity_tor_gradient_norm']='?'                                                                                            #[ADD?]# 2.000000 # velocity  [-]
_cocos_signals['gyrokinetics.species_all.velocity_tor_norm']='?'                                                                                                   #[ADD?]# 2.000000 # velocity  [-]
_cocos_signals['gyrokinetics.wavevector.:.eigenmode.:.fluxes_moments.:.fluxes_norm.energy_a_field_parallel']='?'                                                   #[ADD?]# 2.000000 # parallel  [-]
_cocos_signals['gyrokinetics.wavevector.:.eigenmode.:.fluxes_moments.:.fluxes_norm.momentum_tor_parallel_phi_potential']='?'                                       #[ADD?]# 2.000000 # momentum  [-]
_cocos_signals['gyrokinetics.wavevector.:.eigenmode.:.fluxes_moments.:.fluxes_norm.momentum_tor_perpendicular_phi_potential']='?'                                  #[ADD?]# 2.000000 # momentum  [-]
_cocos_signals['gyrokinetics.wavevector.:.eigenmode.:.fluxes_moments.:.fluxes_norm.particles_a_field_parallel']='?'                                                #[ADD?]# 2.000000 # parallel  [-]
_cocos_signals['gyrokinetics.wavevector.:.eigenmode.:.fluxes_moments.:.moments_norm_rotating_frame.velocity_parallel_gyroaveraged_imaginary']='?'                  #[ADD?]# 2.000000 # velocity  [-]
_cocos_signals['gyrokinetics.wavevector.:.eigenmode.:.fluxes_moments.:.moments_norm_rotating_frame.velocity_parallel_gyroaveraged_real']='?'                       #[ADD?]# 2.000000 # velocity  [-]
_cocos_signals['gyrokinetics.wavevector.:.eigenmode.:.fluxes_moments.:.moments_norm_rotating_frame.velocity_parallel_imaginary']='?'                               #[ADD?]# 2.000000 # velocity  [-]
_cocos_signals['gyrokinetics.wavevector.:.eigenmode.:.fluxes_moments.:.moments_norm_rotating_frame.velocity_parallel_real']='?'                                    #[ADD?]# 2.000000 # velocity  [-]
_cocos_signals['gyrokinetics.wavevector.:.eigenmode.:.phi_potential_perturbed_norm_imaginary']='?'                                                                 #[ADD?]# 2.000000 # phi  [-]
_cocos_signals['gyrokinetics.wavevector.:.eigenmode.:.phi_potential_perturbed_norm_real']='?'                                                                      #[ADD?]# 2.000000 # phi  [-]
_cocos_signals['gyrokinetics.wavevector.:.eigenmode.:.phi_potential_perturbed_parity']='?'                                                                         #[ADD?]# 2.000000 # phi  [-]
_cocos_signals['gyrokinetics.wavevector.:.eigenmode.:.poloidal_angle']='?'                                                                                         #[ADD?]# 2.000000 # poloidal  [-]

# HARD_X_RAYS
_cocos_signals['hard_x_rays.channel.:.aperture.:.centre.phi']='?'                       #[ADD?]# 2.000000 # phi  [rad]
_cocos_signals['hard_x_rays.channel.:.detector.centre.phi']='?'                         #[ADD?]# 2.000000 # phi  [rad]
_cocos_signals['hard_x_rays.channel.:.line_of_sight.first_point.phi']='?'               #[ADD?]# 2.000000 # phi  [rad]
_cocos_signals['hard_x_rays.channel.:.line_of_sight.second_point.phi']='?'              #[ADD?]# 2.000000 # phi  [rad]

# IC_ANTENNAS
_cocos_signals['ic_antennas.antenna.:.module.:.current.:.position.phi']='TOR'                                        # 2.625000 # current  phi  [rad]
_cocos_signals['ic_antennas.antenna.:.module.:.pressure.:.position.phi']='TOR'                                       # 2.000000 # phi  [rad]
_cocos_signals['ic_antennas.antenna.:.module.:.strap.:.outline.phi']='TOR'                                           # 2.000000 # phi  [rad]
_cocos_signals['ic_antennas.antenna.:.module.:.voltage.:.position.phi']='TOR'                                        # 2.000000 # phi  [rad]
_cocos_signals['ic_antennas.antenna.:.module.:.strap.:.current.data']='?'                                     #[ADD?]# 1.875000 # current  [A]
_cocos_signals['ic_antennas.antenna.:.module.:.current.:.amplitude.data']='?'                                 #[ADD?]# 1.625000 # current  [A]
_cocos_signals['ic_antennas.antenna.:.module.:.current.:.phase.data']='?'                                     #[ADD?]# 1.625000 # current  [rad]
_cocos_signals['ic_antennas.antenna.:.surface_current.:.spectrum']='?'                                        #[ADD?]# 1.600000 # current  [A]

# INTERFEROMETER
_cocos_signals['interferometer.channel.:.line_of_sight.first_point.phi']='TOR'                           # 2.000000 # phi  [rad]
_cocos_signals['interferometer.channel.:.line_of_sight.second_point.phi']='TOR'                          # 2.000000 # phi  [rad]
_cocos_signals['interferometer.channel.:.line_of_sight.third_point.phi']='TOR'                           # 2.000000 # phi  [rad]

# IRON_CORE
_cocos_signals['iron_core.segment.:.b_field']='?'                                          #[ADD?]# 3.000000 # b  b_field  [T]

# LANGMUIR_PROBES
_cocos_signals['langmuir_probes.reciprocating.:.plunge.:.b_field_angle.data']='?'                   #[ADD?]# 2.666667 # b  b_field  [rad]
_cocos_signals['langmuir_probes.reciprocating.:.plunge.:.j_ion_parallel.data']='?'                  #[ADD?]# 2.666667 # j  parallel  [A.m^-2]
_cocos_signals['langmuir_probes.embedded.:.b_field_angle.data']='?'                                 #[ADD?]# 2.500000 # b  b_field  [rad]
_cocos_signals['langmuir_probes.embedded.:.j_ion_parallel.data']='?'                                #[ADD?]# 2.500000 # j  parallel  [A.m^-2]
_cocos_signals['langmuir_probes.embedded.:.position.phi']='?'                                       #[ADD?]# 2.000000 # phi  [rad]
_cocos_signals['langmuir_probes.reciprocating.:.plunge.:.position.phi']='?'                         #[ADD?]# 2.000000 # phi  [rad]
_cocos_signals['langmuir_probes.reciprocating.:.plunge.:.mach_number_parallel.data']='?'            #[ADD?]# 1.833333 # parallel  [-]
_cocos_signals['langmuir_probes.reciprocating.:.plunge.:.saturation_current_ion.data']='?'          #[ADD?]# 1.833333 # current  [A]
_cocos_signals['langmuir_probes.embedded.:.saturation_current_ion.data']='?'                        #[ADD?]# 1.750000 # current  [A]
_cocos_signals['langmuir_probes.reciprocating.:.plunge.:.heat_flux_parallel.data']='?'              #[ADD?]# 0.833333 # parallel
_cocos_signals['langmuir_probes.embedded.:.heat_flux_parallel.data']='?'                            #[ADD?]# 0.750000 # parallel

# LH_ANTENNAS
_cocos_signals['lh_antennas.antenna.:.row.:.n_pol']='?'                                   #[ADD?]# 2.000000 # _pol  [-]
_cocos_signals['lh_antennas.antenna.:.row.:.n_tor']='?'                                   #[ADD?]# 2.000000 # _tor  [-]
_cocos_signals['lh_antennas.antenna.:.row.:.position.phi']='?'                            #[ADD?]# 2.000000 # phi  [rad]
_cocos_signals['lh_antennas.antenna.:.position.phi.data']='?'                             #[ADD?]# 1.800000 # phi  [rad]

# MAGNETICS
_cocos_signals['magnetics.b_field_pol_probe.:.non_linear_response.b_field_linear']='?'              #[ADD?]# 3.500000 # b  b_field  b  b_field  [T]
_cocos_signals['magnetics.b_field_pol_probe.:.non_linear_response.b_field_non_linear']='?'          #[ADD?]# 3.500000 # b  b_field  b  b_field  [T]
_cocos_signals['magnetics.b_field_tor_probe.:.non_linear_response.b_field_linear']='?'              #[ADD?]# 3.500000 # b  b_field  b  b_field  [T]
_cocos_signals['magnetics.b_field_tor_probe.:.non_linear_response.b_field_non_linear']='?'          #[ADD?]# 3.500000 # b  b_field  b  b_field  [T]
_cocos_signals['magnetics.bpol_probe.:.non_linear_response.b_field_linear']='?'                     #[ADD?]# 3.000000 # b  b_field  [T]
_cocos_signals['magnetics.bpol_probe.:.non_linear_response.b_field_non_linear']='?'                 #[ADD?]# 3.000000 # b  b_field  [T]
_cocos_signals['magnetics.b_field_pol_probe.:.poloidal_angle']='POL'                                       # 2.666667 # b  b_field  poloidal  [rad]
_cocos_signals['magnetics.b_field_pol_probe.:.toroidal_angle']='TOR'                                       # 2.666667 # b  b_field  toroidal  [rad]
_cocos_signals['magnetics.b_field_tor_probe.:.poloidal_angle']='POL'                                       # 2.666667 # b  b_field  poloidal  [rad]
_cocos_signals['magnetics.b_field_tor_probe.:.toroidal_angle']='TOR'                                       # 2.666667 # b  b_field  toroidal  [rad]
_cocos_signals['magnetics.b_field_pol_probe.:.position.phi']='?'                                    #[ADD?]# 2.500000 # b  b_field  phi  [rad]
_cocos_signals['magnetics.b_field_tor_probe.:.position.phi']='?'                                    #[ADD?]# 2.500000 # b  b_field  phi  [rad]
_cocos_signals['magnetics.bpol_probe.:.poloidal_angle']='POL'                                              # 2.000000 # poloidal  [rad]
_cocos_signals['magnetics.bpol_probe.:.position.phi']='TOR'                                                # 2.000000 # phi  [rad]
_cocos_signals['magnetics.bpol_probe.:.toroidal_angle']='TOR'                                              # 2.000000 # toroidal  [rad]
_cocos_signals['magnetics.flux_loop.:.position.:.phi']='TOR'                                               # 2.000000 # phi  [rad]
_cocos_signals['magnetics.rogowski_coil.:.position.:.phi']='?'                                      #[ADD?]# 2.000000 # phi  [rad]
_cocos_signals['magnetics.method.:.ip.data']='TOR'                                                         # 1.750000 # ip  [A]
_cocos_signals['magnetics.rogowski_coil.:.current.data']='?'                                        #[ADD?]# 1.750000 # current  [A]
_cocos_signals['magnetics.b_field_pol_probe.:.bandwidth_3db']='?'                                   #[ADD?]# 1.666667 # b  b_field  [Hz]
_cocos_signals['magnetics.b_field_tor_probe.:.bandwidth_3db']='?'                                   #[ADD?]# 1.666667 # b  b_field  [Hz]
_cocos_signals['magnetics.b_field_pol_probe.:.field.data']='?'                                      #[ADD?]# 1.500000 # b  b_field  [T]
_cocos_signals['magnetics.b_field_pol_probe.:.voltage.data']='?'                                    #[ADD?]# 1.500000 # b  b_field  [V]
_cocos_signals['magnetics.b_field_tor_probe.:.field.data']='?'                                      #[ADD?]# 1.500000 # b  b_field  [T]
_cocos_signals['magnetics.b_field_tor_probe.:.voltage.data']='?'                                    #[ADD?]# 1.500000 # b  b_field  [V]
_cocos_signals['magnetics.b_field_pol_probe.:.area']='?'                                            #[ADD?]# 0.666667 # b  b_field
_cocos_signals['magnetics.b_field_pol_probe.:.length']='?'                                          #[ADD?]# 0.666667 # b  b_field
_cocos_signals['magnetics.b_field_tor_probe.:.area']='?'                                            #[ADD?]# 0.666667 # b  b_field
_cocos_signals['magnetics.b_field_tor_probe.:.length']='?'                                          #[ADD?]# 0.666667 # b  b_field

# MHD
_cocos_signals['mhd.ggd.:.b_field_tor.:.values']='?'                                             #[ADD?]# 2.800000 # b  b_field  _tor  [T]
_cocos_signals['mhd.ggd.:.j_tor.:.values']='?'                                                   #[ADD?]# 2.200000 # j  _tor  [A.m^-2]
_cocos_signals['mhd.ggd.:.velocity_parallel.:.values']='?'                                       #[ADD?]# 2.200000 # velocity  parallel  [m.s^-1]
_cocos_signals['mhd.ggd.:.velocity_tor.:.values']='?'                                            #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['mhd.ggd.:.a_field_tor.:.values']='?'                                             #[ADD?]# 1.600000 # _tor  [T.m]
_cocos_signals['mhd.ggd.:.phi_potential.:.values']='?'                                           #[ADD?]# 1.600000 # phi  [V]
_cocos_signals['mhd.ggd.:.psi.:.values']='?'                                                     #[ADD?]# 1.600000 # psi  [Wb]

# MHD_LINEAR
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.b_field_perturbed.coordinate1.coefficients_imaginary']='?'           #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.b_field_perturbed.coordinate1.coefficients_real']='?'                #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.b_field_perturbed.coordinate1.imaginary']='?'                        #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.b_field_perturbed.coordinate1.real']='?'                             #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.b_field_perturbed.coordinate2.coefficients_imaginary']='?'           #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.b_field_perturbed.coordinate2.coefficients_real']='?'                #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.b_field_perturbed.coordinate2.imaginary']='?'                        #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.b_field_perturbed.coordinate2.real']='?'                             #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.b_field_perturbed.coordinate3.coefficients_imaginary']='?'           #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.b_field_perturbed.coordinate3.coefficients_real']='?'                #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.b_field_perturbed.coordinate3.imaginary']='?'                        #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.b_field_perturbed.coordinate3.real']='?'                             #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.b_field_perturbed.coordinate1.coefficients_imaginary']='?'           #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.b_field_perturbed.coordinate1.coefficients_real']='?'                #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.b_field_perturbed.coordinate1.imaginary']='?'                        #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.b_field_perturbed.coordinate1.real']='?'                             #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.b_field_perturbed.coordinate2.coefficients_imaginary']='?'           #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.b_field_perturbed.coordinate2.coefficients_real']='?'                #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.b_field_perturbed.coordinate2.imaginary']='?'                        #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.b_field_perturbed.coordinate2.real']='?'                             #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.b_field_perturbed.coordinate3.coefficients_imaginary']='?'           #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.b_field_perturbed.coordinate3.coefficients_real']='?'                #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.b_field_perturbed.coordinate3.imaginary']='?'                        #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.b_field_perturbed.coordinate3.real']='?'                             #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.phi_potential_perturbed.coefficients_imaginary']='?'                 #[ADD?]# 2.285714 # toroidal  phi  [V]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.phi_potential_perturbed.coefficients_real']='?'                      #[ADD?]# 2.285714 # toroidal  phi  [V]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.phi_potential_perturbed.imaginary']='?'                              #[ADD?]# 2.285714 # toroidal  phi  [V]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.phi_potential_perturbed.real']='?'                                   #[ADD?]# 2.285714 # toroidal  phi  [V]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.psi_potential_perturbed.coefficients_imaginary']='?'                 #[ADD?]# 2.285714 # toroidal  psi  [V]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.psi_potential_perturbed.coefficients_real']='?'                      #[ADD?]# 2.285714 # toroidal  psi  [V]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.psi_potential_perturbed.imaginary']='?'                              #[ADD?]# 2.285714 # toroidal  psi  [V]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.psi_potential_perturbed.real']='?'                                   #[ADD?]# 2.285714 # toroidal  psi  [V]
_cocos_signals['mhd_linear.vacuum_toroidal_field.b0']='TOR'                                                                                # 2.000000 # b0  [T]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.frequency']='?'                                                             #[ADD?]# 1.600000 # toroidal  [Hz]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.growthrate']=None                                                                  # 1.600000 # toroidal  [Hz]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.m_pol_dominant']='?'                                                        #[ADD?]# 1.600000 # toroidal  [-]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.phase']='?'                                                                 #[ADD?]# 1.600000 # toroidal  [rad]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.radial_mode_number']='?'                                                    #[ADD?]# 1.600000 # toroidal  [-]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.a_field_perturbed.coordinate1.coefficients_imaginary']='?'           #[ADD?]# 1.375000 # toroidal  [T.m]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.a_field_perturbed.coordinate1.coefficients_real']='?'                #[ADD?]# 1.375000 # toroidal  [T.m]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.a_field_perturbed.coordinate1.imaginary']='?'                        #[ADD?]# 1.375000 # toroidal  [T.m]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.a_field_perturbed.coordinate1.real']='?'                             #[ADD?]# 1.375000 # toroidal  [T.m]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.a_field_perturbed.coordinate2.coefficients_imaginary']='?'           #[ADD?]# 1.375000 # toroidal  [T.m]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.a_field_perturbed.coordinate2.coefficients_real']='?'                #[ADD?]# 1.375000 # toroidal  [T.m]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.a_field_perturbed.coordinate2.imaginary']='?'                        #[ADD?]# 1.375000 # toroidal  [T.m]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.a_field_perturbed.coordinate2.real']='?'                             #[ADD?]# 1.375000 # toroidal  [T.m]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.a_field_perturbed.coordinate3.coefficients_imaginary']='?'           #[ADD?]# 1.375000 # toroidal  [T.m]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.a_field_perturbed.coordinate3.coefficients_real']='?'                #[ADD?]# 1.375000 # toroidal  [T.m]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.a_field_perturbed.coordinate3.imaginary']='?'                        #[ADD?]# 1.375000 # toroidal  [T.m]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.a_field_perturbed.coordinate3.real']='?'                             #[ADD?]# 1.375000 # toroidal  [T.m]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.a_field_perturbed.coordinate1.coefficients_imaginary']='?'           #[ADD?]# 1.375000 # toroidal  [T.m]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.a_field_perturbed.coordinate1.coefficients_real']='?'                #[ADD?]# 1.375000 # toroidal  [T.m]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.a_field_perturbed.coordinate1.imaginary']='?'                        #[ADD?]# 1.375000 # toroidal  [T.m]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.a_field_perturbed.coordinate1.real']='?'                             #[ADD?]# 1.375000 # toroidal  [T.m]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.a_field_perturbed.coordinate2.coefficients_imaginary']='?'           #[ADD?]# 1.375000 # toroidal  [T.m]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.a_field_perturbed.coordinate2.coefficients_real']='?'                #[ADD?]# 1.375000 # toroidal  [T.m]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.a_field_perturbed.coordinate2.imaginary']='?'                        #[ADD?]# 1.375000 # toroidal  [T.m]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.a_field_perturbed.coordinate2.real']='?'                             #[ADD?]# 1.375000 # toroidal  [T.m]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.a_field_perturbed.coordinate3.coefficients_imaginary']='?'           #[ADD?]# 1.375000 # toroidal  [T.m]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.a_field_perturbed.coordinate3.coefficients_real']='?'                #[ADD?]# 1.375000 # toroidal  [T.m]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.a_field_perturbed.coordinate3.imaginary']='?'                        #[ADD?]# 1.375000 # toroidal  [T.m]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.a_field_perturbed.coordinate3.real']='?'                             #[ADD?]# 1.375000 # toroidal  [T.m]
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.displacement_parallel.coefficients_imaginary']='?'                   #[ADD?]# 1.285714 # toroidal  parallel
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.displacement_parallel.coefficients_real']='?'                        #[ADD?]# 1.285714 # toroidal  parallel
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.displacement_parallel.imaginary']='?'                                #[ADD?]# 1.285714 # toroidal  parallel
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.displacement_parallel.real']='?'                                     #[ADD?]# 1.285714 # toroidal  parallel
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.velocity_perturbed.coordinate1.coefficients_imaginary']='?'          #[ADD?]# 1.125000 # toroidal  velocity
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.velocity_perturbed.coordinate1.coefficients_real']='?'               #[ADD?]# 1.125000 # toroidal  velocity
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.velocity_perturbed.coordinate1.imaginary']='?'                       #[ADD?]# 1.125000 # toroidal  velocity
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.velocity_perturbed.coordinate1.real']='?'                            #[ADD?]# 1.125000 # toroidal  velocity
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.velocity_perturbed.coordinate2.coefficients_imaginary']='?'          #[ADD?]# 1.125000 # toroidal  velocity
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.velocity_perturbed.coordinate2.coefficients_real']='?'               #[ADD?]# 1.125000 # toroidal  velocity
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.velocity_perturbed.coordinate2.imaginary']='?'                       #[ADD?]# 1.125000 # toroidal  velocity
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.velocity_perturbed.coordinate2.real']='?'                            #[ADD?]# 1.125000 # toroidal  velocity
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.velocity_perturbed.coordinate3.coefficients_imaginary']='?'          #[ADD?]# 1.125000 # toroidal  velocity
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.velocity_perturbed.coordinate3.coefficients_real']='?'               #[ADD?]# 1.125000 # toroidal  velocity
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.velocity_perturbed.coordinate3.imaginary']='?'                       #[ADD?]# 1.125000 # toroidal  velocity
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.velocity_perturbed.coordinate3.real']='?'                            #[ADD?]# 1.125000 # toroidal  velocity
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.amplitude_multiplier']='?'                                                  #[ADD?]# 0.600000 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.coordinate_system.jacobian']='?'                                     #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.coordinate_system.tensor_contravariant']='?'                         #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.coordinate_system.tensor_covariant']='?'                             #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.displacement_perpendicular.coefficients_imaginary']='?'              #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.displacement_perpendicular.coefficients_real']='?'                   #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.displacement_perpendicular.imaginary']='?'                           #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.displacement_perpendicular.real']='?'                                #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.grid.dim1']='?'                                                      #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.grid.dim2']='?'                                                      #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.grid.volume_element']='?'                                            #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.mass_density_perturbed.coefficients_imaginary']='?'                  #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.mass_density_perturbed.coefficients_real']='?'                       #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.mass_density_perturbed.imaginary']='?'                               #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.mass_density_perturbed.real']='?'                                    #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.ntv.imaginary']='?'                                                  #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.ntv.real']='?'                                                       #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.pressure_perturbed.coefficients_imaginary']='?'                      #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.pressure_perturbed.coefficients_real']='?'                           #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.pressure_perturbed.imaginary']='?'                                   #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.pressure_perturbed.real']='?'                                        #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.stress_maxwell.imaginary']='?'                                       #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.stress_maxwell.real']='?'                                            #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.stress_reynolds.imaginary']='?'                                      #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.stress_reynolds.real']='?'                                           #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.temperature_perturbed.coefficients_imaginary']='?'                   #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.temperature_perturbed.coefficients_real']='?'                        #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.temperature_perturbed.imaginary']='?'                                #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.temperature_perturbed.real']='?'                                     #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.coordinate_system.jacobian']='?'                                     #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.coordinate_system.tensor_contravariant']='?'                         #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.coordinate_system.tensor_covariant']='?'                             #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.grid.dim1']='?'                                                      #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.grid.dim2']='?'                                                      #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.grid.volume_element']='?'                                            #[ADD?]# 0.428571 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.alfven_frequency_spectrum.:.imaginary']='?'                          #[ADD?]# 0.375000 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.alfven_frequency_spectrum.:.real']='?'                               #[ADD?]# 0.375000 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.coordinate_system.grid.dim1']='?'                                    #[ADD?]# 0.375000 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.coordinate_system.grid.dim2']='?'                                    #[ADD?]# 0.375000 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.coordinate_system.grid.volume_element']='?'                          #[ADD?]# 0.375000 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.coordinate_system.grid.dim1']='?'                                    #[ADD?]# 0.375000 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.coordinate_system.grid.dim2']='?'                                    #[ADD?]# 0.375000 # toroidal
_cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.coordinate_system.grid.volume_element']='?'                          #[ADD?]# 0.375000 # toroidal

# MSE
_cocos_signals['mse.channel.:.active_spatial_resolution.:.centre.phi']='TOR'                           # 2.000000 # phi  [rad]
_cocos_signals['mse.channel.:.active_spatial_resolution.:.width.phi']='TOR'                            # 2.000000 # phi  [rad]
_cocos_signals['mse.channel.:.aperture.:.centre.phi']='TOR'                                            # 2.000000 # phi  [rad]
_cocos_signals['mse.channel.:.detector.centre.phi']='TOR'                                              # 2.000000 # phi  [rad]
_cocos_signals['mse.channel.:.line_of_sight.first_point.phi']='TOR'                                    # 2.000000 # phi  [rad]
_cocos_signals['mse.channel.:.line_of_sight.second_point.phi']='TOR'                                   # 2.000000 # phi  [rad]

# NBI
_cocos_signals['nbi.unit.:.aperture.:.centre.phi']='?'                                               #[ADD?]# 2.000000 # phi  [rad]
_cocos_signals['nbi.unit.:.beamlets_group.:.beamlets.positions.phi']='TOR'                                  # 2.000000 # phi  [rad]
_cocos_signals['nbi.unit.:.beamlets_group.:.position.phi']='TOR'                                            # 2.000000 # phi  [rad]
_cocos_signals['nbi.unit.:.beamlets_group.:.tilting.:.delta_position.phi']='TOR'                            # 2.000000 # phi  [rad]
_cocos_signals['nbi.unit.:.source.centre.phi']='?'                                                   #[ADD?]# 2.000000 # phi  [rad]
_cocos_signals['nbi.unit.:.beamlets_group.:.direction']='TOR'                                        #[DEL?]# -1.000000 # [None]

# NEUTRON_DIAGNOSTIC
_cocos_signals['neutron_diagnostic.detectors.:.b_field_sensor.amplitude.data']='?'                   #[ADD?]# 2.200000 # b  b_field  [V]
_cocos_signals['neutron_diagnostic.detectors.:.b_field_sensor.frequency.data']='?'                   #[ADD?]# 2.200000 # b  b_field  [Hz]
_cocos_signals['neutron_diagnostic.detectors.:.aperture.:.centre.phi']='TOR'                                # 2.000000 # phi  [rad]
_cocos_signals['neutron_diagnostic.detectors.:.detector.centre.phi']='TOR'                                  # 2.000000 # phi  [rad]
_cocos_signals['neutron_diagnostic.detectors.:.position.phi']='TOR'                                         # 2.000000 # phi  [rad]

# NTMS
_cocos_signals['ntms.vacuum_toroidal_field.b0']='TOR'                                            # 2.000000 # b0  [T]
_cocos_signals['ntms.time_slice.:.mode.:.detailed_evolution.torque.:.value']='TOR'               # 1.750000 # torque  [kg.m^2.s^-2]
_cocos_signals['ntms.time_slice.:.mode.:.torque.:.value']='TOR'                                  # 1.714286 # torque  [kg.m^2.s^-2]

# NUMERICS

# PELLETS
_cocos_signals['pellets.time_slice.:.pellet.:.path_geometry.first_point.phi']='TOR'                  # 2.000000 # phi  [rad]
_cocos_signals['pellets.time_slice.:.pellet.:.path_geometry.second_point.phi']='TOR'                 # 2.000000 # phi  [rad]
_cocos_signals['pellets.time_slice.:.pellet.:.path_profiles.position.phi']='TOR'                     # 2.000000 # phi  [rad]
_cocos_signals['pellets.time_slice.:.pellet.:.path_profiles.psi']='?'                         #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['pellets.time_slice.:.pellet.:.path_profiles.velocity']='?'                    #[ADD?]# 2.000000 # velocity  [m.s^-1]
_cocos_signals['pellets.time_slice.:.pellet.:.velocity_initial']='?'                          #[ADD?]# 2.000000 # velocity  [m.s^-1]

# PF_ACTIVE
_cocos_signals['pf_active.coil.:.b_field_max_timed.data']='?'                                     #[ADD?]# 2.500000 # b  b_field  [T]
_cocos_signals['pf_active.coil.:.current_limit_max']=None                                                # 2.000000 # current  [A]
_cocos_signals['pf_active.supply.:.current_limit_max']=None                                              # 2.000000 # current  [A]
_cocos_signals['pf_active.supply.:.current_limit_min']=None                                              # 2.000000 # current  [A]
_cocos_signals['pf_active.supply.:.current_limiter_gain']=None                                           # 2.000000 # current  [V]
_cocos_signals['pf_active.circuit.:.current.data']='TOR'                                                 # 1.750000 # current  [A]
_cocos_signals['pf_active.coil.:.current.data']='TOR'                                                    # 1.750000 # current  [A]
_cocos_signals['pf_active.supply.:.current.data']='TOR'                                                  # 1.750000 # current  [A]

# PF_PASSIVE
_cocos_signals['pf_passive.loop.:.current']='TOR'                                                         # 2.000000 # current  [A]

# POLARIMETER
_cocos_signals['polarimeter.channel.:.line_of_sight.first_point.phi']='TOR'                # 2.000000 # phi  [rad]
_cocos_signals['polarimeter.channel.:.line_of_sight.second_point.phi']='TOR'               # 2.000000 # phi  [rad]
_cocos_signals['polarimeter.channel.:.line_of_sight.third_point.phi']='TOR'                # 2.000000 # phi  [rad]

# PULSE_SCHEDULE
_cocos_signals['pulse_schedule.tf.b_field_tor_vacuum_r.reference.data']='?'                            #[ADD?]# 1.000000 # b  b_field
_cocos_signals['pulse_schedule.ec.launcher.:.steering_angle_pol.reference.data']='?'                   #[ADD?]# 0.666667 # _pol
_cocos_signals['pulse_schedule.ec.launcher.:.steering_angle_tor.reference.data']='?'                   #[ADD?]# 0.666667 # _tor
_cocos_signals['pulse_schedule.lh.antenna.:.n_parallel.reference.data']='?'                            #[ADD?]# 0.666667 # parallel

# RADIATION
_cocos_signals['radiation.process.:.profiles_1d.:.grid.psi']='PSI'                                              # 2.000000 # psi  [Wb]
_cocos_signals['radiation.process.:.profiles_1d.:.grid.psi_boundary']='?'                                #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['radiation.process.:.profiles_1d.:.grid.psi_magnetic_axis']='?'                           #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['radiation.vacuum_toroidal_field.b0']='TOR'                                                      # 2.000000 # b0  [T]

# REFLECTOMETER_PROFILE
_cocos_signals['reflectometer_profile.channel.:.line_of_sight_detection.first_point.phi']='TOR'                # 2.000000 # phi  [rad]
_cocos_signals['reflectometer_profile.channel.:.line_of_sight_detection.second_point.phi']='TOR'               # 2.000000 # phi  [rad]
_cocos_signals['reflectometer_profile.channel.:.line_of_sight_emission.first_point.phi']='TOR'                 # 2.000000 # phi  [rad]
_cocos_signals['reflectometer_profile.channel.:.line_of_sight_emission.second_point.phi']='TOR'                # 2.000000 # phi  [rad]
_cocos_signals['reflectometer_profile.channel.:.position.phi']='?'                                      #[ADD?]# 2.000000 # phi  [rad]
_cocos_signals['reflectometer_profile.psi_normalization.psi_boundary']='?'                              #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['reflectometer_profile.psi_normalization.psi_magnetic_axis']='?'                         #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['reflectometer_profile.channel.:.position.psi']='?'                                      #[ADD?]# 1.000000 # psi

# SAWTEETH
_cocos_signals['sawteeth.profiles_1d.:.e_field_parallel']='?'                      #[ADD?]# 3.000000 # e_field  parallel  [V.m^-1]
_cocos_signals['sawteeth.profiles_1d.:.j_tor']='?'                                 #[ADD?]# 3.000000 # j  _tor  [A/m^2]
_cocos_signals['sawteeth.profiles_1d.:.grid.psi']='PSI'                                   # 2.000000 # psi  [Wb]
_cocos_signals['sawteeth.profiles_1d.:.grid.psi_boundary']='?'                     #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['sawteeth.profiles_1d.:.grid.psi_magnetic_axis']='?'                #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['sawteeth.profiles_1d.:.j_bootstrap']='?'                           #[ADD?]# 2.000000 # j  [A/m^2]
_cocos_signals['sawteeth.profiles_1d.:.j_non_inductive']='?'                       #[ADD?]# 2.000000 # j  [A/m^2]
_cocos_signals['sawteeth.profiles_1d.:.j_ohmic']='?'                               #[ADD?]# 2.000000 # j  [A/m^2]
_cocos_signals['sawteeth.profiles_1d.:.j_total']='?'                               #[ADD?]# 2.000000 # j  [A/m^2]
_cocos_signals['sawteeth.profiles_1d.:.momentum_tor']='?'                          #[ADD?]# 2.000000 # momentum  _tor
_cocos_signals['sawteeth.profiles_1d.:.phi']='TOR'                                        # 2.000000 # phi  [Wb]
_cocos_signals['sawteeth.profiles_1d.:.psi_star_post_crash']='?'                   #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['sawteeth.profiles_1d.:.psi_star_pre_crash']='?'                    #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['sawteeth.profiles_1d.:.q']='?'                                     #[ADD?]# 2.000000 # q  [-]
_cocos_signals['sawteeth.vacuum_toroidal_field.b0']='TOR'                                 # 2.000000 # b0  [T]
_cocos_signals['sawteeth.profiles_1d.:.p_e_fast_parallel']='?'                     #[ADD?]# 1.000000 # parallel
_cocos_signals['sawteeth.profiles_1d.:.p_i_total_fast_parallel']='?'               #[ADD?]# 1.000000 # parallel

# SDN

# SOFT_X_RAYS
_cocos_signals['soft_x_rays.channel.:.aperture.:.centre.phi']='TOR'                            # 2.000000 # phi  [rad]
_cocos_signals['soft_x_rays.channel.:.detector.centre.phi']='TOR'                              # 2.000000 # phi  [rad]
_cocos_signals['soft_x_rays.channel.:.line_of_sight.first_point.phi']='TOR'                    # 2.000000 # phi  [rad]
_cocos_signals['soft_x_rays.channel.:.line_of_sight.second_point.phi']='TOR'                   # 2.000000 # phi  [rad]

# SPECTROMETER_MASS

# SPECTROMETER_UV
_cocos_signals['spectrometer_uv.channel.:.grating.image_field.centre.phi']='?'                  #[ADD?]# 2.666667 # e_field  phi  [rad]
_cocos_signals['spectrometer_uv.channel.:.aperture.:.centre.phi']='?'                           #[ADD?]# 2.000000 # phi  [rad]
_cocos_signals['spectrometer_uv.channel.:.detector.centre.phi']='?'                             #[ADD?]# 2.000000 # phi  [rad]
_cocos_signals['spectrometer_uv.channel.:.grating.centre.phi']='?'                              #[ADD?]# 2.000000 # phi  [rad]
_cocos_signals['spectrometer_uv.channel.:.grating.summit.phi']='?'                              #[ADD?]# 2.000000 # phi  [rad]
_cocos_signals['spectrometer_uv.channel.:.line_of_sight.first_point.phi']='?'                   #[ADD?]# 2.000000 # phi  [rad]
_cocos_signals['spectrometer_uv.channel.:.line_of_sight.second_point.phi']='?'                  #[ADD?]# 2.000000 # phi  [rad]
_cocos_signals['spectrometer_uv.channel.:.grating.image_field.curvature_radius']='?'            #[ADD?]# 0.800000 # e_field
_cocos_signals['spectrometer_uv.channel.:.grating.image_field.x3_unit_vector.x']='?'            #[ADD?]# 0.666667 # e_field
_cocos_signals['spectrometer_uv.channel.:.grating.image_field.x3_unit_vector.y']='?'            #[ADD?]# 0.666667 # e_field

# SPECTROMETER_VISIBLE
_cocos_signals['spectrometer_visible.channel.:.active_spatial_resolution.:.centre.phi']='TOR'                                 # 2.000000 # phi  [rad]
_cocos_signals['spectrometer_visible.channel.:.active_spatial_resolution.:.width.phi']='TOR'                                  # 2.000000 # phi  [rad]
_cocos_signals['spectrometer_visible.channel.:.aperture.:.centre.phi']='TOR'                                                  # 2.000000 # phi  [rad]
_cocos_signals['spectrometer_visible.channel.:.detector.centre.phi']='TOR'                                                    # 2.000000 # phi  [rad]
_cocos_signals['spectrometer_visible.channel.:.detector_image.outline.phi']='TOR'                                             # 2.000000 # phi  [rad]
_cocos_signals['spectrometer_visible.channel.:.fibre_image.outline.phi']='TOR'                                                # 2.000000 # phi  [rad]
_cocos_signals['spectrometer_visible.channel.:.light_collection_efficiencies.positions.phi']='TOR'                            # 2.000000 # phi  [rad]
_cocos_signals['spectrometer_visible.channel.:.line_of_sight.first_point.phi']='TOR'                                          # 2.000000 # phi  [rad]
_cocos_signals['spectrometer_visible.channel.:.line_of_sight.second_point.phi']='TOR'                                         # 2.000000 # phi  [rad]

# SPECTROMETER_X_RAY_CRYSTAL
_cocos_signals['spectrometer_x_ray_crystal.camera.centre.phi']='?'                             #[ADD?]# 2.000000 # phi  [rad]
_cocos_signals['spectrometer_x_ray_crystal.crystal.summit.phi']='?'                            #[ADD?]# 2.000000 # phi  [rad]
_cocos_signals['spectrometer_x_ray_crystal.velocity_tor_proxy.data']='?'                       #[ADD?]# 1.500000 # velocity  [m.s^-1]

# SUMMARY
_cocos_signals['summary.local.itb.e_field_parallel.value']='?'                                                                #[ADD?]# 2.500000 # e_field  parallel  [V.m^-1]
_cocos_signals['summary.local.magnetic_axis.b_field.value']='?'                                                               #[ADD?]# 2.500000 # b  b_field  [T]
_cocos_signals['summary.local.magnetic_axis.e_field_parallel.value']='?'                                                      #[ADD?]# 2.500000 # e_field  parallel  [V.m^-1]
_cocos_signals['summary.local.pedestal.e_field_parallel.value']='?'                                                           #[ADD?]# 2.500000 # e_field  parallel  [V.m^-1]
_cocos_signals['summary.local.separatrix.e_field_parallel.value']='?'                                                         #[ADD?]# 2.500000 # e_field  parallel  [V.m^-1]
_cocos_signals['summary.pedestal_fits.linear.b_field_pedestal_top_hfs.value']='?'                                             #[ADD?]# 2.500000 # b  b_field  [T]
_cocos_signals['summary.pedestal_fits.linear.b_field_pedestal_top_lfs.value']='?'                                             #[ADD?]# 2.500000 # b  b_field  [T]
_cocos_signals['summary.pedestal_fits.linear.b_field_pol_pedestal_top_average.value']='?'                                     #[ADD?]# 2.500000 # b  b_field  [T]
_cocos_signals['summary.pedestal_fits.linear.b_field_pol_pedestal_top_hfs.value']='?'                                         #[ADD?]# 2.500000 # b  b_field  [T]
_cocos_signals['summary.pedestal_fits.linear.b_field_pol_pedestal_top_lfs.value']='?'                                         #[ADD?]# 2.500000 # b  b_field  [T]
_cocos_signals['summary.pedestal_fits.linear.b_field_tor_pedestal_top_hfs.value']='?'                                         #[ADD?]# 2.500000 # b  b_field  [T]
_cocos_signals['summary.pedestal_fits.linear.b_field_tor_pedestal_top_lfs.value']='?'                                         #[ADD?]# 2.500000 # b  b_field  [T]
_cocos_signals['summary.pedestal_fits.mtanh.b_field_pedestal_top_hfs.value']='?'                                              #[ADD?]# 2.500000 # b  b_field  [T]
_cocos_signals['summary.pedestal_fits.mtanh.b_field_pedestal_top_lfs.value']='?'                                              #[ADD?]# 2.500000 # b  b_field  [T]
_cocos_signals['summary.pedestal_fits.mtanh.b_field_pol_pedestal_top_average.value']='?'                                      #[ADD?]# 2.500000 # b  b_field  [T]
_cocos_signals['summary.pedestal_fits.mtanh.b_field_pol_pedestal_top_hfs.value']='?'                                          #[ADD?]# 2.500000 # b  b_field  [T]
_cocos_signals['summary.pedestal_fits.mtanh.b_field_pol_pedestal_top_lfs.value']='?'                                          #[ADD?]# 2.500000 # b  b_field  [T]
_cocos_signals['summary.pedestal_fits.mtanh.b_field_tor_pedestal_top_hfs.value']='?'                                          #[ADD?]# 2.500000 # b  b_field  [T]
_cocos_signals['summary.pedestal_fits.mtanh.b_field_tor_pedestal_top_lfs.value']='?'                                          #[ADD?]# 2.500000 # b  b_field  [T]
_cocos_signals['summary.local.itb.velocity_tor.argon.value']='?'                                                              #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.itb.velocity_tor.beryllium.value']='?'                                                          #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.itb.velocity_tor.carbon.value']='?'                                                             #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.itb.velocity_tor.deuterium.value']='?'                                                          #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.itb.velocity_tor.helium_3.value']='?'                                                           #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.itb.velocity_tor.helium_4.value']='?'                                                           #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.itb.velocity_tor.hydrogen.value']='?'                                                           #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.itb.velocity_tor.lithium.value']='?'                                                            #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.itb.velocity_tor.neon.value']='?'                                                               #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.itb.velocity_tor.nitrogen.value']='?'                                                           #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.itb.velocity_tor.oxygen.value']='?'                                                             #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.itb.velocity_tor.tritium.value']='?'                                                            #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.itb.velocity_tor.tungsten.value']='?'                                                           #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.itb.velocity_tor.xenon.value']='?'                                                              #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.magnetic_axis.velocity_tor.argon.value']='?'                                                    #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.magnetic_axis.velocity_tor.beryllium.value']='?'                                                #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.magnetic_axis.velocity_tor.carbon.value']='?'                                                   #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.magnetic_axis.velocity_tor.deuterium.value']='?'                                                #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.magnetic_axis.velocity_tor.helium_3.value']='?'                                                 #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.magnetic_axis.velocity_tor.helium_4.value']='?'                                                 #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.magnetic_axis.velocity_tor.hydrogen.value']='?'                                                 #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.magnetic_axis.velocity_tor.lithium.value']='?'                                                  #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.magnetic_axis.velocity_tor.neon.value']='?'                                                     #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.magnetic_axis.velocity_tor.nitrogen.value']='?'                                                 #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.magnetic_axis.velocity_tor.oxygen.value']='?'                                                   #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.magnetic_axis.velocity_tor.tritium.value']='?'                                                  #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.magnetic_axis.velocity_tor.tungsten.value']='?'                                                 #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.magnetic_axis.velocity_tor.xenon.value']='?'                                                    #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.pedestal.velocity_tor.argon.value']='?'                                                         #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.pedestal.velocity_tor.beryllium.value']='?'                                                     #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.pedestal.velocity_tor.carbon.value']='?'                                                        #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.pedestal.velocity_tor.deuterium.value']='?'                                                     #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.pedestal.velocity_tor.helium_3.value']='?'                                                      #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.pedestal.velocity_tor.helium_4.value']='?'                                                      #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.pedestal.velocity_tor.hydrogen.value']='?'                                                      #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.pedestal.velocity_tor.lithium.value']='?'                                                       #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.pedestal.velocity_tor.neon.value']='?'                                                          #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.pedestal.velocity_tor.nitrogen.value']='?'                                                      #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.pedestal.velocity_tor.oxygen.value']='?'                                                        #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.pedestal.velocity_tor.tritium.value']='?'                                                       #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.pedestal.velocity_tor.tungsten.value']='?'                                                      #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.pedestal.velocity_tor.xenon.value']='?'                                                         #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.separatrix.velocity_tor.argon.value']='?'                                                       #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.separatrix.velocity_tor.beryllium.value']='?'                                                   #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.separatrix.velocity_tor.carbon.value']='?'                                                      #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.separatrix.velocity_tor.deuterium.value']='?'                                                   #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.separatrix.velocity_tor.helium_3.value']='?'                                                    #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.separatrix.velocity_tor.helium_4.value']='?'                                                    #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.separatrix.velocity_tor.hydrogen.value']='?'                                                    #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.separatrix.velocity_tor.lithium.value']='?'                                                     #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.separatrix.velocity_tor.neon.value']='?'                                                        #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.separatrix.velocity_tor.nitrogen.value']='?'                                                    #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.separatrix.velocity_tor.oxygen.value']='?'                                                      #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.separatrix.velocity_tor.tritium.value']='?'                                                     #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.separatrix.velocity_tor.tungsten.value']='?'                                                    #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.separatrix.velocity_tor.xenon.value']='?'                                                       #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
_cocos_signals['summary.local.itb.position.psi']='PSI'                                                                               # 2.000000 # psi  [Wb]
_cocos_signals['summary.local.magnetic_axis.position.psi']='PSI'                                                                     # 2.000000 # psi  [Wb]
_cocos_signals['summary.local.pedestal.position.psi']='PSI'                                                                          # 2.000000 # psi  [Wb]
_cocos_signals['summary.local.separatrix.position.psi']='PSI'                                                                        # 2.000000 # psi  [Wb]
_cocos_signals['summary.heating_current_drive.nbi.:.position.phi.value']='?'                                                  #[ADD?]# 1.833333 # phi  [rad]
_cocos_signals['summary.heating_current_drive.ec.:.angle_pol.value']='?'                                                      #[ADD?]# 1.800000 # _pol  [rad]
_cocos_signals['summary.heating_current_drive.ec.:.angle_tor.value']='?'                                                      #[ADD?]# 1.800000 # _tor  [rad]
_cocos_signals['summary.heating_current_drive.ec.:.current.value']='?'                                                        #[ADD?]# 1.800000 # current  [A]
_cocos_signals['summary.heating_current_drive.ic.:.current.value']='?'                                                        #[ADD?]# 1.800000 # current  [A]
_cocos_signals['summary.heating_current_drive.lh.:.current.value']='?'                                                        #[ADD?]# 1.800000 # current  [A]
_cocos_signals['summary.heating_current_drive.lh.:.n_parallel.value']='?'                                                     #[ADD?]# 1.800000 # parallel  [-]
_cocos_signals['summary.heating_current_drive.nbi.:.current.value']='?'                                                       #[ADD?]# 1.800000 # current  [A]
_cocos_signals['summary.local.itb.q.value']='Q'                                                                                      # 1.750000 # q  [-]
_cocos_signals['summary.local.magnetic_axis.q.value']='Q'                                                                            # 1.750000 # q  [-]
_cocos_signals['summary.local.pedestal.q.value']='Q'                                                                                 # 1.750000 # q  [-]
_cocos_signals['summary.local.separatrix.q.value']='Q'                                                                               # 1.750000 # q  [-]
_cocos_signals['summary.fusion.current.value']='TOR'                                                                                 # 1.666667 # current  [A]
_cocos_signals['summary.global_quantities.b0.value']='TOR'                                                                           # 1.666667 # b0  [T]
_cocos_signals['summary.global_quantities.current_alignment.value']='?'                                                       #[ADD?]# 1.666667 # current  [A]
_cocos_signals['summary.global_quantities.current_bootstrap.value']='TOR'                                                            # 1.666667 # current  [A]
_cocos_signals['summary.global_quantities.current_non_inductive.value']='TOR'                                                        # 1.666667 # current  [A]
_cocos_signals['summary.global_quantities.current_ohm.value']='TOR'                                                                  # 1.666667 # current  [A]
_cocos_signals['summary.global_quantities.ip.value']='TOR'                                                                           # 1.666667 # ip  [A]
_cocos_signals['summary.global_quantities.q_95.value']='?'                                                                    #[ADD?]# 1.666667 # q  [-]
_cocos_signals['summary.global_quantities.v_loop.value']='TOR'                                                                       # 1.666667 # v  [V]
_cocos_signals['summary.pedestal_fits.mtanh.stability.bootstrap_current_hager.alpha_critical.value']='?'                      #[ADD?]# 1.666667 # current  [-]
_cocos_signals['summary.pedestal_fits.mtanh.stability.bootstrap_current_sauter.alpha_critical.value']='?'                     #[ADD?]# 1.666667 # current  [-]
_cocos_signals['summary.runaways.current.value']='?'                                                                          #[ADD?]# 1.666667 # current  [A]
_cocos_signals['summary.local.itb.momentum_tor.value']='?'                                                                    #[ADD?]# 1.500000 # momentum  _tor
_cocos_signals['summary.local.magnetic_axis.momentum_tor.value']='?'                                                          #[ADD?]# 1.500000 # momentum  _tor
_cocos_signals['summary.local.pedestal.momentum_tor.value']='?'                                                               #[ADD?]# 1.500000 # momentum  _tor
_cocos_signals['summary.local.separatrix.momentum_tor.value']='?'                                                             #[ADD?]# 1.500000 # momentum  _tor
_cocos_signals['summary.global_quantities.energy_b_field_pol.value']='?'                                                      #[ADD?]# 1.333333 # b_field  _pol
_cocos_signals['summary.global_quantities.energy_fast_parallel.value']='?'                                                    #[ADD?]# 0.666667 # parallel
_cocos_signals['summary.pedestal_fits.mtanh.stability.bootstrap_current_hager.t_e_pedestal_top_critical.value']='?'           #[ADD?]# 0.666667 # current
_cocos_signals['summary.pedestal_fits.mtanh.stability.bootstrap_current_sauter.t_e_pedestal_top_critical.value']='?'          #[ADD?]# 0.666667 # current

# TEMPORARY

# TF
_cocos_signals['tf.field_map.:.b_field_tor.:.values']='?'                                             #[ADD?]# 2.800000 # b  b_field  _tor  [T]
_cocos_signals['tf.coil.:.conductor.:.elements.centres.phi']='TOR'                                           # 2.000000 # phi  [rad]
_cocos_signals['tf.coil.:.conductor.:.elements.end_points.phi']='TOR'                                        # 2.000000 # phi  [rad]
_cocos_signals['tf.coil.:.conductor.:.elements.intermediate_points.phi']='TOR'                               # 2.000000 # phi  [rad]
_cocos_signals['tf.coil.:.conductor.:.elements.start_points.phi']='TOR'                                      # 2.000000 # phi  [rad]
_cocos_signals['tf.coil.:.conductor.:.current.data']='?'                                              #[ADD?]# 1.833333 # current  [A]
_cocos_signals['tf.coil.:.current.data']='?'                                                          #[ADD?]# 1.750000 # current  [A]
_cocos_signals['tf.field_map.:.a_field_tor.:.values']='?'                                             #[ADD?]# 1.600000 # _tor  [T.m]

# THOMSON_SCATTERING
_cocos_signals['thomson_scattering.channel.:.delta_position.phi']='?'                  #[ADD?]# 2.000000 # phi  [rad]
_cocos_signals['thomson_scattering.channel.:.position.phi']='TOR'                             # 2.000000 # phi  [rad]

# TRANSPORT_SOLVER_NUMERICS
_cocos_signals['transport_solver_numerics.derivatives_1d.:.electrons.d2_drho_tor_norm2.velocity_pol']='?'                                  #[ADD?]# 3.000000 # velocity  _pol  [m.s^-1]
_cocos_signals['transport_solver_numerics.derivatives_1d.:.electrons.d2_drho_tor_norm2.velocity_tor']='?'                                  #[ADD?]# 3.000000 # velocity  _tor  [m.s^-1]
_cocos_signals['transport_solver_numerics.derivatives_1d.:.electrons.d_drho_tor_norm.velocity_pol']='?'                                    #[ADD?]# 3.000000 # velocity  _pol  [m.s^-1]
_cocos_signals['transport_solver_numerics.derivatives_1d.:.electrons.d_drho_tor_norm.velocity_tor']='?'                                    #[ADD?]# 3.000000 # velocity  _tor  [m.s^-1]
_cocos_signals['transport_solver_numerics.derivatives_1d.:.electrons.d_dt.velocity_pol']='?'                                               #[ADD?]# 3.000000 # velocity  _pol  [m.s^-1]
_cocos_signals['transport_solver_numerics.derivatives_1d.:.electrons.d_dt.velocity_tor']='?'                                               #[ADD?]# 3.000000 # velocity  _tor  [m.s^-1]
_cocos_signals['transport_solver_numerics.derivatives_1d.:.ion.:.d2_drho_tor_norm2.velocity_pol']='?'                                      #[ADD?]# 3.000000 # velocity  _pol  [m.s^-1]
_cocos_signals['transport_solver_numerics.derivatives_1d.:.ion.:.d2_drho_tor_norm2.velocity_tor']='?'                                      #[ADD?]# 3.000000 # velocity  _tor  [m.s^-1]
_cocos_signals['transport_solver_numerics.derivatives_1d.:.ion.:.d_drho_tor_norm.velocity_pol']='?'                                        #[ADD?]# 3.000000 # velocity  _pol  [m.s^-1]
_cocos_signals['transport_solver_numerics.derivatives_1d.:.ion.:.d_drho_tor_norm.velocity_tor']='?'                                        #[ADD?]# 3.000000 # velocity  _tor  [m.s^-1]
_cocos_signals['transport_solver_numerics.derivatives_1d.:.ion.:.d_dt.velocity_pol']='?'                                                   #[ADD?]# 3.000000 # velocity  _pol  [m.s^-1]
_cocos_signals['transport_solver_numerics.derivatives_1d.:.ion.:.d_dt.velocity_tor']='?'                                                   #[ADD?]# 3.000000 # velocity  _tor  [m.s^-1]
_cocos_signals['transport_solver_numerics.derivatives_1d.:.ion.:.state.:.d2_drho_tor_norm2.velocity_pol']='?'                              #[ADD?]# 3.000000 # velocity  _pol  [m.s^-1]
_cocos_signals['transport_solver_numerics.derivatives_1d.:.ion.:.state.:.d2_drho_tor_norm2.velocity_tor']='?'                              #[ADD?]# 3.000000 # velocity  _tor  [m.s^-1]
_cocos_signals['transport_solver_numerics.derivatives_1d.:.ion.:.state.:.d_drho_tor_norm.velocity_pol']='?'                                #[ADD?]# 3.000000 # velocity  _pol  [m.s^-1]
_cocos_signals['transport_solver_numerics.derivatives_1d.:.ion.:.state.:.d_drho_tor_norm.velocity_tor']='?'                                #[ADD?]# 3.000000 # velocity  _tor  [m.s^-1]
_cocos_signals['transport_solver_numerics.derivatives_1d.:.ion.:.state.:.d_dt.velocity_pol']='?'                                           #[ADD?]# 3.000000 # velocity  _pol  [m.s^-1]
_cocos_signals['transport_solver_numerics.derivatives_1d.:.ion.:.state.:.d_dt.velocity_tor']='?'                                           #[ADD?]# 3.000000 # velocity  _tor  [m.s^-1]
_cocos_signals['transport_solver_numerics.derivatives_1d.:.grid.psi']='PSI'                                                                       # 2.000000 # psi  [Wb]
_cocos_signals['transport_solver_numerics.derivatives_1d.:.grid.psi_boundary']='?'                                                         #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['transport_solver_numerics.derivatives_1d.:.grid.psi_magnetic_axis']='?'                                                    #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['transport_solver_numerics.solver_1d.:.grid.psi']='PSI'                                                                            # 2.000000 # psi  [Wb]
_cocos_signals['transport_solver_numerics.solver_1d.:.grid.psi_boundary']='?'                                                              #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['transport_solver_numerics.solver_1d.:.grid.psi_magnetic_axis']='?'                                                         #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['transport_solver_numerics.vacuum_toroidal_field.b0']='TOR'                                                                        # 2.000000 # b0  [T]
_cocos_signals['transport_solver_numerics.convergence.equations.:.current.delta_relative.value']='?'                                       #[ADD?]# 1.666667 # current  [-]
_cocos_signals['transport_solver_numerics.boundary_conditions_1d.:.momentum_tor.value']='?'                                                #[ADD?]# 1.500000 # momentum  _tor
_cocos_signals['transport_solver_numerics.derivatives_1d.:.dpsi_drho_tor']='?'                                                             #[ADD?]# 1.000000 # _tor
_cocos_signals['transport_solver_numerics.boundary_conditions_1d.:.current.value']='?'                                                     #[ADD?]# 0.750000 # current
_cocos_signals['transport_solver_numerics.boundary_conditions_ggd.:.current.:.values']='?'                                                 #[ADD?]# 0.600000 # current

# TURBULENCE

# WALL
_cocos_signals['wall.global_quantities.current_tor']='?'                                                            #[ADD?]# 3.000000 # current  _tor  [A]
_cocos_signals['wall.description_2d.:.vessel.unit.:.element.:.j_tor.data']='?'                                      #[ADD?]# 2.777778 # j  _tor  [A]
_cocos_signals['wall.description_2d.:.limiter.unit.:.phi_extensions']='?'                                           #[ADD?]# 2.000000 # phi  [rad]
_cocos_signals['wall.description_2d.:.mobile.unit.:.phi_extensions']='?'                                            #[ADD?]# 2.000000 # phi  [rad]

# WAVES
_cocos_signals['waves.coherent_wave.:.profiles_1d.:.e_field_n_tor.:.parallel.amplitude']='?'                             #[ADD?]# 3.125000 # e_field  _tor  parallel  [V.m^-1]
_cocos_signals['waves.coherent_wave.:.profiles_1d.:.e_field_n_tor.:.parallel.phase']='?'                                 #[ADD?]# 3.125000 # e_field  _tor  parallel  [V.m^-1]
_cocos_signals['waves.coherent_wave.:.profiles_2d.:.e_field_n_tor.:.parallel.amplitude']='?'                             #[ADD?]# 3.125000 # e_field  _tor  parallel  [V.m^-1]
_cocos_signals['waves.coherent_wave.:.profiles_2d.:.e_field_n_tor.:.parallel.phase']='?'                                 #[ADD?]# 3.125000 # e_field  _tor  parallel  [V.m^-1]
_cocos_signals['waves.coherent_wave.:.full_wave.:.b_field.parallel.:.values']='?'                                        #[ADD?]# 3.000000 # b  b_field  parallel  [V.m^-1]
_cocos_signals['waves.coherent_wave.:.global_quantities.:.current_tor']='?'                                              #[ADD?]# 3.000000 # current  _tor  [A]
_cocos_signals['waves.coherent_wave.:.global_quantities.:.current_tor_n_tor']='?'                                        #[ADD?]# 3.000000 # current  _tor  [A]
_cocos_signals['waves.coherent_wave.:.profiles_1d.:.current_parallel_density_n_tor']='?'                                 #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
_cocos_signals['waves.coherent_wave.:.profiles_1d.:.current_tor_inside_n_tor']='?'                                       #[ADD?]# 3.000000 # current  _tor  [A]
_cocos_signals['waves.coherent_wave.:.beam_tracing.:.beam.:.e_field.parallel.imaginary']='?'                             #[ADD?]# 2.666667 # e_field  parallel  [V.m^-1]
_cocos_signals['waves.coherent_wave.:.beam_tracing.:.beam.:.e_field.parallel.real']='?'                                  #[ADD?]# 2.666667 # e_field  parallel  [V.m^-1]
_cocos_signals['waves.coherent_wave.:.full_wave.:.e_field.parallel.:.values']='?'                                        #[ADD?]# 2.375000 # e_field  parallel  [V.m^-1]
_cocos_signals['waves.coherent_wave.:.full_wave.:.b_field.bi_normal.:.values']='?'                                       #[ADD?]# 2.250000 # b  b_field  [V.m^-1]
_cocos_signals['waves.coherent_wave.:.full_wave.:.b_field.normal.:.values']='?'                                          #[ADD?]# 2.250000 # b  b_field  [V.m^-1]
_cocos_signals['waves.coherent_wave.:.profiles_1d.:.e_field_n_tor.:.minus.amplitude']='?'                                #[ADD?]# 2.250000 # e_field  _tor  [V.m^-1]
_cocos_signals['waves.coherent_wave.:.profiles_1d.:.e_field_n_tor.:.minus.phase']='?'                                    #[ADD?]# 2.250000 # e_field  _tor  [V.m^-1]
_cocos_signals['waves.coherent_wave.:.profiles_1d.:.e_field_n_tor.:.plus.amplitude']='?'                                 #[ADD?]# 2.250000 # e_field  _tor  [V.m^-1]
_cocos_signals['waves.coherent_wave.:.profiles_1d.:.e_field_n_tor.:.plus.phase']='?'                                     #[ADD?]# 2.250000 # e_field  _tor  [V.m^-1]
_cocos_signals['waves.coherent_wave.:.profiles_2d.:.e_field_n_tor.:.minus.amplitude']='?'                                #[ADD?]# 2.250000 # e_field  _tor  [V.m^-1]
_cocos_signals['waves.coherent_wave.:.profiles_2d.:.e_field_n_tor.:.minus.phase']='?'                                    #[ADD?]# 2.250000 # e_field  _tor  [V.m^-1]
_cocos_signals['waves.coherent_wave.:.profiles_2d.:.e_field_n_tor.:.plus.amplitude']='?'                                 #[ADD?]# 2.250000 # e_field  _tor  [V.m^-1]
_cocos_signals['waves.coherent_wave.:.profiles_2d.:.e_field_n_tor.:.plus.phase']='?'                                     #[ADD?]# 2.250000 # e_field  _tor  [V.m^-1]
_cocos_signals['waves.coherent_wave.:.beam_tracing.:.beam.:.position.phi']='TOR'                                                # 2.000000 # phi  [rad]
_cocos_signals['waves.coherent_wave.:.beam_tracing.:.beam.:.position.psi']='PSI'                                                # 2.000000 # psi  [Wb]
_cocos_signals['waves.coherent_wave.:.beam_tracing.:.beam.:.power_flow_norm.parallel']='?'                               #[ADD?]# 2.000000 # parallel  [-]
_cocos_signals['waves.coherent_wave.:.beam_tracing.:.beam.:.wave_vector.n_parallel']='?'                                 #[ADD?]# 2.000000 # parallel  [-]
_cocos_signals['waves.coherent_wave.:.profiles_1d.:.current_parallel_density']='?'                                       #[ADD?]# 2.000000 # current  [A.m^-2]
_cocos_signals['waves.coherent_wave.:.profiles_1d.:.current_tor_inside']='?'                                             #[ADD?]# 2.000000 # current  [A]
_cocos_signals['waves.coherent_wave.:.profiles_1d.:.grid.psi']='PSI'                                                            # 2.000000 # psi  [Wb]
_cocos_signals['waves.coherent_wave.:.profiles_1d.:.grid.psi_boundary']='?'                                              #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['waves.coherent_wave.:.profiles_1d.:.grid.psi_magnetic_axis']='?'                                         #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['waves.coherent_wave.:.profiles_2d.:.grid.psi']='?'                                                       #[ADD?]# 2.000000 # psi  [Wb]
_cocos_signals['waves.vacuum_toroidal_field.b0']='TOR'                                                                          # 2.000000 # b0  [T]
_cocos_signals['waves.coherent_wave.:.beam_tracing.:.beam.:.e_field.minus.imaginary']='?'                                #[ADD?]# 1.777778 # e_field  [V.m^-1]
_cocos_signals['waves.coherent_wave.:.beam_tracing.:.beam.:.e_field.minus.real']='?'                                     #[ADD?]# 1.777778 # e_field  [V.m^-1]
_cocos_signals['waves.coherent_wave.:.beam_tracing.:.beam.:.e_field.plus.imaginary']='?'                                 #[ADD?]# 1.777778 # e_field  [V.m^-1]
_cocos_signals['waves.coherent_wave.:.beam_tracing.:.beam.:.e_field.plus.real']='?'                                      #[ADD?]# 1.777778 # e_field  [V.m^-1]
_cocos_signals['waves.coherent_wave.:.full_wave.:.e_field.bi_normal.:.values']='?'                                       #[ADD?]# 1.625000 # e_field  [V.m^-1]
_cocos_signals['waves.coherent_wave.:.full_wave.:.e_field.minus.:.values']='?'                                           #[ADD?]# 1.625000 # e_field  [V.m^-1]
_cocos_signals['waves.coherent_wave.:.full_wave.:.e_field.normal.:.values']='?'                                          #[ADD?]# 1.625000 # e_field  [V.m^-1]
_cocos_signals['waves.coherent_wave.:.full_wave.:.e_field.plus.:.values']='?'                                            #[ADD?]# 1.625000 # e_field  [V.m^-1]
_cocos_signals['waves.coherent_wave.:.beam_tracing.:.beam.:.wave_vector.k_tor']='?'                                      #[ADD?]# 1.000000 # _tor
_cocos_signals['waves.coherent_wave.:.global_quantities.:.electrons.power_fast_n_tor']='?'                               #[ADD?]# 1.000000 # _tor
_cocos_signals['waves.coherent_wave.:.global_quantities.:.electrons.power_thermal_n_tor']='?'                            #[ADD?]# 1.000000 # _tor
_cocos_signals['waves.coherent_wave.:.global_quantities.:.ion.:.power_fast_n_tor']='?'                                   #[ADD?]# 1.000000 # _tor
_cocos_signals['waves.coherent_wave.:.global_quantities.:.ion.:.power_thermal_n_tor']='?'                                #[ADD?]# 1.000000 # _tor
_cocos_signals['waves.coherent_wave.:.global_quantities.:.ion.:.state.:.power_fast_n_tor']='?'                           #[ADD?]# 1.000000 # _tor
_cocos_signals['waves.coherent_wave.:.global_quantities.:.ion.:.state.:.power_thermal_n_tor']='?'                        #[ADD?]# 1.000000 # _tor
_cocos_signals['waves.coherent_wave.:.global_quantities.:.power_n_tor']='?'                                              #[ADD?]# 1.000000 # _tor
_cocos_signals['waves.coherent_wave.:.profiles_1d.:.electrons.power_density_fast_n_tor']='?'                             #[ADD?]# 1.000000 # _tor
_cocos_signals['waves.coherent_wave.:.profiles_1d.:.electrons.power_density_thermal_n_tor']='?'                          #[ADD?]# 1.000000 # _tor
_cocos_signals['waves.coherent_wave.:.profiles_1d.:.electrons.power_inside_fast_n_tor']='?'                              #[ADD?]# 1.000000 # _tor
_cocos_signals['waves.coherent_wave.:.profiles_1d.:.electrons.power_inside_thermal_n_tor']='?'                           #[ADD?]# 1.000000 # _tor
_cocos_signals['waves.coherent_wave.:.profiles_1d.:.ion.:.power_density_fast_n_tor']='?'                                 #[ADD?]# 1.000000 # _tor
_cocos_signals['waves.coherent_wave.:.profiles_1d.:.ion.:.power_density_thermal_n_tor']='?'                              #[ADD?]# 1.000000 # _tor
_cocos_signals['waves.coherent_wave.:.profiles_1d.:.ion.:.power_inside_fast_n_tor']='?'                                  #[ADD?]# 1.000000 # _tor
_cocos_signals['waves.coherent_wave.:.profiles_1d.:.ion.:.power_inside_thermal_n_tor']='?'                               #[ADD?]# 1.000000 # _tor
_cocos_signals['waves.coherent_wave.:.profiles_1d.:.ion.:.state.:.power_density_fast_n_tor']='?'                         #[ADD?]# 1.000000 # _tor
_cocos_signals['waves.coherent_wave.:.profiles_1d.:.ion.:.state.:.power_density_thermal_n_tor']='?'                      #[ADD?]# 1.000000 # _tor
_cocos_signals['waves.coherent_wave.:.profiles_1d.:.ion.:.state.:.power_inside_fast_n_tor']='?'                          #[ADD?]# 1.000000 # _tor
_cocos_signals['waves.coherent_wave.:.profiles_1d.:.ion.:.state.:.power_inside_thermal_n_tor']='?'                       #[ADD?]# 1.000000 # _tor
_cocos_signals['waves.coherent_wave.:.profiles_1d.:.power_density_n_tor']='?'                                            #[ADD?]# 1.000000 # _tor
_cocos_signals['waves.coherent_wave.:.profiles_1d.:.power_inside_n_tor']='?'                                             #[ADD?]# 1.000000 # _tor
_cocos_signals['waves.coherent_wave.:.profiles_2d.:.electrons.power_density_fast_n_tor']='?'                             #[ADD?]# 1.000000 # _tor
_cocos_signals['waves.coherent_wave.:.profiles_2d.:.electrons.power_density_thermal_n_tor']='?'                          #[ADD?]# 1.000000 # _tor
_cocos_signals['waves.coherent_wave.:.profiles_2d.:.ion.:.power_density_fast_n_tor']='?'                                 #[ADD?]# 1.000000 # _tor
_cocos_signals['waves.coherent_wave.:.profiles_2d.:.ion.:.power_density_thermal_n_tor']='?'                              #[ADD?]# 1.000000 # _tor
_cocos_signals['waves.coherent_wave.:.profiles_2d.:.ion.:.state.:.power_density_fast_n_tor']='?'                         #[ADD?]# 1.000000 # _tor
_cocos_signals['waves.coherent_wave.:.profiles_2d.:.ion.:.state.:.power_density_thermal_n_tor']='?'                      #[ADD?]# 1.000000 # _tor
_cocos_signals['waves.coherent_wave.:.profiles_2d.:.power_density_n_tor']='?'                                            #[ADD?]# 1.000000 # _tor