"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AzIdToNameMapping = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class AzIdToNameMapping extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const handlerPolicy = new aws_cdk_lib_1.aws_iam.ManagedPolicy(this, 'handlerPolicy', {
            statements: [
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    sid: 'AllowSSMParameterEdit',
                    actions: [
                        'ssm:PutParameter',
                        'ssm:DeleteParameter',
                        'ssm:AddTagsToResource',
                    ],
                    resources: [
                        '*',
                    ],
                    conditions: {
                        StringEquals: {
                            'aws:ResourceTag/CdkAzMappingParameter': 'True',
                        },
                    },
                }),
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    sid: 'AllowDescribeAZs',
                    actions: [
                        'ec2:DescribeAvailabilityZones',
                    ],
                    resources: [
                        '*',
                    ],
                }),
            ],
        });
        const role = new aws_cdk_lib_1.aws_iam.Role(this, 'handlerRole', {
            assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('lambda.amazonaws.com'),
            managedPolicies: [
                handlerPolicy,
            ],
        });
        const onEventHandler = new aws_cdk_lib_1.aws_lambda.Function(this, 'handler', {
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_8,
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, '../lambda')),
            handler: 'index.handler',
            description: 'Stores VPC mappings into parameter store',
            timeout: aws_cdk_lib_1.Duration.seconds(5),
            logRetention: props.logRetention ?? aws_cdk_lib_1.aws_logs.RetentionDays.ONE_MONTH,
            role,
        });
        const provider = new aws_cdk_lib_1.custom_resources.Provider(this, 'provider', {
            onEventHandler,
            logRetention: props.logRetention ?? aws_cdk_lib_1.aws_logs.RetentionDays.ONE_MONTH,
        });
        const mapping = new aws_cdk_lib_1.CustomResource(this, 'mapping', {
            serviceToken: provider.serviceToken,
            properties: {
                azIds: props.azIds || ['use1-az2', 'use1-az4', 'use1-az6'],
                prefix: props.ssmParameterPrefix || '/az-mapping/',
            },
        });
        this.mapping = mapping.getAtt('azIds').toString();
    }
}
exports.AzIdToNameMapping = AzIdToNameMapping;
_a = JSII_RTTI_SYMBOL_1;
AzIdToNameMapping[_a] = { fqn: "@renovosolutions/cdk-library-multi-account-az-mapping.AzIdToNameMapping", version: "0.0.39" };
//# sourceMappingURL=data:application/json;base64,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