"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstructTreeParser = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const parse_tree_1 = require("./models/parse-tree");
/**
 * @stability stable
 */
class ConstructTreeParser {
    /**
     * @stability stable
     */
    constructor(node) {
        this._rootNode = node;
    }
    /**
     * @stability stable
     */
    generateParseTree() {
        return new parse_tree_1.ParseTree(this._rootNode);
    }
    /**
     * @stability stable
     */
    generateTreeStructure() {
        return new parse_tree_1.ParseTree(this._rootNode).genTreeStructure();
    }
    /**
     * @stability stable
     */
    get rootNode() {
        return this._rootNode;
    }
}
exports.ConstructTreeParser = ConstructTreeParser;
_a = JSII_RTTI_SYMBOL_1;
ConstructTreeParser[_a] = { fqn: "cdk-utilities.ConstructTreeParser", version: "0.0.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHJlZS1wYXJzZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvdHJlZS1wYXJzZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFFQSxvREFBZ0Q7Ozs7QUFFaEQsTUFBYSxtQkFBbUI7Ozs7SUFHOUIsWUFBWSxJQUFhO1FBQ3ZCLElBQUksQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDO0lBQ3hCLENBQUM7Ozs7SUFFTSxpQkFBaUI7UUFDdEIsT0FBTyxJQUFJLHNCQUFTLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7Ozs7SUFFTSxxQkFBcUI7UUFDMUIsT0FBTyxJQUFJLHNCQUFTLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDLGdCQUFnQixFQUFFLENBQUM7SUFDMUQsQ0FBQzs7OztJQUVELElBQVcsUUFBUTtRQUNqQixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUM7SUFDeEIsQ0FBQzs7QUFqQkgsa0RBa0JDIiwic291cmNlc0NvbnRlbnQiOlsiXG5pbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBQYXJzZVRyZWUgfSBmcm9tICcuL21vZGVscy9wYXJzZS10cmVlJztcblxuZXhwb3J0IGNsYXNzIENvbnN0cnVjdFRyZWVQYXJzZXIge1xuICBwcml2YXRlIHJlYWRvbmx5IF9yb290Tm9kZTogY2RrLkFwcDtcblxuICBjb25zdHJ1Y3Rvcihub2RlOiBjZGsuQXBwKSB7XG4gICAgdGhpcy5fcm9vdE5vZGUgPSBub2RlO1xuICB9XG5cbiAgcHVibGljIGdlbmVyYXRlUGFyc2VUcmVlKCk6IFBhcnNlVHJlZSB7XG4gICAgcmV0dXJuIG5ldyBQYXJzZVRyZWUodGhpcy5fcm9vdE5vZGUpO1xuICB9XG5cbiAgcHVibGljIGdlbmVyYXRlVHJlZVN0cnVjdHVyZSgpOiBzdHJpbmcge1xuICAgIHJldHVybiBuZXcgUGFyc2VUcmVlKHRoaXMuX3Jvb3ROb2RlKS5nZW5UcmVlU3RydWN0dXJlKCk7XG4gIH1cblxuICBwdWJsaWMgZ2V0IHJvb3ROb2RlKCk6IGNkay5BcHAge1xuICAgIHJldHVybiB0aGlzLl9yb290Tm9kZTtcbiAgfVxufVxuIl19