"""creation

Revision ID: f724fac25359
Revises: 
Create Date: 2020-07-01 12:11:00.121115

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'f724fac25359'
down_revision = None
branch_labels = None
depends_on = None

from sqlalchemy.engine.reflection import Inspector


def _table_has_column(inspector,table, column):

    has_column = False
    for col in inspector.get_columns(table):
        if column not in col['name']:
            continue
        has_column = True
    return has_column


def upgrade():
    conn = op.get_bind()
    inspector = Inspector.from_engine(conn)
    tables = inspector.get_table_names()
    if 'module_db_version' not in tables:
        # ### commands auto generated by Alembic - please adjust! ###
        op.create_table('module_db_version',
        sa.Column('modulename', sa.Unicode(length=128), nullable=False),
        sa.Column('moduleversion', sa.Unicode(length=64), nullable=False),
        sa.Column('dbversion', sa.Unicode(length=64), nullable=True),
        sa.Column('insertdt', sa.DateTime(), nullable=True),
        sa.PrimaryKeyConstraint('modulename', 'moduleversion', name=op.f('pk_module_db_version'))
        )
    if 'ppss_group' not in tables:
        op.create_table('ppss_group',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('name', sa.Unicode(length=128), nullable=True),
        sa.Column('enabled', sa.Integer(), nullable=True),
        sa.PrimaryKeyConstraint('id', name=op.f('pk_ppss_group')),
        sa.UniqueConstraint('name', name=op.f('uq_ppss_group_name'))
        )
    if 'ppss_permission' not in tables:
        op.create_table('ppss_permission',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('name', sa.Unicode(length=128), nullable=True),
        sa.Column('permtype', sa.Integer(), nullable=True),
        sa.Column('systemperm', sa.Unicode(length=4), nullable=True),
        sa.PrimaryKeyConstraint('id', name=op.f('pk_ppss_permission'))
        )
    if 'ppss_user' not in tables:
        op.create_table('ppss_user',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('username', sa.Unicode(length=128), nullable=True),
        sa.Column('password', sa.Unicode(length=1024), nullable=True),
        sa.Column('insertdt', sa.DateTime(), nullable=True),
        sa.Column('updatedt', sa.DateTime(), nullable=True),
        sa.Column('lastlogin', sa.DateTime(), nullable=True),
        sa.Column('enabled', sa.Integer(), nullable=True),
        sa.Column('magicnumber', sa.Text(), nullable=True),
        sa.Column('createdby', sa.Integer(), nullable=True),
        sa.Column('disabledby', sa.Integer(), nullable=True),
        sa.Column('passwordexpire', sa.DateTime(), nullable=True),
        sa.PrimaryKeyConstraint('id', name=op.f('pk_ppss_user'))
        )
    else:
        with op.batch_alter_table('ppss_user', schema=None) as batch_op:
            if not _table_has_column(inspector,'ppss_user','passwordexpire'):
                batch_op.add_column(sa.Column('passwordexpire', sa.Integer(), nullable=True))

    if 'ppss_loginhistory' not in tables:
        op.create_table('ppss_loginhistory',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('user_id', sa.Integer(), nullable=True),
        sa.Column('ipaddress', sa.Unicode(length=128), nullable=True),
        sa.Column('insertdt', sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(['user_id'], ['ppss_user.id'], name=op.f('fk_ppss_loginhistory_user_id_ppss_user')),
        sa.PrimaryKeyConstraint('id', name=op.f('pk_ppss_loginhistory'))
        )
    if 'ppss_passwordhistory' not in tables:
        op.create_table('ppss_passwordhistory',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('user_id', sa.Integer(), nullable=True),
        sa.Column('insertdt', sa.DateTime(), nullable=True),
        sa.Column('password', sa.Unicode(length=1024), nullable=True),
        sa.ForeignKeyConstraint(['user_id'], ['ppss_user.id'], name=op.f('fk_ppss_passwordhistory_user_id_ppss_user')),
        sa.PrimaryKeyConstraint('id', name=op.f('pk_ppss_passwordhistory'))
        )
    if 'ppssgroup_lk_ppsspermission' not in tables:
        op.create_table('ppssgroup_lk_ppsspermission',
        sa.Column('group_id', sa.Integer(), nullable=False),
        sa.Column('permission_id', sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(['group_id'], ['ppss_group.id'], name=op.f('fk_ppssgroup_lk_ppsspermission_group_id_ppss_group'), ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['permission_id'], ['ppss_permission.id'], name=op.f('fk_ppssgroup_lk_ppsspermission_permission_id_ppss_permission'), ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('group_id', 'permission_id', name=op.f('pk_ppssgroup_lk_ppsspermission'))
        )
    if 'ppssuser_lk_ppssgroup' not in tables:
        op.create_table('ppssuser_lk_ppssgroup',
        sa.Column('user_id', sa.Integer(), nullable=False),
        sa.Column('group_id', sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(['group_id'], ['ppss_group.id'], name=op.f('fk_ppssuser_lk_ppssgroup_group_id_ppss_group'), ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['user_id'], ['ppss_user.id'], name=op.f('fk_ppssuser_lk_ppssgroup_user_id_ppss_user'), ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('user_id', 'group_id', name=op.f('pk_ppssuser_lk_ppssgroup'))
        )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('ppssuser_lk_ppssgroup')
    op.drop_table('ppssgroup_lk_ppsspermission')
    op.drop_table('ppss_passwordhistory')
    op.drop_table('ppss_loginhistory')
    op.drop_table('ppss_user')
    op.drop_table('ppss_permission')
    op.drop_table('ppss_group')
    op.drop_table('module_db_version')
    # ### end Alembic commands ###
