# Dispy
<p align=center><img src="logo.png" width="430" alt="logo" style="text-align: center"/></p>

<p align=center>
    <a href="https://pypi.org/project/disspy">
        <img src="https://img.shields.io/pypi/v/disspy?color=blueviolet" alt="version"/>
    </a>
    <a href="https://pypi.org/project/disspy">
        <img src="https://img.shields.io/badge/language-python-blueviolet?style=flat" alt="project language"/>
    </a>
    <a href="https://pypi.org/project/disspy">
        <img src="https://img.shields.io/badge/python_versions-3.8_|_3.9_|_3.10-blueviolet?style=flat" alt="python version"/>
    </a>
    <a href="https://github.com/PyCQA/pylint">
        <img src="https://img.shields.io/badge/linting-pylint-blueviolet?style=flat" alt="linting"/></a>
    <a href="https://github.com/itttgg/dispy/actions/workflows/pylint.yml">
         <img src="https://img.shields.io/badge/pylink_mark-9.48/10-blueviolet?style=flat" alt="pylint mark"/>
    </a>
    <a href='https://disspy.readthedocs.io/en/latest/?badge=latest'>
        <img src='https://readthedocs.org/projects/disspy/badge/?version=latest' alt='documentation Status'/>
    </a>
</p>

# Advantages
- Package for ``async/await`` support
- Registering events with wrappers
- Easy code with syntax sugar

## Needs minimal 3.8 python version
Dispy is package for creating bots in Discord. This package use discord API and discord Gateway
for handle events or, for example, sending messages. Bot use for different goals; handle information
on your server, creating mini games in discord, auto moderation in your discord server and other.
For example, you can send messages use this code:

```python
import disspy  # Import package

bot = disspy.DisBot(token="YOUR_TOKEN")  # Create a bot

async def test():  # Send messages needs to execute in the async function
    channel_id = 000000  # Yours channel id
    channel = bot.get_channel(channel_id)  # Get the channel for sending to this channel a message
    
    await channel.send(content="Message!")  # Sending a message
    
if __name__ == '__main__':  # If file is started as a main file
    from asyncio import run  # Import asyncio.run
    
    run(test())  # Run async function
```

# Download package
## Download stable version

```
# Windows
pip install --upgrade disspy

# MacOS
py3 -m pip install --upgrade disspy

# Linux
sudo pip install --upgrade disspy
```

## Download dev version
```
git clone https://github.com/itttgg/dispy.git
cd dispy
pip install --upgrade .
```

# Links
<p><a href="https://github.com/itttgg/dispy">https://github.com/itttgg/dispy</a> - GitHub repo</p>
<p><a href="https://pypi.org/project/disspy">https://pypi.org/project/disspy</a> - Project site on PyPi</p>
<p><a href="https://disspy.readthedocs.io">https://disspy.readthedocs.io</a> - Site with docs for package</p>

# Using
### Creating and running bot

```python
import disspy

bot = disspy.DisBot(token="YOUR_TOKEN")

bot.run()
```

### bot.on("ready")

```python
import disspy

bot = disspy.DisBot(token="YOUR_TOKEN")


@bot.on("ready")
async def on_ready():
    print("Ready!")


bot.run()
```

### bot.on("messagec")
*message create event*

```python
import disspy

bot = disspy.DisBot(token="YOUR_TOKEN", flags=disspy.DisFlags.messages())


@bot.on("messagec")
async def on_messagec(message: disspy.DisMessage):
    await message.channel.send("Content: " + message.content)


bot.run()
```

### bot.on("messageu")
*message update event*

```python
import disspy

bot = disspy.DisBot(token="YOUR_TOKEN", flags=disspy.DisFlags.messages())


@bot.on("messageu")
async def on_messageu(message: disspy.DisMessage):
    await message.channel.send("New content of message: " + message.content)


bot.run()
```

### bot.on("messaged")
*message delete event*

```python
import disspy

bot = disspy.DisBot(token="YOUR_TOKEN", flags=disspy.DisFlags.messages())


@bot.on("messaged")
async def on_messaged(e: disspy.MessageDeleteEvent):
    await e.channel.send("You deleted message!")


bot.run()
```
