# Generated by Django 2.1.5 on 2019-02-07 04:38

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Department',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=70)),
                ('description', models.TextField(blank=True)),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Drug',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('generic_name', models.CharField(max_length=70)),
                ('brand_name', models.CharField(blank=True, default='', max_length=70)),
                ('dosage', models.CharField(blank=True, default='', max_length=35)),
                ('indication', models.CharField(blank=True, max_length=70)),
                ('price', models.FloatField(blank=True, null=True)),
            ],
            options={
                'ordering': ['generic_name'],
            },
        ),
        migrations.CreateModel(
            name='Employee',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('first_name', models.CharField(max_length=35)),
                ('middle_name', models.CharField(max_length=35)),
                ('last_name', models.CharField(max_length=35)),
                ('photo', models.ImageField(blank=True, null=True, upload_to='photos/employees/%Y/%m/%D')),
                ('gender', models.CharField(blank=True, choices=[('M', 'Male'), ('F', 'Female')], max_length=1)),
                ('civil_status', models.CharField(blank=True, choices=[('S', 'Single'), ('M', 'Married'), ('W', 'Widowed')], max_length=1)),
                ('birth_date', models.DateField()),
                ('permanent_address', models.TextField(max_length=175)),
                ('educational_attainment', models.CharField(blank=True, choices=[('G', 'Elementary Education'), ('H', 'High School'), ('U', 'Undergraduate'), ('C', 'College'), ('P', 'Post Graduate')], max_length=1)),
                ('contact_number', models.CharField(max_length=75)),
                ('email', models.EmailField(blank=True, max_length=254, null=True)),
                ('social_security', models.CharField(blank=True, max_length=24)),
                ('philhealth', models.CharField(blank=True, max_length=24)),
                ('pagibig', models.CharField(blank=True, max_length=24)),
                ('tin', models.CharField(blank=True, max_length=24)),
                ('basic_salary', models.PositiveIntegerField(blank=True, null=True)),
                ('allowance', models.PositiveIntegerField(blank=True, null=True, verbose_name='Allowance/De Minimis')),
                ('monthly_salary', models.PositiveIntegerField(blank=True, null=True)),
                ('remarks', models.TextField(blank=True)),
            ],
            options={
                'ordering': ['last_name', 'first_name'],
                'permissions': (('can_view_hris', 'View HRIS Database'),),
            },
        ),
        migrations.CreateModel(
            name='EmploymentStatus',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('employment_status', models.CharField(choices=[('C', 'Contractual'), ('P', 'Probationary'), ('R', 'Regular'), ('W', 'Resigned'), ('T', 'Terminated')], default='C', max_length=1)),
                ('date_started', models.DateField()),
                ('date_due', models.DateField(blank=True, null=True)),
                ('employee', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='cm_portal.Employee')),
            ],
            options={
                'verbose_name_plural': 'Employment statuses',
                'ordering': ['date_started'],
            },
        ),
        migrations.CreateModel(
            name='Item',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('item_type', models.CharField(choices=[('S', 'Medical Supply'), ('E', 'Medical Equipment')], default='S', max_length=1)),
                ('item_name', models.CharField(max_length=70)),
                ('brand_name', models.CharField(blank=True, max_length=70)),
                ('model', models.CharField(blank=True, max_length=70)),
                ('manufacturer', models.CharField(blank=True, max_length=70)),
                ('description', models.TextField(blank=True)),
            ],
            options={
                'ordering': ['item_name'],
            },
        ),
        migrations.CreateModel(
            name='MedicalAbstract',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('reason_for_confinement', models.TextField(blank=True)),
                ('history_of_present_illness', models.TextField(blank=True)),
                ('course_in_the_ward', models.TextField(blank=True)),
            ],
            options={
                'ordering': ['resident'],
            },
        ),
        migrations.CreateModel(
            name='MedicalEquipment',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, help_text='Unique ID for this particular medical equipment across whole inventory', primary_key=True, serialize=False)),
                ('location', models.CharField(blank=True, choices=[('R', 'Blessed Enrico Rebuschini Building'), ('L', 'Blessed Luigi Tezza Building'), ('1', 'St. Camillus Building - First floor'), ('2', 'St. Camillus Building - Second floor'), ('3', 'Building 3')], max_length=1)),
                ('date_acquired', models.DateField(blank=True, null=True)),
                ('due_back', models.DateField(blank=True, null=True)),
                ('status', models.CharField(blank=True, choices=[('m', 'Maintenance'), ('o', 'On loan'), ('a', 'Available'), ('r', 'Reserved')], default='m', help_text='Medical equipment availability', max_length=1)),
                ('item', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='cm_portal.Item')),
            ],
            options={
                'ordering': ['due_back'],
            },
        ),
        migrations.CreateModel(
            name='MedicalSupply',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, help_text='Unique ID for this particular medical supply across whole inventory', primary_key=True, serialize=False)),
                ('date_acquired', models.DateField(blank=True, null=True)),
                ('expiration_date', models.DateField(blank=True, null=True)),
                ('stocks_available', models.PositiveIntegerField(blank=True, null=True)),
                ('unit_of_measure', models.CharField(blank=True, max_length=35)),
                ('item', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='cm_portal.Item')),
            ],
            options={
                'verbose_name_plural': 'Medical supplies',
                'ordering': ['item'],
            },
        ),
        migrations.CreateModel(
            name='Medication',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateField(auto_now_add=True)),
                ('last_modified', models.DateField(auto_now=True)),
                ('frequency', models.CharField(blank=True, max_length=70)),
                ('quantity', models.PositiveIntegerField(blank=True, null=True)),
                ('discontinued', models.BooleanField(default=False)),
                ('date_started', models.DateField(blank=True, null=True)),
                ('due', models.DateField(blank=True, null=True)),
                ('medicine', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='cm_portal.Drug')),
            ],
        ),
        migrations.CreateModel(
            name='PerformanceAppraisal',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('evaluator', models.CharField(max_length=70)),
                ('evaluation_type', models.CharField(blank=True, max_length=70)),
                ('date', models.DateField(default=django.utils.timezone.now)),
                ('result', models.CharField(blank=True, choices=[('P', 'Poor'), ('F', 'Fair'), ('G', 'Good'), ('V', 'Very Good'), ('E', 'Excellent')], max_length=1)),
                ('remarks', models.TextField(blank=True)),
                ('employee', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, to='cm_portal.Employee')),
            ],
            options={
                'ordering': ['employee'],
            },
        ),
        migrations.CreateModel(
            name='Physician',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('first_name', models.CharField(max_length=35)),
                ('middle_name', models.CharField(blank=True, max_length=35)),
                ('last_name', models.CharField(max_length=35)),
                ('specialty', models.CharField(blank=True, max_length=35)),
                ('telephone', models.CharField(max_length=75)),
                ('hospital_of_choice', models.TextField()),
            ],
            options={
                'ordering': ['last_name', 'first_name'],
            },
        ),
        migrations.CreateModel(
            name='Position',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=70)),
                ('job_description', models.TextField(blank=True)),
                ('department', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='cm_portal.Department')),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Relative',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('relation_to_resident', models.CharField(blank=True, max_length=35)),
                ('first_name', models.CharField(max_length=35)),
                ('middle_name', models.CharField(blank=True, max_length=35)),
                ('last_name', models.CharField(max_length=35)),
                ('address', models.TextField(blank=True, max_length=175)),
                ('telephone', models.CharField(blank=True, max_length=75)),
            ],
            options={
                'ordering': ['last_name', 'first_name'],
            },
        ),
        migrations.CreateModel(
            name='Resident',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('first_name', models.CharField(max_length=35)),
                ('middle_name', models.CharField(blank=True, max_length=35)),
                ('last_name', models.CharField(max_length=35)),
                ('photo', models.ImageField(blank=True, null=True, upload_to='photos/residents/%Y/%m/%D')),
                ('gender', models.CharField(blank=True, choices=[('M', 'Male'), ('F', 'Female')], max_length=1)),
                ('osca_id', models.CharField(blank=True, max_length=24)),
                ('address', models.TextField(max_length=175)),
                ('birth_date', models.DateField()),
                ('birth_place', models.CharField(max_length=35)),
                ('nationality', models.CharField(max_length=70)),
                ('civil_status', models.CharField(blank=True, choices=[('S', 'Single'), ('M', 'Married'), ('W', 'Widowed')], max_length=1)),
                ('most_recent_occupation', models.CharField(blank=True, max_length=70)),
                ('admission_date', models.DateField(blank=True, null=True, verbose_name='date of admission')),
                ('admission_time', models.TimeField(blank=True, null=True, verbose_name='time of admission')),
                ('religion', models.CharField(max_length=70)),
                ('reminders', models.TextField(blank=True)),
                ('advanced_directives', models.CharField(blank=True, max_length=70)),
                ('admitting_diagnosis', models.TextField(blank=True)),
                ('level_of_care', models.CharField(blank=True, choices=[('H', 'High'), ('I', 'Intermediate'), ('L', 'Low')], max_length=1)),
                ('building', models.CharField(blank=True, choices=[('R', 'Blessed Enrico Rebuschini Building'), ('L', 'Blessed Luigi Tezza Building'), ('1', 'St. Camillus Building - First floor'), ('2', 'St. Camillus Building - Second floor'), ('3', 'Building 3')], max_length=1)),
                ('room_number', models.CharField(blank=True, max_length=70)),
                ('diet', models.TextField(blank=True)),
                ('weight', models.FloatField(blank=True, null=True)),
                ('height', models.FloatField(blank=True, null=True)),
                ('vital_status', models.CharField(choices=[('LI', 'Living'), ('DE', 'Deceased'), ('DC', 'Discharged')], default='LI', max_length=2)),
                ('died_on', models.DateField(blank=True, null=True)),
                ('discharged_on', models.DateField(blank=True, null=True)),
                ('physicians', models.ManyToManyField(blank=True, to='cm_portal.Physician')),
            ],
            options={
                'ordering': ['last_name', 'first_name'],
                'permissions': (('can_view_nursing_home', 'View nursing home database'),),
            },
        ),
        migrations.CreateModel(
            name='ResidentWeight',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateField(blank=True, null=True)),
                ('weight', models.FloatField(blank=True, null=True)),
                ('resident', models.ForeignKey(limit_choices_to={'vital_status': 'LI'}, null=True, on_delete=django.db.models.deletion.CASCADE, to='cm_portal.Resident')),
            ],
        ),
        migrations.AddField(
            model_name='relative',
            name='related_to',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='cm_portal.Resident'),
        ),
        migrations.AddField(
            model_name='medication',
            name='resident',
            field=models.ForeignKey(limit_choices_to={'vital_status': 'LI'}, null=True, on_delete=django.db.models.deletion.CASCADE, to='cm_portal.Resident'),
        ),
        migrations.AddField(
            model_name='medicalabstract',
            name='resident',
            field=models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, to='cm_portal.Resident'),
        ),
        migrations.AddField(
            model_name='employee',
            name='position',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, to='cm_portal.Position'),
        ),
    ]
