import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Datadog Monitors Downtime 3.0.0
 *
 * @schema CfnDowntimeProps
 */
export interface CfnDowntimeProps {
    /**
     * Whether or not this downtime is disabled
     *
     * @schema CfnDowntimeProps#Disabled
     */
    readonly disabled?: boolean;
    /**
     * POSIX timestamp to end the downtime. If not provided, the downtime is in effect indefinitely (i.e. until you cancel it).
     *
     * @schema CfnDowntimeProps#End
     */
    readonly end?: number;
    /**
     * Message on the downtime
     *
     * @schema CfnDowntimeProps#Message
     */
    readonly message?: string;
    /**
     * A single monitor to which the downtime applies. If not provided, the downtime applies to all monitors.
     *
     * @schema CfnDowntimeProps#MonitorId
     */
    readonly monitorId?: number;
    /**
     * A comma-separated list of monitor tags, to which the downtime applies. The resulting downtime applies to monitors that match ALL provided monitor tags.
     *
     * @schema CfnDowntimeProps#MonitorTags
     */
    readonly monitorTags?: string[];
    /**
     * The scope(s) to which the downtime applies
     *
     * @schema CfnDowntimeProps#Scope
     */
    readonly scope: string[];
    /**
     * POSIX timestamp to start the downtime. If not provided, the downtime starts the moment it is created.
     *
     * @schema CfnDowntimeProps#Start
     */
    readonly start?: number;
    /**
     * The timezone for the downtime
     *
     * @schema CfnDowntimeProps#Timezone
     */
    readonly timezone?: string;
}
/**
 * Converts an object of type 'CfnDowntimeProps' to JSON representation.
 */
export declare function toJson_CfnDowntimeProps(obj: CfnDowntimeProps | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `Datadog::Monitors::Downtime`
 *
 * @cloudformationResource Datadog::Monitors::Downtime
 * @stability external
 * @link http://unknown-url
 */
export declare class CfnDowntime extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "Datadog::Monitors::Downtime";
    /**
     * Resource props.
     */
    readonly props: CfnDowntimeProps;
    /**
     * Attribute `Datadog::Monitors::Downtime.Active`
     * @link http://unknown-url
     */
    readonly attrActive: cdk.IResolvable;
    /**
     * Attribute `Datadog::Monitors::Downtime.Canceled`
     * @link http://unknown-url
     */
    readonly attrCanceled: number;
    /**
     * Attribute `Datadog::Monitors::Downtime.CreatorId`
     * @link http://unknown-url
     */
    readonly attrCreatorId: number;
    /**
     * Attribute `Datadog::Monitors::Downtime.DowntimeType`
     * @link http://unknown-url
     */
    readonly attrDowntimeType: number;
    /**
     * Attribute `Datadog::Monitors::Downtime.Id`
     * @link http://unknown-url
     */
    readonly attrId: number;
    /**
     * Attribute `Datadog::Monitors::Downtime.ParentId`
     * @link http://unknown-url
     */
    readonly attrParentId: number;
    /**
     * Attribute `Datadog::Monitors::Downtime.UpdaterId`
     * @link http://unknown-url
     */
    readonly attrUpdaterId: number;
    /**
     * Create a new `Datadog::Monitors::Downtime`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnDowntimeProps);
}
