# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.purls_vulnerability import PurlsVulnerability
from typing import Optional, Set
from typing_extensions import Self

class PurlsPurlResponse(BaseModel):
    """
    PurlsPurlResponse
    """ # noqa: E501
    artifacts: Optional[Dict[str, Any]] = None
    cves: Optional[List[StrictStr]] = None
    licenses: Optional[List[StrictStr]] = None
    name: Optional[StrictStr] = None
    published_date: Optional[StrictStr] = None
    purl: Optional[List[StrictStr]] = None
    version: Optional[StrictStr] = None
    vulnerabilities: Optional[List[PurlsVulnerability]] = None
    __properties: ClassVar[List[str]] = ["artifacts", "cves", "licenses", "name", "published_date", "purl", "version", "vulnerabilities"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PurlsPurlResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in vulnerabilities (list)
        _items = []
        if self.vulnerabilities:
            for _item_vulnerabilities in self.vulnerabilities:
                if _item_vulnerabilities:
                    _items.append(_item_vulnerabilities.to_dict())
            _dict['vulnerabilities'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PurlsPurlResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "artifacts": obj.get("artifacts"),
            "cves": obj.get("cves"),
            "licenses": obj.get("licenses"),
            "name": obj.get("name"),
            "published_date": obj.get("published_date"),
            "purl": obj.get("purl"),
            "version": obj.get("version"),
            "vulnerabilities": [PurlsVulnerability.from_dict(_item) for _item in obj["vulnerabilities"]] if obj.get("vulnerabilities") is not None else None
        })
        return _obj


