# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.api_date_time import ApiDateTime
from vulncheck_sdk.models.api_package import ApiPackage
from vulncheck_sdk.models.api_reference import ApiReference
from typing import Optional, Set
from typing_extensions import Self

class ApiUpdate(BaseModel):
    """
    ApiUpdate
    """ # noqa: E501
    cve: Optional[List[StrictStr]] = None
    date_added: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    id: Optional[StrictStr] = Field(default=None, description="sort // key")
    issued: Optional[ApiDateTime] = None
    os_arch: Optional[StrictStr] = None
    os_version: Optional[StrictStr] = None
    packages: Optional[List[ApiPackage]] = None
    references: Optional[List[ApiReference]] = None
    severity: Optional[StrictStr] = None
    title: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    updated: Optional[ApiDateTime] = None
    __properties: ClassVar[List[str]] = ["cve", "date_added", "description", "id", "issued", "os_arch", "os_version", "packages", "references", "severity", "title", "type", "updated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiUpdate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of issued
        if self.issued:
            _dict['issued'] = self.issued.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in packages (list)
        _items = []
        if self.packages:
            for _item_packages in self.packages:
                if _item_packages:
                    _items.append(_item_packages.to_dict())
            _dict['packages'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in references (list)
        _items = []
        if self.references:
            for _item_references in self.references:
                if _item_references:
                    _items.append(_item_references.to_dict())
            _dict['references'] = _items
        # override the default output from pydantic by calling `to_dict()` of updated
        if self.updated:
            _dict['updated'] = self.updated.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiUpdate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cve": obj.get("cve"),
            "date_added": obj.get("date_added"),
            "description": obj.get("description"),
            "id": obj.get("id"),
            "issued": ApiDateTime.from_dict(obj["issued"]) if obj.get("issued") is not None else None,
            "os_arch": obj.get("os_arch"),
            "os_version": obj.get("os_version"),
            "packages": [ApiPackage.from_dict(_item) for _item in obj["packages"]] if obj.get("packages") is not None else None,
            "references": [ApiReference.from_dict(_item) for _item in obj["references"]] if obj.get("references") is not None else None,
            "severity": obj.get("severity"),
            "title": obj.get("title"),
            "type": obj.get("type"),
            "updated": ApiDateTime.from_dict(obj["updated"]) if obj.get("updated") is not None else None
        })
        return _obj


