# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.api_oss_package_hash_info import ApiOSSPackageHashInfo
from typing import Optional, Set
from typing_extensions import Self

class ApiOSSPackageDownloadInfo(BaseModel):
    """
    ApiOSSPackageDownloadInfo
    """ # noqa: E501
    hashes: Optional[List[ApiOSSPackageHashInfo]] = None
    reference: Optional[StrictStr] = None
    type: Optional[StrictStr] = Field(default=None, description="See OSSPackageDownloadInfoType* consts")
    url: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["hashes", "reference", "type", "url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiOSSPackageDownloadInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in hashes (list)
        _items = []
        if self.hashes:
            for _item_hashes in self.hashes:
                if _item_hashes:
                    _items.append(_item_hashes.to_dict())
            _dict['hashes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiOSSPackageDownloadInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "hashes": [ApiOSSPackageHashInfo.from_dict(_item) for _item in obj["hashes"]] if obj.get("hashes") is not None else None,
            "reference": obj.get("reference"),
            "type": obj.get("type"),
            "url": obj.get("url")
        })
        return _obj


