# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.api_oss_package_artifacts import ApiOSSPackageArtifacts
from vulncheck_sdk.models.api_oss_package_research_attributes import ApiOSSPackageResearchAttributes
from vulncheck_sdk.models.api_oss_package_vulnerability import ApiOSSPackageVulnerability
from typing import Optional, Set
from typing_extensions import Self

class ApiOSSPackage(BaseModel):
    """
    ApiOSSPackage
    """ # noqa: E501
    artifacts: Optional[ApiOSSPackageArtifacts] = None
    cves: Optional[List[StrictStr]] = None
    licenses: Optional[List[StrictStr]] = None
    name: Optional[StrictStr] = None
    published_date: Optional[StrictStr] = None
    purl: Optional[List[StrictStr]] = None
    research_attributes: Optional[ApiOSSPackageResearchAttributes] = None
    version: Optional[StrictStr] = None
    vulnerabilities: Optional[List[ApiOSSPackageVulnerability]] = None
    __properties: ClassVar[List[str]] = ["artifacts", "cves", "licenses", "name", "published_date", "purl", "research_attributes", "version", "vulnerabilities"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiOSSPackage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of artifacts
        if self.artifacts:
            _dict['artifacts'] = self.artifacts.to_dict()
        # override the default output from pydantic by calling `to_dict()` of research_attributes
        if self.research_attributes:
            _dict['research_attributes'] = self.research_attributes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in vulnerabilities (list)
        _items = []
        if self.vulnerabilities:
            for _item_vulnerabilities in self.vulnerabilities:
                if _item_vulnerabilities:
                    _items.append(_item_vulnerabilities.to_dict())
            _dict['vulnerabilities'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiOSSPackage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "artifacts": ApiOSSPackageArtifacts.from_dict(obj["artifacts"]) if obj.get("artifacts") is not None else None,
            "cves": obj.get("cves"),
            "licenses": obj.get("licenses"),
            "name": obj.get("name"),
            "published_date": obj.get("published_date"),
            "purl": obj.get("purl"),
            "research_attributes": ApiOSSPackageResearchAttributes.from_dict(obj["research_attributes"]) if obj.get("research_attributes") is not None else None,
            "version": obj.get("version"),
            "vulnerabilities": [ApiOSSPackageVulnerability.from_dict(_item) for _item in obj["vulnerabilities"]] if obj.get("vulnerabilities") is not None else None
        })
        return _obj


