# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from vulncheck_sdk.models.api_nvd20_temporal_associated_base_metric import ApiNVD20TemporalAssociatedBaseMetric
from typing import Optional, Set
from typing_extensions import Self

class ApiNVD20TemporalCVSSV3(BaseModel):
    """
    ApiNVD20TemporalCVSSV3
    """ # noqa: E501
    associated_base_metric_v3: Optional[ApiNVD20TemporalAssociatedBaseMetric] = Field(default=None, alias="associatedBaseMetricV3")
    exploit_code_maturity: Optional[StrictStr] = Field(default=None, alias="exploitCodeMaturity")
    remediation_level: Optional[StrictStr] = Field(default=None, alias="remediationLevel")
    report_confidence: Optional[StrictStr] = Field(default=None, alias="reportConfidence")
    temporal_score: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="temporalScore")
    vector_string: Optional[StrictStr] = Field(default=None, alias="vectorString")
    version: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["associatedBaseMetricV3", "exploitCodeMaturity", "remediationLevel", "reportConfidence", "temporalScore", "vectorString", "version"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiNVD20TemporalCVSSV3 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of associated_base_metric_v3
        if self.associated_base_metric_v3:
            _dict['associatedBaseMetricV3'] = self.associated_base_metric_v3.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiNVD20TemporalCVSSV3 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "associatedBaseMetricV3": ApiNVD20TemporalAssociatedBaseMetric.from_dict(obj["associatedBaseMetricV3"]) if obj.get("associatedBaseMetricV3") is not None else None,
            "exploitCodeMaturity": obj.get("exploitCodeMaturity"),
            "remediationLevel": obj.get("remediationLevel"),
            "reportConfidence": obj.get("reportConfidence"),
            "temporalScore": obj.get("temporalScore"),
            "vectorString": obj.get("vectorString"),
            "version": obj.get("version")
        })
        return _obj


