# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.api_epss import ApiEPSS
from vulncheck_sdk.models.api_nvd20_cvss_metric_v2 import ApiNVD20CvssMetricV2
from vulncheck_sdk.models.api_nvd20_cvss_metric_v3 import ApiNVD20CvssMetricV3
from vulncheck_sdk.models.api_nvd20_cvss_metric_v40 import ApiNVD20CvssMetricV40
from vulncheck_sdk.models.api_nvd20_temporal_cvssv2 import ApiNVD20TemporalCVSSV2
from vulncheck_sdk.models.api_nvd20_temporal_cvssv3 import ApiNVD20TemporalCVSSV3
from vulncheck_sdk.models.api_nvd20_threat_cvssv40 import ApiNVD20ThreatCVSSV40
from vulncheck_sdk.models.api_ssvc import ApiSSVC
from typing import Optional, Set
from typing_extensions import Self

class ApiNVD20MetricExtended(BaseModel):
    """
    ApiNVD20MetricExtended
    """ # noqa: E501
    cvss_metric_v2: Optional[List[ApiNVD20CvssMetricV2]] = Field(default=None, alias="cvssMetricV2")
    cvss_metric_v30: Optional[List[ApiNVD20CvssMetricV3]] = Field(default=None, alias="cvssMetricV30")
    cvss_metric_v31: Optional[List[ApiNVD20CvssMetricV3]] = Field(default=None, alias="cvssMetricV31")
    cvss_metric_v40: Optional[List[ApiNVD20CvssMetricV40]] = Field(default=None, alias="cvssMetricV40")
    epss: Optional[ApiEPSS] = None
    ssvc: Optional[List[ApiSSVC]] = None
    temporal_cvssv2: Optional[ApiNVD20TemporalCVSSV2] = Field(default=None, alias="temporalCVSSV2")
    temporal_cvssv2_secondary: Optional[List[ApiNVD20TemporalCVSSV2]] = Field(default=None, alias="temporalCVSSV2Secondary")
    temporal_cvssv30: Optional[ApiNVD20TemporalCVSSV3] = Field(default=None, alias="temporalCVSSV30")
    temporal_cvssv30_secondary: Optional[List[ApiNVD20TemporalCVSSV3]] = Field(default=None, alias="temporalCVSSV30Secondary")
    temporal_cvssv31: Optional[ApiNVD20TemporalCVSSV3] = Field(default=None, alias="temporalCVSSV31")
    temporal_cvssv31_secondary: Optional[List[ApiNVD20TemporalCVSSV3]] = Field(default=None, alias="temporalCVSSV31Secondary")
    threat_cvssv40: Optional[ApiNVD20ThreatCVSSV40] = Field(default=None, alias="threatCVSSV40")
    threat_cvssv40_secondary: Optional[List[ApiNVD20ThreatCVSSV40]] = Field(default=None, alias="threatCVSSV40Secondary")
    __properties: ClassVar[List[str]] = ["cvssMetricV2", "cvssMetricV30", "cvssMetricV31", "cvssMetricV40", "epss", "ssvc", "temporalCVSSV2", "temporalCVSSV2Secondary", "temporalCVSSV30", "temporalCVSSV30Secondary", "temporalCVSSV31", "temporalCVSSV31Secondary", "threatCVSSV40", "threatCVSSV40Secondary"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiNVD20MetricExtended from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in cvss_metric_v2 (list)
        _items = []
        if self.cvss_metric_v2:
            for _item_cvss_metric_v2 in self.cvss_metric_v2:
                if _item_cvss_metric_v2:
                    _items.append(_item_cvss_metric_v2.to_dict())
            _dict['cvssMetricV2'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in cvss_metric_v30 (list)
        _items = []
        if self.cvss_metric_v30:
            for _item_cvss_metric_v30 in self.cvss_metric_v30:
                if _item_cvss_metric_v30:
                    _items.append(_item_cvss_metric_v30.to_dict())
            _dict['cvssMetricV30'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in cvss_metric_v31 (list)
        _items = []
        if self.cvss_metric_v31:
            for _item_cvss_metric_v31 in self.cvss_metric_v31:
                if _item_cvss_metric_v31:
                    _items.append(_item_cvss_metric_v31.to_dict())
            _dict['cvssMetricV31'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in cvss_metric_v40 (list)
        _items = []
        if self.cvss_metric_v40:
            for _item_cvss_metric_v40 in self.cvss_metric_v40:
                if _item_cvss_metric_v40:
                    _items.append(_item_cvss_metric_v40.to_dict())
            _dict['cvssMetricV40'] = _items
        # override the default output from pydantic by calling `to_dict()` of epss
        if self.epss:
            _dict['epss'] = self.epss.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in ssvc (list)
        _items = []
        if self.ssvc:
            for _item_ssvc in self.ssvc:
                if _item_ssvc:
                    _items.append(_item_ssvc.to_dict())
            _dict['ssvc'] = _items
        # override the default output from pydantic by calling `to_dict()` of temporal_cvssv2
        if self.temporal_cvssv2:
            _dict['temporalCVSSV2'] = self.temporal_cvssv2.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in temporal_cvssv2_secondary (list)
        _items = []
        if self.temporal_cvssv2_secondary:
            for _item_temporal_cvssv2_secondary in self.temporal_cvssv2_secondary:
                if _item_temporal_cvssv2_secondary:
                    _items.append(_item_temporal_cvssv2_secondary.to_dict())
            _dict['temporalCVSSV2Secondary'] = _items
        # override the default output from pydantic by calling `to_dict()` of temporal_cvssv30
        if self.temporal_cvssv30:
            _dict['temporalCVSSV30'] = self.temporal_cvssv30.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in temporal_cvssv30_secondary (list)
        _items = []
        if self.temporal_cvssv30_secondary:
            for _item_temporal_cvssv30_secondary in self.temporal_cvssv30_secondary:
                if _item_temporal_cvssv30_secondary:
                    _items.append(_item_temporal_cvssv30_secondary.to_dict())
            _dict['temporalCVSSV30Secondary'] = _items
        # override the default output from pydantic by calling `to_dict()` of temporal_cvssv31
        if self.temporal_cvssv31:
            _dict['temporalCVSSV31'] = self.temporal_cvssv31.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in temporal_cvssv31_secondary (list)
        _items = []
        if self.temporal_cvssv31_secondary:
            for _item_temporal_cvssv31_secondary in self.temporal_cvssv31_secondary:
                if _item_temporal_cvssv31_secondary:
                    _items.append(_item_temporal_cvssv31_secondary.to_dict())
            _dict['temporalCVSSV31Secondary'] = _items
        # override the default output from pydantic by calling `to_dict()` of threat_cvssv40
        if self.threat_cvssv40:
            _dict['threatCVSSV40'] = self.threat_cvssv40.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in threat_cvssv40_secondary (list)
        _items = []
        if self.threat_cvssv40_secondary:
            for _item_threat_cvssv40_secondary in self.threat_cvssv40_secondary:
                if _item_threat_cvssv40_secondary:
                    _items.append(_item_threat_cvssv40_secondary.to_dict())
            _dict['threatCVSSV40Secondary'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiNVD20MetricExtended from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cvssMetricV2": [ApiNVD20CvssMetricV2.from_dict(_item) for _item in obj["cvssMetricV2"]] if obj.get("cvssMetricV2") is not None else None,
            "cvssMetricV30": [ApiNVD20CvssMetricV3.from_dict(_item) for _item in obj["cvssMetricV30"]] if obj.get("cvssMetricV30") is not None else None,
            "cvssMetricV31": [ApiNVD20CvssMetricV3.from_dict(_item) for _item in obj["cvssMetricV31"]] if obj.get("cvssMetricV31") is not None else None,
            "cvssMetricV40": [ApiNVD20CvssMetricV40.from_dict(_item) for _item in obj["cvssMetricV40"]] if obj.get("cvssMetricV40") is not None else None,
            "epss": ApiEPSS.from_dict(obj["epss"]) if obj.get("epss") is not None else None,
            "ssvc": [ApiSSVC.from_dict(_item) for _item in obj["ssvc"]] if obj.get("ssvc") is not None else None,
            "temporalCVSSV2": ApiNVD20TemporalCVSSV2.from_dict(obj["temporalCVSSV2"]) if obj.get("temporalCVSSV2") is not None else None,
            "temporalCVSSV2Secondary": [ApiNVD20TemporalCVSSV2.from_dict(_item) for _item in obj["temporalCVSSV2Secondary"]] if obj.get("temporalCVSSV2Secondary") is not None else None,
            "temporalCVSSV30": ApiNVD20TemporalCVSSV3.from_dict(obj["temporalCVSSV30"]) if obj.get("temporalCVSSV30") is not None else None,
            "temporalCVSSV30Secondary": [ApiNVD20TemporalCVSSV3.from_dict(_item) for _item in obj["temporalCVSSV30Secondary"]] if obj.get("temporalCVSSV30Secondary") is not None else None,
            "temporalCVSSV31": ApiNVD20TemporalCVSSV3.from_dict(obj["temporalCVSSV31"]) if obj.get("temporalCVSSV31") is not None else None,
            "temporalCVSSV31Secondary": [ApiNVD20TemporalCVSSV3.from_dict(_item) for _item in obj["temporalCVSSV31Secondary"]] if obj.get("temporalCVSSV31Secondary") is not None else None,
            "threatCVSSV40": ApiNVD20ThreatCVSSV40.from_dict(obj["threatCVSSV40"]) if obj.get("threatCVSSV40") is not None else None,
            "threatCVSSV40Secondary": [ApiNVD20ThreatCVSSV40.from_dict(_item) for _item in obj["threatCVSSV40Secondary"]] if obj.get("threatCVSSV40Secondary") is not None else None
        })
        return _obj


