# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.api_mitre_detection_tech import ApiMitreDetectionTech
from vulncheck_sdk.models.api_mitre_mitigation2_d3fend_mapping import ApiMitreMitigation2D3fendMapping
from vulncheck_sdk.models.api_mitre_mitigation_tech import ApiMitreMitigationTech
from typing import Optional, Set
from typing_extensions import Self

class ApiMitreAttackTech(BaseModel):
    """
    ApiMitreAttackTech
    """ # noqa: E501
    d3fendmapping: Optional[List[ApiMitreMitigation2D3fendMapping]] = None
    detections: Optional[List[ApiMitreDetectionTech]] = None
    domain: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    mitigations: Optional[List[ApiMitreMitigationTech]] = None
    name: Optional[StrictStr] = None
    subtechnique: Optional[StrictBool] = None
    tactics: Optional[List[StrictStr]] = None
    url: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["d3fendmapping", "detections", "domain", "id", "mitigations", "name", "subtechnique", "tactics", "url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiMitreAttackTech from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in d3fendmapping (list)
        _items = []
        if self.d3fendmapping:
            for _item_d3fendmapping in self.d3fendmapping:
                if _item_d3fendmapping:
                    _items.append(_item_d3fendmapping.to_dict())
            _dict['d3fendmapping'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in detections (list)
        _items = []
        if self.detections:
            for _item_detections in self.detections:
                if _item_detections:
                    _items.append(_item_detections.to_dict())
            _dict['detections'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in mitigations (list)
        _items = []
        if self.mitigations:
            for _item_mitigations in self.mitigations:
                if _item_mitigations:
                    _items.append(_item_mitigations.to_dict())
            _dict['mitigations'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiMitreAttackTech from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "d3fendmapping": [ApiMitreMitigation2D3fendMapping.from_dict(_item) for _item in obj["d3fendmapping"]] if obj.get("d3fendmapping") is not None else None,
            "detections": [ApiMitreDetectionTech.from_dict(_item) for _item in obj["detections"]] if obj.get("detections") is not None else None,
            "domain": obj.get("domain"),
            "id": obj.get("id"),
            "mitigations": [ApiMitreMitigationTech.from_dict(_item) for _item in obj["mitigations"]] if obj.get("mitigations") is not None else None,
            "name": obj.get("name"),
            "subtechnique": obj.get("subtechnique"),
            "tactics": obj.get("tactics"),
            "url": obj.get("url")
        })
        return _obj


