# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.api_initial_access_artifact import ApiInitialAccessArtifact
from typing import Optional, Set
from typing_extensions import Self

class ApiInitialAccess(BaseModel):
    """
    ApiInitialAccess
    """ # noqa: E501
    artifacts: Optional[List[ApiInitialAccessArtifact]] = Field(default=None, description="Artifacts holds the set of available artifacts for this vulnerability, such as exploit, shodan queries, PCAP traces, and others.")
    cve: Optional[StrictStr] = Field(default=None, description="CVE identifier for the given initial access record.")
    in_kev: Optional[StrictBool] = Field(default=None, description="InKEV is true if this artifact is in CISA's Known Exploited Vulnerabilities (KEV) data set; otherwise, false.", alias="inKEV")
    in_vckev: Optional[StrictBool] = Field(default=None, description="InVCKEV is true if this artifact is in VulnCheck's Known Exploited Vulnerabilities (VCKEV) data set; otherwise, false.", alias="inVCKEV")
    vulnerable_cpes: Optional[List[StrictStr]] = Field(default=None, description="VulnerableCPEs is the list of vulnerable CPE strings associated with this CVE and artifact(s).")
    __properties: ClassVar[List[str]] = ["artifacts", "cve", "inKEV", "inVCKEV", "vulnerable_cpes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiInitialAccess from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in artifacts (list)
        _items = []
        if self.artifacts:
            for _item_artifacts in self.artifacts:
                if _item_artifacts:
                    _items.append(_item_artifacts.to_dict())
            _dict['artifacts'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiInitialAccess from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "artifacts": [ApiInitialAccessArtifact.from_dict(_item) for _item in obj["artifacts"]] if obj.get("artifacts") is not None else None,
            "cve": obj.get("cve"),
            "inKEV": obj.get("inKEV"),
            "inVCKEV": obj.get("inVCKEV"),
            "vulnerable_cpes": obj.get("vulnerable_cpes")
        })
        return _obj


