# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_zdi_product import AdvisoryZDIProduct
from vulncheck_sdk.models.advisory_zdi_response import AdvisoryZDIResponse
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryZDI(BaseModel):
    """
    AdvisoryZDI
    """ # noqa: E501
    cves: Optional[List[StrictStr]] = None
    cvss_score: Optional[StrictStr] = None
    cvss_vector: Optional[StrictStr] = None
    cvss_version: Optional[StrictStr] = None
    discoverers: Optional[List[StrictStr]] = None
    filter_ids_dv: Optional[List[StrictStr]] = None
    last_updated_at: Optional[StrictStr] = None
    products: Optional[List[AdvisoryZDIProduct]] = None
    public_advisory: Optional[StrictStr] = None
    published_date: Optional[StrictStr] = None
    responses: Optional[List[AdvisoryZDIResponse]] = None
    title: Optional[StrictStr] = None
    zdi_can: Optional[StrictStr] = None
    zdi_public: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["cves", "cvss_score", "cvss_vector", "cvss_version", "discoverers", "filter_ids_dv", "last_updated_at", "products", "public_advisory", "published_date", "responses", "title", "zdi_can", "zdi_public"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryZDI from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in products (list)
        _items = []
        if self.products:
            for _item_products in self.products:
                if _item_products:
                    _items.append(_item_products.to_dict())
            _dict['products'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in responses (list)
        _items = []
        if self.responses:
            for _item_responses in self.responses:
                if _item_responses:
                    _items.append(_item_responses.to_dict())
            _dict['responses'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryZDI from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cves": obj.get("cves"),
            "cvss_score": obj.get("cvss_score"),
            "cvss_vector": obj.get("cvss_vector"),
            "cvss_version": obj.get("cvss_version"),
            "discoverers": obj.get("discoverers"),
            "filter_ids_dv": obj.get("filter_ids_dv"),
            "last_updated_at": obj.get("last_updated_at"),
            "products": [AdvisoryZDIProduct.from_dict(_item) for _item in obj["products"]] if obj.get("products") is not None else None,
            "public_advisory": obj.get("public_advisory"),
            "published_date": obj.get("published_date"),
            "responses": [AdvisoryZDIResponse.from_dict(_item) for _item in obj["responses"]] if obj.get("responses") is not None else None,
            "title": obj.get("title"),
            "zdi_can": obj.get("zdi_can"),
            "zdi_public": obj.get("zdi_public")
        })
        return _obj


