# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_log_source import AdvisoryLogSource
from vulncheck_sdk.models.advisory_related_rule import AdvisoryRelatedRule
from typing import Optional, Set
from typing_extensions import Self

class AdvisorySigmaRuleRule(BaseModel):
    """
    AdvisorySigmaRuleRule
    """ # noqa: E501
    author: Optional[StrictStr] = None
    var_date: Optional[StrictStr] = Field(default=None, alias="date")
    description: Optional[StrictStr] = None
    detection: Optional[Dict[str, Any]] = None
    false_positives: Optional[List[StrictStr]] = None
    fields: Optional[List[StrictStr]] = None
    id: Optional[StrictStr] = None
    level: Optional[StrictStr] = None
    logsource: Optional[AdvisoryLogSource] = None
    modified: Optional[StrictStr] = None
    references: Optional[List[StrictStr]] = None
    related: Optional[List[AdvisoryRelatedRule]] = None
    status: Optional[StrictStr] = None
    tags: Optional[List[StrictStr]] = None
    title: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["author", "date", "description", "detection", "false_positives", "fields", "id", "level", "logsource", "modified", "references", "related", "status", "tags", "title"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisorySigmaRuleRule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of logsource
        if self.logsource:
            _dict['logsource'] = self.logsource.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in related (list)
        _items = []
        if self.related:
            for _item_related in self.related:
                if _item_related:
                    _items.append(_item_related.to_dict())
            _dict['related'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisorySigmaRuleRule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "author": obj.get("author"),
            "date": obj.get("date"),
            "description": obj.get("description"),
            "detection": obj.get("detection"),
            "false_positives": obj.get("false_positives"),
            "fields": obj.get("fields"),
            "id": obj.get("id"),
            "level": obj.get("level"),
            "logsource": AdvisoryLogSource.from_dict(obj["logsource"]) if obj.get("logsource") is not None else None,
            "modified": obj.get("modified"),
            "references": obj.get("references"),
            "related": [AdvisoryRelatedRule.from_dict(_item) for _item in obj["related"]] if obj.get("related") is not None else None,
            "status": obj.get("status"),
            "tags": obj.get("tags"),
            "title": obj.get("title")
        })
        return _obj


