# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_cve_detail import AdvisoryCVEDetail
from vulncheck_sdk.models.advisory_hardware_update import AdvisoryHardwareUpdate
from vulncheck_sdk.models.advisory_nvidia_revision import AdvisoryNvidiaRevision
from vulncheck_sdk.models.advisory_software_update import AdvisorySoftwareUpdate
from typing import Optional, Set
from typing_extensions import Self

class AdvisorySecurityBulletin(BaseModel):
    """
    AdvisorySecurityBulletin
    """ # noqa: E501
    acknowledgement: Optional[StrictStr] = None
    bulletin_id: Optional[StrictStr] = Field(default=None, alias="bulletinId")
    cve: Optional[List[StrictStr]] = None
    cvedetails: Optional[List[AdvisoryCVEDetail]] = None
    date_added: Optional[StrictStr] = None
    hardware_updates: Optional[List[AdvisoryHardwareUpdate]] = Field(default=None, alias="hardwareUpdates")
    last_updated: Optional[StrictStr] = Field(default=None, alias="lastUpdated")
    link: Optional[StrictStr] = None
    revisions: Optional[List[AdvisoryNvidiaRevision]] = None
    severity: Optional[StrictStr] = None
    software_updates: Optional[List[AdvisorySoftwareUpdate]] = Field(default=None, alias="softwareUpdates")
    title: Optional[StrictStr] = None
    updated_at: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["acknowledgement", "bulletinId", "cve", "cvedetails", "date_added", "hardwareUpdates", "lastUpdated", "link", "revisions", "severity", "softwareUpdates", "title", "updated_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisorySecurityBulletin from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in cvedetails (list)
        _items = []
        if self.cvedetails:
            for _item_cvedetails in self.cvedetails:
                if _item_cvedetails:
                    _items.append(_item_cvedetails.to_dict())
            _dict['cvedetails'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in hardware_updates (list)
        _items = []
        if self.hardware_updates:
            for _item_hardware_updates in self.hardware_updates:
                if _item_hardware_updates:
                    _items.append(_item_hardware_updates.to_dict())
            _dict['hardwareUpdates'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in revisions (list)
        _items = []
        if self.revisions:
            for _item_revisions in self.revisions:
                if _item_revisions:
                    _items.append(_item_revisions.to_dict())
            _dict['revisions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in software_updates (list)
        _items = []
        if self.software_updates:
            for _item_software_updates in self.software_updates:
                if _item_software_updates:
                    _items.append(_item_software_updates.to_dict())
            _dict['softwareUpdates'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisorySecurityBulletin from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "acknowledgement": obj.get("acknowledgement"),
            "bulletinId": obj.get("bulletinId"),
            "cve": obj.get("cve"),
            "cvedetails": [AdvisoryCVEDetail.from_dict(_item) for _item in obj["cvedetails"]] if obj.get("cvedetails") is not None else None,
            "date_added": obj.get("date_added"),
            "hardwareUpdates": [AdvisoryHardwareUpdate.from_dict(_item) for _item in obj["hardwareUpdates"]] if obj.get("hardwareUpdates") is not None else None,
            "lastUpdated": obj.get("lastUpdated"),
            "link": obj.get("link"),
            "revisions": [AdvisoryNvidiaRevision.from_dict(_item) for _item in obj["revisions"]] if obj.get("revisions") is not None else None,
            "severity": obj.get("severity"),
            "softwareUpdates": [AdvisorySoftwareUpdate.from_dict(_item) for _item in obj["softwareUpdates"]] if obj.get("softwareUpdates") is not None else None,
            "title": obj.get("title"),
            "updated_at": obj.get("updated_at")
        })
        return _obj


