# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_restart_data import AdvisoryRestartData
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryRemediationData(BaseModel):
    """
    AdvisoryRemediationData
    """ # noqa: E501
    category: Optional[StrictStr] = None
    var_date: Optional[StrictStr] = Field(default=None, alias="date")
    details: Optional[StrictStr] = None
    entitlements: Optional[List[StrictStr]] = None
    group_ids: Optional[List[StrictStr]] = None
    product_ids: Optional[List[StrictStr]] = None
    restart_required: Optional[AdvisoryRestartData] = None
    __properties: ClassVar[List[str]] = ["category", "date", "details", "entitlements", "group_ids", "product_ids", "restart_required"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryRemediationData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of restart_required
        if self.restart_required:
            _dict['restart_required'] = self.restart_required.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryRemediationData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "category": obj.get("category"),
            "date": obj.get("date"),
            "details": obj.get("details"),
            "entitlements": obj.get("entitlements"),
            "group_ids": obj.get("group_ids"),
            "product_ids": obj.get("product_ids"),
            "restart_required": AdvisoryRestartData.from_dict(obj["restart_required"]) if obj.get("restart_required") is not None else None
        })
        return _obj


