# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from vulncheck_sdk.models.advisory_affected_rel import AdvisoryAffectedRel
from vulncheck_sdk.models.advisory_package_stat import AdvisoryPackageStat
from vulncheck_sdk.models.advisory_vuln_check_package import AdvisoryVulnCheckPackage
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryRedhatCVE(BaseModel):
    """
    AdvisoryRedhatCVE
    """ # noqa: E501
    advisories: Optional[List[StrictStr]] = None
    advisory_csaf_vex_url: Optional[List[StrictStr]] = None
    affected_packages: Optional[List[StrictStr]] = Field(default=None, description="used for un-marshlling from redhat")
    affected_release: Optional[List[AdvisoryAffectedRel]] = None
    bugzilla: Optional[StrictStr] = None
    bugzilla_description: Optional[StrictStr] = None
    cve: Optional[List[StrictStr]] = None
    cve_csaf_vex_url: Optional[StrictStr] = None
    cvss3_score: Optional[StrictStr] = None
    cvss3_scoring_vector: Optional[StrictStr] = None
    cvss_score: Optional[Union[StrictFloat, StrictInt]] = None
    cvss_scoring_vector: Optional[StrictStr] = None
    cwe: Optional[StrictStr] = None
    package_state: Optional[List[AdvisoryPackageStat]] = None
    packages: Optional[List[AdvisoryVulnCheckPackage]] = Field(default=None, description="used to index into vulncheck OS")
    public_date: Optional[StrictStr] = None
    resource_url: Optional[StrictStr] = None
    severity: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["advisories", "advisory_csaf_vex_url", "affected_packages", "affected_release", "bugzilla", "bugzilla_description", "cve", "cve_csaf_vex_url", "cvss3_score", "cvss3_scoring_vector", "cvss_score", "cvss_scoring_vector", "cwe", "package_state", "packages", "public_date", "resource_url", "severity"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryRedhatCVE from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in affected_release (list)
        _items = []
        if self.affected_release:
            for _item_affected_release in self.affected_release:
                if _item_affected_release:
                    _items.append(_item_affected_release.to_dict())
            _dict['affected_release'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in package_state (list)
        _items = []
        if self.package_state:
            for _item_package_state in self.package_state:
                if _item_package_state:
                    _items.append(_item_package_state.to_dict())
            _dict['package_state'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in packages (list)
        _items = []
        if self.packages:
            for _item_packages in self.packages:
                if _item_packages:
                    _items.append(_item_packages.to_dict())
            _dict['packages'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryRedhatCVE from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "advisories": obj.get("advisories"),
            "advisory_csaf_vex_url": obj.get("advisory_csaf_vex_url"),
            "affected_packages": obj.get("affected_packages"),
            "affected_release": [AdvisoryAffectedRel.from_dict(_item) for _item in obj["affected_release"]] if obj.get("affected_release") is not None else None,
            "bugzilla": obj.get("bugzilla"),
            "bugzilla_description": obj.get("bugzilla_description"),
            "cve": obj.get("cve"),
            "cve_csaf_vex_url": obj.get("cve_csaf_vex_url"),
            "cvss3_score": obj.get("cvss3_score"),
            "cvss3_scoring_vector": obj.get("cvss3_scoring_vector"),
            "cvss_score": obj.get("cvss_score"),
            "cvss_scoring_vector": obj.get("cvss_scoring_vector"),
            "cwe": obj.get("cwe"),
            "package_state": [AdvisoryPackageStat.from_dict(_item) for _item in obj["package_state"]] if obj.get("package_state") is not None else None,
            "packages": [AdvisoryVulnCheckPackage.from_dict(_item) for _item in obj["packages"]] if obj.get("packages") is not None else None,
            "public_date": obj.get("public_date"),
            "resource_url": obj.get("resource_url"),
            "severity": obj.get("severity")
        })
        return _obj


