# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_cvsss_v23 import AdvisoryCvsssV23
from vulncheck_sdk.models.advisory_patch import AdvisoryPatch
from vulncheck_sdk.models.advisory_vendor_ref import AdvisoryVendorRef
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryQualysQID(BaseModel):
    """
    AdvisoryQualysQID
    """ # noqa: E501
    consequence: Optional[StrictStr] = None
    cve: Optional[List[StrictStr]] = None
    cvss_v2: Optional[List[AdvisoryCvsssV23]] = None
    cvss_v3: Optional[List[AdvisoryCvsssV23]] = None
    date_added: Optional[StrictStr] = None
    date_insert: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    patches: Optional[List[AdvisoryPatch]] = None
    published: Optional[StrictStr] = None
    qid: Optional[StrictStr] = None
    severity: Optional[StrictStr] = None
    solution: Optional[StrictStr] = None
    title: Optional[StrictStr] = None
    url: Optional[StrictStr] = None
    vendor_refs: Optional[List[AdvisoryVendorRef]] = None
    __properties: ClassVar[List[str]] = ["consequence", "cve", "cvss_v2", "cvss_v3", "date_added", "date_insert", "description", "patches", "published", "qid", "severity", "solution", "title", "url", "vendor_refs"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryQualysQID from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in cvss_v2 (list)
        _items = []
        if self.cvss_v2:
            for _item_cvss_v2 in self.cvss_v2:
                if _item_cvss_v2:
                    _items.append(_item_cvss_v2.to_dict())
            _dict['cvss_v2'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in cvss_v3 (list)
        _items = []
        if self.cvss_v3:
            for _item_cvss_v3 in self.cvss_v3:
                if _item_cvss_v3:
                    _items.append(_item_cvss_v3.to_dict())
            _dict['cvss_v3'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in patches (list)
        _items = []
        if self.patches:
            for _item_patches in self.patches:
                if _item_patches:
                    _items.append(_item_patches.to_dict())
            _dict['patches'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in vendor_refs (list)
        _items = []
        if self.vendor_refs:
            for _item_vendor_refs in self.vendor_refs:
                if _item_vendor_refs:
                    _items.append(_item_vendor_refs.to_dict())
            _dict['vendor_refs'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryQualysQID from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "consequence": obj.get("consequence"),
            "cve": obj.get("cve"),
            "cvss_v2": [AdvisoryCvsssV23.from_dict(_item) for _item in obj["cvss_v2"]] if obj.get("cvss_v2") is not None else None,
            "cvss_v3": [AdvisoryCvsssV23.from_dict(_item) for _item in obj["cvss_v3"]] if obj.get("cvss_v3") is not None else None,
            "date_added": obj.get("date_added"),
            "date_insert": obj.get("date_insert"),
            "description": obj.get("description"),
            "patches": [AdvisoryPatch.from_dict(_item) for _item in obj["patches"]] if obj.get("patches") is not None else None,
            "published": obj.get("published"),
            "qid": obj.get("qid"),
            "severity": obj.get("severity"),
            "solution": obj.get("solution"),
            "title": obj.get("title"),
            "url": obj.get("url"),
            "vendor_refs": [AdvisoryVendorRef.from_dict(_item) for _item in obj["vendor_refs"]] if obj.get("vendor_refs") is not None else None
        })
        return _obj


