# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_csaf_relationship import AdvisoryCSAFRelationship
from vulncheck_sdk.models.advisory_product import AdvisoryProduct
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryProductBranch(BaseModel):
    """
    AdvisoryProductBranch
    """ # noqa: E501
    branches: Optional[List[AdvisoryProductBranch]] = None
    category: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    product: Optional[AdvisoryProduct] = None
    relationships: Optional[List[AdvisoryCSAFRelationship]] = None
    __properties: ClassVar[List[str]] = ["branches", "category", "name", "product", "relationships"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryProductBranch from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in branches (list)
        _items = []
        if self.branches:
            for _item_branches in self.branches:
                if _item_branches:
                    _items.append(_item_branches.to_dict())
            _dict['branches'] = _items
        # override the default output from pydantic by calling `to_dict()` of product
        if self.product:
            _dict['product'] = self.product.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in relationships (list)
        _items = []
        if self.relationships:
            for _item_relationships in self.relationships:
                if _item_relationships:
                    _items.append(_item_relationships.to_dict())
            _dict['relationships'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryProductBranch from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "branches": [AdvisoryProductBranch.from_dict(_item) for _item in obj["branches"]] if obj.get("branches") is not None else None,
            "category": obj.get("category"),
            "name": obj.get("name"),
            "product": AdvisoryProduct.from_dict(obj["product"]) if obj.get("product") is not None else None,
            "relationships": [AdvisoryCSAFRelationship.from_dict(_item) for _item in obj["relationships"]] if obj.get("relationships") is not None else None
        })
        return _obj

# TODO: Rewrite to not use raise_errors
AdvisoryProductBranch.model_rebuild(raise_errors=False)

