# coding: utf-8

"""
    VulnCheck API

    Version 3 of the VulnCheck API

    The version of the OpenAPI document: 3.0
    Contact: support@vulncheck.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vulncheck_sdk.models.advisory_curl_affected import AdvisoryCurlAffected
from vulncheck_sdk.models.advisory_curl_credit import AdvisoryCurlCredit
from vulncheck_sdk.models.advisory_db_specific import AdvisoryDBSpecific
from typing import Optional, Set
from typing_extensions import Self

class AdvisoryOCurl(BaseModel):
    """
    AdvisoryOCurl
    """ # noqa: E501
    affected: Optional[List[AdvisoryCurlAffected]] = None
    aliases: Optional[List[StrictStr]] = None
    credits: Optional[List[AdvisoryCurlCredit]] = None
    database_specific: Optional[AdvisoryDBSpecific] = None
    details: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    modified: Optional[StrictStr] = None
    published: Optional[StrictStr] = None
    schema_version: Optional[StrictStr] = None
    summary: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["affected", "aliases", "credits", "database_specific", "details", "id", "modified", "published", "schema_version", "summary"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdvisoryOCurl from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in affected (list)
        _items = []
        if self.affected:
            for _item_affected in self.affected:
                if _item_affected:
                    _items.append(_item_affected.to_dict())
            _dict['affected'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in credits (list)
        _items = []
        if self.credits:
            for _item_credits in self.credits:
                if _item_credits:
                    _items.append(_item_credits.to_dict())
            _dict['credits'] = _items
        # override the default output from pydantic by calling `to_dict()` of database_specific
        if self.database_specific:
            _dict['database_specific'] = self.database_specific.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdvisoryOCurl from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "affected": [AdvisoryCurlAffected.from_dict(_item) for _item in obj["affected"]] if obj.get("affected") is not None else None,
            "aliases": obj.get("aliases"),
            "credits": [AdvisoryCurlCredit.from_dict(_item) for _item in obj["credits"]] if obj.get("credits") is not None else None,
            "database_specific": AdvisoryDBSpecific.from_dict(obj["database_specific"]) if obj.get("database_specific") is not None else None,
            "details": obj.get("details"),
            "id": obj.get("id"),
            "modified": obj.get("modified"),
            "published": obj.get("published"),
            "schema_version": obj.get("schema_version"),
            "summary": obj.get("summary")
        })
        return _obj


